/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota.migration;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.user.api.UsersRepository;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraPerUserMaxQuotaManagerMigration
implements Migration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraPerUserMaxQuotaManagerMigration.class);
    private final UsersRepository usersRepository;
    private final DomainList domainDao;
    private final MaxQuotaManager oldMaxQuotaManager;
    private final MaxQuotaManager newMaxQuotaManager;
    private UserQuotaRootResolver userQuotaRootResolver;

    @Inject
    public CassandraPerUserMaxQuotaManagerMigration(UsersRepository usersRepository, DomainList domainDao, @Named(value="old") MaxQuotaManager oldMaxQuotaManager, @Named(value="new") MaxQuotaManager newMaxQuotaManager, UserQuotaRootResolver userQuotaRootResolver) {
        this.usersRepository = usersRepository;
        this.domainDao = domainDao;
        this.oldMaxQuotaManager = oldMaxQuotaManager;
        this.newMaxQuotaManager = newMaxQuotaManager;
        this.userQuotaRootResolver = userQuotaRootResolver;
    }

    public void apply() throws InterruptedException {
        Mono.from((Publisher)this.oldMaxQuotaManager.getGlobalMaxMessageReactive()).flatMap(quotaCountLimit -> Mono.from((Publisher)this.newMaxQuotaManager.setGlobalMaxMessageReactive(quotaCountLimit))).block();
        Mono.from((Publisher)this.oldMaxQuotaManager.getGlobalMaxStorageReactive()).flatMap(quotaSizeLimit -> Mono.from((Publisher)this.newMaxQuotaManager.setGlobalMaxStorageReactive(quotaSizeLimit))).block();
        Flux.fromIterable(this.getDomains()).flatMap(domain -> this.migrateDomainQuotaLimit((Domain)domain)).then().block();
        Flux.from((Publisher)this.usersRepository.listReactive()).map(arg_0 -> ((UserQuotaRootResolver)this.userQuotaRootResolver).forUser(arg_0)).flatMap(quotaRoot -> this.migrateUserQuotaLimit((QuotaRoot)quotaRoot)).then().block();
    }

    private Mono<Void> migrateDomainQuotaLimit(Domain domain) {
        return Mono.from((Publisher)this.oldMaxQuotaManager.getDomainMaxMessageReactive(domain)).flatMap(quotaCountLimit -> Mono.from((Publisher)this.newMaxQuotaManager.setDomainMaxMessageReactive(domain, quotaCountLimit))).then(Mono.from((Publisher)this.oldMaxQuotaManager.getDomainMaxStorageReactive(domain)).flatMap(quotaSizeLimit -> Mono.from((Publisher)this.newMaxQuotaManager.setDomainMaxStorageReactive(domain, quotaSizeLimit))));
    }

    private Mono<Void> migrateUserQuotaLimit(QuotaRoot quotaRoot) {
        return Mono.from((Publisher)this.oldMaxQuotaManager.listMaxMessagesDetailsReactive(quotaRoot)).filter(map -> map.containsKey(Quota.Scope.User)).map(map -> (QuotaCountLimit)map.get(Quota.Scope.User)).flatMap(quotaCountLimit -> Mono.from((Publisher)this.newMaxQuotaManager.setMaxMessageReactive(quotaRoot, quotaCountLimit))).then(Mono.from((Publisher)this.oldMaxQuotaManager.listMaxStorageDetailsReactive(quotaRoot)).filter(map -> map.containsKey(Quota.Scope.User)).map(map -> (QuotaSizeLimit)map.get(Quota.Scope.User)).flatMap(quotaSizeLimit -> Mono.from((Publisher)this.newMaxQuotaManager.setMaxStorageReactive(quotaRoot, quotaSizeLimit))));
    }

    private List<Domain> getDomains() {
        try {
            return this.domainDao.getDomains();
        }
        catch (DomainListException ex) {
            throw new RuntimeException(ex);
        }
    }
}

