/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota.migration;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.user.api.UsersRepository;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraCurrentQuotaManagerMigration
implements Migration {
    private final UsersRepository usersRepository;
    private final UserQuotaRootResolver userQuotaRootResolver;
    private final CurrentQuotaManager oldCurrentQuotaManager;
    private final CurrentQuotaManager newCurrentQuotaManager;

    @Inject
    public CassandraCurrentQuotaManagerMigration(UsersRepository usersRepository, UserQuotaRootResolver userQuotaRootResolver, @Named(value="old") CurrentQuotaManager oldCurrentQuotaManager, @Named(value="new") CurrentQuotaManager newCurrentQuotaManager) {
        this.usersRepository = usersRepository;
        this.userQuotaRootResolver = userQuotaRootResolver;
        this.oldCurrentQuotaManager = oldCurrentQuotaManager;
        this.newCurrentQuotaManager = newCurrentQuotaManager;
    }

    public void apply() throws InterruptedException {
        Flux.from((Publisher)this.usersRepository.listReactive()).flatMap(this::migrateCurrentValue).then().block();
    }

    private Mono<Void> migrateCurrentValue(Username username) {
        QuotaRoot quotaRoot = this.userQuotaRootResolver.forUser(username);
        return Mono.from((Publisher)this.oldCurrentQuotaManager.getCurrentQuotas(quotaRoot)).flatMap(currentQuotas -> Mono.from((Publisher)this.newCurrentQuotaManager.setCurrentQuotas(QuotaOperation.from((QuotaRoot)quotaRoot, (CurrentQuotas)currentQuotas))));
    }
}

