/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.cassandra.table.CassandraGlobalMaxQuota;
import org.apache.james.mailbox.quota.Limits;
import org.apache.james.mailbox.quota.QuotaCodec;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

@Deprecated
public class CassandraGlobalMaxQuotaDao {
    private final CassandraAsyncExecutor queryExecutor;
    private final PreparedStatement setGlobalMaxStorageStatement;
    private final PreparedStatement setGlobalMaxMessageStatement;
    private final PreparedStatement getGlobalMaxStatement;
    private final PreparedStatement removeMessageMaxQuotaStatement;
    private final PreparedStatement removeStorageMaxQuotaStatement;

    @Inject
    public CassandraGlobalMaxQuotaDao(CqlSession session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
        this.getGlobalMaxStatement = session.prepare(this.getGlobalMaxStatement().build());
        this.setGlobalMaxMessageStatement = session.prepare(this.setGlobalMaxMessageStatement().build());
        this.setGlobalMaxStorageStatement = session.prepare(this.setGlobalMaxStorageStatement().build());
        this.removeMessageMaxQuotaStatement = session.prepare(this.removeMessageMaxQuotaStatement().build());
        this.removeStorageMaxQuotaStatement = session.prepare(this.removeStorageMaxQuotaStatement().build());
    }

    private Delete removeMessageMaxQuotaStatement() {
        return (Delete)QueryBuilder.deleteFrom((String)"defaultMaxQuota2").column(CassandraGlobalMaxQuota.MESSAGE).where((Relation)Relation.column((CqlIdentifier)CassandraGlobalMaxQuota.KEY).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraGlobalMaxQuota.KEY)));
    }

    private Delete removeStorageMaxQuotaStatement() {
        return (Delete)QueryBuilder.deleteFrom((String)"defaultMaxQuota2").column(CassandraGlobalMaxQuota.STORAGE).where((Relation)Relation.column((CqlIdentifier)CassandraGlobalMaxQuota.KEY).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraGlobalMaxQuota.KEY)));
    }

    private Insert setGlobalMaxStorageStatement() {
        return QueryBuilder.insertInto((String)"defaultMaxQuota2").value(CassandraGlobalMaxQuota.KEY, (Term)QueryBuilder.literal((Object)"value")).value(CassandraGlobalMaxQuota.STORAGE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraGlobalMaxQuota.STORAGE));
    }

    private Insert setGlobalMaxMessageStatement() {
        return QueryBuilder.insertInto((String)"defaultMaxQuota2").value(CassandraGlobalMaxQuota.KEY, (Term)QueryBuilder.literal((Object)"value")).value(CassandraGlobalMaxQuota.MESSAGE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraGlobalMaxQuota.MESSAGE));
    }

    private Select getGlobalMaxStatement() {
        return (Select)QueryBuilder.selectFrom((String)"defaultMaxQuota2").all().where((Relation)Relation.column((CqlIdentifier)CassandraGlobalMaxQuota.KEY).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraGlobalMaxQuota.KEY)));
    }

    Mono<Void> setGlobalMaxStorage(QuotaSizeLimit globalMaxStorage) {
        return this.queryExecutor.executeVoid((Statement)this.setGlobalMaxStorageStatement.bind(new Object[]{QuotaCodec.quotaValueToLong((QuotaLimitValue)globalMaxStorage)}));
    }

    Mono<Void> setGlobalMaxMessage(QuotaCountLimit globalMaxMessageCount) {
        return this.queryExecutor.executeVoid((Statement)this.setGlobalMaxMessageStatement.bind(new Object[]{QuotaCodec.quotaValueToLong((QuotaLimitValue)globalMaxMessageCount)}));
    }

    Mono<QuotaSizeLimit> getGlobalMaxStorage() {
        return this.queryExecutor.executeSingleRow((Statement)this.getGlobalMaxStatement.bind(new Object[0]).setString(CassandraGlobalMaxQuota.KEY, "value")).map(row -> Optional.ofNullable((Long)row.get(CassandraGlobalMaxQuota.STORAGE, Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaSize).handle(ReactorUtils.publishIfPresent());
    }

    Mono<QuotaCountLimit> getGlobalMaxMessage() {
        return this.queryExecutor.executeSingleRow((Statement)this.getGlobalMaxStatement.bind(new Object[0]).setString(CassandraGlobalMaxQuota.KEY, "value")).map(row -> Optional.ofNullable((Long)row.get(CassandraGlobalMaxQuota.MESSAGE, Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaCount).handle(ReactorUtils.publishIfPresent());
    }

    Mono<Void> removeGlobaltMaxStorage() {
        return this.queryExecutor.executeVoid((Statement)this.removeStorageMaxQuotaStatement.bind(new Object[0]).setString(CassandraGlobalMaxQuota.KEY, "value"));
    }

    Mono<Void> removeGlobalMaxMessage() {
        return this.queryExecutor.executeVoid((Statement)this.removeMessageMaxQuotaStatement.bind(new Object[0]).setString(CassandraGlobalMaxQuota.KEY, "value"));
    }

    Mono<Limits> getGlobalLimits() {
        return this.queryExecutor.executeSingleRow((Statement)this.getGlobalMaxStatement.bind(new Object[0]).setString(CassandraGlobalMaxQuota.KEY, "value")).map(row -> new Limits(Optional.ofNullable((Long)row.get(CassandraGlobalMaxQuota.STORAGE, Long.class)).flatMap(QuotaCodec::longToQuotaSize), Optional.ofNullable((Long)row.get(CassandraGlobalMaxQuota.MESSAGE, Long.class)).flatMap(QuotaCodec::longToQuotaCount))).switchIfEmpty(Mono.just((Object)Limits.empty()));
    }
}

