/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailbox.cassandra.mail.MessageAttachmentRepresentation;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;

public class MessageRepresentation {
    private final MessageId messageId;
    private final Date internalDate;
    private final Long size;
    private final Integer bodyStartOctet;
    private final Content content;
    private final Properties properties;
    private final List<MessageAttachmentRepresentation> attachments;
    private final BlobId headerId;
    private final BlobId bodyId;

    public MessageRepresentation(MessageId messageId, Date internalDate, Long size, Integer bodyStartOctet, Content content, Properties properties, List<MessageAttachmentRepresentation> attachments, BlobId headerId, BlobId bodyId) {
        this.messageId = messageId;
        this.internalDate = internalDate;
        this.size = size;
        this.bodyStartOctet = bodyStartOctet;
        this.content = content;
        this.properties = properties;
        this.attachments = attachments;
        this.headerId = headerId;
        this.bodyId = bodyId;
    }

    public SimpleMailboxMessage toMailboxMessage(ComposedMessageIdWithMetaData metadata, List<MessageAttachmentMetadata> attachments, Optional<Date> saveDate) {
        return SimpleMailboxMessage.builder().messageId(this.messageId).threadId(metadata.getThreadId()).mailboxId(metadata.getComposedMessageId().getMailboxId()).uid(metadata.getComposedMessageId().getUid()).modseq(metadata.getModSeq()).internalDate(this.internalDate).saveDate(saveDate).bodyStartOctet(this.bodyStartOctet.intValue()).size(this.size.longValue()).content(this.content).flags(metadata.getFlags()).properties(this.properties).addAttachments(attachments).build();
    }

    public Date getInternalDate() {
        return this.internalDate;
    }

    public Long getSize() {
        return this.size;
    }

    public Integer getBodyStartOctet() {
        return this.bodyStartOctet;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public Content getContent() {
        return this.content;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<MessageAttachmentRepresentation> getAttachments() {
        return this.attachments;
    }

    public BlobId getHeaderId() {
        return this.headerId;
    }

    public BlobId getBodyId() {
        return this.bodyId;
    }
}

