/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.FlagsExtractor;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIdTable;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIds;
import org.apache.james.mailbox.cassandra.table.CassandraMessageV3Table;
import org.apache.james.mailbox.cassandra.table.Flag;
import org.apache.james.mailbox.cassandra.table.MessageIdToImapUid;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Limit;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CassandraMessageIdDAO {
    private static final String IMAP_UID_GTE = String.valueOf(CassandraMessageIds.IMAP_UID) + "_GTE";
    private static final String IMAP_UID_LTE = String.valueOf(CassandraMessageIds.IMAP_UID) + "_LTE";
    public static final String LIMIT = "LIMIT_BIND_MARKER";
    private static final String ADDED_USERS_FLAGS = "added_user_flags";
    private static final String REMOVED_USERS_FLAGS = "removed_user_flags";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement selectAll;
    private final PreparedStatement selectAllUids;
    private final PreparedStatement selectAllLimited;
    private final PreparedStatement selectUidGte;
    private final PreparedStatement selectUidGteLimited;
    private final PreparedStatement selectUidRange;
    private final PreparedStatement selectUidOnlyRange;
    private final PreparedStatement selectMetadataRange;
    private final PreparedStatement selectNotDeletedRange;
    private final PreparedStatement selectUidRangeLimited;
    private final PreparedStatement update;
    private final PreparedStatement listStatement;
    private final ProtocolVersion protocolVersion;

    @Inject
    public CassandraMessageIdDAO(CqlSession session, BlobId.Factory blobIdFactory) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.protocolVersion = session.getContext().getProtocolVersion();
        this.blobIdFactory = blobIdFactory;
        this.delete = this.prepareDelete(session);
        this.insert = this.prepareInsert(session);
        this.update = this.prepareUpdate(session);
        this.select = this.prepareSelect(session);
        this.selectAll = this.prepareSelectAll(session);
        this.selectAllUids = this.prepareSelectAllUids(session);
        this.selectAllLimited = this.prepareSelectAllLimited(session);
        this.selectUidGte = this.prepareSelectUidGte(session);
        this.selectUidGteLimited = this.prepareSelectUidGteLimited(session);
        this.selectUidRange = this.prepareSelectUidRange(session);
        this.selectUidOnlyRange = this.prepareSelectUidOnlyRange(session);
        this.selectUidRangeLimited = this.prepareSelectUidRangeLimited(session);
        this.listStatement = this.prepareList(session);
        this.selectMetadataRange = this.prepareSelectMetadataRange(session);
        this.selectNotDeletedRange = this.prepareSelectNotDeletedRange(session);
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"messageIdTable").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID))})).build());
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(((Update)QueryBuilder.update((String)"messageIdTable").set(new Assignment[]{Assignment.setColumn((CqlIdentifier)CassandraMessageIdTable.THREAD_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIdTable.THREAD_ID)), Assignment.setColumn((CqlIdentifier)CassandraMessageIds.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)), Assignment.setColumn((CqlIdentifier)MessageIdToImapUid.MOD_SEQ, (Term)QueryBuilder.bindMarker((CqlIdentifier)MessageIdToImapUid.MOD_SEQ)), Assignment.setColumn((CqlIdentifier)Flag.ANSWERED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.ANSWERED)), Assignment.setColumn((CqlIdentifier)Flag.DELETED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DELETED)), Assignment.setColumn((CqlIdentifier)Flag.DRAFT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DRAFT)), Assignment.setColumn((CqlIdentifier)Flag.FLAGGED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.FLAGGED)), Assignment.setColumn((CqlIdentifier)Flag.RECENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.RECENT)), Assignment.setColumn((CqlIdentifier)Flag.SEEN, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.SEEN)), Assignment.setColumn((CqlIdentifier)Flag.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.INTERNAL_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.INTERNAL_DATE)), Assignment.setColumn((CqlIdentifier)CassandraMessageIdTable.SAVE_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIdTable.SAVE_DATE)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.BODY_START_OCTET, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.BODY_START_OCTET)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.FULL_CONTENT_OCTETS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.FULL_CONTENT_OCTETS)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.HEADER_CONTENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.HEADER_CONTENT)), Assignment.append((CqlIdentifier)Flag.USER_FLAGS, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER_FLAGS))}).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID))})).build());
    }

    private PreparedStatement prepareUpdate(CqlSession session) {
        return session.prepare(((Update)QueryBuilder.update((String)"messageIdTable").set(new Assignment[]{Assignment.setColumn((CqlIdentifier)MessageIdToImapUid.MOD_SEQ, (Term)QueryBuilder.bindMarker((CqlIdentifier)MessageIdToImapUid.MOD_SEQ)), Assignment.setColumn((CqlIdentifier)Flag.ANSWERED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.ANSWERED)), Assignment.setColumn((CqlIdentifier)Flag.DELETED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DELETED)), Assignment.setColumn((CqlIdentifier)Flag.DRAFT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DRAFT)), Assignment.setColumn((CqlIdentifier)Flag.FLAGGED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.FLAGGED)), Assignment.setColumn((CqlIdentifier)Flag.RECENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.RECENT)), Assignment.setColumn((CqlIdentifier)Flag.SEEN, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.SEEN)), Assignment.setColumn((CqlIdentifier)Flag.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER)), Assignment.append((CqlIdentifier)Flag.USER_FLAGS, (Term)QueryBuilder.bindMarker((String)ADDED_USERS_FLAGS)), Assignment.remove((CqlIdentifier)Flag.USER_FLAGS, (Term)QueryBuilder.bindMarker((String)REMOVED_USERS_FLAGS))}).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID))})).build());
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID))})).build());
    }

    private PreparedStatement prepareSelectAll(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").all().where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)))).orderBy(CassandraMessageIds.IMAP_UID, ClusteringOrder.ASC).build());
    }

    private PreparedStatement prepareSelectAllUids(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").column(CassandraMessageIds.IMAP_UID).where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)))).orderBy(CassandraMessageIds.IMAP_UID, ClusteringOrder.ASC).build());
    }

    private PreparedStatement prepareSelectAllLimited(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").all().where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)))).limit(QueryBuilder.bindMarker((String)LIMIT)).orderBy(CassandraMessageIds.IMAP_UID, ClusteringOrder.ASC).build());
    }

    private PreparedStatement prepareList(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"messageIdTable").all().build());
    }

    private PreparedStatement prepareSelectUidGte(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID))})).orderBy(CassandraMessageIds.IMAP_UID, ClusteringOrder.ASC).build());
    }

    private PreparedStatement prepareSelectUidGteLimited(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID))})).limit(QueryBuilder.bindMarker((String)LIMIT)).orderBy(CassandraMessageIds.IMAP_UID, ClusteringOrder.ASC).build());
    }

    private PreparedStatement prepareSelectUidRange(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_GTE)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_LTE))})).orderBy(CassandraMessageIds.IMAP_UID, ClusteringOrder.ASC).build());
    }

    private PreparedStatement prepareSelectUidOnlyRange(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").column(CassandraMessageIds.IMAP_UID).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_GTE)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_LTE))})).orderBy(CassandraMessageIds.IMAP_UID, ClusteringOrder.ASC).build());
    }

    private PreparedStatement prepareSelectMetadataRange(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").columns(new CqlIdentifier[]{CassandraMessageIds.IMAP_UID, CassandraMessageIds.MESSAGE_ID, CassandraMessageIdTable.THREAD_ID, Flag.ANSWERED, Flag.DELETED, Flag.DRAFT, Flag.RECENT, Flag.SEEN, Flag.FLAGGED, Flag.USER, Flag.USER_FLAGS, MessageIdToImapUid.MOD_SEQ}).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_GTE)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_LTE))})).build());
    }

    private PreparedStatement prepareSelectNotDeletedRange(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").columns(new CqlIdentifier[]{CassandraMessageIds.IMAP_UID, Flag.DELETED}).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_GTE)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_LTE))})).build());
    }

    private PreparedStatement prepareSelectUidRangeLimited(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageIdTable").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_GTE)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((String)IMAP_UID_LTE))})).limit(QueryBuilder.bindMarker((String)LIMIT)).build());
    }

    public Mono<Void> delete(CassandraId mailboxId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.delete.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageIds.IMAP_UID, uid.asLong()));
    }

    public Mono<Void> insert(CassandraMessageMetadata metadata) {
        Preconditions.checkState((boolean)metadata.isComplete(), (Object)"Attempt to write incomplete metadata");
        ComposedMessageId composedMessageId = metadata.getComposedMessageId().getComposedMessageId();
        Flags flags = metadata.getComposedMessageId().getFlags();
        ThreadId threadId = metadata.getComposedMessageId().getThreadId();
        BoundStatementBuilder statementBuilder = this.insert.boundStatementBuilder(new Object[0]);
        if (flags.getUserFlags().length == 0) {
            statementBuilder.unset(Flag.USER_FLAGS);
        } else {
            statementBuilder.setSet(Flag.USER_FLAGS, (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags()), String.class);
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)statementBuilder.set(CassandraMessageIds.MAILBOX_ID, (Object)((CassandraId)composedMessageId.getMailboxId()).asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageIds.IMAP_UID, composedMessageId.getUid().asLong())).setUuid(CassandraMessageIds.MESSAGE_ID, ((CassandraMessageId)composedMessageId.getMessageId()).get())).setUuid(CassandraMessageIdTable.THREAD_ID, ((CassandraMessageId)threadId.getBaseMessageId()).get())).setLong(MessageIdToImapUid.MOD_SEQ, metadata.getComposedMessageId().getModSeq().asLong())).setBoolean(Flag.ANSWERED, flags.contains(Flags.Flag.ANSWERED))).setBoolean(Flag.DELETED, flags.contains(Flags.Flag.DELETED))).setBoolean(Flag.DRAFT, flags.contains(Flags.Flag.DRAFT))).setBoolean(Flag.FLAGGED, flags.contains(Flags.Flag.FLAGGED))).setBoolean(Flag.RECENT, flags.contains(Flags.Flag.RECENT))).setBoolean(Flag.SEEN, flags.contains(Flags.Flag.SEEN))).setBoolean(Flag.USER, flags.contains(Flags.Flag.USER))).setInstant(CassandraMessageV3Table.INTERNAL_DATE, metadata.getInternalDate().get().toInstant())).setInstant(CassandraMessageIdTable.SAVE_DATE, (Instant)metadata.getSaveDate().map(Date::toInstant).orElse(null))).setInt(CassandraMessageV3Table.BODY_START_OCTET, Math.toIntExact(metadata.getBodyStartOctet().get()))).setLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS, metadata.getSize().get().longValue())).setString(CassandraMessageV3Table.HEADER_CONTENT, metadata.getHeaderContent().get().asString())).build());
    }

    public Mono<Void> updateMetadata(ComposedMessageId composedMessageId, UpdatedFlags updatedFlags) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateBoundStatement(composedMessageId, updatedFlags));
    }

    private BoundStatement updateBoundStatement(ComposedMessageId id, UpdatedFlags updatedFlags) {
        BoundStatementBuilder statementBuilder = (BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.update.boundStatementBuilder(new Object[0]).setLong(MessageIdToImapUid.MOD_SEQ, updatedFlags.getModSeq().asLong())).setUuid(CassandraMessageIds.MAILBOX_ID, ((CassandraId)id.getMailboxId()).asUuid())).setLong(CassandraMessageIds.IMAP_UID, id.getUid().asLong());
        if (updatedFlags.isChanged(Flags.Flag.ANSWERED)) {
            statementBuilder.setBoolean(Flag.ANSWERED, updatedFlags.isModifiedToSet(Flags.Flag.ANSWERED));
        } else {
            statementBuilder.unset(Flag.ANSWERED);
        }
        if (updatedFlags.isChanged(Flags.Flag.DRAFT)) {
            statementBuilder.setBoolean(Flag.DRAFT, updatedFlags.isModifiedToSet(Flags.Flag.DRAFT));
        } else {
            statementBuilder.unset(Flag.DRAFT);
        }
        if (updatedFlags.isChanged(Flags.Flag.FLAGGED)) {
            statementBuilder.setBoolean(Flag.FLAGGED, updatedFlags.isModifiedToSet(Flags.Flag.FLAGGED));
        } else {
            statementBuilder.unset(Flag.FLAGGED);
        }
        if (updatedFlags.isChanged(Flags.Flag.DELETED)) {
            statementBuilder.setBoolean(Flag.DELETED, updatedFlags.isModifiedToSet(Flags.Flag.DELETED));
        } else {
            statementBuilder.unset(Flag.DELETED);
        }
        if (updatedFlags.isChanged(Flags.Flag.RECENT)) {
            statementBuilder.setBoolean(Flag.RECENT, updatedFlags.getNewFlags().contains(Flags.Flag.RECENT));
        } else {
            statementBuilder.unset(Flag.RECENT);
        }
        if (updatedFlags.isChanged(Flags.Flag.SEEN)) {
            statementBuilder.setBoolean(Flag.SEEN, updatedFlags.isModifiedToSet(Flags.Flag.SEEN));
        } else {
            statementBuilder.unset(Flag.SEEN);
        }
        if (updatedFlags.isChanged(Flags.Flag.USER)) {
            statementBuilder.setBoolean(Flag.USER, updatedFlags.isModifiedToSet(Flags.Flag.USER));
        } else {
            statementBuilder.unset(Flag.USER);
        }
        Sets.SetView removedFlags = Sets.difference((Set)ImmutableSet.copyOf((Object[])updatedFlags.getOldFlags().getUserFlags()), (Set)ImmutableSet.copyOf((Object[])updatedFlags.getNewFlags().getUserFlags()));
        Sets.SetView addedFlags = Sets.difference((Set)ImmutableSet.copyOf((Object[])updatedFlags.getNewFlags().getUserFlags()), (Set)ImmutableSet.copyOf((Object[])updatedFlags.getOldFlags().getUserFlags()));
        if (addedFlags.isEmpty()) {
            statementBuilder.unset(ADDED_USERS_FLAGS);
        } else {
            statementBuilder.setSet(ADDED_USERS_FLAGS, (Set)addedFlags, String.class);
        }
        if (removedFlags.isEmpty()) {
            statementBuilder.unset(REMOVED_USERS_FLAGS);
        } else {
            statementBuilder.setSet(REMOVED_USERS_FLAGS, (Set)removedFlags, String.class);
        }
        return statementBuilder.build();
    }

    public Mono<Optional<CassandraMessageMetadata>> retrieve(CassandraId mailboxId, MessageUid uid) {
        return this.asOptionalOfCassandraMessageId(this.selectOneRow(mailboxId, uid));
    }

    private Mono<Optional<CassandraMessageMetadata>> asOptionalOfCassandraMessageId(Mono<Row> row) {
        return row.map(this::fromRowToComposedMessageIdWithFlags).defaultIfEmpty(Optional.empty());
    }

    private Mono<Row> selectOneRow(CassandraId mailboxId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)((BoundStatement)this.select.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageIds.IMAP_UID, uid.asLong()));
    }

    public Flux<CassandraMessageMetadata> retrieveMessages(CassandraId mailboxId, MessageRange set, Limit limit) {
        return this.retrieveRows(mailboxId, set, limit).map(this::fromRowToComposedMessageIdWithFlags).handle(ReactorUtils.publishIfPresent());
    }

    public Flux<MessageUid> listUids(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAllUids.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).map(row -> MessageUid.of((long)TypeCodecs.BIGINT.decodePrimitive(row.getBytesUnsafe(0), this.protocolVersion)));
    }

    public Flux<ComposedMessageIdWithMetaData> listMessagesMetadata(CassandraId mailboxId, MessageRange range) {
        return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)((BoundStatement)this.selectMetadataRange.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(IMAP_UID_GTE, range.getUidFrom().asLong())).setLong(IMAP_UID_LTE, range.getUidTo().asLong())).map(row -> {
            CassandraMessageId messageId = CassandraMessageId.Factory.of((UUID)row.get(CassandraMessageIds.MESSAGE_ID, TypeCodecs.TIMEUUID));
            return ComposedMessageIdWithMetaData.builder().modSeq(ModSeq.of((long)TypeCodecs.BIGINT.decodePrimitive(row.getBytesUnsafe(MessageIdToImapUid.MOD_SEQ), this.protocolVersion))).threadId(this.getThreadIdFromRow((Row)row, messageId)).flags(FlagsExtractor.getFlags(row)).composedMessageId(new ComposedMessageId((MailboxId)mailboxId, (MessageId)messageId, MessageUid.of((long)TypeCodecs.BIGINT.decodePrimitive(row.getBytesUnsafe(CassandraMessageIds.IMAP_UID), this.protocolVersion)))).build();
        });
    }

    public Flux<MessageUid> listNotDeletedUids(CassandraId mailboxId, MessageRange range) {
        MemoizedSupplier deletedPosition = new MemoizedSupplier();
        MemoizedSupplier uidPosition = new MemoizedSupplier();
        return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)((BoundStatement)this.selectNotDeletedRange.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(IMAP_UID_GTE, range.getUidFrom().asLong())).setLong(IMAP_UID_LTE, range.getUidTo().asLong())).filter(row -> !TypeCodecs.BOOLEAN.decodePrimitive(row.getBytesUnsafe(deletedPosition.get(() -> row.getColumnDefinitions().firstIndexOf(Flag.DELETED)).intValue()), this.protocolVersion)).map(row -> MessageUid.of((long)TypeCodecs.BIGINT.decodePrimitive(row.getBytesUnsafe(uidPosition.get(() -> row.getColumnDefinitions().firstIndexOf(CassandraMessageIds.IMAP_UID)).intValue()), this.protocolVersion)));
    }

    private Flux<MessageUid> doListUids(CassandraId mailboxId, MessageRange range) {
        return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)((BoundStatement)this.selectUidOnlyRange.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(IMAP_UID_GTE, range.getUidFrom().asLong())).setLong(IMAP_UID_LTE, range.getUidTo().asLong())).map(row -> MessageUid.of((long)TypeCodecs.BIGINT.decodePrimitive(row.getBytesUnsafe(0), this.protocolVersion)));
    }

    public Flux<MessageUid> listUids(CassandraId mailboxId, MessageRange range) {
        if (range.getType() == MessageRange.Type.ALL) {
            return this.listUids(mailboxId);
        }
        return this.doListUids(mailboxId, range);
    }

    public Flux<CassandraMessageMetadata> retrieveAllMessages() {
        return this.cassandraAsyncExecutor.executeRows(this.listStatement.bind(new Object[0]).setTimeout(Duration.ofDays(1L))).map(this::fromRowToComposedMessageIdWithFlags).handle(ReactorUtils.publishIfPresent());
    }

    private Flux<Row> retrieveRows(CassandraId mailboxId, MessageRange set, Limit limit) {
        switch (set.getType()) {
            case ALL: {
                return this.selectAll(mailboxId, limit);
            }
            case FROM: {
                return this.selectFrom(mailboxId, set.getUidFrom(), limit);
            }
            case RANGE: {
                return this.selectRange(mailboxId, set.getUidFrom(), set.getUidTo(), limit);
            }
            case ONE: {
                return Flux.from(this.selectOneRow(mailboxId, set.getUidFrom()));
            }
        }
        throw new UnsupportedOperationException();
    }

    private Flux<Row> selectAll(CassandraId mailboxId, Limit limit) {
        return this.cassandraAsyncExecutor.executeRows((Statement)limit.getLimit().map(limitAsInt -> (BoundStatement)((BoundStatement)this.selectAllLimited.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setInt(LIMIT, limitAsInt.intValue())).orElseGet(() -> (BoundStatement)this.selectAll.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)));
    }

    private Flux<Row> selectFrom(CassandraId mailboxId, MessageUid uid, Limit limit) {
        return this.cassandraAsyncExecutor.executeRows((Statement)limit.getLimit().map(limitAsInt -> (BoundStatement)((BoundStatement)((BoundStatement)this.selectUidGteLimited.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageIds.IMAP_UID, uid.asLong())).setInt(LIMIT, limitAsInt.intValue())).orElseGet(() -> (BoundStatement)((BoundStatement)this.selectUidGte.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageIds.IMAP_UID, uid.asLong())));
    }

    private Flux<Row> selectRange(CassandraId mailboxId, MessageUid from, MessageUid to, Limit limit) {
        return this.cassandraAsyncExecutor.executeRows((Statement)limit.getLimit().map(limitAsInt -> (BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.selectUidRangeLimited.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(IMAP_UID_GTE, from.asLong())).setLong(IMAP_UID_LTE, to.asLong())).setInt(LIMIT, limitAsInt.intValue())).orElseGet(() -> (BoundStatement)((BoundStatement)((BoundStatement)this.selectUidRange.bind(new Object[0]).set(CassandraMessageIds.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(IMAP_UID_GTE, from.asLong())).setLong(IMAP_UID_LTE, to.asLong())));
    }

    private Optional<CassandraMessageMetadata> fromRowToComposedMessageIdWithFlags(Row row) {
        UUID rowAsUuid = (UUID)row.get(CassandraMessageIds.MESSAGE_ID, TypeCodecs.TIMEUUID);
        if (rowAsUuid == null) {
            this.delete(CassandraId.of((UUID)row.get(CassandraMessageIds.MAILBOX_ID, TypeCodecs.TIMEUUID)), MessageUid.of((long)row.getLong(CassandraMessageIds.IMAP_UID))).subscribeOn(Schedulers.parallel()).subscribe();
            return Optional.empty();
        }
        CassandraMessageId messageId = CassandraMessageId.Factory.of(rowAsUuid);
        return Optional.of(CassandraMessageMetadata.builder().ids(ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)CassandraId.of((UUID)row.get(CassandraMessageIds.MAILBOX_ID, TypeCodecs.TIMEUUID)), (MessageId)messageId, MessageUid.of((long)row.getLong(CassandraMessageIds.IMAP_UID)))).flags(FlagsExtractor.getFlags(row)).modSeq(ModSeq.of((long)row.getLong(MessageIdToImapUid.MOD_SEQ))).threadId(this.getThreadIdFromRow(row, messageId)).build()).bodyStartOctet((Integer)row.get(CassandraMessageV3Table.BODY_START_OCTET, Integer.class)).internalDate(Optional.ofNullable((Instant)row.get(CassandraMessageV3Table.INTERNAL_DATE, TypeCodecs.TIMESTAMP)).map(Date::from)).saveDate(Optional.ofNullable((Instant)row.get(CassandraMessageIdTable.SAVE_DATE, TypeCodecs.TIMESTAMP)).map(Date::from)).size((Long)row.get(CassandraMessageV3Table.FULL_CONTENT_OCTETS, Long.class)).headerContent(Optional.ofNullable((String)row.get(CassandraMessageV3Table.HEADER_CONTENT, TypeCodecs.TEXT)).map(arg_0 -> ((BlobId.Factory)this.blobIdFactory).parse(arg_0))).build());
    }

    private ThreadId getThreadIdFromRow(Row row, MessageId messageId) {
        UUID threadIdUUID = (UUID)row.get(CassandraMessageIdTable.THREAD_ID, TypeCodecs.TIMEUUID);
        if (threadIdUUID == null) {
            return ThreadId.fromBaseMessageId((MessageId)messageId);
        }
        return ThreadId.fromBaseMessageId((MessageId)CassandraMessageId.Factory.of(threadIdUUID));
    }

    @VisibleForTesting
    Mono<Void> insertNullInternalDateAndHeaderContent(CassandraMessageMetadata metadata) {
        ComposedMessageId composedMessageId = metadata.getComposedMessageId().getComposedMessageId();
        Flags flags = metadata.getComposedMessageId().getFlags();
        ThreadId threadId = metadata.getComposedMessageId().getThreadId();
        BoundStatementBuilder statementBuilder = this.insert.boundStatementBuilder(new Object[0]);
        if (flags.getUserFlags().length == 0) {
            statementBuilder.unset(Flag.USER_FLAGS);
        } else {
            statementBuilder.setSet(Flag.USER_FLAGS, (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags()), String.class);
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)statementBuilder.setUuid(CassandraMessageIds.MAILBOX_ID, ((CassandraId)composedMessageId.getMailboxId()).asUuid())).setLong(CassandraMessageIds.IMAP_UID, composedMessageId.getUid().asLong())).setUuid(CassandraMessageIds.MESSAGE_ID, ((CassandraMessageId)composedMessageId.getMessageId()).get())).setUuid(CassandraMessageIdTable.THREAD_ID, ((CassandraMessageId)threadId.getBaseMessageId()).get())).setLong(MessageIdToImapUid.MOD_SEQ, metadata.getComposedMessageId().getModSeq().asLong())).setBoolean(Flag.ANSWERED, flags.contains(Flags.Flag.ANSWERED))).setBoolean(Flag.DELETED, flags.contains(Flags.Flag.DELETED))).setBoolean(Flag.DRAFT, flags.contains(Flags.Flag.DRAFT))).setBoolean(Flag.FLAGGED, flags.contains(Flags.Flag.FLAGGED))).setBoolean(Flag.RECENT, flags.contains(Flags.Flag.RECENT))).setBoolean(Flag.SEEN, flags.contains(Flags.Flag.SEEN))).setBoolean(Flag.USER, flags.contains(Flags.Flag.USER))).setInstant(CassandraMessageV3Table.INTERNAL_DATE, null)).setInt(CassandraMessageV3Table.BODY_START_OCTET, 0)).setLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS, 0L)).setString(CassandraMessageV3Table.HEADER_CONTENT, null)).build());
    }

    private static class MemoizedSupplier<T> {
        private final AtomicReference<T> value = new AtomicReference();

        private MemoizedSupplier() {
        }

        T get(Supplier<T> initializer) {
            T result = this.value.get();
            if (result == null) {
                T initialValue = initializer.get();
                this.value.set(initialValue);
                return initialValue;
            }
            return result;
        }
    }
}

