/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Stream;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraDeletedMessageTable;
import org.apache.james.mailbox.model.MessageRange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraDeletedMessageDAO {
    private static final String UID_TO = "uid_to";
    private static final String UID_FROM = "uid_from";
    private static final int BATCH_STATEMENT_WINDOW = 1024;
    private static final int LOW_CONCURRENCY = 2;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement deleteAllStatement;
    private final PreparedStatement selectAllUidStatement;
    private final PreparedStatement selectOneUidStatement;
    private final PreparedStatement selectBetweenUidStatement;
    private final PreparedStatement selectFromUidStatement;
    private final ProtocolVersion protocolVersion;

    @Inject
    public CassandraDeletedMessageDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAddStatement(session);
        this.deleteStatement = this.prepareDeleteStatement(session);
        this.deleteAllStatement = this.prepareDeleteAllStatement(session);
        this.selectAllUidStatement = this.prepareAllUidStatement(session);
        this.selectOneUidStatement = this.prepareOneUidStatement(session);
        this.selectBetweenUidStatement = this.prepareBetweenUidStatement(session);
        this.selectFromUidStatement = this.prepareFromUidStatement(session);
        this.protocolVersion = session.getContext().getProtocolVersion();
    }

    private PreparedStatement prepareAllUidStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageDeleted").column(CassandraDeletedMessageTable.UID).where((Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement prepareOneUidStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageDeleted").column(CassandraDeletedMessageTable.UID).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.UID))})).build());
    }

    private PreparedStatement prepareBetweenUidStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageDeleted").column(CassandraDeletedMessageTable.UID).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)UID_FROM)), (Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.UID).isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((String)UID_TO))})).build());
    }

    private PreparedStatement prepareFromUidStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageDeleted").column(CassandraDeletedMessageTable.UID).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)UID_FROM))})).build());
    }

    private PreparedStatement prepareDeleteStatement(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"messageDeleted").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.UID))})).build());
    }

    private PreparedStatement prepareDeleteAllStatement(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"messageDeleted").where((Relation)Relation.column((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement prepareAddStatement(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"messageDeleted").value(CassandraDeletedMessageTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.MAILBOX_ID)).value(CassandraDeletedMessageTable.UID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDeletedMessageTable.UID)).build());
    }

    public Mono<Void> addDeleted(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.addStatement.bind(new Object[0]).setUuid(CassandraDeletedMessageTable.MAILBOX_ID, cassandraId.asUuid())).setLong(CassandraDeletedMessageTable.UID, uid.asLong()));
    }

    public Mono<Void> addDeleted(CassandraId cassandraId, List<MessageUid> uids) {
        if (uids.size() == 1) {
            return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.addStatement.bind(new Object[0]).setUuid(CassandraDeletedMessageTable.MAILBOX_ID, cassandraId.asUuid())).setLong(CassandraDeletedMessageTable.UID, uids.iterator().next().asLong()));
        }
        Stream<BatchStatement> batches = Lists.partition(uids, (int)1024).stream().map(uidBatch -> {
            BatchStatementBuilder batch = new BatchStatementBuilder(BatchType.UNLOGGED);
            uidBatch.forEach(uid -> batch.addStatement((BatchableStatement)((BoundStatement)this.addStatement.bind(new Object[0]).setUuid(CassandraDeletedMessageTable.MAILBOX_ID, cassandraId.asUuid())).setLong(CassandraDeletedMessageTable.UID, uid.asLong())));
            return batch.build();
        });
        return Flux.fromStream(batches).flatMap(arg_0 -> ((CassandraAsyncExecutor)this.cassandraAsyncExecutor).executeVoid(arg_0), 2).then();
    }

    public Mono<Void> removeDeleted(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraDeletedMessageTable.MAILBOX_ID, cassandraId.asUuid())).setLong(CassandraDeletedMessageTable.UID, uid.asLong()));
    }

    public Mono<Void> removeDeleted(CassandraId cassandraId, List<MessageUid> uids) {
        if (uids.size() == 1) {
            return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraDeletedMessageTable.MAILBOX_ID, cassandraId.asUuid())).setLong(CassandraDeletedMessageTable.UID, uids.iterator().next().asLong()));
        }
        Stream<BatchStatement> batches = Lists.partition(uids, (int)1024).stream().map(uidBatch -> {
            BatchStatementBuilder batch = new BatchStatementBuilder(BatchType.UNLOGGED);
            uidBatch.forEach(uid -> batch.addStatement((BatchableStatement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraDeletedMessageTable.MAILBOX_ID, cassandraId.asUuid())).setLong(CassandraDeletedMessageTable.UID, uid.asLong())));
            return batch.build();
        });
        return Flux.fromStream(batches).flatMap(arg_0 -> ((CassandraAsyncExecutor)this.cassandraAsyncExecutor).executeVoid(arg_0), 2).then();
    }

    public Mono<Void> removeAll(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteAllStatement.bind(new Object[0]).set(CassandraDeletedMessageTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.TIMEUUID));
    }

    public Flux<MessageUid> retrieveDeletedMessage(CassandraId cassandraId, MessageRange range) {
        return this.retrieveResultSetOfDeletedMessage(cassandraId, range).map(this::asMessageUid);
    }

    private Flux<Row> retrieveResultSetOfDeletedMessage(CassandraId cassandraId, MessageRange range) {
        switch (range.getType()) {
            case ALL: {
                return this.retrieveAllDeleted(cassandraId);
            }
            case FROM: {
                return this.retrieveDeletedAfter(cassandraId, range.getUidFrom());
            }
            case RANGE: {
                return this.retrieveDeletedBetween(cassandraId, range.getUidFrom(), range.getUidTo());
            }
            case ONE: {
                return this.retrieveOneDeleted(cassandraId, range.getUidFrom());
            }
        }
        throw new UnsupportedOperationException();
    }

    private Flux<Row> retrieveAllDeleted(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAllUidStatement.bind(new Object[0]).set(CassandraDeletedMessageTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.TIMEUUID));
    }

    private Flux<Row> retrieveOneDeleted(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)this.selectOneUidStatement.bind(new Object[0]).setUuid(CassandraDeletedMessageTable.MAILBOX_ID, cassandraId.asUuid())).setLong(CassandraDeletedMessageTable.UID, uid.asLong()));
    }

    private Flux<Row> retrieveDeletedBetween(CassandraId cassandraId, MessageUid from, MessageUid to) {
        return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)((BoundStatement)this.selectBetweenUidStatement.bind(new Object[0]).setUuid(CassandraDeletedMessageTable.MAILBOX_ID, cassandraId.asUuid())).setLong(UID_FROM, from.asLong())).setLong(UID_TO, to.asLong()));
    }

    private Flux<Row> retrieveDeletedAfter(CassandraId cassandraId, MessageUid from) {
        return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)this.selectFromUidStatement.bind(new Object[0]).setUuid(CassandraDeletedMessageTable.MAILBOX_ID, cassandraId.asUuid())).setLong(UID_FROM, from.asLong()));
    }

    private MessageUid asMessageUid(Row row) {
        return MessageUid.of((long)TypeCodecs.BIGINT.decodePrimitive(row.getBytesUnsafe(0), this.protocolVersion));
    }
}

