/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class ZonedDateTimeRepresentation {
    private final ZonedDateTime zonedDateTime;

    public static ZonedDateTimeRepresentation fromZonedDateTime(ZonedDateTime zonedDateTime) {
        return new ZonedDateTimeRepresentation(zonedDateTime);
    }

    public static ZonedDateTimeRepresentation fromDate(Instant date, String serializedZoneId) {
        return new ZonedDateTimeRepresentation(ZonedDateTime.ofInstant(date, ZoneId.of(serializedZoneId)));
    }

    public ZonedDateTimeRepresentation(ZonedDateTime zonedDateTime) {
        this.zonedDateTime = zonedDateTime;
    }

    public Date getDate() {
        return new Date(this.zonedDateTime.toInstant().toEpochMilli());
    }

    public String getSerializedZoneId() {
        return this.zonedDateTime.getZone().getId();
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }
}

