/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra.migration;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.sieve.cassandra.CassandraSieveQuotaDAO;
import org.apache.james.user.api.UsersRepository;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SieveQuotaMigration
implements Migration {
    private final UsersRepository usersRepository;
    private final CassandraSieveQuotaDAO oldDAO;
    private final CassandraSieveQuotaDAO newDAO;

    @Inject
    public SieveQuotaMigration(UsersRepository usersRepository, @Named(value="old") CassandraSieveQuotaDAO oldDAO, @Named(value="new") CassandraSieveQuotaDAO newDAO) {
        this.usersRepository = usersRepository;
        this.oldDAO = oldDAO;
        this.newDAO = newDAO;
    }

    public void apply() throws InterruptedException {
        this.oldDAO.getQuota().flatMap(maybeLimit -> maybeLimit.map(this.newDAO::setQuota).orElse(Mono.empty())).block();
        Flux.from((Publisher)this.usersRepository.listReactive()).flatMap(username -> this.migrateLimit((Username)username).then(this.migrateCurrentValue((Username)username))).then().block();
    }

    private Mono<Void> migrateCurrentValue(Username username) {
        return this.oldDAO.spaceUsedBy(username).flatMap(currentValue -> this.newDAO.updateSpaceUsed(username, (long)currentValue));
    }

    private Mono<Void> migrateLimit(Username username) {
        return this.oldDAO.getQuota(username).flatMap(maybeLimit -> maybeLimit.map(limit -> this.newDAO.setQuota(username, (QuotaSizeLimit)limit)).orElse(Mono.empty()));
    }
}

