/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.schema.Drop;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultDrop
implements Drop {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier itemName;
    private final String schemaTypeName;
    private final boolean ifExists;

    public DefaultDrop(@NonNull CqlIdentifier itemName, @NonNull String schemaTypeName) {
        this(null, itemName, schemaTypeName);
    }

    public DefaultDrop(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier itemName, @NonNull String schemaTypeName) {
        this(keyspace, itemName, schemaTypeName, false);
    }

    public DefaultDrop(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier itemName, @NonNull String schemaTypeName, boolean ifExists) {
        this.keyspace = keyspace;
        this.itemName = itemName;
        this.schemaTypeName = schemaTypeName;
        this.ifExists = ifExists;
    }

    @Override
    @NonNull
    public Drop ifExists() {
        return new DefaultDrop(this.keyspace, this.itemName, this.schemaTypeName, true);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("DROP ").append(this.schemaTypeName).append(' ');
        if (this.ifExists) {
            builder.append("IF EXISTS ");
        }
        CqlHelper.qualify(this.keyspace, this.itemName, builder);
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getName() {
        return this.itemName;
    }

    @NonNull
    public String getSchemaType() {
        return this.schemaTypeName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }
}

