/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.Raw;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultRaw
implements Raw {
    private final String rawExpression;
    private final CqlIdentifier alias;

    public DefaultRaw(@NonNull String rawExpression) {
        this(rawExpression, null);
    }

    private DefaultRaw(@NonNull String rawExpression, @Nullable CqlIdentifier alias) {
        Preconditions.checkNotNull((Object)rawExpression);
        this.rawExpression = rawExpression;
        this.alias = alias;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new DefaultRaw(this.rawExpression, alias);
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append(this.rawExpression);
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @NonNull
    public String getRawExpression() {
        return this.rawExpression;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DefaultRaw) {
            DefaultRaw that = (DefaultRaw)other;
            return this.rawExpression.equals(that.rawExpression) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.rawExpression, this.alias);
    }
}

