/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.memory;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailrepository.api.Initializable;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryLoader;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.MailRepositoryUrlStore;
import org.apache.james.mailrepository.api.Protocol;
import org.apache.james.mailrepository.memory.MailRepositoryStoreConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMailRepositoryStore
implements MailRepositoryStore,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryMailRepositoryStore.class);
    private final MailRepositoryUrlStore urlStore;
    private final ConcurrentMap<MailRepositoryUrl, MailRepository> destinationToRepositoryAssociations;
    private final Map<Protocol, String> protocolToClass;
    private final MailRepositoryLoader mailRepositoryLoader;
    private final Map<Protocol, HierarchicalConfiguration<ImmutableNode>> perProtocolMailRepositoryDefaultConfiguration;
    private final MailRepositoryStoreConfiguration configuration;

    @Inject
    public MemoryMailRepositoryStore(MailRepositoryUrlStore urlStore, MailRepositoryLoader mailRepositoryLoader, MailRepositoryStoreConfiguration configuration) {
        this.urlStore = urlStore;
        this.mailRepositoryLoader = mailRepositoryLoader;
        this.configuration = configuration;
        this.destinationToRepositoryAssociations = new ConcurrentHashMap<MailRepositoryUrl, MailRepository>();
        this.protocolToClass = new HashMap<Protocol, String>();
        this.perProtocolMailRepositoryDefaultConfiguration = new HashMap<Protocol, HierarchicalConfiguration<ImmutableNode>>();
    }

    public Optional<Protocol> defaultProtocol() {
        return this.configuration.getDefaultProtocol();
    }

    public void init() throws Exception {
        LOGGER.info("JamesMailStore init... {}", (Object)this);
        for (MailRepositoryStoreConfiguration.Item item : this.configuration.getItems()) {
            this.initEntry(item);
        }
    }

    private void initEntry(MailRepositoryStoreConfiguration.Item item) {
        for (Protocol protocol : item.getProtocols()) {
            this.protocolToClass.put(protocol, item.getClassFqdn());
            this.perProtocolMailRepositoryDefaultConfiguration.put(protocol, item.getConfiguration());
        }
    }

    public Stream<MailRepositoryUrl> getUrls() {
        return this.urlStore.listDistinct();
    }

    public Optional<MailRepository> get(MailRepositoryUrl url) {
        return Optional.of(url).filter(arg_0 -> ((MailRepositoryUrlStore)this.urlStore).contains(arg_0)).map(this::select);
    }

    public Stream<MailRepository> getByPath(MailRepositoryPath path) {
        return this.urlStore.listDistinct().filter(url -> url.getPath().equals((Object)path)).map(this::select);
    }

    public MailRepository select(MailRepositoryUrl mailRepositoryUrl) {
        return this.destinationToRepositoryAssociations.computeIfAbsent(mailRepositoryUrl, Throwing.function(this::createNewMailRepository).sneakyThrow());
    }

    private MailRepository createNewMailRepository(MailRepositoryUrl mailRepositoryUrl) throws MailRepositoryStore.MailRepositoryStoreException {
        MailRepository newMailRepository = this.retrieveMailRepository(mailRepositoryUrl);
        this.initializeNewRepository(newMailRepository, this.createRepositoryCombinedConfig(mailRepositoryUrl));
        this.urlStore.add(mailRepositoryUrl);
        return newMailRepository;
    }

    private CombinedConfiguration createRepositoryCombinedConfig(MailRepositoryUrl mailRepositoryUrl) {
        CombinedConfiguration config = new CombinedConfiguration();
        Optional.ofNullable(this.perProtocolMailRepositoryDefaultConfiguration.get(mailRepositoryUrl.getProtocol())).ifPresent(arg_0 -> ((CombinedConfiguration)config).addConfiguration(arg_0));
        config.setProperty("[@destinationURL]", (Object)mailRepositoryUrl.asString());
        return config;
    }

    private void initializeNewRepository(MailRepository mailRepository, CombinedConfiguration config) throws MailRepositoryStore.MailRepositoryStoreException {
        try {
            if (mailRepository instanceof Configurable) {
                ((Configurable)mailRepository).configure((HierarchicalConfiguration)config);
            }
            if (mailRepository instanceof Initializable) {
                ((Initializable)mailRepository).init();
            }
        }
        catch (Exception e) {
            throw new MailRepositoryStore.UnsupportedRepositoryStoreException("Cannot init mail repository", (Throwable)e);
        }
    }

    private MailRepository retrieveMailRepository(MailRepositoryUrl mailRepositoryUrl) throws MailRepositoryStore.MailRepositoryStoreException {
        Protocol protocol = mailRepositoryUrl.getProtocol();
        Optional<String> fullyQualifiedClass = Optional.ofNullable(this.protocolToClass.get(protocol));
        ThrowingFunction fqcnToMailRepository = className -> this.mailRepositoryLoader.load(className, mailRepositoryUrl);
        return (MailRepository)fullyQualifiedClass.map(Throwing.function((ThrowingFunction)fqcnToMailRepository).sneakyThrow()).orElseThrow(() -> new MailRepositoryStore.UnsupportedRepositoryStoreException("No Mail Repository associated with " + protocol.getValue()));
    }
}

