/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import jakarta.inject.Inject;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.opensearch.client.opensearch.core.InfoResponse;
import org.opensearch.client.transport.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchStartUpCheck
implements StartUpCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchStartUpCheck.class);
    private static final Version RECOMMENDED_OS_VERSION = Version.parse((String)"2.0.0");
    private static final String VERSION_CHECKING_ERROR_MESSAGE = "Error when checking ES version";
    public static final String CHECK_NAME = "OpenSearchStartUpCheck";
    private final ReactorOpenSearchClient client;

    @Inject
    private OpenSearchStartUpCheck(ReactorOpenSearchClient client) {
        this.client = client;
    }

    public StartUpCheck.CheckResult check() {
        try {
            Version esVersion = Version.parse((String)((InfoResponse)this.client.info().block()).version().number());
            if (this.isCompatible(esVersion)) {
                return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.GOOD).build();
            }
            String esVersionCompatibilityWarn = String.format("ES version(%s) is not compatible with the recommendation(%s)", esVersion.toString(), RECOMMENDED_OS_VERSION.toString());
            LOGGER.warn(esVersionCompatibilityWarn);
            return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.BAD).description(esVersionCompatibilityWarn).build();
        }
        catch (Exception e) {
            LOGGER.error(VERSION_CHECKING_ERROR_MESSAGE, (Throwable)e);
            return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.BAD).description("Error when checking ES version: " + e.getMessage()).build();
        }
    }

    public String checkName() {
        return CHECK_NAME;
    }

    private boolean isCompatible(Version usedVersion) {
        return usedVersion.major() > RECOMMENDED_OS_VERSION.major() || usedVersion.major() == RECOMMENDED_OS_VERSION.major() && usedVersion.minor() >= RECOMMENDED_OS_VERSION.minor();
    }
}

