/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.generic;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.client.opensearch.generic.Body;
import org.opensearch.client.opensearch.generic.Response;

final class GenericResponse
implements Response {
    private final String protocol;
    private final String method;
    private final String uri;
    private final int status;
    private final String reason;
    private final Collection<Map.Entry<String, String>> headers;
    private final Body body;

    GenericResponse(String uri, String protocol, String method, int status, String reason, Collection<Map.Entry<String, String>> headers) {
        this(uri, protocol, method, status, reason, headers, null);
    }

    GenericResponse(String uri, String protocol, String method, int status, String reason, Collection<Map.Entry<String, String>> headers, Body body) {
        this.uri = Objects.requireNonNull(uri, "uri cannot be null");
        this.protocol = Objects.requireNonNull(protocol, "protocol cannot be null");
        this.method = Objects.requireNonNull(method, "method cannot be null");
        this.status = status;
        this.reason = reason;
        this.headers = Objects.requireNonNull(headers, "headers cannot be null");
        this.body = body;
    }

    @Override
    public Optional<Body> getBody() {
        return Optional.ofNullable(this.body);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public Collection<Map.Entry<String, String>> getHeaders() {
        return Collections.unmodifiableCollection(this.headers);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        GenericResponse other = (GenericResponse)obj;
        return this.method.equals(other.method) && this.protocol.equals(other.protocol) && this.uri.equals(other.uri) && Objects.equals(this.reason, other.reason) && this.headers.equals(other.headers) && this.status == other.status && Objects.equals(this.body, other.body);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.protocol, this.uri, this.status, this.reason, this.headers, this.body);
    }

    @Override
    public void close() throws IOException {
        if (this.body != null) {
            this.body.close();
        }
    }
}

