/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch.generic.GenericByteArrayBody;
import org.opensearch.client.opensearch.generic.GenericInputStreamBody;

public interface Body
extends AutoCloseable {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    @Nullable
    public static Body from(@Nullable InputStream body, @Nullable String contentType) {
        if (body == null) {
            return null;
        }
        return new GenericInputStreamBody(body, contentType);
    }

    @Nullable
    public static Body from(@Nullable byte[] body, @Nullable String contentType) {
        if (body == null) {
            return null;
        }
        return new GenericByteArrayBody(body, contentType);
    }

    public String contentType();

    public InputStream body();

    default public String bodyAsString() {
        return new String(this.bodyAsBytes(), StandardCharsets.UTF_8);
    }

    default public byte[] bodyAsBytes() {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            try (InputStream in = this.body();){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = in.read(buffer, 0, 8192)) >= 0) {
                    out.write(buffer, 0, read);
                }
            }
            out.flush();
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        out.close();
        return byArray;
    }

    @Override
    public void close() throws IOException;
}

