/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.dangling_indices.list_dangling_indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class DanglingIndex
implements PlainJsonSerializable {
    private final String indexName;
    private final String indexUuid;
    private final String creationDateMillis;
    private final List<String> nodeIds;
    public static final JsonpDeserializer<DanglingIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DanglingIndex::setupDanglingIndexDeserializer);

    private DanglingIndex(Builder builder) {
        this.indexName = ApiTypeHelper.requireNonNull(builder.indexName, this, "indexName");
        this.indexUuid = ApiTypeHelper.requireNonNull(builder.indexUuid, this, "indexUuid");
        this.creationDateMillis = ApiTypeHelper.requireNonNull(builder.creationDateMillis, this, "creationDateMillis");
        this.nodeIds = ApiTypeHelper.unmodifiableRequired(builder.nodeIds, (Object)this, "nodeIds");
    }

    public static DanglingIndex of(Function<Builder, ObjectBuilder<DanglingIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String indexUuid() {
        return this.indexUuid;
    }

    public final String creationDateMillis() {
        return this.creationDateMillis;
    }

    public final List<String> nodeIds() {
        return this.nodeIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_name");
        generator.write(this.indexName);
        generator.writeKey("index_uuid");
        generator.write(this.indexUuid);
        generator.writeKey("creation_date_millis");
        generator.write(this.creationDateMillis);
        if (ApiTypeHelper.isDefined(this.nodeIds)) {
            generator.writeKey("node_ids");
            generator.writeStartArray();
            for (String item0 : this.nodeIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDanglingIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
        op.add(Builder::indexUuid, JsonpDeserializer.stringDeserializer(), "index_uuid");
        op.add(Builder::creationDateMillis, JsonpDeserializer.stringDeserializer(), "creation_date_millis");
        op.add(Builder::nodeIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "node_ids");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DanglingIndex> {
        private String indexName;
        private String indexUuid;
        private String creationDateMillis;
        private List<String> nodeIds;

        public final Builder indexName(String value) {
            this.indexName = value;
            return this;
        }

        public final Builder indexUuid(String value) {
            this.indexUuid = value;
            return this;
        }

        public final Builder creationDateMillis(String value) {
            this.creationDateMillis = value;
            return this;
        }

        public final Builder nodeIds(List<String> list) {
            this.nodeIds = Builder._listAddAll(this.nodeIds, list);
            return this;
        }

        public final Builder nodeIds(String value, String ... values) {
            this.nodeIds = Builder._listAdd(this.nodeIds, value, values);
            return this;
        }

        @Override
        public DanglingIndex build() {
            this._checkSingleUse();
            return new DanglingIndex(this);
        }
    }
}

