/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.BulkIndexByScrollFailure;
import org.opensearch.client.opensearch._types.Retries;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ReindexResponse
implements PlainJsonSerializable {
    @Nullable
    private final Long batches;
    @Nullable
    private final Long created;
    @Nullable
    private final Long deleted;
    private final List<BulkIndexByScrollFailure> failures;
    @Nullable
    private final Long noops;
    @Nullable
    private final Retries retries;
    @Nullable
    private final Long requestsPerSecond;
    @Nullable
    private final Integer sliceId;
    @Nullable
    private final String task;
    @Nullable
    private final String throttledMillis;
    @Nullable
    private final String throttledUntilMillis;
    @Nullable
    private final Boolean timedOut;
    @Nullable
    private final Time took;
    @Nullable
    private final Long total;
    @Nullable
    private final Long updated;
    @Nullable
    private final Long versionConflicts;
    public static final JsonpDeserializer<ReindexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexResponse::setupReindexResponseDeserializer);

    private ReindexResponse(Builder builder) {
        this.batches = builder.batches;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.noops = builder.noops;
        this.retries = builder.retries;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.sliceId = builder.sliceId;
        this.task = builder.task;
        this.throttledMillis = builder.throttledMillis;
        this.throttledUntilMillis = builder.throttledUntilMillis;
        this.timedOut = builder.timedOut;
        this.took = builder.took;
        this.total = builder.total;
        this.updated = builder.updated;
        this.versionConflicts = builder.versionConflicts;
    }

    public static ReindexResponse of(Function<Builder, ObjectBuilder<ReindexResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long batches() {
        return this.batches;
    }

    @Nullable
    public final Long created() {
        return this.created;
    }

    @Nullable
    public final Long deleted() {
        return this.deleted;
    }

    public final List<BulkIndexByScrollFailure> failures() {
        return this.failures;
    }

    @Nullable
    public final Long noops() {
        return this.noops;
    }

    @Nullable
    public final Retries retries() {
        return this.retries;
    }

    @Nullable
    public final Long requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public final Integer sliceId() {
        return this.sliceId;
    }

    @Nullable
    public final String task() {
        return this.task;
    }

    @Nullable
    public final String throttledMillis() {
        return this.throttledMillis;
    }

    @Nullable
    public final String throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    @Nullable
    public final Boolean timedOut() {
        return this.timedOut;
    }

    @Nullable
    public final Time took() {
        return this.took;
    }

    @Nullable
    public final Long total() {
        return this.total;
    }

    @Nullable
    public final Long updated() {
        return this.updated;
    }

    @Nullable
    public final Long versionConflicts() {
        return this.versionConflicts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.batches != null) {
            generator.writeKey("batches");
            generator.write(this.batches.longValue());
        }
        if (this.created != null) {
            generator.writeKey("created");
            generator.write(this.created.longValue());
        }
        if (this.deleted != null) {
            generator.writeKey("deleted");
            generator.write(this.deleted.longValue());
        }
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (BulkIndexByScrollFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.noops != null) {
            generator.writeKey("noops");
            generator.write(this.noops.longValue());
        }
        if (this.retries != null) {
            generator.writeKey("retries");
            this.retries.serialize(generator, mapper);
        }
        if (this.requestsPerSecond != null) {
            generator.writeKey("requests_per_second");
            generator.write(this.requestsPerSecond.longValue());
        }
        if (this.sliceId != null) {
            generator.writeKey("slice_id");
            generator.write(this.sliceId.intValue());
        }
        if (this.task != null) {
            generator.writeKey("task");
            generator.write(this.task);
        }
        if (this.throttledMillis != null) {
            generator.writeKey("throttled_millis");
            generator.write(this.throttledMillis);
        }
        if (this.throttledUntilMillis != null) {
            generator.writeKey("throttled_until_millis");
            generator.write(this.throttledUntilMillis);
        }
        if (this.timedOut != null) {
            generator.writeKey("timed_out");
            generator.write(this.timedOut.booleanValue());
        }
        if (this.took != null) {
            generator.writeKey("took");
            this.took.serialize(generator, mapper);
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total.longValue());
        }
        if (this.updated != null) {
            generator.writeKey("updated");
            generator.write(this.updated.longValue());
        }
        if (this.versionConflicts != null) {
            generator.writeKey("version_conflicts");
            generator.write(this.versionConflicts.longValue());
        }
    }

    protected static void setupReindexResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::batches, JsonpDeserializer.longDeserializer(), "batches");
        op.add(Builder::created, JsonpDeserializer.longDeserializer(), "created");
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(BulkIndexByScrollFailure._DESERIALIZER), "failures");
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops");
        op.add(Builder::retries, Retries._DESERIALIZER, "retries");
        op.add(Builder::requestsPerSecond, JsonpDeserializer.longDeserializer(), "requests_per_second");
        op.add(Builder::sliceId, JsonpDeserializer.integerDeserializer(), "slice_id");
        op.add(Builder::task, JsonpDeserializer.stringDeserializer(), "task");
        op.add(Builder::throttledMillis, JsonpDeserializer.stringDeserializer(), "throttled_millis");
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.stringDeserializer(), "throttled_until_millis");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::took, Time._DESERIALIZER, "took");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::updated, JsonpDeserializer.longDeserializer(), "updated");
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ReindexResponse> {
        @Nullable
        private Long batches;
        @Nullable
        private Long created;
        @Nullable
        private Long deleted;
        @Nullable
        private List<BulkIndexByScrollFailure> failures;
        @Nullable
        private Long noops;
        @Nullable
        private Retries retries;
        @Nullable
        private Long requestsPerSecond;
        @Nullable
        private Integer sliceId;
        @Nullable
        private String task;
        @Nullable
        private String throttledMillis;
        @Nullable
        private String throttledUntilMillis;
        @Nullable
        private Boolean timedOut;
        @Nullable
        private Time took;
        @Nullable
        private Long total;
        @Nullable
        private Long updated;
        @Nullable
        private Long versionConflicts;

        public final Builder batches(@Nullable Long value) {
            this.batches = value;
            return this;
        }

        public final Builder created(@Nullable Long value) {
            this.created = value;
            return this;
        }

        public final Builder deleted(@Nullable Long value) {
            this.deleted = value;
            return this;
        }

        public final Builder failures(List<BulkIndexByScrollFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(BulkIndexByScrollFailure value, BulkIndexByScrollFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder failures(Function<BulkIndexByScrollFailure.Builder, ObjectBuilder<BulkIndexByScrollFailure>> fn) {
            return this.failures(fn.apply(new BulkIndexByScrollFailure.Builder()).build(), new BulkIndexByScrollFailure[0]);
        }

        public final Builder noops(@Nullable Long value) {
            this.noops = value;
            return this;
        }

        public final Builder retries(@Nullable Retries value) {
            this.retries = value;
            return this;
        }

        public final Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        public final Builder requestsPerSecond(@Nullable Long value) {
            this.requestsPerSecond = value;
            return this;
        }

        public final Builder sliceId(@Nullable Integer value) {
            this.sliceId = value;
            return this;
        }

        public final Builder task(@Nullable String value) {
            this.task = value;
            return this;
        }

        public final Builder throttledMillis(@Nullable String value) {
            this.throttledMillis = value;
            return this;
        }

        public final Builder throttledUntilMillis(@Nullable String value) {
            this.throttledUntilMillis = value;
            return this;
        }

        public final Builder timedOut(@Nullable Boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder took(@Nullable Time value) {
            this.took = value;
            return this;
        }

        public final Builder took(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.took(fn.apply(new Time.Builder()).build());
        }

        public final Builder total(@Nullable Long value) {
            this.total = value;
            return this;
        }

        public final Builder updated(@Nullable Long value) {
            this.updated = value;
            return this;
        }

        public final Builder versionConflicts(@Nullable Long value) {
            this.versionConflicts = value;
            return this;
        }

        @Override
        public ReindexResponse build() {
            this._checkSingleUse();
            return new ReindexResponse(this);
        }
    }
}

