/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class DateHistogramBucket
extends MultiBucketBase {
    @Nullable
    private final String keyAsString;
    private final String key;
    public static final JsonpDeserializer<DateHistogramBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateHistogramBucket::setupDateHistogramBucketDeserializer);

    private DateHistogramBucket(Builder builder) {
        super(builder);
        this.keyAsString = builder.keyAsString;
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
    }

    public static DateHistogramBucket of(Function<Builder, ObjectBuilder<DateHistogramBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    public final String key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
        generator.writeKey("key");
        generator.write(this.key);
    }

    protected static void setupDateHistogramBucketDeserializer(ObjectDeserializer<Builder> op) {
        DateHistogramBucket.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateHistogramBucket> {
        @Nullable
        private String keyAsString;
        private String key;

        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        public final Builder key(String value) {
            this.key = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateHistogramBucket build() {
            this._checkSingleUse();
            return new DateHistogramBucket(this);
        }
    }
}

