/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.async;

import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkProtectedApi;

@SdkProtectedApi
public final class ContentLengthAwareSubscriber
implements Subscriber<ByteBuffer> {
    private final Subscriber<? super ByteBuffer> subscriber;
    private Subscription subscription;
    private boolean subscriptionCancelled;
    private long remaining;

    public ContentLengthAwareSubscriber(Subscriber<? super ByteBuffer> subscriber, long contentLength) {
        this.subscriber = subscriber;
        this.remaining = contentLength;
    }

    public void onSubscribe(Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription must not be null");
        }
        this.subscription = subscription;
        this.subscriber.onSubscribe(subscription);
    }

    public void onNext(ByteBuffer byteBuffer) {
        if (this.remaining > 0L) {
            long bytesToRead = Math.min(this.remaining, (long)byteBuffer.remaining());
            byteBuffer.limit(byteBuffer.position() + (int)bytesToRead);
            this.remaining -= bytesToRead;
            this.subscriber.onNext((Object)byteBuffer);
        }
        if (this.remaining == 0L && !this.subscriptionCancelled) {
            this.subscriptionCancelled = true;
            this.subscription.cancel();
            this.onComplete();
        }
    }

    public void onError(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable cannot be null");
        }
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }
}

