/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.james.util.AuditTrail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidRcptHandler
implements RcptHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractValidRcptHandler.class);

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        try {
            if (!this.isLocalDomain(session, rcpt.getDomain())) {
                return HookResult.DECLINED;
            }
            if (!this.isValidRecipient(session, rcpt)) {
                return this.reject(session, rcpt);
            }
            return HookResult.DECLINED;
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Encounter an error upon RCPT validation ({}), deny", (Object)rcpt.asString());
            return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("550").smtpDescription(DSNStatus.getStatus(5, "1.1") + " Unknown user: " + rcpt.asString()).build();
        }
        catch (Exception e) {
            LOGGER.error("Encounter an error upon RCPT validation ({}), deny-soft", (Object)rcpt.asString(), (Object)e);
            return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("451").smtpDescription(DSNStatus.getStatus(4, "0.0") + " Unexpected error for " + rcpt.asString()).build();
        }
    }

    public HookResult reject(SMTPSession session, MailAddress rcpt) {
        MaybeSender sender = session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).orElse(MaybeSender.nullSender());
        AuditTrail.entry().username(() -> Optional.ofNullable(session.getUsername()).map(Username::asString).orElse("")).remoteIP(() -> Optional.ofNullable(session.getRemoteAddress())).sessionId(() -> ((SMTPSession)session).getSessionID()).protocol("SMTP").action("SPOOL").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"sender", (Object)sender.asString(), (Object)"recipient", (Object)rcpt.asString()))).log("Rejected message. Unknown user: " + rcpt.asString());
        return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("550").smtpDescription(DSNStatus.getStatus(5, "1.1") + " Unknown user: " + rcpt.asString()).build();
    }

    protected abstract boolean isValidRecipient(SMTPSession var1, MailAddress var2) throws Exception;

    protected abstract boolean isLocalDomain(SMTPSession var1, Domain var2) throws Exception;
}

