/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.io.FileNotFoundException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.healthcheck.MailReceptionCheck;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailReceptionHealthCheckModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailReceptionHealthCheckModule.class);
    private static final String FILENAME = "healthcheck";

    protected void configure() {
        Multibinder healthCheckMultibinder = Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class);
        healthCheckMultibinder.addBinding().to(MailReceptionCheck.class);
    }

    @Singleton
    @Provides
    MailReceptionCheck.Configuration configuration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfigurations(new String[]{FILENAME});
            return MailReceptionCheck.Configuration.from((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find {} configuration file, using default configuration", (Object)FILENAME);
            return MailReceptionCheck.Configuration.DEFAULT;
        }
    }
}

