/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.MimeDescriptor;

final class MimeDescriptorStructure
implements FetchResponse.Structure {
    private final MimeDescriptor descriptor;
    private final List<String> parameters;
    private final List<FetchResponse.Structure> parts;
    private final String disposition;
    private final Map<String, String> dispositionParams;
    private final String location;
    private final String md5;
    private final List<String> languages;
    private final FetchResponse.Structure embeddedMessageStructure;
    private final FetchResponse.Envelope envelope;

    public MimeDescriptorStructure(boolean allowExtensions, MimeDescriptor descriptor, EnvelopeBuilder builder) throws MailboxException {
        this.descriptor = descriptor;
        this.parameters = MimeDescriptorStructure.createParameters(descriptor);
        this.parts = MimeDescriptorStructure.createParts(allowExtensions, descriptor, builder);
        this.languages = descriptor.getLanguages();
        this.dispositionParams = descriptor.getDispositionParams();
        this.disposition = descriptor.getDisposition();
        this.md5 = descriptor.getContentMD5();
        this.location = descriptor.getContentLocation();
        MimeDescriptor embeddedMessage = descriptor.embeddedMessage();
        if (embeddedMessage == null) {
            this.embeddedMessageStructure = null;
            this.envelope = null;
        } else {
            this.embeddedMessageStructure = new MimeDescriptorStructure(allowExtensions, embeddedMessage, builder);
            this.envelope = builder.buildEnvelope((Headers)embeddedMessage);
        }
    }

    private static List<FetchResponse.Structure> createParts(boolean allowExtensions, MimeDescriptor descriptor, EnvelopeBuilder builder) throws MailboxException {
        ArrayList<FetchResponse.Structure> results = new ArrayList<FetchResponse.Structure>();
        Iterator it = descriptor.parts();
        while (it.hasNext()) {
            MimeDescriptor partDescriptor = (MimeDescriptor)it.next();
            results.add(new MimeDescriptorStructure(allowExtensions, partDescriptor, builder));
        }
        return results;
    }

    private static List<String> createParameters(MimeDescriptor descriptor) throws MailboxException {
        ArrayList<String> results = new ArrayList<String>();
        for (Map.Entry entry : descriptor.contentTypeParameters().entrySet()) {
            results.add((String)entry.getKey());
            results.add((String)entry.getValue());
        }
        return results;
    }

    @Override
    public String getDescription() {
        return this.descriptor.getContentDescription();
    }

    @Override
    public String getEncoding() {
        return this.descriptor.getTransferContentEncoding();
    }

    @Override
    public String getId() {
        return this.descriptor.getContentID();
    }

    @Override
    public long getLines() {
        return this.descriptor.getLines();
    }

    @Override
    public String getMediaType() {
        return this.descriptor.getMimeType();
    }

    @Override
    public long getOctets() {
        return this.descriptor.getBodyOctets();
    }

    @Override
    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getSubType() {
        return this.descriptor.getMimeSubType();
    }

    @Override
    public Iterator<FetchResponse.Structure> parts() {
        return this.parts.iterator();
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getMD5() {
        return this.md5;
    }

    @Override
    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    public FetchResponse.Structure getBody() {
        return this.embeddedMessageStructure;
    }

    @Override
    public Map<String, String> getDispositionParams() {
        return this.dispositionParams;
    }

    @Override
    public FetchResponse.Envelope getEnvelope() {
        return this.envelope;
    }
}

