/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import jakarta.inject.Inject;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.core.Username;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.FetchRequest;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.imap.processor.fetch.FetchDataConverter;
import org.apache.james.imap.processor.fetch.FetchResponseBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.DurationParser;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.SizeFormat;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.publisher.SynchronousSink;

public class FetchProcessor
extends AbstractMailboxProcessor<FetchRequest> {
    public static final String CACHE_KEY = "message-saved-for-later";
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchProcessor.class);
    private final LocalCacheConfiguration localCacheConfiguration;

    @Inject
    public FetchProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, LocalCacheConfiguration localCacheConfiguration) {
        super(FetchRequest.class, mailboxManager, factory, metricFactory);
        this.localCacheConfiguration = localCacheConfiguration;
    }

    @Override
    protected Mono<Void> processRequestReactive(FetchRequest request, ImapSession session, ImapProcessor.Responder responder) {
        IdRange[] idSet = request.getIdSet();
        FetchData fetch = this.computeFetchData(request, session);
        long changedSince = fetch.getChangedSince();
        return Mono.fromCallable(() -> Optional.ofNullable(session.getSelected())).handle((a, sink) -> a.ifPresentOrElse(arg_0 -> ((SynchronousSink)sink).next(arg_0), () -> sink.error((Throwable)new MailboxException("Session not in SELECTED state")))).flatMap(selected -> this.processFetch(request, session, responder, (SelectedMailbox)selected, fetch, changedSince)).doOnEach(ReactorUtils.logOnError(MessageRangeException.class, e -> LOGGER.debug("Fetch failed for mailbox {} because of invalid sequence-set {}", new Object[]{Optional.ofNullable(session.getSelected()).map(SelectedMailbox::getMailboxId), idSet, e}))).onErrorResume(MessageRangeException.class, e -> {
            this.taggedBad(request, responder, HumanReadableText.INVALID_MESSAGESET);
            return Mono.empty();
        }).doOnEach(ReactorUtils.logOnError(MailboxException.class, e -> LOGGER.error("Fetch failed for mailbox {} and sequence-set {}", new Object[]{Optional.ofNullable(session.getSelected()).map(SelectedMailbox::getMailboxId), idSet, e}))).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.SEARCH_FAILED);
            return Mono.empty();
        });
    }

    private Mono<Void> processFetch(FetchRequest request, ImapSession session, ImapProcessor.Responder responder, SelectedMailbox selected, FetchData fetch, long changedSince) {
        MailboxSession mailboxSession = session.getMailboxSession();
        return Mono.from((Publisher)this.getMailboxManager().getMailboxReactive(selected.getMailboxId(), mailboxSession)).flatMap(Throwing.function(mailbox -> {
            boolean vanished = fetch.getVanished();
            if (vanished && !EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
                this.taggedBad(request, responder, HumanReadableText.QRESYNC_NOT_ENABLED);
                return Mono.empty();
            }
            if (vanished && changedSince == -1L) {
                this.taggedBad(request, responder, HumanReadableText.QRESYNC_VANISHED_WITHOUT_CHANGEDSINCE);
                return Mono.empty();
            }
            boolean constoreCommand = fetch.getChangedSince() != -1L || fetch.contains(FetchData.Item.MODSEQ);
            Set<Capability> enabled = EnableProcessor.getEnabledCapabilities(session);
            if (constoreCommand && !enabled.contains(ImapConstants.SUPPORTS_CONDSTORE)) {
                return mailbox.getMetaDataReactive(MessageManager.MailboxMetaData.RecentMode.IGNORE, mailboxSession, EnumSet.of(MessageManager.MailboxMetaData.Item.HighestModSeq)).doOnNext(metaData -> this.condstoreEnablingCommand(session, responder, (MessageManager.MailboxMetaData)metaData, true)).flatMap(Throwing.function(any -> this.doFetch(selected, request, responder, fetch, mailboxSession, (MessageManager)mailbox, session)).sneakyThrow());
            }
            return this.doFetch(selected, request, responder, fetch, mailboxSession, (MessageManager)mailbox, session);
        }).sneakyThrow()).then();
    }

    private Mono<Void> doFetch(SelectedMailbox selected, FetchRequest request, ImapProcessor.Responder responder, FetchData fetch, MailboxSession mailboxSession, MessageManager mailbox, ImapSession session) throws MailboxException {
        ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
        for (IdRange range : request.getIdSet()) {
            Optional<MessageRange> messageSet = this.messageRange(session.getSelected(), range, request.isUseUids());
            if (!messageSet.isPresent()) continue;
            MessageRange normalizedMessageSet = this.normalizeMessageRange(selected, messageSet.orElse(null));
            MessageRange batchedMessageSet = MessageRange.range((MessageUid)normalizedMessageSet.getUidFrom(), (MessageUid)normalizedMessageSet.getUidTo());
            ranges.add(batchedMessageSet);
        }
        if (fetch.getVanished()) {
            this.respondVanished(selected, ranges, responder);
        }
        boolean omitExpunged = !request.isUseUids();
        return this.processMessageRanges(selected, mailbox, ranges, fetch, mailboxSession, responder, session).then(this.unsolicitedResponses(session, responder, omitExpunged, request.isUseUids())).then(Mono.fromRunnable(() -> this.okComplete(request, responder)));
    }

    private FetchData computeFetchData(FetchRequest request, ImapSession session) {
        if (EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
            return FetchData.Builder.from(request.getFetch()).fetch(FetchData.Item.UID).build();
        }
        return request.getFetch();
    }

    private Mono<Void> processMessageRanges(SelectedMailbox selected, MessageManager mailbox, List<MessageRange> ranges, FetchData fetch, MailboxSession mailboxSession, ImapProcessor.Responder responder, ImapSession imapSession) {
        FetchGroup resultToFetch = FetchDataConverter.getFetchGroup(fetch);
        if (fetch.isOnlyFlags()) {
            return Flux.fromIterable(this.consolidate(selected, ranges, fetch)).concatMap(range -> Flux.from((Publisher)mailbox.listMessagesMetadata(range, mailboxSession))).filter(ids -> !fetch.contains(FetchData.Item.MODSEQ) || ids.getModSeq().asLong() > fetch.getChangedSince()).concatMap(result -> this.toResponse(mailbox, fetch, mailboxSession, selected, (ComposedMessageIdWithMetaData)result)).doOnNext(responder::respond).then();
        }
        FetchSubscriber fetchSubscriber = new FetchSubscriber(imapSession, responder);
        boolean singleMessage = ranges.size() == 1 && ranges.getFirst().getUidFrom().equals((Object)ranges.getFirst().getUidTo());
        boolean shouldCache = fetch.getBodyElements().stream().anyMatch(bodyFetchElement -> bodyFetchElement.getNumberOfOctets() != null);
        if (singleMessage && shouldCache) {
            DefaultLocalMessageCache localMessageCache = new DefaultLocalMessageCache(imapSession, this.localCacheConfiguration);
            localMessageCache.lookupInCache(mailbox.getId(), ranges.getFirst().getUidFrom(), resultToFetch).map(Flux::just).orElseGet(() -> Flux.from((Publisher)mailbox.getMessagesReactive((MessageRange)ranges.getFirst(), resultToFetch, mailboxSession)).doOnNext(message -> localMessageCache.saveForLater((MessageResult)message, resultToFetch))).filter(ids -> !fetch.contains(FetchData.Item.MODSEQ) || ids.getModSeq().asLong() > fetch.getChangedSince()).concatMap(result -> this.toResponse(mailbox, fetch, mailboxSession, selected, (MessageResult)result)).subscribe((Subscriber)fetchSubscriber);
        } else {
            Flux.fromIterable(this.consolidate(selected, ranges, fetch)).doOnNext(range -> FetchProcessor.auditTrail(mailbox, mailboxSession, resultToFetch, range)).concatMap(range -> Flux.from((Publisher)mailbox.getMessagesReactive(range, resultToFetch, mailboxSession))).filter(ids -> !fetch.contains(FetchData.Item.MODSEQ) || ids.getModSeq().asLong() > fetch.getChangedSince()).concatMap(result -> this.toResponse(mailbox, fetch, mailboxSession, selected, (MessageResult)result)).subscribe((Subscriber)fetchSubscriber);
        }
        return fetchSubscriber.completionMono();
    }

    List<MessageRange> consolidate(SelectedMailbox selected, List<MessageRange> ranges, FetchData fetchData) {
        if (fetchData.getPartialRange().isEmpty()) {
            return ranges;
        }
        LongArrayList longs = new LongArrayList();
        selected.allUids().stream().filter(uid -> ranges.stream().anyMatch(range -> range.includes(uid))).forEach(arg_0 -> FetchProcessor.lambda$consolidate$26((LongList)longs, arg_0));
        LongList filter = fetchData.getPartialRange().get().filter((LongList)longs);
        return MessageRange.toRanges((Collection)((Collection)filter.longStream().mapToObj(MessageUid::of).collect(ImmutableList.toImmutableList())));
    }

    private Mono<FetchResponse> toResponse(MessageManager mailbox, FetchData fetch, MailboxSession mailboxSession, SelectedMailbox selected, ComposedMessageIdWithMetaData result) {
        try {
            return new FetchResponseBuilder(new EnvelopeBuilder()).build(fetch, result, mailbox, selected, mailboxSession);
        }
        catch (MessageRangeException e) {
            LOGGER.debug("Unable to find message with uid {}", (Object)result.getComposedMessageId().getUid(), (Object)e);
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Unable to find message with uid {}", (Object)result.getComposedMessageId().getUid(), (Object)e)).then(Mono.empty());
        }
        catch (MailboxException e) {
            return ReactorUtils.logAsMono(() -> LOGGER.error("Unable to fetch message with uid {}, so skip it", (Object)result.getComposedMessageId().getUid(), (Object)e)).then(Mono.empty());
        }
    }

    private Mono<FetchResponse> toResponse(MessageManager mailbox, FetchData fetch, MailboxSession mailboxSession, SelectedMailbox selected, MessageResult result) {
        try {
            return new FetchResponseBuilder(new EnvelopeBuilder()).build(fetch, result, mailbox, selected, mailboxSession);
        }
        catch (MessageRangeException e) {
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Unable to find message with uid {}", (Object)result.getUid(), (Object)e)).then(Mono.empty());
        }
        catch (MailboxException e) {
            return ReactorUtils.logAsMono(() -> LOGGER.error("Unable to fetch message with uid {}, so skip it", (Object)result.getUid(), (Object)e)).then(Mono.empty());
        }
    }

    private static void auditTrail(MessageManager mailbox, MailboxSession mailboxSession, FetchGroup resultToFetch, MessageRange range) {
        if (resultToFetch.equals((Object)FetchGroup.FULL_CONTENT)) {
            AuditTrail.entry().username(() -> mailboxSession.getUser().asString()).protocol("IMAP").action("FETCH").parameters(() -> ImmutableMap.of((Object)"loggedInUser", (Object)mailboxSession.getLoggedInUser().map(Username::asString).orElse(""), (Object)"mailboxId", (Object)mailbox.getId().serialize(), (Object)"messageUids", (Object)range.toString())).log("IMAP FETCH full content read.");
        }
    }

    @Override
    protected MDCBuilder mdc(FetchRequest request) {
        return MDCBuilder.create().addToContext("action", "FETCH").addToContext("useUid", Boolean.toString(request.isUseUids())).addToContext("idSet", IdRange.toString(request.getIdSet())).addToContext("fetchedData", request.getFetch().toString());
    }

    private static /* synthetic */ void lambda$consolidate$26(LongList longs, MessageUid uid) {
        longs.add(uid.asLong());
    }

    public record LocalCacheConfiguration(Duration ttl, long sizeInBytes, boolean enabled) {
        public static final LocalCacheConfiguration DEFAULT = new LocalCacheConfiguration(Duration.ofMinutes(2L), 524288000L, false);

        public static LocalCacheConfiguration from(Configuration configuration) {
            return new LocalCacheConfiguration(DurationParser.parse((String)configuration.getString("partialBodyFetchCacheDuration", "2m"), (ChronoUnit)ChronoUnit.MINUTES), SizeFormat.parseAsByteCount((String)configuration.getString("partialBodyFetchCacheSize", "500 MiB")), configuration.getBoolean("partialBodyFetchCacheEnabled", false));
        }
    }

    static class FetchSubscriber
    implements Subscriber<FetchResponse> {
        private final AtomicReference<Subscription> subscription = new AtomicReference();
        private final Sinks.One<Void> sink = Sinks.one();
        private final ImapSession imapSession;
        private final ImapProcessor.Responder responder;

        FetchSubscriber(ImapSession imapSession, ImapProcessor.Responder responder) {
            this.imapSession = imapSession;
            this.responder = responder;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription.set(subscription);
            this.requestOne();
        }

        public void onNext(FetchResponse fetchResponse) {
            AtomicBoolean mustRequestOne = new AtomicBoolean(true);
            this.responder.respond(fetchResponse);
            Runnable requestOne = () -> {
                if (mustRequestOne.getAndSet(false)) {
                    LOGGER.info("Resuming IMAP FETCH for user {}", (Object)this.imapSession.getUserName().asString());
                    this.requestOne();
                }
            };
            if (this.imapSession.backpressureNeeded(requestOne)) {
                LOGGER.info("Applying backpressure as user {} is a slow reader", (Object)this.imapSession.getUserName().asString());
            } else if (mustRequestOne.getAndSet(false)) {
                this.requestOne();
            }
        }

        private void requestOne() {
            Optional.ofNullable(this.subscription.get()).ifPresent(s -> s.request(1L));
        }

        public void onError(Throwable throwable) {
            this.subscription.set(null);
            this.sink.tryEmitError(throwable);
        }

        public void onComplete() {
            this.subscription.set(null);
            this.sink.tryEmitEmpty();
        }

        public Mono<Void> completionMono() {
            return this.sink.asMono().doOnCancel(() -> {
                Optional.ofNullable(this.subscription.get()).ifPresent(Subscription::cancel);
                this.subscription.set(null);
            });
        }
    }

    public static class DefaultLocalMessageCache
    implements LocalMessageCache {
        public static final ReferenceQueue<LocalCacheEntry> REFERENCE_QUEUE = new ReferenceQueue();
        public static final AtomicLong TOTAL_SIZE = new AtomicLong(0L);
        private final ImapSession imapSession;
        private final LocalCacheConfiguration configuration;

        DefaultLocalMessageCache(ImapSession imapSession, LocalCacheConfiguration configuration) {
            this.imapSession = imapSession;
            this.configuration = configuration;
        }

        @Override
        public Optional<MessageResult> lookupInCache(MailboxId mailboxId, MessageUid uid, FetchGroup fetchGroup) {
            if (!this.configuration.enabled()) {
                return Optional.empty();
            }
            return this.retrieveCachedEntry().filter(entry -> entry.fetchGroup().equals((Object)fetchGroup)).filter(entry -> entry.message().getMailboxId().equals((Object)mailboxId)).filter(entry -> entry.message().getUid().equals((Object)uid)).map(LocalCacheEntry::message);
        }

        private Optional<LocalCacheEntry> retrieveCachedEntry() {
            Optional<Object> maybeMessage = Optional.ofNullable(this.imapSession.getAttribute(FetchProcessor.CACHE_KEY));
            Optional<Object> cacheContent = maybeMessage.filter(SoftReference.class::isInstance).flatMap(ref -> {
                SoftReference softReference = (SoftReference)ref;
                return Optional.ofNullable(softReference.get());
            }).filter(LocalCacheEntry.class::isInstance).map(LocalCacheEntry.class::cast);
            return cacheContent;
        }

        @Override
        public void saveForLater(MessageResult messageResult, FetchGroup fetchGroup) {
            if (!this.configuration.enabled()) {
                return;
            }
            if (TOTAL_SIZE.get() <= this.configuration.sizeInBytes()) {
                Reference<LocalCacheEntry> referenceFromQueue;
                SoftReference<LocalCacheEntry> ref = new SoftReference<LocalCacheEntry>(new LocalCacheEntry(fetchGroup, messageResult), REFERENCE_QUEUE);
                TOTAL_SIZE.addAndGet(messageResult.getSize());
                this.imapSession.setAttribute(FetchProcessor.CACHE_KEY, ref);
                this.imapSession.schedule(() -> {
                    this.retrieveCachedEntry().ifPresent(entry -> TOTAL_SIZE.addAndGet(-1L * entry.message().getSize()));
                    this.imapSession.setAttribute(FetchProcessor.CACHE_KEY, null);
                }, this.configuration.ttl());
                while ((referenceFromQueue = REFERENCE_QUEUE.poll()) != null) {
                    Optional.ofNullable(referenceFromQueue.get()).ifPresent(entry -> TOTAL_SIZE.addAndGet(-1L * entry.message().getSize()));
                }
            }
        }
    }

    static interface LocalMessageCache {
        public Optional<MessageResult> lookupInCache(MailboxId var1, MessageUid var2, FetchGroup var3);

        public void saveForLater(MessageResult var1, FetchGroup var2);
    }

    record LocalCacheEntry(FetchGroup fetchGroup, MessageResult message) {
    }
}

