/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.MailboxName;
import org.apache.james.imap.message.request.ListRightsRequest;
import org.apache.james.imap.message.response.ListRightsResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ListRightsProcessor
extends AbstractMailboxProcessor<ListRightsRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListRightsProcessor.class);
    private static final List<Capability> CAPABILITIES = ImmutableList.of((Object)ImapConstants.SUPPORTS_ACL);
    private final PathConverter.Factory pathConverterFactory;

    @Inject
    public ListRightsProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, PathConverter.Factory pathConverterFactory) {
        super(ListRightsRequest.class, mailboxManager, factory, metricFactory);
        this.pathConverterFactory = pathConverterFactory;
    }

    @Override
    protected Mono<Void> processRequestReactive(ListRightsRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        MailboxName mailboxName = request.getMailboxName();
        MailboxPath mailboxPath = this.pathConverterFactory.forSession(session).buildFullPath(mailboxName.asString());
        return Mono.from((Publisher)mailboxManager.getMailboxReactive(mailboxPath, mailboxSession)).doOnNext(Throwing.consumer(mailbox -> {
            if (!mailboxManager.hasRight(mailbox.getMailboxEntity(), MailboxACL.Right.Lookup, mailboxSession)) {
                this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            } else if (!mailboxManager.hasRight(mailbox.getMailboxEntity(), MailboxACL.Right.Administer, mailboxSession)) {
                Object[] params = new Object[]{MailboxACL.Right.Administer.toString(), request.getCommand().getName(), mailboxName};
                HumanReadableText text = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(request, responder, text);
            } else {
                List rights = mailboxManager.listRights(mailbox.getMailboxEntity(), request.getEntryKey(), mailboxSession);
                ListRightsResponse aclResponse = new ListRightsResponse(mailboxName, request.getEntryKey(), rights);
                responder.respond(aclResponse);
                this.okComplete(request, responder);
            }
        }).sneakyThrow()).then().onErrorResume(MailboxNotFoundException.class, e -> {
            this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            return Mono.empty();
        }).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
            return ReactorUtils.logAsMono(() -> LOGGER.error("{} failed for mailbox {}", new Object[]{request.getCommand().getName(), mailboxName, e}));
        });
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected MDCBuilder mdc(ListRightsRequest request) {
        return MDCBuilder.create().addToContext("action", "LIST_RIGHTS").addToContext("mailbox", request.getMailboxName().asString()).addToContext("identifier", request.getEntryKey().toString());
    }
}

