/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.RabbitMQManagementAPI;
import org.apache.james.queue.rabbitmq.MailQueueName;

public class RabbitMQMailQueueManagement {
    private final RabbitMQManagementAPI api;
    private final Optional<String> vhost;

    @Inject
    RabbitMQMailQueueManagement(RabbitMQConfiguration configuration) {
        this.api = RabbitMQManagementAPI.from((RabbitMQConfiguration)configuration);
        this.vhost = configuration.getVhost();
    }

    @VisibleForTesting
    RabbitMQMailQueueManagement(RabbitMQManagementAPI api) {
        this.api = api;
        this.vhost = Optional.empty();
    }

    Stream<MailQueueName> listCreatedMailQueueNames() {
        return this.vhost.map(arg_0 -> ((RabbitMQManagementAPI)this.api).listVhostQueues(arg_0)).orElse(this.api.listQueues()).stream().map(RabbitMQManagementAPI.MessageQueue::getName).map(MailQueueName::fromRabbitWorkQueueName).flatMap(Optional::stream).distinct();
    }

    @VisibleForTesting
    public void deleteAllQueues() {
        this.api.listQueues().forEach(queue -> this.api.deleteQueue("/", queue.getName()));
    }
}

