/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.filtering;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.ReactiveSubscriber;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.RuleDTO;
import org.apache.james.jmap.api.filtering.Rules;
import org.apache.james.jmap.api.filtering.Version;
import org.apache.james.jmap.api.filtering.impl.EventSourcingFilteringManagement;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregate;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CassandraFilteringProjection
implements EventSourcingFilteringManagement.ReadProjection,
ReactiveSubscriber {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement readStatement;
    private final PreparedStatement readVersionStatement;
    private final ObjectMapper objectMapper;

    @Inject
    public CassandraFilteringProjection(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"filters_projection").value("aggregate_id", (Term)QueryBuilder.bindMarker((String)"aggregate_id")).value("event_id", (Term)QueryBuilder.bindMarker((String)"event_id")).value("rules", (Term)QueryBuilder.bindMarker((String)"rules")).build());
        this.readStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"filters_projection").all().whereColumn("aggregate_id").isEqualTo((Term)QueryBuilder.bindMarker((String)"aggregate_id"))).build());
        this.readVersionStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"filters_projection").column("event_id").whereColumn("aggregate_id").isEqualTo((Term)QueryBuilder.bindMarker((String)"aggregate_id"))).build());
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
    }

    public Publisher<Rules> listRulesForUser(Username username) {
        return this.executor.executeSingleRow((Statement)this.readStatement.bind(new Object[0]).setString("aggregate_id", new FilteringAggregateId(username).asAggregateKey())).handle((row, sink) -> {
            try {
                Rules rules = this.parseRules((Row)row);
                sink.next((Object)rules);
            }
            catch (JsonProcessingException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Publisher<Version> getLatestVersion(Username username) {
        return this.executor.executeSingleRow((Statement)this.readVersionStatement.bind(new Object[0]).setString("aggregate_id", new FilteringAggregateId(username).asAggregateKey())).map(this::parseVersion);
    }

    public Optional<ReactiveSubscriber> subscriber() {
        return Optional.of(this);
    }

    public Publisher<Void> handleReactive(EventWithState eventWithState) {
        Event event = eventWithState.event();
        FilteringAggregate.FilterState state = (FilteringAggregate.FilterState)eventWithState.state().get();
        return this.persistRules(event.getAggregateId(), event.eventId(), (ImmutableList<Rule>)state.getRules());
    }

    private Mono<Void> persistRules(AggregateId aggregateId, EventId eventId, ImmutableList<Rule> rules) {
        try {
            return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setString("aggregate_id", aggregateId.asAggregateKey())).setInt("event_id", eventId.value())).setString("rules", this.objectMapper.writeValueAsString((Object)RuleDTO.from(rules))));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
    }

    private Version parseVersion(Row row) {
        return new Version(row.getInt("event_id"));
    }

    private Rules parseRules(Row row) throws JsonProcessingException {
        String serializedRules = row.getString("rules");
        List ruleDTOS = (List)this.objectMapper.readValue(serializedRules, (TypeReference)new TypeReference<List<RuleDTO>>(this){});
        Version version = this.parseVersion(row);
        return new Rules((List)RuleDTO.toRules((List)ruleDTOS), version);
    }
}

