/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres.utils;

import jakarta.inject.Inject;
import java.time.Duration;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.jooq.SelectField;
import org.jooq.impl.DSL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PostgresHealthCheck
implements HealthCheck {
    public static final ComponentName COMPONENT_NAME = new ComponentName("Postgres");
    private final PostgresExecutor postgresExecutor;

    @Inject
    public PostgresHealthCheck(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Publisher<Result> check() {
        return this.postgresExecutor.executeRow(context -> Mono.from((Publisher)context.select((SelectField)DSL.now()))).timeout(Duration.ofSeconds(5L)).map(any -> Result.healthy((ComponentName)COMPONENT_NAME)).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Failed to execute request against postgres", (Throwable)e)));
    }
}

