/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.ContextConverter;
import org.jooq.Converter;
import org.jooq.ConverterContext;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractContextConverter;
import org.jooq.impl.Tools;

public class AutoConverter<T, U>
extends AbstractContextConverter<T, U> {
    public AutoConverter(Class<T> fromType, Class<U> toType) {
        super(fromType, toType);
    }

    @Override
    public U from(T t, ConverterContext ctx) {
        return this.delegate(ctx).from(t, ctx);
    }

    @Override
    public T to(U u, ConverterContext ctx) {
        return this.delegate(ctx).to(u, ctx);
    }

    private final ContextConverter<T, U> delegate(ConverterContext ctx) {
        Converter c = ctx.configuration().converterProvider().provide(this.fromType(), this.toType());
        if (c == null) {
            c = Tools.CONFIG.get().converterProvider().provide(this.fromType(), this.toType());
        }
        if (c == null) {
            throw new DataTypeException("Cannot auto convert from " + String.valueOf(this.fromType()) + " to " + String.valueOf(this.toType()));
        }
        return ContextConverter.scoped(c);
    }

    @Override
    public String toString() {
        return "AutoConverter [ " + this.fromType().getName() + " -> " + this.toType().getName() + " ]";
    }
}

