/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class NodeInfoHttp
implements PlainJsonSerializable {
    private final List<String> boundAddress;
    @Nullable
    private final String maxContentLength;
    private final long maxContentLengthInBytes;
    private final String publishAddress;
    public static final JsonpDeserializer<NodeInfoHttp> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoHttp::setupNodeInfoHttpDeserializer);

    private NodeInfoHttp(Builder builder) {
        this.boundAddress = ApiTypeHelper.unmodifiableRequired(builder.boundAddress, (Object)this, "boundAddress");
        this.maxContentLength = builder.maxContentLength;
        this.maxContentLengthInBytes = ApiTypeHelper.requireNonNull(builder.maxContentLengthInBytes, this, "maxContentLengthInBytes");
        this.publishAddress = ApiTypeHelper.requireNonNull(builder.publishAddress, this, "publishAddress");
    }

    public static NodeInfoHttp of(Function<Builder, ObjectBuilder<NodeInfoHttp>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> boundAddress() {
        return this.boundAddress;
    }

    @Nullable
    public final String maxContentLength() {
        return this.maxContentLength;
    }

    public final long maxContentLengthInBytes() {
        return this.maxContentLengthInBytes;
    }

    public final String publishAddress() {
        return this.publishAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.boundAddress)) {
            generator.writeKey("bound_address");
            generator.writeStartArray();
            for (String item0 : this.boundAddress) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.maxContentLength != null) {
            generator.writeKey("max_content_length");
            generator.write(this.maxContentLength);
        }
        generator.writeKey("max_content_length_in_bytes");
        generator.write(this.maxContentLengthInBytes);
        generator.writeKey("publish_address");
        generator.write(this.publishAddress);
    }

    protected static void setupNodeInfoHttpDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::boundAddress, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "bound_address");
        op.add(Builder::maxContentLength, JsonpDeserializer.stringDeserializer(), "max_content_length");
        op.add(Builder::maxContentLengthInBytes, JsonpDeserializer.longDeserializer(), "max_content_length_in_bytes");
        op.add(Builder::publishAddress, JsonpDeserializer.stringDeserializer(), "publish_address");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeInfoHttp> {
        private List<String> boundAddress;
        @Nullable
        private String maxContentLength;
        private Long maxContentLengthInBytes;
        private String publishAddress;

        public final Builder boundAddress(List<String> list) {
            this.boundAddress = Builder._listAddAll(this.boundAddress, list);
            return this;
        }

        public final Builder boundAddress(String value, String ... values) {
            this.boundAddress = Builder._listAdd(this.boundAddress, value, values);
            return this;
        }

        public final Builder maxContentLength(@Nullable String value) {
            this.maxContentLength = value;
            return this;
        }

        public final Builder maxContentLengthInBytes(long value) {
            this.maxContentLengthInBytes = value;
            return this;
        }

        public final Builder publishAddress(String value) {
            this.publishAddress = value;
            return this;
        }

        @Override
        public NodeInfoHttp build() {
            this._checkSingleUse();
            return new NodeInfoHttp(this);
        }
    }
}

