/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.github.fge.lambdas.Throwing;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.function.Supplier;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.user.api.InvalidUsernameException;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.ldap.LDAPConnectionFactory;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.james.user.ldap.ReadOnlyLDAPUsersDAO;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.lib.UsersRepositoryImpl;
import reactor.core.publisher.Mono;

public class ReadOnlyUsersLDAPRepository
extends UsersRepositoryImpl<ReadOnlyLDAPUsersDAO>
implements Configurable {
    private final LdapRepositoryConfiguration ldapConfiguration;

    @Inject
    public ReadOnlyUsersLDAPRepository(DomainList domainList, GaugeRegistry gaugeRegistry, LDAPConnectionPool ldapConnectionPool, LdapRepositoryConfiguration configuration) {
        super(domainList, (UsersDAO)new ReadOnlyLDAPUsersDAO(gaugeRegistry, ldapConnectionPool, configuration));
        this.ldapConfiguration = configuration;
    }

    public ReadOnlyUsersLDAPRepository(DomainList domainList, GaugeRegistry gaugeRegistry, LdapRepositoryConfiguration configuration) throws LDAPException {
        super(domainList, (UsersDAO)new ReadOnlyLDAPUsersDAO(gaugeRegistry, new LDAPConnectionFactory(configuration).getLdapConnectionPool(), configuration));
        this.ldapConfiguration = configuration;
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        super.configure(configuration);
    }

    @PostConstruct
    public void init() throws Exception {
        ((ReadOnlyLDAPUsersDAO)this.usersDAO).init();
    }

    public boolean supportVirtualHosting() {
        return this.ldapConfiguration.supportsVirtualHosting();
    }

    public boolean isAdministrator(Username username) throws UsersRepositoryException {
        this.assertValid(username);
        return this.ldapConfiguration.getAdministratorId().map(ldapAdministratorAttribute -> ldapAdministratorAttribute.equals((Object)username)).orElseGet((Supplier<Boolean>)Throwing.supplier(() -> super.isAdministrator(username)));
    }

    public boolean isReadOnly() {
        return true;
    }

    public void assertValid(Username username) throws UsersRepositoryException {
        this.assertLocalPartValid(username);
        boolean localPartAsLoginUsernameSupported = this.ldapConfiguration.getResolveLocalPartAttribute().isPresent();
        if (!localPartAsLoginUsernameSupported) {
            this.assertDomainPartValid(username);
        }
    }

    public Mono<Void> assertValidReactive(Username username) {
        try {
            this.assertLocalPartValid(username);
            boolean localPartAsLoginUsernameSupported = this.ldapConfiguration.getResolveLocalPartAttribute().isPresent();
            if (!localPartAsLoginUsernameSupported) {
                return this.assertDomainPartValidReactive(username);
            }
            return Mono.empty();
        }
        catch (InvalidUsernameException e) {
            return Mono.error((Throwable)e);
        }
    }
}

