/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.receptionist;

import java.io.Serializable;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.BehaviorImpl;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$SameBehavior$;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$UnhandledBehavior$;
import org.apache.pekko.actor.typed.internal.receptionist.AbstractServiceKey;
import org.apache.pekko.actor.typed.internal.receptionist.LocalReceptionist;
import org.apache.pekko.actor.typed.internal.receptionist.LocalReceptionist$State$;
import org.apache.pekko.actor.typed.internal.receptionist.ReceptionistBehaviorProvider;
import org.apache.pekko.actor.typed.internal.receptionist.ReceptionistMessages;
import org.apache.pekko.actor.typed.receptionist.Receptionist;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.LineNumbers$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class LocalReceptionist$
implements ReceptionistBehaviorProvider {
    public static final LocalReceptionist$ MODULE$ = new LocalReceptionist$();
    private static final String name = "localReceptionist";

    @Override
    public String name() {
        return name;
    }

    @Override
    public Behavior<Receptionist.Command> behavior() {
        Function1 & Serializable setup_factory = (Function1 & Serializable)ctx -> {
            ctx.setLoggerName(LocalReceptionist.class);
            Behavior<Object> behavior = MODULE$.behavior(LocalReceptionist$State$.MODULE$.empty());
            if (behavior == null) {
                throw null;
            }
            return behavior;
        };
        return new BehaviorImpl.DeferredBehavior<T>(setup_factory){
            private final Function1 factory$1;

            public Behavior<T> apply(TypedActorContext<T> ctx) {
                return (Behavior)this.factory$1.apply(ctx.asScala());
            }

            public String toString() {
                return new StringBuilder(10).append("Deferred(").append(LineNumbers$.MODULE$.apply((Object)this.factory$1)).append(")").toString();
            }
            {
                this.factory$1 = factory$1;
            }
        };
    }

    private Behavior<Object> behavior(LocalReceptionist.State state) {
        Function2 & Serializable receive_onMessage = (Function2 & Serializable)(ctx, msg) -> {
            if (msg instanceof Receptionist.Command) {
                Receptionist.Command command = (Receptionist.Command)msg;
                return this.onCommand$1((ActorContext)ctx, command, state);
            }
            if (msg instanceof LocalReceptionist.InternalCommand) {
                LocalReceptionist.InternalCommand internalCommand = (LocalReceptionist.InternalCommand)msg;
                return this.onInternal$1((ActorContext)ctx, internalCommand, state);
            }
            return BehaviorImpl$UnhandledBehavior$.MODULE$;
        };
        return new Behaviors.ReceiveImpl<Object>(receive_onMessage);
    }

    /*
     * WARNING - void declaration
     */
    private static final void notifySubscribersFor$1(AbstractServiceKey key, LocalReceptionist.State newState$1) {
        void apply_servicesWereAddedOrRemoved;
        Set newListing = newState$1.services().get((Object)key);
        boolean bl = true;
        ServiceKey<Object> apply_key = key.asServiceKey();
        Object var4_4 = null;
        ReceptionistMessages.Listing<Object> listing = new ReceptionistMessages.Listing<Object>(apply_key, newListing, newListing, (boolean)apply_servicesWereAddedOrRemoved);
        newState$1.subscriptions().get((Object)key).foreach((Function1 & Serializable)x$1 -> {
            x$1.tell(listing);
            return BoxedUnit.UNIT;
        });
    }

    private final Behavior updateServices$1(Set changedKeysHint, Function1 f, LocalReceptionist.State state$1) {
        LocalReceptionist.State newState = (LocalReceptionist.State)f.apply((Object)state$1);
        changedKeysHint.foreach((Function1 & Serializable)key -> {
            LocalReceptionist$.notifySubscribersFor$1(key, newState);
            return BoxedUnit.UNIT;
        });
        return this.behavior(newState);
    }

    private static final void replyWithListing$1(ServiceKey key, ActorRef replyTo, LocalReceptionist.State state$1) {
        Set listing = state$1.services().get((Object)key);
        boolean apply_servicesWereAddedOrRemoved = true;
        ReceptionistMessages.Listing $bang$extension_msg = new ReceptionistMessages.Listing(key, listing, listing, apply_servicesWereAddedOrRemoved);
        replyTo.tell($bang$extension_msg);
    }

    public static final /* synthetic */ LocalReceptionist.State $anonfun$behavior$4(ServiceKey key$5, ActorRef serviceInstance$4, LocalReceptionist.State x$2) {
        return x$2.serviceInstanceAdded(key$5, serviceInstance$4);
    }

    public static final /* synthetic */ LocalReceptionist.State $anonfun$behavior$6(ServiceKey key$6, ActorRef serviceInstance$5, ActorContext ctx$1, LocalReceptionist.State state) {
        LocalReceptionist.State newState = state.serviceInstanceRemoved(key$6, serviceInstance$5);
        if (((IterableOnceOps)state.servicesPerActor().getOrElse((Object)serviceInstance$5, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).isEmpty()) {
            ctx$1.unwatch(serviceInstance$5);
        }
        return newState;
    }

    private final Behavior onCommand$1(ActorContext ctx, Receptionist.Command cmd, LocalReceptionist.State state$1) {
        if (cmd instanceof ReceptionistMessages.Register) {
            ReceptionistMessages.Register register = (ReceptionistMessages.Register)cmd;
            ServiceKey key2 = register.key();
            ActorRef<Object> serviceInstance = register.serviceInstance();
            Option<ActorRef<Receptionist.Registered>> maybeReplyTo = register.replyTo();
            ctx.log().debug("Actor was registered: {} {}", key2, serviceInstance);
            if (!state$1.servicesPerActor().contains(serviceInstance)) {
                ctx.watchWith(serviceInstance, new LocalReceptionist.RegisteredActorTerminated(serviceInstance));
            }
            if (maybeReplyTo instanceof Some) {
                ActorRef replyTo = (ActorRef)((Some)maybeReplyTo).value();
                ReceptionistMessages.Registered $bang$extension_msg = new ReceptionistMessages.Registered(key2, serviceInstance);
                replyTo.tell($bang$extension_msg);
                Object var25_9 = null;
            } else if (!None$.MODULE$.equals(maybeReplyTo)) {
                throw new MatchError(maybeReplyTo);
            }
            Set updateServices$1_changedKeysHint = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractServiceKey[]{key2}));
            LocalReceptionist.State updateServices$1_newState = state$1.serviceInstanceAdded(key2, serviceInstance);
            updateServices$1_changedKeysHint.foreach((Function1 & Serializable)key -> {
                LocalReceptionist$.notifySubscribersFor$1(key, newState);
                return BoxedUnit.UNIT;
            });
            return this.behavior(updateServices$1_newState);
        }
        if (cmd instanceof ReceptionistMessages.Deregister) {
            ReceptionistMessages.Deregister deregister = (ReceptionistMessages.Deregister)cmd;
            ServiceKey key3 = deregister.key();
            ActorRef serviceInstance = deregister.serviceInstance();
            Option<ActorRef<Receptionist.Deregistered>> maybeReplyTo = deregister.replyTo();
            Set servicesForActor = (Set)state$1.servicesPerActor().getOrElse(serviceInstance, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            if (servicesForActor.isEmpty()) {
                return BehaviorImpl$SameBehavior$.MODULE$;
            }
            ctx.log().debug("Actor was deregistered: {} {}", key3, serviceInstance);
            if (servicesForActor.$minus(key3).isEmpty()) {
                ctx.unwatch(serviceInstance);
            }
            if (maybeReplyTo instanceof Some) {
                ActorRef replyTo = (ActorRef)((Some)maybeReplyTo).value();
                ReceptionistMessages.Deregistered $bang$extension_msg = new ReceptionistMessages.Deregistered(key3, serviceInstance);
                replyTo.tell($bang$extension_msg);
                Object var26_18 = null;
            } else if (!None$.MODULE$.equals(maybeReplyTo)) {
                throw new MatchError(maybeReplyTo);
            }
            Set updateServices$1_changedKeysHint = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractServiceKey[]{key3}));
            LocalReceptionist.State updateServices$1_newState = LocalReceptionist$.$anonfun$behavior$6(key3, serviceInstance, ctx, state$1);
            updateServices$1_changedKeysHint.foreach((Function1 & Serializable)key -> {
                LocalReceptionist$.notifySubscribersFor$1(key, newState);
                return BoxedUnit.UNIT;
            });
            return this.behavior(updateServices$1_newState);
        }
        if (cmd instanceof ReceptionistMessages.Find) {
            ReceptionistMessages.Find find = (ReceptionistMessages.Find)cmd;
            ServiceKey key4 = find.key();
            ActorRef<Receptionist.Listing> replyTo = find.replyTo();
            LocalReceptionist$.replyWithListing$1(key4, replyTo, state$1);
            return BehaviorImpl$SameBehavior$.MODULE$;
        }
        if (cmd instanceof ReceptionistMessages.Subscribe) {
            ReceptionistMessages.Subscribe subscribe = (ReceptionistMessages.Subscribe)cmd;
            ServiceKey key5 = subscribe.key();
            ActorRef<Receptionist.Listing> subscriber = subscribe.subscriber();
            if (!state$1.subscriptionsPerActor().contains(subscriber)) {
                ctx.watchWith(subscriber, new LocalReceptionist.SubscriberTerminated(subscriber));
            }
            LocalReceptionist$.replyWithListing$1(key5, subscriber, state$1);
            return this.behavior(state$1.subscriberAdded(key5, subscriber));
        }
        throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected command type ").append(cmd.getClass()).toString());
    }

    public static final /* synthetic */ LocalReceptionist.State $anonfun$behavior$9(ActorRef serviceInstance$6, LocalReceptionist.State x$3) {
        return x$3.serviceInstanceRemoved(serviceInstance$6);
    }

    private final Behavior onInternal$1(ActorContext ctx, LocalReceptionist.InternalCommand cmd, LocalReceptionist.State state$1) {
        if (cmd instanceof LocalReceptionist.RegisteredActorTerminated) {
            ActorRef serviceInstance = ((LocalReceptionist.RegisteredActorTerminated)cmd).ref();
            Set keys = (Set)state$1.servicesPerActor().getOrElse(serviceInstance, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            if (keys.isEmpty()) {
                return BehaviorImpl$SameBehavior$.MODULE$;
            }
            ctx.log().debug("Registered actor terminated: [{}] {}", (Object)keys.mkString(","), serviceInstance);
            LocalReceptionist.State updateServices$1_newState = state$1.serviceInstanceRemoved(serviceInstance);
            keys.foreach((Function1 & Serializable)key -> {
                LocalReceptionist$.notifySubscribersFor$1(key, newState);
                return BoxedUnit.UNIT;
            });
            return this.behavior(updateServices$1_newState);
        }
        if (cmd instanceof LocalReceptionist.SubscriberTerminated) {
            ActorRef subscriber = ((LocalReceptionist.SubscriberTerminated)cmd).ref();
            if (ctx.log().isDebugEnabled()) {
                Set keys = (Set)state$1.subscriptionsPerActor().getOrElse(subscriber, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
                ctx.log().debug("Subscribed actor terminated: [{}] {}", (Object)keys.mkString(","), subscriber);
            }
            return this.behavior(state$1.subscriberRemoved(subscriber));
        }
        throw new MatchError((Object)cmd);
    }

    private LocalReceptionist$() {
    }
}

