/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import com.google.common.base.CharMatcher;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.numeric;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.method.AccountNotFoundException;
import org.apache.james.jmap.routes.Blob;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.jmap.routes.DownloadRoutes$;
import org.apache.james.jmap.routes.ForbiddenException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import shapeless._0;

@ScalaSignature(bytes="\u0006\u0005\t-v!B\u0016-\u0011\u00039d!B\u001d-\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005bB\"\u0002\u0005\u0004%\t\u0001\u0012\u0005\u0007\u0017\u0006\u0001\u000b\u0011B#\t\u000f1\u000b!\u0019!C\u0001\u001b\"1\u0011+\u0001Q\u0001\n93A!\u000f\u0017\u0001%\"Aql\u0002BC\u0002\u0013\u0005\u0001\r\u0003\u0005h\u000f\t\u0005\t\u0015!\u0003b\u0011!AwA!b\u0001\n\u0003I\u0007\u0002C7\b\u0005\u0003\u0005\u000b\u0011\u00026\t\u00119<!Q1A\u0005\u0002=D\u0001B^\u0004\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\to\u001e\u0011)\u0019!C\u0001q\"I\u00111A\u0004\u0003\u0002\u0003\u0006I!\u001f\u0005\u0007\u0003\u001e!\t!!\u0002\t\u0013\u0005ErA1A\u0005\n\u0005M\u0002\u0002CA&\u000f\u0001\u0006I!!\u000e\t\u0013\u00055sA1A\u0005\n\u0005M\u0002\u0002CA(\u000f\u0001\u0006I!!\u000e\t\u0013\u0005EsA1A\u0005\n\u0005M\u0002\u0002CA*\u000f\u0001\u0006I!!\u000e\t\u0013\u0005UsA1A\u0005\n\u0005M\u0002\u0002CA,\u000f\u0001\u0006I!!\u000e\t\u0013\u0005esA1A\u0005\n\u0005m\u0003\u0002CA1\u000f\u0001\u0006I!!\u0018\t\u0013\u0005\rtA1A\u0005\n\u0005\u0015\u0004\u0002CA7\u000f\u0001\u0006I!a\u001a\t\r5:A\u0011IA8\u0011\u001d\t9i\u0002C\u0005\u0003\u0013Cq!a\"\b\t\u0013\t\u0019\rC\u0004\u0002l\u001e!I!!<\t\u000f\u0005Ux\u0001\"\u0003\u0002x\"9!qD\u0004\u0005\n\t\u0005\u0002b\u0002B\u0016\u000f\u0011%!Q\u0006\u0005\b\u0005g9A\u0011\u0002B\u001b\u0011\u001d\u0011yg\u0002C\u0005\u0005cBqAa\u001d\b\t\u0013\u0011)\bC\u0004\u0003\u0000\u001d!IA!!\t\u000f\t\u0015u\u0001\"\u0003\u0003\b\"9!QQ\u0004\u0005\n\tE\u0005b\u0002BM\u000f\u0011%!1T\u0001\u000f\t><h\u000e\\8bIJ{W\u000f^3t\u0015\tic&\u0001\u0004s_V$Xm\u001d\u0006\u0003_A\nAA[7ba*\u0011\u0011GM\u0001\u0006U\u0006lWm\u001d\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005a\nQ\"\u0001\u0017\u0003\u001d\u0011{wO\u001c7pC\u0012\u0014v.\u001e;fgN\u0011\u0011a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0014A\u0002'P\u000f\u001e+%+F\u0001F!\t1\u0015*D\u0001H\u0015\tAE'A\u0003tY\u001a$$.\u0003\u0002K\u000f\n1Aj\\4hKJ\fq\u0001T(H\u000f\u0016\u0013\u0006%A\u0006C+\u001a3UIU0T\u0013j+U#\u0001(\u0011\u0005qz\u0015B\u0001)>\u0005\rIe\u000e^\u0001\r\u0005V3e)\u0012*`'&SV\tI\n\u0004\u000fM[\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0011a\u0017M\\4\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005qkV\"\u0001\u0018\n\u0005ys#A\u0003&N\u0003B\u0013v.\u001e;fg\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I:\nA\u0001\u001b;ua&\u0011am\u0019\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005i!\r\\8c%\u0016\u001cx\u000e\u001c<feN,\u0012A\u001b\t\u0003q-L!\u0001\u001c\u0017\u0003\u001b\tcwN\u0019*fg>dg/\u001a:t\u00039\u0011Gn\u001c2SKN|GN^3sg\u0002\n\u0011c]3tg&|g\u000e\u0016:b]Nd\u0017\r^8s+\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:/\u0003\u0011\u0019wN]3\n\u0005U\u0014(!E*fgNLwN\u001c+sC:\u001cH.\u0019;pe\u0006\u00112/Z:tS>tGK]1og2\fGo\u001c:!\u00035iW\r\u001e:jG\u001a\u000b7\r^8ssV\t\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006\u0019\u0011\r]5\u000b\u0005y\u0004\u0014aB7fiJL7m]\u0005\u0004\u0003\u0003Y(!D'fiJL7MR1di>\u0014\u00180\u0001\bnKR\u0014\u0018n\u0019$bGR|'/\u001f\u0011\u0015\u0015\u0005\u001d\u0011\u0011BA\u0012\u0003K\t9\u0003\u0005\u00029\u000f!)q\f\u0005a\u0001C\"B\u0011\u0011BA\u0007\u0003;\ty\u0002\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\r%t'.Z2u\u0015\t\t9\"A\u0004kC.\f'\u000f^1\n\t\u0005m\u0011\u0011\u0003\u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003C\t\u0001B\u0015$D[a2$'\r\u0005\u0006QB\u0001\rA\u001b\u0005\u0006]B\u0001\r\u0001\u001d\u0005\u0006oB\u0001\r!\u001f\u0015\u0004!\u0005-\u0002\u0003BA\b\u0003[IA!a\f\u0002\u0012\t1\u0011J\u001c6fGR\fa\"Y2d_VtG/\u00133QCJ\fW.\u0006\u0002\u00026A!\u0011qGA#\u001d\u0011\tI$!\u0011\u0011\u0007\u0005mR(\u0004\u0002\u0002>)\u0019\u0011q\b\u001c\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019%P\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0013\u0011\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\rS(A\bbG\u000e|WO\u001c;JIB\u000b'/Y7!\u0003-\u0011Gn\u001c2JIB\u000b'/Y7\u0002\u0019\tdwNY%e!\u0006\u0014\u0018-\u001c\u0011\u0002\u00139\fW.\u001a)be\u0006l\u0017A\u00038b[\u0016\u0004\u0016M]1nA\u0005\u00012m\u001c8uK:$H+\u001f9f!\u0006\u0014\u0018-\\\u0001\u0012G>tG/\u001a8u)f\u0004X\rU1sC6\u0004\u0013a\u00033po:dw.\u00193Ve&,\"!!\u0018\u0011\u0007Q\u000by&C\u0002\u0002HU\u000bA\u0002Z8x]2|\u0017\rZ+sS\u0002\nQ\u0003]3oI&tw\rR8x]2|\u0017\rZ'fiJL7-\u0006\u0002\u0002hA\u0019!0!\u001b\n\u0007\u0005-4P\u0001\u0004NKR\u0014\u0018nY\u0001\u0017a\u0016tG-\u001b8h\t><h\u000e\\8bI6+GO]5dAQ\u0011\u0011\u0011\u000f\t\u0007\u0003g\ni(!!\u000e\u0005\u0005U$\u0002BA<\u0003s\naa\u001d;sK\u0006l'bAA>/\u0006!Q\u000f^5m\u0013\u0011\ty(!\u001e\u0003\rM#(/Z1n!\ra\u00161Q\u0005\u0004\u0003\u000bs#!\u0003&N\u0003B\u0013v.\u001e;f\u0003\r9W\r\u001e\u000b\u0007\u0003\u0017\u000b\u0019+!/\u0011\r\u00055\u0015\u0011TAO\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!\u00039vE2L7\u000f[3s\u0015\r\u0019\u0018Q\u0013\u0006\u0003\u0003/\u000bqA]3bGR|'/\u0003\u0003\u0002\u001c\u0006=%\u0001B'p]>\u00042\u0001VAP\u0013\r\t\t+\u0016\u0002\u0005->LG\rC\u0004\u0002&z\u0001\r!a*\u0002\u000fI,\u0017/^3tiB!\u0011\u0011VA[\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016AB:feZ,'OC\u0002e\u0003cSA!a-\u0002\u0016\u0006)a.\u001a;us&!\u0011qWAV\u0005EAE\u000f\u001e9TKJ4XM\u001d*fcV,7\u000f\u001e\u0005\b\u0003ws\u0002\u0019AA_\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BAU\u0003\u007fKA!!1\u0002,\n\u0011\u0002\n\u001e;q'\u0016\u0014h/\u001a:SKN\u0004xN\\:f)!\t)-a6\u0002Z\u0006m\u0007CBAd\u0003\u001b\f\t.\u0004\u0002\u0002J*!\u0011\u0011SAf\u0015\rq\u00141S\u0005\u0005\u0003\u001f\fIMA\u0003T\u001b>tw\u000eE\u0002=\u0003'L1!!6>\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015v\u00041\u0001\u0002(\"9\u00111X\u0010A\u0002\u0005u\u0006bBAo?\u0001\u0007\u0011q\\\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\u0011\t\t/a:\u000e\u0005\u0005\r(bAAsa\u00059Q.Y5mE>D\u0018\u0002BAu\u0003G\u0014a\"T1jY\n|\u0007pU3tg&|g.\u0001\u0006hKRLemT<oKJ$\u0002\"!2\u0002p\u0006E\u00181\u001f\u0005\b\u0003K\u0003\u0003\u0019AAT\u0011\u001d\tY\f\ta\u0001\u0003{Cq!!8!\u0001\u0004\ty.\u0001\u0007e_^tGn\\1e\u00052|'\r\u0006\u0006\u0002F\u0006e(1\u0001B\u0003\u0005+Aq!a?\"\u0001\u0004\ti0\u0001\u0007paRLwN\\1m\u001d\u0006lW\rE\u0003=\u0003\u007f\f)$C\u0002\u0003\u0002u\u0012aa\u00149uS>t\u0007bBA^C\u0001\u0007\u0011Q\u0018\u0005\b\u0005\u000f\t\u0003\u0019\u0001B\u0005\u0003=\u0011Gn\u001c2D_:$XM\u001c;UsB,\u0007\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\t\t=\u00111]\u0001\u0006[>$W\r\\\u0005\u0005\u0005'\u0011iAA\u0006D_:$XM\u001c;UsB,\u0007b\u0002B\fC\u0001\u0007!\u0011D\u0001\u0005E2|'\rE\u00029\u00057I1A!\b-\u0005\u0011\u0011En\u001c2\u00027\u0005$GmQ8oi\u0016tG\u000fR5ta>\u001c\u0018\u000e^5p]\"+\u0017\rZ3s)\u0011\u0011\u0019C!\u000b\u0011\u000fq\u0012)#!0\u0002>&\u0019!qE\u001f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBA~E\u0001\u0007\u0011Q`\u0001\u0014g\u0006t\u0017\u000e^5{K\"+\u0017\rZ3s-\u0006dW/\u001a\u000b\u0005\u0003k\u0011y\u0003C\u0004\u00032\r\u0002\r!!\u000e\u0002\u0003M\fa#\u00193e\u0007>tG/\u001a8u\u0019\u0016tw\r\u001e5IK\u0006$WM\u001d\u000b\u0005\u0005G\u00119\u0004C\u0004\u0003:\u0011\u0002\rAa\u000f\u0002\u000fML'0\u001a+ssB1!Q\bB!\u0005\u000bj!Aa\u0010\u000b\u0007\u0005mT(\u0003\u0003\u0003D\t}\"a\u0001+ssB!!q\tB5\u001d\u0011\u0011IEa\u0019\u000f\t\t-#q\f\b\u0005\u0005\u001b\u0012iF\u0004\u0003\u0003P\tmc\u0002\u0002B)\u00053rAAa\u0015\u0003X9!\u00111\bB+\u0013\u0005)\u0014BA\u001a5\u0013\t\t$'\u0003\u00020a%\u0011APL\u0005\u0005\u0005\u001f\u0011\tG\u0003\u0002}]%!!Q\rB4\u0003\u0011\u0019\u0016N_3\u000b\t\t=!\u0011M\u0005\u0005\u0005W\u0012iG\u0001\u0003TSj,'\u0002\u0002B3\u0005O\nQ#\u00193e\u0007\u0006\u001c\u0007.Z\"p]R\u0014x\u000e\u001c%fC\u0012,'\u000f\u0006\u0002\u0003$\u0005a\u0013\r\u001a3D_:$XM\u001c;ESN\u0004xn]5uS>t\u0007*Z1eKJ\u0014VmZ1sI&tw-\u00128d_\u0012Lgn\u001a\u000b\u0007\u0003{\u00139Ha\u001f\t\u000f\ted\u00051\u0001\u00026\u0005!a.Y7f\u0011\u001d\u0011iH\na\u0001\u0003{\u000bAA]3ta\u0006yQM\\2pI\u0016$g)\u001b7f\u001d\u0006lW\r\u0006\u0003\u0002^\t\r\u0005b\u0002B=O\u0001\u0007\u0011QG\u0001\u000bcV,'/\u001f)be\u0006lGCBA\u007f\u0005\u0013\u0013i\tC\u0004\u0003\f\"\u0002\r!a*\u0002\u0017!$H\u000f\u001d*fcV,7\u000f\u001e\u0005\b\u0005\u001fC\u0003\u0019AA\u001b\u00035\u0001\u0018M]1nKR,'OT1nKR1\u0011Q BJ\u0005+CqAa$*\u0001\u0004\t)\u0004C\u0004\u0003\u0018&\u0002\r!!\u000e\u0002\u0007U\u0014\u0018.\u0001\bsKN\u0004xN\u001c3EKR\f\u0017\u000e\\:\u0015\r\u0005\u0015'Q\u0014BQ\u0011\u001d\u0011yJ\u000ba\u0001\u0003{\u000b!\u0003\u001b;uaN+'O^3s%\u0016\u001c\bo\u001c8tK\"9!1\u0015\u0016A\u0002\t\u0015\u0016a\u00023fi\u0006LGn\u001d\t\u0004c\n\u001d\u0016b\u0001BUe\nq\u0001K]8cY\u0016lG)\u001a;bS2\u001c\b")
public class DownloadRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final BlobResolvers blobResolvers;
    private final SessionTranslator sessionTranslator;
    private final MetricFactory metricFactory;
    private final String accountIdParam;
    private final String blobIdParam;
    private final String nameParam;
    private final String contentTypeParam;
    private final String downloadUri;
    private final Metric pendingDownloadMetric;

    public static int BUFFER_SIZE() {
        return DownloadRoutes$.MODULE$.BUFFER_SIZE();
    }

    public static Logger LOGGER() {
        return DownloadRoutes$.MODULE$.LOGGER();
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public BlobResolvers blobResolvers() {
        return this.blobResolvers;
    }

    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    private String accountIdParam() {
        return this.accountIdParam;
    }

    private String blobIdParam() {
        return this.blobIdParam;
    }

    private String nameParam() {
        return this.nameParam;
    }

    private String contentTypeParam() {
        return this.contentTypeParam;
    }

    private String downloadUri() {
        return this.downloadUri;
    }

    private Metric pendingDownloadMetric() {
        return this.pendingDownloadMetric;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, this.downloadUri())).action((request, response) -> this.get(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, this.downloadUri())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private Mono<Void> get(HttpServerRequest request, HttpServerResponse response) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> this.getIfOwner(request, response, (MailboxSession)mailboxSession)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ForbiddenException ? true : throwable instanceof AccountNotFoundException) {
                HttpResponseStatus x$1 = HttpResponseStatus.FORBIDDEN;
                String x$2 = "You cannot download in others accounts";
                String x$3 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$3, x$1, x$4, "You cannot download in others accounts"));
            }
            if (throwable instanceof UnauthorizedException) {
                UnauthorizedException unauthorizedException = (UnauthorizedException)throwable;
                DownloadRoutes$.MODULE$.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
                HttpResponseStatus x$5 = HttpResponseStatus.UNAUTHORIZED;
                String x$6 = unauthorizedException.getMessage();
                String x$7 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$7, x$5, x$8, x$6));
            }
            if (throwable instanceof BlobNotFoundException) {
                HttpResponseStatus x$9 = HttpResponseStatus.NOT_FOUND;
                String x$10 = "The resource could not be found";
                String x$11 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$12 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$11, x$9, x$12, "The resource could not be found"));
            }
            DownloadRoutes$.MODULE$.LOGGER().error("Unexpected error upon download {}", (Object)request.uri(), (Object)throwable);
            HttpResponseStatus x$13 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String x$14 = throwable.getMessage();
            String x$15 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$16 = ProblemDetails$.MODULE$.apply$default$3();
            return this.respondDetails(response, new ProblemDetails(x$15, x$13, x$16, x$14));
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).asJava().then();
    }

    private SMono<BoxedUnit> get(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        return ((SMono)BlobId$.MODULE$.of(request.param((CharSequence)this.blobIdParam())).fold((Function1 & Serializable)e -> SMono$.MODULE$.error(e), (Function1 & Serializable)x$2 -> this.blobResolvers().resolve((BlobId)x$2, mailboxSession).doOnSubscribe((Function1 & Serializable)x$3 -> {
            DownloadRoutes.$anonfun$get$5(this, x$3);
            return BoxedUnit.UNIT;
        }))).flatMap((Function1 & Serializable)blob -> this.downloadBlob(this.queryParam(request, this.nameParam()), response, (ContentType)this.queryParam(request, this.contentTypeParam()).map((Function1 & Serializable)value -> ContentType.of((String)value)).getOrElse((Function0 & Serializable)() -> blob.contentType()), (Blob)blob).then()).doOnSuccess((Function1 & Serializable)x$4 -> {
            DownloadRoutes.$anonfun$get$9(this, x$4);
            return BoxedUnit.UNIT;
        });
    }

    private SMono<BoxedUnit> getIfOwner(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        Left left;
        IllegalArgumentException throwable;
        Right right;
        String id;
        Either<IllegalArgumentException, Refined<String, Id.IdConstraint>> either = Id$.MODULE$.validate(request.param((CharSequence)this.accountIdParam()));
        if (either instanceof Right && new Refined((Object)(id = (String)((Refined)(right = (Right)either).value()).value())) instanceof Refined) {
            String string2 = id;
            return this.sessionTranslator().delegateIfNeeded(mailboxSession, new AccountId(string2)).flatMap((Function1 & Serializable)session -> this.get(request, response, (MailboxSession)session));
        }
        if (either instanceof Left && (throwable = (IllegalArgumentException)(left = (Left)either).value()) != null) {
            IllegalArgumentException illegalArgumentException = throwable;
            return SMono$.MODULE$.error((Throwable)illegalArgumentException);
        }
        throw new MatchError(either);
    }

    private SMono<BoxedUnit> downloadBlob(Option<String> optionalName, HttpServerResponse response, ContentType blobContentType, Blob blob) {
        Callable<InputStream> resourceSupplier = () -> blob.content();
        Function<InputStream, Mono> sourceSupplier = stream -> SMono$.MODULE$.apply((Publisher)((HttpServerResponse)this.addContentDispositionHeader(optionalName).compose(this.addContentLengthHeader(blob.size())).compose(this.addCacheControlHeader()).apply((Object)response)).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)this.sanitizeHeaderValue(blobContentType.asString())).status(HttpResponseStatus.OK).send((Publisher)ReactorUtils.toChunks((InputStream)stream, (int)DownloadRoutes$.MODULE$.BUFFER_SIZE()).map(x$5 -> Unpooled.wrappedBuffer((ByteBuffer)x$5)).subscribeOn(Schedulers.boundedElastic()))).asJava();
        Consumer<InputStream> resourceRelease = stream -> stream.close();
        return SMono$.MODULE$.fromPublisher((Publisher)Mono.using(resourceSupplier, sourceSupplier, resourceRelease)).then();
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentDispositionHeader(Option<String> optionalName) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)optionalName.map((Function1 & Serializable)x$6 -> this.addContentDispositionHeaderRegardingEncoding((String)x$6, (HttpServerResponse)resp)).getOrElse((Function0 & Serializable)() -> resp);
    }

    private String sanitizeHeaderValue(String s) {
        if (HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)s) == -1) {
            return s;
        }
        return "application/octet-stream";
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentLengthHeader(Try<Refined<Object, boolean.Not<numeric.Less<_0>>>> sizeTry) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)sizeTry.map((Function1 & Serializable)size -> resp.header((CharSequence)"Content-Length", (CharSequence)((Long)((Refined)size).value()).toString())).getOrElse((Function0 & Serializable)() -> resp);
    }

    private Function1<HttpServerResponse, HttpServerResponse> addCacheControlHeader() {
        return (Function1 & Serializable)resp -> resp.header((CharSequence)HttpHeaderNames.CACHE_CONTROL, (CharSequence)"private, immutable, max-age=31536000");
    }

    private HttpServerResponse addContentDispositionHeaderRegardingEncoding(String name, HttpServerResponse resp) {
        if (CharMatcher.ascii().matchesAllOf((CharSequence)name)) {
            return (HttpServerResponse)Try$.MODULE$.apply((Function0 & Serializable)() -> resp.header((CharSequence)"Content-Disposition", (CharSequence)("attachment; filename=\"" + name + "\""))).getOrElse((Function0 & Serializable)() -> resp.header((CharSequence)"Content-Disposition", (CharSequence)this.encodedFileName(name)));
        }
        return resp.header((CharSequence)"Content-Disposition", (CharSequence)this.encodedFileName(name));
    }

    private String encodedFileName(String name) {
        return "attachment; filename*=\"" + EncoderUtil.encodeEncodedWord((String)name, (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN) + "\"";
    }

    private Option<String> queryParam(HttpServerRequest httpRequest, String parameterName) {
        return this.queryParam(parameterName, httpRequest.uri());
    }

    private Option<String> queryParam(String parameterName, String uri) {
        return Option$.MODULE$.apply(new QueryStringDecoder(uri).parameters().get(parameterName)).toList().flatMap((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7).asScala()).headOption();
    }

    private SMono<BoxedUnit> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json)).map((Function1 & Serializable)x$8 -> x$8.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()).then());
    }

    public static final /* synthetic */ void $anonfun$get$5(DownloadRoutes $this, Subscription x$3) {
        $this.pendingDownloadMetric().increment();
    }

    public static final /* synthetic */ void $anonfun$get$9(DownloadRoutes $this, BoxedUnit x$4) {
        $this.pendingDownloadMetric().decrement();
    }

    @Inject
    public DownloadRoutes(@Named(value="RFC-8621") Authenticator authenticator, BlobResolvers blobResolvers, SessionTranslator sessionTranslator, MetricFactory metricFactory) {
        this.authenticator = authenticator;
        this.blobResolvers = blobResolvers;
        this.sessionTranslator = sessionTranslator;
        this.metricFactory = metricFactory;
        this.accountIdParam = "accountId";
        this.blobIdParam = "blobId";
        this.nameParam = "name";
        this.contentTypeParam = "type";
        this.downloadUri = "/download/{" + this.accountIdParam() + "}/{" + this.blobIdParam() + "}";
        this.pendingDownloadMetric = metricFactory.generate("jmap_pending_downloads");
    }
}

