/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.CRAMMD5BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequest;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequestProperties;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONMessages;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import com.unboundid.util.json.LDAPConnectionDetailsJSONSpecification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class AuthenticationDetails
implements Serializable {
    @NotNull
    private static final String FIELD_AUTHENTICATION_ID = "authentication-id";
    @NotNull
    private static final String FIELD_AUTHENTICATION_TYPE = "authentication-type";
    @NotNull
    private static final String FIELD_AUTHORIZATION_ID = "authorization-id";
    @NotNull
    private static final String FIELD_CONFIG_FILE_PATH = "config-file-path";
    @NotNull
    private static final String FIELD_DN = "dn";
    @NotNull
    private static final String FIELD_KDC_ADDRESS = "kdc-address";
    @NotNull
    private static final String FIELD_PASSWORD = "password";
    @NotNull
    private static final String FIELD_PASSWORD_FILE = "password-file";
    @NotNull
    private static final String FIELD_QOP = "qop";
    @NotNull
    private static final String FIELD_REALM = "realm";
    @NotNull
    private static final String FIELD_RENEW_TGT = "renew-tgt";
    @NotNull
    private static final String FIELD_REQUIRE_CACHED_CREDENTIALS = "require-cached-credentials";
    @NotNull
    private static final String FIELD_TICKET_CACHE_PATH = "ticket-cache-path";
    @NotNull
    private static final String FIELD_USE_SUBJECT_CREDS_ONLY = "use-subject-credentials-only";
    @NotNull
    private static final String FIELD_USE_TICKET_CACHE = "use-ticket-cache";
    private static final long serialVersionUID = 2798778432389082274L;
    @Nullable
    private final BindRequest bindRequest;

    AuthenticationDetails(@NotNull JSONObject connectionDetailsObject) throws LDAPException {
        JSONObject o = LDAPConnectionDetailsJSONSpecification.getObject(connectionDetailsObject, "authentication-details");
        if (o == null) {
            this.bindRequest = null;
            return;
        }
        String authType = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_AUTHENTICATION_TYPE, null);
        String loweAuthType = StaticUtils.toLowerCase(authType);
        if (loweAuthType == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_MISSING_REQUIRED_FIELD.get("authentication-details", FIELD_AUTHENTICATION_TYPE));
        }
        if (loweAuthType.equals("none")) {
            LDAPConnectionDetailsJSONSpecification.validateAllowedFields(o, "authentication-details", FIELD_AUTHENTICATION_TYPE);
            this.bindRequest = null;
        } else if (loweAuthType.equals("simple")) {
            AuthenticationDetails.validateAllowedFields(o, authType, FIELD_DN, FIELD_PASSWORD, FIELD_PASSWORD_FILE);
            String dn = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_DN, null);
            if (dn == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_MISSING_REQUIRED_FIELD_FOR_AUTH_TYPE.get(FIELD_DN, authType));
            }
            String password = AuthenticationDetails.getPassword(o, authType, false);
            this.bindRequest = new SimpleBindRequest(dn, password);
        } else if (loweAuthType.equals("cram-md5") || loweAuthType.equals("crammd5")) {
            AuthenticationDetails.validateAllowedFields(o, authType, FIELD_AUTHENTICATION_ID, FIELD_PASSWORD, FIELD_PASSWORD_FILE);
            String authID = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_AUTHENTICATION_ID, null);
            if (authID == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_MISSING_REQUIRED_FIELD_FOR_AUTH_TYPE.get(FIELD_AUTHENTICATION_ID, authType));
            }
            String password = AuthenticationDetails.getPassword(o, authType, false);
            this.bindRequest = new CRAMMD5BindRequest(authID, password);
        } else if (loweAuthType.equals("digest-md5") || loweAuthType.equals("digestmd5")) {
            AuthenticationDetails.validateAllowedFields(o, authType, FIELD_AUTHENTICATION_ID, FIELD_AUTHORIZATION_ID, FIELD_PASSWORD, FIELD_PASSWORD_FILE, FIELD_QOP, FIELD_REALM);
            String authID = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_AUTHENTICATION_ID, null);
            if (authID == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_MISSING_REQUIRED_FIELD_FOR_AUTH_TYPE.get(FIELD_AUTHENTICATION_ID, authType));
            }
            String password = AuthenticationDetails.getPassword(o, authType, false);
            DIGESTMD5BindRequestProperties properties = new DIGESTMD5BindRequestProperties(authID, password);
            properties.setAuthorizationID(LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_AUTHORIZATION_ID, null));
            properties.setRealm(LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_REALM, null));
            properties.setAllowedQoP(AuthenticationDetails.getAllowedQoP(o));
            this.bindRequest = new DIGESTMD5BindRequest(properties, new Control[0]);
        } else if (loweAuthType.equals("external")) {
            AuthenticationDetails.validateAllowedFields(o, authType, FIELD_AUTHORIZATION_ID);
            String authzID = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_AUTHORIZATION_ID, null);
            this.bindRequest = new EXTERNALBindRequest(authzID);
        } else if (loweAuthType.equals("gssapi") || loweAuthType.equals("gss-api")) {
            AuthenticationDetails.validateAllowedFields(o, authType, FIELD_AUTHENTICATION_ID, FIELD_AUTHORIZATION_ID, FIELD_PASSWORD, FIELD_PASSWORD_FILE, FIELD_CONFIG_FILE_PATH, FIELD_KDC_ADDRESS, FIELD_QOP, FIELD_REALM, FIELD_RENEW_TGT, FIELD_REQUIRE_CACHED_CREDENTIALS, FIELD_TICKET_CACHE_PATH, FIELD_USE_SUBJECT_CREDS_ONLY, FIELD_USE_TICKET_CACHE);
            String authID = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_AUTHENTICATION_ID, null);
            if (authID == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_MISSING_REQUIRED_FIELD_FOR_AUTH_TYPE.get(FIELD_AUTHENTICATION_ID, authType));
            }
            String password = AuthenticationDetails.getPassword(o, authType, true);
            GSSAPIBindRequestProperties properties = new GSSAPIBindRequestProperties(authID, password);
            properties.setAuthorizationID(LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_AUTHORIZATION_ID, null));
            properties.setRealm(LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_REALM, null));
            properties.setAllowedQoP(AuthenticationDetails.getAllowedQoP(o));
            properties.setConfigFilePath(LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_CONFIG_FILE_PATH, null));
            properties.setKDCAddress(LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_KDC_ADDRESS, null));
            properties.setRenewTGT(LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_RENEW_TGT, false));
            properties.setRequireCachedCredentials(LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_REQUIRE_CACHED_CREDENTIALS, false));
            properties.setTicketCachePath(LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_TICKET_CACHE_PATH, null));
            properties.setUseSubjectCredentialsOnly(LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_USE_SUBJECT_CREDS_ONLY, true));
            properties.setUseTicketCache(LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_USE_TICKET_CACHE, true));
            if (password == null && !properties.requireCachedCredentials()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_MISSING_GSSAPI_PASSWORD.get(FIELD_PASSWORD, FIELD_PASSWORD_FILE, authType, FIELD_REQUIRE_CACHED_CREDENTIALS));
            }
            this.bindRequest = new GSSAPIBindRequest(properties, new Control[0]);
        } else if (loweAuthType.equals("plain")) {
            AuthenticationDetails.validateAllowedFields(o, authType, FIELD_AUTHENTICATION_ID, FIELD_AUTHORIZATION_ID, FIELD_PASSWORD, FIELD_PASSWORD_FILE);
            String authID = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_AUTHENTICATION_ID, null);
            if (authID == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_MISSING_REQUIRED_FIELD_FOR_AUTH_TYPE.get(FIELD_AUTHENTICATION_ID, authType));
            }
            String authzID = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_AUTHORIZATION_ID, null);
            String password = AuthenticationDetails.getPassword(o, authType, false);
            this.bindRequest = new PLAINBindRequest(authID, authzID, password);
        } else {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_UNRECOGNIZED_TYPE.get(authType));
        }
    }

    @Nullable
    BindRequest getBindRequest() {
        return this.bindRequest;
    }

    private static void validateAllowedFields(@NotNull JSONObject o, @NotNull String authType, String ... allowedFields) throws LDAPException {
        HashSet<String> s = new HashSet<String>(Arrays.asList(allowedFields));
        for (String fieldName : o.getFields().keySet()) {
            if (fieldName.equals(FIELD_AUTHENTICATION_TYPE) || s.contains(fieldName)) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_FIELD_NOT_PERMITTED_FOR_AUTH_TYPE.get(fieldName, authType));
        }
    }

    @Nullable
    private static String getPassword(@NotNull JSONObject o, @NotNull String authType, boolean optional) throws LDAPException {
        String password = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_PASSWORD, null);
        if (password != null) {
            LDAPConnectionDetailsJSONSpecification.rejectConflictingFields(o, FIELD_PASSWORD, FIELD_PASSWORD_FILE);
            return password;
        }
        String path = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_PASSWORD_FILE, null);
        if (path == null) {
            if (optional) {
                return null;
            }
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_NO_PASSWORD.get(FIELD_PASSWORD, FIELD_PASSWORD_FILE, authType));
        }
        return LDAPConnectionDetailsJSONSpecification.getStringFromFile(path, FIELD_PASSWORD_FILE);
    }

    @NotNull
    private static List<SASLQualityOfProtection> getAllowedQoP(@NotNull JSONObject o) throws LDAPException {
        JSONValue v = o.getField(FIELD_QOP);
        if (v == null) {
            return Collections.singletonList(SASLQualityOfProtection.AUTH);
        }
        if (v instanceof JSONString) {
            return SASLQualityOfProtection.decodeQoPList(((JSONString)v).stringValue());
        }
        if (v instanceof JSONArray) {
            JSONArray a = (JSONArray)v;
            ArrayList<SASLQualityOfProtection> qopList = new ArrayList<SASLQualityOfProtection>(a.size());
            for (JSONValue av : a.getValues()) {
                if (av instanceof JSONString) {
                    SASLQualityOfProtection qop = SASLQualityOfProtection.forName(((JSONString)av).stringValue());
                    if (qop == null) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_INVALID_QOP.get(FIELD_QOP));
                    }
                    qopList.add(qop);
                    continue;
                }
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_INVALID_QOP.get(FIELD_QOP));
            }
            return qopList;
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_AUTH_DETAILS_INVALID_QOP.get(FIELD_QOP));
    }
}

