/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.OperationRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Set;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class TextFormattedRequestAccessLogMessage
extends TextFormattedAccessLogMessage
implements OperationRequestAccessLogMessage {
    private static final long serialVersionUID = -4966579210690500174L;
    @Nullable
    private final Boolean usingAdminSessionWorkerThread;
    @Nullable
    private final Integer messageID;
    @Nullable
    private final Long operationID = this.getLongNoThrow(TextFormattedAccessLogFields.OPERATION_ID);
    @Nullable
    private final Long triggeredByConnectionID;
    @Nullable
    private final Long triggeredByOperationID;
    @NotNull
    private final Set<String> requestControlOIDs;
    @Nullable
    private final String administrativeOperationMessage;
    @Nullable
    private final String intermediateClientRequestControl;
    @Nullable
    private final String operationPurposeRequestControl;
    @Nullable
    private final String origin;
    @Nullable
    private final String requesterDN;
    @Nullable
    private final String requesterIPAddress;

    protected TextFormattedRequestAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.messageID = this.getIntegerNoThrow(TextFormattedAccessLogFields.MESSAGE_ID);
        this.origin = this.getString(TextFormattedAccessLogFields.ORIGIN);
        this.triggeredByConnectionID = this.getLongNoThrow(TextFormattedAccessLogFields.TRIGGERED_BY_CONNECTION_ID);
        this.triggeredByOperationID = this.getLongNoThrow(TextFormattedAccessLogFields.TRIGGERED_BY_OPERATION_ID);
        this.requesterDN = this.getString(TextFormattedAccessLogFields.REQUESTER_DN);
        this.requesterIPAddress = this.getString(TextFormattedAccessLogFields.REQUESTER_IP_ADDRESS);
        this.requestControlOIDs = this.getCommaDelimitedStringSet(TextFormattedAccessLogFields.REQUEST_CONTROL_OIDS);
        this.usingAdminSessionWorkerThread = this.getBooleanNoThrow(TextFormattedAccessLogFields.USING_ADMIN_SESSION_WORKER_THREAD);
        this.administrativeOperationMessage = this.getString(TextFormattedAccessLogFields.ADMINISTRATIVE_OPERATION);
        this.intermediateClientRequestControl = this.getString(TextFormattedAccessLogFields.INTERMEDIATE_CLIENT_REQUEST);
        this.operationPurposeRequestControl = this.getString(TextFormattedAccessLogFields.OPERATION_PURPOSE);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.REQUEST;
    }

    @Override
    @Nullable
    public final Long getOperationID() {
        return this.operationID;
    }

    @Override
    @Nullable
    public final Integer getMessageID() {
        return this.messageID;
    }

    @Override
    @Nullable
    public final String getOrigin() {
        return this.origin;
    }

    @Override
    @Nullable
    public final Long getTriggeredByConnectionID() {
        return this.triggeredByConnectionID;
    }

    @Override
    @Nullable
    public final Long getTriggeredByOperationID() {
        return this.triggeredByOperationID;
    }

    @Override
    @Nullable
    public final String getRequesterDN() {
        return this.requesterDN;
    }

    @Override
    @Nullable
    public final String getRequesterIPAddress() {
        return this.requesterIPAddress;
    }

    @Override
    @NotNull
    public final Set<String> getRequestControlOIDs() {
        return this.requestControlOIDs;
    }

    @Override
    @Nullable
    public final Boolean getUsingAdminSessionWorkerThread() {
        return this.usingAdminSessionWorkerThread;
    }

    @Override
    @Nullable
    public final String getAdministrativeOperationMessage() {
        return this.administrativeOperationMessage;
    }

    @Nullable
    public final String getIntermediateClientRequestControl() {
        return this.intermediateClientRequestControl;
    }

    @Nullable
    public final String getOperationPurposeRequestControl() {
        return this.operationPurposeRequestControl;
    }
}

