/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.search;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;

public class UidSearchOverride
implements ListeningMessageSearchIndex.SearchOverride {
    private final CassandraMessageIdDAO dao;

    @Inject
    public UidSearchOverride(CassandraMessageIdDAO dao) {
        this.dao = dao;
    }

    public boolean applicable(SearchQuery searchQuery, MailboxSession session) {
        return searchQuery.getCriteria().size() == 1 && searchQuery.getCriteria().get(0) instanceof SearchQuery.UidCriterion && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        SearchQuery.UidCriterion uidArgument = searchQuery.getCriteria().stream().filter(criterion -> criterion instanceof SearchQuery.UidCriterion).map(SearchQuery.UidCriterion.class::cast).findAny().orElseThrow(() -> new RuntimeException("Missing Uid argument"));
        Object[] uidRanges = uidArgument.getOperator().getRange();
        return Flux.fromIterable((Iterable)ImmutableList.copyOf((Object[])uidRanges)).concatMap(range -> this.dao.listUids((CassandraId)mailbox.getMailboxId(), MessageRange.range((MessageUid)range.getLowValue(), (MessageUid)range.getHighValue())));
    }
}

