/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws.sse;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;

public interface S3SSECConfiguration {
    public static final String ENCRYPTION_S3_SSEC_ALGORITHM_DEFAULT = "AES256";
    public static final String CUSTOMER_KEY_FACTORY_ALGORITHM_DEFAULT = "PBKDF2WithHmacSHA256";
    public static final List<String> SUPPORTED_ALGORITHMS = List.of("AES256");
    public static final String ENCRYPTION_S3_SSEC_MASTER_KEY_ALGORITHM_PROPERTY = "encryption.s3.sse.c.master.key.algorithm";
    public static final String ENCRYPTION_S3_SSEC_MASTER_KEY_SALT_PROPERTY = "encryption.s3.sse.c.master.key.salt";
    public static final String ENCRYPTION_S3_SSEC_MASTER_KEY_PASSWORD_PROPERTY = "encryption.s3.sse.c.master.key.password";

    public static S3SSECConfiguration from(Configuration configuration) {
        String algorithm = configuration.getString(ENCRYPTION_S3_SSEC_MASTER_KEY_ALGORITHM_PROPERTY, ENCRYPTION_S3_SSEC_ALGORITHM_DEFAULT);
        return new Basic(algorithm, configuration.getString(ENCRYPTION_S3_SSEC_MASTER_KEY_PASSWORD_PROPERTY, null), configuration.getString(ENCRYPTION_S3_SSEC_MASTER_KEY_SALT_PROPERTY, null));
    }

    public String ssecAlgorithm();

    default public Optional<String> customerKeyFactoryAlgorithm() {
        return Optional.of(CUSTOMER_KEY_FACTORY_ALGORITHM_DEFAULT);
    }

    public record Basic(String ssecAlgorithm, String masterPassword, String salt) implements S3SSECConfiguration
    {
        public Basic {
            Preconditions.checkArgument((boolean)SUPPORTED_ALGORITHMS.contains(ssecAlgorithm), (Object)("Unsupported algorithm: " + ssecAlgorithm + ". The supported algorithms are: " + String.valueOf(SUPPORTED_ALGORITHMS)));
            Preconditions.checkNotNull((Object)masterPassword, (Object)"encryption.s3.sse.c.master.key.password cannot be null");
            Preconditions.checkNotNull((Object)salt, (Object)"encryption.s3.sse.c.master.key.salt cannot be null");
        }
    }
}

