/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.file.Path;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.MultiPartCompliance;

public class MultiPartConfig {
    private static final int DEFAULT_MAX_PARTS = 100;
    private static final int DEFAULT_MAX_SIZE = 0x3200000;
    private static final int DEFAULT_MAX_PART_SIZE = 0xA00000;
    private static final int DEFAULT_MAX_MEMORY_PART_SIZE = 1024;
    private static final int DEFAULT_MAX_HEADERS_SIZE = 8192;
    private static final boolean DEFAULT_USE_FILES_FOR_PARTS_WITHOUT_FILE_NAME = true;
    private final Path _location;
    private final long _maxMemoryPartSize;
    private final long _maxPartSize;
    private final long _maxSize;
    private final int _maxParts;
    private final int _maxHeadersSize;
    private final boolean _useFilesForPartsWithoutFileName;
    private final MultiPartCompliance _compliance;
    private final ComplianceViolation.Listener _listener;

    private MultiPartConfig(Path location, int maxParts, long maxSize, long maxPartSize, long maxMemoryPartSize, int maxHeadersSize, boolean useFilesForPartsWithoutFileName, MultiPartCompliance compliance, ComplianceViolation.Listener listener) {
        this._location = location;
        this._maxParts = maxParts;
        this._maxSize = maxSize;
        this._maxPartSize = maxPartSize;
        this._maxMemoryPartSize = maxMemoryPartSize;
        this._maxHeadersSize = maxHeadersSize;
        this._useFilesForPartsWithoutFileName = useFilesForPartsWithoutFileName;
        this._compliance = compliance;
        this._listener = listener;
    }

    public Path getLocation() {
        return this._location;
    }

    public int getMaxParts() {
        return this._maxParts;
    }

    public long getMaxSize() {
        return this._maxSize;
    }

    public long getMaxPartSize() {
        return this._maxPartSize;
    }

    public long getMaxMemoryPartSize() {
        return this._maxMemoryPartSize;
    }

    public int getMaxHeadersSize() {
        return this._maxHeadersSize;
    }

    public boolean isUseFilesForPartsWithoutFileName() {
        return this._useFilesForPartsWithoutFileName;
    }

    public MultiPartCompliance getMultiPartCompliance() {
        return this._compliance;
    }

    public ComplianceViolation.Listener getViolationListener() {
        return this._listener;
    }

    public static class Builder {
        private Path _location;
        private Integer _maxParts;
        private Long _maxSize;
        private Long _maxPartSize;
        private Long _maxMemoryPartSize;
        private Integer _maxHeadersSize;
        private Boolean _useFilesForPartsWithoutFileName;
        private MultiPartCompliance _complianceMode;
        private ComplianceViolation.Listener _violationListener;

        public Builder location(Path location) {
            this._location = location;
            return this;
        }

        public Builder maxParts(int maxParts) {
            this._maxParts = maxParts;
            return this;
        }

        public Builder maxSize(long maxSize) {
            this._maxSize = maxSize;
            return this;
        }

        public Builder maxPartSize(long maxPartSize) {
            this._maxPartSize = maxPartSize;
            return this;
        }

        public Builder maxMemoryPartSize(long maxMemoryPartSize) {
            this._maxMemoryPartSize = maxMemoryPartSize;
            return this;
        }

        public Builder maxHeadersSize(int maxHeadersSize) {
            this._maxHeadersSize = maxHeadersSize;
            return this;
        }

        public Builder useFilesForPartsWithoutFileName(Boolean useFilesForPartsWithoutFileName) {
            this._useFilesForPartsWithoutFileName = useFilesForPartsWithoutFileName;
            return this;
        }

        public Builder complianceMode(MultiPartCompliance complianceMode) {
            this._complianceMode = complianceMode;
            return this;
        }

        public Builder violationListener(ComplianceViolation.Listener violationListener) {
            this._violationListener = violationListener;
            return this;
        }

        public MultiPartConfig build() {
            return new MultiPartConfig(this._location, this._maxParts == null ? 100 : this._maxParts, this._maxSize == null ? 0x3200000L : this._maxSize, this._maxPartSize == null ? 0xA00000L : this._maxPartSize, this._maxMemoryPartSize == null ? 1024L : this._maxMemoryPartSize, this._maxHeadersSize == null ? 8192 : this._maxHeadersSize, this._useFilesForPartsWithoutFileName == null ? true : this._useFilesForPartsWithoutFileName, this._complianceMode == null ? MultiPartCompliance.RFC7578 : this._complianceMode, this._violationListener == null ? ComplianceViolation.Listener.NOOP : this._violationListener);
        }
    }
}

