/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.aninteger;

import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleAnotB;
import org.apache.datasketches.tuple.TupleIntersection;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.TupleUnion;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.apache.datasketches.tuple.aninteger.IntegerTupleSketch;
import org.testng.annotations.Test;

public class ParameterLeakageTest {
    IntegerSummarySetOperations setOps = new IntegerSummarySetOperations(IntegerSummary.Mode.Sum, IntegerSummary.Mode.Min);

    @Test
    public void checkUnion() {
        IntegerTupleSketch sk1 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)sk1)[0];
        IntegerTupleSketch sk2 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        sk2.update(2L, Integer.valueOf(1));
        IntegerSummary sk2sum = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)sk2)[0];
        TupleUnion union = new TupleUnion((SummarySetOperations)this.setOps);
        CompactTupleSketch csk = union.union((TupleSketch)sk1, (TupleSketch)sk2);
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("TupleUnion Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum && isum != sk2sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    @Test
    public void checkIntersectStateless() {
        IntegerTupleSketch sk1 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)sk1)[0];
        IntegerTupleSketch sk2 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        sk2.update(1L, Integer.valueOf(1));
        IntegerSummary sk2sum = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)sk2)[0];
        TupleIntersection intersect = new TupleIntersection((SummarySetOperations)this.setOps);
        CompactTupleSketch csk = intersect.intersect((TupleSketch)sk1, (TupleSketch)sk2);
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("Intersect Stateless Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum && isum != sk2sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    @Test
    public void checkIntersectStateful() {
        IntegerTupleSketch sk1 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)sk1)[0];
        IntegerTupleSketch sk2 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        sk2.update(1L, Integer.valueOf(1));
        IntegerSummary sk2sum = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)sk2)[0];
        TupleIntersection intersect = new TupleIntersection((SummarySetOperations)this.setOps);
        intersect.intersect((TupleSketch)sk1);
        intersect.intersect((TupleSketch)sk2);
        CompactTupleSketch csk = intersect.getResult();
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("Intersect Stateful Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum && isum != sk2sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    @Test
    public void checkAnotbStateless() {
        IntegerTupleSketch sk1 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        CompactTupleSketch csk1 = sk1.compact();
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)csk1)[0];
        IntegerTupleSketch sk2 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        CompactTupleSketch csk = TupleAnotB.aNotB((TupleSketch)csk1, (TupleSketch)sk2);
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("TupleAnotB Stateless Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    @Test
    public void checkAnotbStateful() {
        IntegerTupleSketch sk1 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        CompactTupleSketch csk1 = sk1.compact();
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)csk1)[0];
        IntegerTupleSketch sk2 = new IntegerTupleSketch(4, IntegerSummary.Mode.Sum);
        TupleAnotB anotb = new TupleAnotB();
        anotb.setA((TupleSketch)csk1);
        anotb.notB((TupleSketch)sk2);
        CompactTupleSketch csk = anotb.getResult(true);
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((TupleSketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("TupleAnotB Stateful Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    private static IntegerSummary[] captureSummaries(TupleSketch<IntegerSummary> sk) {
        int entries = sk.getRetainedEntries();
        IntegerSummary[] intSumArr = new IntegerSummary[entries];
        int cnt = 0;
        TupleSketchIterator it = sk.iterator();
        while (it.next()) {
            intSumArr[cnt] = (IntegerSummary)it.getSummary();
            ++cnt;
        }
        return intSumArr;
    }

    static void println(Object o) {
    }
}

