/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.util.Random;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetOpsCornerCasesTest {
    Random rand = new Random(9001L);

    @Test
    public void checkSetOpsRandom() {
        int hiA = 0;
        int loB = 0;
        int hiB = 0;
        for (int i = 0; i < 1000; ++i) {
            hiA = this.rand.nextInt(128);
            loB = this.rand.nextInt(64);
            hiB = loB + this.rand.nextInt(64);
            SetOpsCornerCasesTest.compareSetOpsRandom(64, 0, hiA, loB, hiB);
        }
    }

    private static void compareSetOpsRandom(int k, int loA, int hiA, int loB, int hiB) {
        int i;
        UpdatableThetaSketch tskA = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch tskB = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        for (i = loA; i < hiA; ++i) {
            tskA.update((long)i);
        }
        for (i = loB; i < hiB; ++i) {
            tskB.update((long)i);
        }
        CompactThetaSketch rcskStdU = SetOpsCornerCasesTest.doStdUnion((ThetaSketch)tskA, (ThetaSketch)tskB, k, null);
        CompactThetaSketch rcskPwU = SetOpsCornerCasesTest.doPwUnion((ThetaSketch)tskA, (ThetaSketch)tskB, k);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskPwU, (ThetaSketch)rcskStdU);
        CompactThetaSketch rcskStdPairU = SetOpsCornerCasesTest.doStdPairUnion((ThetaSketch)tskA, (ThetaSketch)tskB, k, null);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskStdPairU, (ThetaSketch)rcskStdU);
        CompactThetaSketch rcskStdI = SetOpsCornerCasesTest.doStdIntersection((ThetaSketch)tskA, (ThetaSketch)tskB, null);
        CompactThetaSketch rcskPwI = SetOpsCornerCasesTest.doPwIntersection((ThetaSketch)tskA, (ThetaSketch)tskB);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskPwI, (ThetaSketch)rcskStdI);
        CompactThetaSketch rcskStdPairI = SetOpsCornerCasesTest.doStdPairIntersection((ThetaSketch)tskA, (ThetaSketch)tskB, null);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskStdPairI, (ThetaSketch)rcskStdI);
        CompactThetaSketch rcskStdAnotB = SetOpsCornerCasesTest.doStdAnotB((ThetaSketch)tskA, (ThetaSketch)tskB, null);
        CompactThetaSketch rcskPwAnotB = SetOpsCornerCasesTest.doPwAnotB((ThetaSketch)tskA, (ThetaSketch)tskB);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskPwAnotB, (ThetaSketch)rcskStdAnotB);
        CompactThetaSketch rcskStdStatefulAnotB = SetOpsCornerCasesTest.doStdStatefulAnotB((ThetaSketch)tskA, (ThetaSketch)tskB, null);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskStdStatefulAnotB, (ThetaSketch)rcskStdAnotB);
    }

    @Test
    public void compareCornerCases() {
        int k = 64;
        for (State stateA : State.values()) {
            for (State stateB : State.values()) {
                if (stateA == State.EST_SEGMENT_UNORDERED || stateB == State.EST_SEGMENT_UNORDERED || stateA == State.NULL || stateB == State.NULL) continue;
                SetOpsCornerCasesTest.cornerCaseChecks(stateA, stateB, 64);
                SetOpsCornerCasesTest.cornerCaseChecksMemorySegment(stateA, stateB, 64);
            }
        }
    }

    private static void cornerCaseChecksMemorySegment(State stateA, State stateB, int k) {
        SetOpsCornerCasesTest.println("StateA: " + String.valueOf((Object)stateA) + ", StateB: " + String.valueOf((Object)stateB));
        CompactThetaSketch tcskA = SetOpsCornerCasesTest.generate(stateA, k);
        CompactThetaSketch tcskB = SetOpsCornerCasesTest.generate(stateB, k);
        MemorySegment wseg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)k)]);
        CompactThetaSketch rcskStdU = SetOpsCornerCasesTest.doStdUnion((ThetaSketch)tcskA, (ThetaSketch)tcskB, k, null);
        CompactThetaSketch rcskPwU = SetOpsCornerCasesTest.doPwUnion((ThetaSketch)tcskA, (ThetaSketch)tcskB, k);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskPwU, (ThetaSketch)rcskStdU);
        rcskStdU = SetOpsCornerCasesTest.doStdUnion((ThetaSketch)tcskA, (ThetaSketch)tcskB, k, wseg);
        CompactThetaSketch rcskStdPairU = SetOpsCornerCasesTest.doStdPairUnion((ThetaSketch)tcskA, (ThetaSketch)tcskB, k, wseg);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskStdPairU, (ThetaSketch)rcskStdU);
        wseg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxIntersectionBytes((int)k)]);
        CompactThetaSketch rcskStdI = SetOpsCornerCasesTest.doStdIntersection((ThetaSketch)tcskA, (ThetaSketch)tcskB, null);
        CompactThetaSketch rcskPwI = SetOpsCornerCasesTest.doPwIntersection((ThetaSketch)tcskA, (ThetaSketch)tcskB);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskPwI, (ThetaSketch)rcskStdI);
        rcskStdI = SetOpsCornerCasesTest.doStdIntersection((ThetaSketch)tcskA, (ThetaSketch)tcskB, wseg);
        CompactThetaSketch rcskStdPairI = SetOpsCornerCasesTest.doStdPairIntersection((ThetaSketch)tcskA, (ThetaSketch)tcskB, wseg);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskStdPairI, (ThetaSketch)rcskStdI);
        wseg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxAnotBResultBytes((int)k)]);
        CompactThetaSketch rcskStdAnotB = SetOpsCornerCasesTest.doStdAnotB((ThetaSketch)tcskA, (ThetaSketch)tcskB, null);
        CompactThetaSketch rcskPwAnotB = SetOpsCornerCasesTest.doPwAnotB((ThetaSketch)tcskA, (ThetaSketch)tcskB);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskPwAnotB, (ThetaSketch)rcskStdAnotB);
        rcskStdAnotB = SetOpsCornerCasesTest.doStdAnotB((ThetaSketch)tcskA, (ThetaSketch)tcskB, wseg);
        CompactThetaSketch rcskStdStatefulAnotB = SetOpsCornerCasesTest.doStdStatefulAnotB((ThetaSketch)tcskA, (ThetaSketch)tcskB, wseg);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskStdStatefulAnotB, (ThetaSketch)rcskStdAnotB);
    }

    private static void cornerCaseChecks(State stateA, State stateB, int k) {
        SetOpsCornerCasesTest.println("StateA: " + String.valueOf((Object)stateA) + ", StateB: " + String.valueOf((Object)stateB));
        CompactThetaSketch tcskA = SetOpsCornerCasesTest.generate(stateA, k);
        CompactThetaSketch tcskB = SetOpsCornerCasesTest.generate(stateB, k);
        CompactThetaSketch rcskStdU = SetOpsCornerCasesTest.doStdUnion((ThetaSketch)tcskA, (ThetaSketch)tcskB, k, null);
        CompactThetaSketch rcskPwU = SetOpsCornerCasesTest.doPwUnion((ThetaSketch)tcskA, (ThetaSketch)tcskB, k);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskPwU, (ThetaSketch)rcskStdU);
        CompactThetaSketch rcskStdPairU = SetOpsCornerCasesTest.doStdPairUnion((ThetaSketch)tcskA, (ThetaSketch)tcskB, k, null);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskStdPairU, (ThetaSketch)rcskStdU);
        CompactThetaSketch rcskStdI = SetOpsCornerCasesTest.doStdIntersection((ThetaSketch)tcskA, (ThetaSketch)tcskB, null);
        CompactThetaSketch rcskPwI = SetOpsCornerCasesTest.doPwIntersection((ThetaSketch)tcskA, (ThetaSketch)tcskB);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskPwI, (ThetaSketch)rcskStdI);
        CompactThetaSketch rcskStdPairI = SetOpsCornerCasesTest.doStdPairIntersection((ThetaSketch)tcskA, (ThetaSketch)tcskB, null);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskStdPairI, (ThetaSketch)rcskStdI);
        CompactThetaSketch rcskStdAnotB = SetOpsCornerCasesTest.doStdAnotB((ThetaSketch)tcskA, (ThetaSketch)tcskB, null);
        CompactThetaSketch rcskPwAnotB = SetOpsCornerCasesTest.doPwAnotB((ThetaSketch)tcskA, (ThetaSketch)tcskB);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskPwAnotB, (ThetaSketch)rcskStdAnotB);
        CompactThetaSketch rcskStdStatefulAnotB = SetOpsCornerCasesTest.doStdStatefulAnotB((ThetaSketch)tcskA, (ThetaSketch)tcskB, null);
        SetOpsCornerCasesTest.checkCornerCase((ThetaSketch)rcskStdStatefulAnotB, (ThetaSketch)rcskStdAnotB);
    }

    private static CompactThetaSketch doStdUnion(ThetaSketch tskA, ThetaSketch tskB, int k, MemorySegment wseg) {
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(k).buildUnion();
        union.union(tskA);
        union.union(tskB);
        return union.getResult(true, wseg);
    }

    private static CompactThetaSketch doStdPairUnion(ThetaSketch tskA, ThetaSketch tskB, int k, MemorySegment wseg) {
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(k).buildUnion();
        return union.union(tskA, tskB, true, wseg);
    }

    private static CompactThetaSketch doStdIntersection(ThetaSketch tskA, ThetaSketch tskB, MemorySegment wseg) {
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect(tskA);
        inter.intersect(tskB);
        return inter.getResult(true, wseg);
    }

    private static CompactThetaSketch doStdPairIntersection(ThetaSketch tskA, ThetaSketch tskB, MemorySegment wseg) {
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        return inter.intersect(tskA, tskB, true, wseg);
    }

    private static CompactThetaSketch doStdAnotB(ThetaSketch tskA, ThetaSketch tskB, MemorySegment wseg) {
        ThetaAnotB anotb = ThetaSetOperation.builder().buildANotB();
        return anotb.aNotB(tskA, tskB, true, wseg);
    }

    private static CompactThetaSketch doStdStatefulAnotB(ThetaSketch tskA, ThetaSketch tskB, MemorySegment wseg) {
        ThetaAnotB anotb = ThetaSetOperation.builder().buildANotB();
        anotb.setA(tskA);
        anotb.notB(tskB);
        anotb.getResult(false);
        return anotb.getResult(true, wseg, true);
    }

    private static CompactThetaSketch doPwUnion(ThetaSketch tskA, ThetaSketch tskB, int k) {
        CompactThetaSketch tcskA;
        if (tskA == null) {
            tcskA = null;
        } else {
            CompactThetaSketch compactThetaSketch = tcskA = tskA instanceof CompactThetaSketch ? (CompactThetaSketch)tskA : tskA.compact();
        }
        CompactThetaSketch tcskB = tskB == null ? null : (tskB instanceof CompactThetaSketch ? (CompactThetaSketch)tskB : tskB.compact());
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(k).buildUnion();
        return union.union((ThetaSketch)tcskA, (ThetaSketch)tcskB);
    }

    private static CompactThetaSketch doPwIntersection(ThetaSketch tskA, ThetaSketch tskB) {
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        return inter.intersect(tskA, tskB);
    }

    private static CompactThetaSketch doPwAnotB(ThetaSketch tskA, ThetaSketch tskB) {
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        return aNotB.aNotB(tskA, tskB);
    }

    private static void checkCornerCase(ThetaSketch rskA, ThetaSketch rskB) {
        double estA = rskA.getEstimate();
        double estB = rskB.getEstimate();
        boolean emptyA = rskA.isEmpty();
        boolean emptyB = rskB.isEmpty();
        long thetaLongA = rskA.getThetaLong();
        long thetaLongB = rskB.getThetaLong();
        int countA = rskA.getRetainedEntries(true);
        int countB = rskB.getRetainedEntries(true);
        Assert.assertEquals((double)estB, (double)estA, (double)0.0);
        Assert.assertEquals((boolean)emptyB, (boolean)emptyA);
        Assert.assertEquals((long)thetaLongB, (long)thetaLongA);
        Assert.assertEquals((int)countB, (int)countA);
        Assert.assertEquals((String)rskA.getClass().getSimpleName(), (String)rskB.getClass().getSimpleName());
    }

    @Test
    public void checkUnionNotOrdered() {
        int k = 64;
        CompactThetaSketch skNull = SetOpsCornerCasesTest.generate(State.NULL, 64);
        CompactThetaSketch skEmpty = SetOpsCornerCasesTest.generate(State.EMPTY, 64);
        CompactThetaSketch skHeap = SetOpsCornerCasesTest.generate(State.EST_HEAP, 64);
        CompactThetaSketch skHeapUO = SetOpsCornerCasesTest.generate(State.EST_SEGMENT_UNORDERED, 64);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(64).buildUnion();
        union.union((ThetaSketch)skNull, (ThetaSketch)skHeapUO);
        union.union((ThetaSketch)skEmpty, (ThetaSketch)skHeapUO);
        union.union((ThetaSketch)skHeapUO, (ThetaSketch)skNull);
        union.union((ThetaSketch)skHeapUO, (ThetaSketch)skEmpty);
        union.union((ThetaSketch)skHeapUO, (ThetaSketch)skHeap);
        union.union((ThetaSketch)skHeap, (ThetaSketch)skHeapUO);
    }

    @Test
    public void checkSeedHash() {
        int k = 64;
        UpdatableThetaSketch tmp1 = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(123L).build();
        tmp1.update(1L);
        tmp1.update(3L);
        CompactThetaSketch skSmallSeed2A = tmp1.compact(true, null);
        UpdatableThetaSketch tmp2 = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(123L).build();
        tmp2.update(1L);
        tmp2.update(2L);
        CompactThetaSketch skSmallSeed2B = tmp2.compact(true, null);
        CompactThetaSketch skExact = SetOpsCornerCasesTest.generate(State.EXACT, 64);
        CompactThetaSketch skHeap = SetOpsCornerCasesTest.generate(State.EST_HEAP, 128);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(64).buildUnion();
        try {
            inter.intersect((ThetaSketch)skExact, (ThetaSketch)skSmallSeed2A);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inter.intersect((ThetaSketch)skExact, (ThetaSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inter.intersect((ThetaSketch)skSmallSeed2B, (ThetaSketch)skExact);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inter.intersect((ThetaSketch)skHeap, (ThetaSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            aNotB.aNotB((ThetaSketch)skExact, (ThetaSketch)skSmallSeed2A);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            aNotB.aNotB((ThetaSketch)skExact, (ThetaSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            aNotB.aNotB((ThetaSketch)skSmallSeed2B, (ThetaSketch)skExact);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            aNotB.aNotB((ThetaSketch)skHeap, (ThetaSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            union.union((ThetaSketch)skExact, (ThetaSketch)skSmallSeed2A);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            union.union((ThetaSketch)skExact, (ThetaSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            union.union((ThetaSketch)skSmallSeed2B, (ThetaSketch)skExact);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            union.union((ThetaSketch)skHeap, (ThetaSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkPwUnionReduceToK() {
        int k = 16;
        CompactThetaSketch skNull = SetOpsCornerCasesTest.generate(State.NULL, 16);
        CompactThetaSketch skEmpty = SetOpsCornerCasesTest.generate(State.EMPTY, 16);
        CompactThetaSketch skHeap1 = SetOpsCornerCasesTest.generate(State.EST_HEAP, 16);
        CompactThetaSketch skHeap2 = SetOpsCornerCasesTest.generate(State.EST_HEAP, 16);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(16).buildUnion();
        CompactThetaSketch csk = union.union((ThetaSketch)skNull, (ThetaSketch)skHeap1);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16);
        csk = union.union((ThetaSketch)skEmpty, (ThetaSketch)skHeap1);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16);
        csk = union.union((ThetaSketch)skHeap1, (ThetaSketch)skNull);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16);
        csk = union.union((ThetaSketch)skHeap1, (ThetaSketch)skEmpty);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16);
        csk = union.union((ThetaSketch)skHeap1, (ThetaSketch)skHeap2);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16);
    }

    @Test
    public void printlnTest() {
        SetOpsCornerCasesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    @Test
    public void checkGenerator() {
        int k = 16;
        CompactThetaSketch csk = SetOpsCornerCasesTest.generate(State.NULL, 0);
        Assert.assertNull((Object)csk);
        csk = SetOpsCornerCasesTest.generate(State.EMPTY, 16);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)0);
        Assert.assertEquals((long)csk.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((boolean)csk.isOffHeap(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemorySegment(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.SINGLE, 16);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)1);
        Assert.assertEquals((long)csk.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((boolean)csk.isOffHeap(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemorySegment(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.EXACT, 16);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16);
        Assert.assertEquals((long)csk.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((boolean)csk.isOffHeap(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemorySegment(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.EST_HEAP, 16);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)true);
        Assert.assertEquals((csk.getRetainedEntries(true) > 16 ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((boolean)csk.isOffHeap(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemorySegment(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.THLT1_CNT0_FALSE, 16);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)true);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)0);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((boolean)csk.isOffHeap(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemorySegment(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.THEQ1_CNT0_TRUE, 16);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)0);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)false);
        Assert.assertEquals((boolean)csk.isOffHeap(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemorySegment(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = SetOpsCornerCasesTest.generate(State.EST_SEGMENT_UNORDERED, 16);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)true);
        Assert.assertEquals((csk.getRetainedEntries(true) > 16 ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((boolean)csk.isOffHeap(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemorySegment(), (boolean)true);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)false);
    }

    private static CompactThetaSketch generate(State state, int k) {
        UpdatableThetaSketch sk = null;
        CompactThetaSketch csk = null;
        switch (state.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                csk = UpdatableThetaSketch.builder().setNominalEntries(k).build().compact(true, null);
                break;
            }
            case 2: {
                sk = UpdatableThetaSketch.builder().setNominalEntries(k).build();
                sk.update(1L);
                csk = sk.compact(true, null);
                break;
            }
            case 3: {
                sk = UpdatableThetaSketch.builder().setNominalEntries(k).build();
                for (int i = 0; i < k; ++i) {
                    sk.update((long)i);
                }
                csk = sk.compact(true, null);
                break;
            }
            case 4: {
                sk = UpdatableThetaSketch.builder().setNominalEntries(k).build();
                for (int i = 0; i < 4 * k; ++i) {
                    sk.update((long)i);
                }
                csk = sk.compact(true, null);
                break;
            }
            case 5: {
                sk = UpdatableThetaSketch.builder().setP(0.5f).setNominalEntries(k).build();
                sk.update(7L);
                assert (sk.getRetainedEntries(true) == 0);
                csk = sk.compact(true, null);
                break;
            }
            case 6: {
                sk = UpdatableThetaSketch.builder().setP(0.5f).setNominalEntries(k).build();
                assert (sk.getRetainedEntries(true) == 0);
                csk = sk.compact(true, null);
                break;
            }
            case 7: {
                sk = UpdatableThetaSketch.builder().setNominalEntries(k).build();
                for (int i = 0; i < 4 * k; ++i) {
                    sk.update((long)i);
                }
                int bytes = ThetaSketch.getMaxCompactSketchBytes((int)sk.getRetainedEntries(true));
                byte[] byteArr = new byte[bytes];
                MemorySegment wseg = MemorySegment.ofArray(byteArr);
                csk = sk.compact(false, wseg);
                break;
            }
        }
        return csk;
    }

    static enum State {
        NULL,
        EMPTY,
        SINGLE,
        EXACT,
        EST_HEAP,
        THLT1_CNT0_FALSE,
        THEQ1_CNT0_TRUE,
        EST_SEGMENT_UNORDERED;

    }
}

