/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.testng.annotations.Test;

public class ExamplesTest {
    @Test
    public void simpleCountingSketch() {
        int k = 4096;
        int u = 1000000;
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        for (int i = 0; i < 1000000; ++i) {
            sketch.update((long)i);
        }
        ExamplesTest.println(sketch.toString());
    }

    @Test
    public void theta2dot0Examples() {
        UpdatableThetaSketchBuilder bldr = UpdatableThetaSketch.builder();
        UpdatableThetaSketch skA = bldr.build();
        UpdatableThetaSketch skB = bldr.build();
        for (int i = 1; i <= 1000; ++i) {
            skA.update((long)i);
            skB.update((long)(i + 250));
        }
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        CompactThetaSketch csk = union.union((ThetaSketch)skA, (ThetaSketch)skB);
        assert (csk.getEstimate() == 1250.0);
        union = ThetaSetOperation.builder().buildUnion();
        union.union((ThetaSketch)skA);
        union.union((ThetaSketch)skB);
        csk = union.getResult();
        assert (csk.getEstimate() == 1250.0);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        csk = inter.intersect((ThetaSketch)skA, (ThetaSketch)skB);
        assert (csk.getEstimate() == 750.0);
        inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)skA);
        inter.intersect((ThetaSketch)skB);
        csk = inter.getResult();
        assert (csk.getEstimate() == 750.0);
        ThetaAnotB diff = ThetaSetOperation.builder().buildANotB();
        csk = diff.aNotB((ThetaSketch)skA, (ThetaSketch)skB);
        assert (csk.getEstimate() == 250.0);
        diff = ThetaSetOperation.builder().buildANotB();
        diff.setA((ThetaSketch)skA);
        diff.notB((ThetaSketch)skB);
        csk = diff.getResult(true);
        assert (csk.getEstimate() == 250.0);
    }

    @Test
    public void printlnTest() {
        ExamplesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

