/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ConcurrentDirectQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapQuickSelectSketchTest;
import org.apache.datasketches.theta.ConcurrentHeapThetaBuffer;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.thetacommon.HashOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConcurrentDirectQuickSelectSketchTest {
    private static final long SEED = 9001L;

    @Test
    public void checkDirectCompactConversion() {
        int lgK = 9;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        Assert.assertTrue((boolean)(sl.shared instanceof ConcurrentDirectQuickSelectSketch));
        Assert.assertTrue((boolean)sl.shared.compact().isCompact());
    }

    @Test
    public void checkHeapifyMemorySegmentEstimating() {
        int lgK = 9;
        int k = 512;
        int u = 1024;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        for (int i = 0; i < 1024; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertEquals((String)shared.getClass().getSimpleName(), (String)"ConcurrentDirectQuickSelectSketch");
        Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
        UpdatableThetaSketch sharedHeap = UpdatableThetaSketch.heapify((MemorySegment)sl.wseg);
        Assert.assertEquals((String)sharedHeap.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        ConcurrentDirectQuickSelectSketchTest.checkMemorySegmentDirectProxyMethods((ThetaSketch)local, (ThetaSketch)shared);
        ConcurrentDirectQuickSelectSketchTest.checkOtherProxyMethods((ThetaSketch)local, (ThetaSketch)shared);
        ConcurrentDirectQuickSelectSketchTest.checkOtherProxyMethods((ThetaSketch)local, (ThetaSketch)sharedHeap);
        int curCount1 = shared.getRetainedEntries(true);
        int curCount2 = sharedHeap.getRetainedEntries(true);
        Assert.assertEquals((int)curCount1, (int)curCount2);
        long[] cache = sharedHeap.getCache();
        long thetaLong = sharedHeap.getThetaLong();
        int cacheCount = HashOperations.count((long[])cache, (long)thetaLong);
        Assert.assertEquals((int)curCount1, (int)cacheCount);
        Assert.assertEquals((int)local.getCurrentPreambleLongs(), (int)3);
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int lgK = 9;
        int k = 512;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        for (int i = 0; i < 512; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        byte[] serArr = shared.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(serArr).asReadOnly();
        ThetaSketch recoveredShared = ThetaSketch.heapify((MemorySegment)srcSeg);
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)512);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        shared = sl.bldr.buildSharedFromSketch((UpdatableThetaSketch)recoveredShared, wseg);
        UpdatableThetaSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)512.0, (double)0.0);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)512.0, (double)0.0);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)512.0, (double)0.0);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)false);
        Assert.assertEquals((String)recoveredShared.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        local2.toString(true, true, 8, true);
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int lgK = 12;
        int k = 4096;
        int u = 8192;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(12, 12, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        for (int i = 0; i < 8192; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double uskEst = local.getEstimate();
        double uskLB = local.getLowerBound(2);
        double uskUB = local.getUpperBound(2);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)true);
        byte[] serArr = shared.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(serArr).asReadOnly();
        ThetaSketch recoveredShared = ThetaSketch.heapify((MemorySegment)srcSeg);
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)4096);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        shared = sl.bldr.buildSharedFromSketch((UpdatableThetaSketch)recoveredShared, wseg);
        UpdatableThetaSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)true);
        Assert.assertEquals((String)recoveredShared.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
    }

    @Test
    public void checkWrapMemorySegmentEst() {
        int lgK = 9;
        int k = 512;
        int u = 1024;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        for (int i = 0; i < 1024; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double sk1est = local.getEstimate();
        double sk1lb = local.getLowerBound(2);
        double sk1ub = local.getUpperBound(2);
        Assert.assertTrue((boolean)local.isEstimationMode());
        ThetaSketch local2 = ThetaSketch.wrap((MemorySegment)sl.wseg);
        Assert.assertEquals((double)local2.getEstimate(), (double)sk1est);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)sk1lb);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)sk1ub);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)local2.isEstimationMode());
    }

    @Test
    public void checkDQStoCompactForms() {
        int lgK = 9;
        int k = 512;
        int u = 2048;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
        Assert.assertFalse((boolean)local.isOffHeap());
        Assert.assertTrue((boolean)local.hasMemorySegment());
        for (int i = 0; i < 2048; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        shared.rebuild();
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertTrue((boolean)local.isEstimationMode());
        CompactThetaSketch csk = shared.compact(false, null);
        Assert.assertEquals((double)csk.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk.getUpperBound(2), (double)localUB);
        Assert.assertFalse((boolean)csk.isEmpty());
        Assert.assertTrue((boolean)csk.isEstimationMode());
        Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactSketch");
        csk = shared.compact(true, null);
        Assert.assertEquals((double)csk.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk.getUpperBound(2), (double)localUB);
        Assert.assertFalse((boolean)csk.isEmpty());
        Assert.assertTrue((boolean)csk.isEstimationMode());
        Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactSketch");
        int bytes = shared.getCompactBytes();
        Assert.assertEquals((int)bytes, (int)(4096 + (Family.COMPACT.getMaxPreLongs() << 3)));
        byte[] segArr2 = new byte[bytes];
        MemorySegment seg2 = MemorySegment.ofArray(segArr2);
        csk = shared.compact(false, seg2);
        Assert.assertEquals((double)csk.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk.getUpperBound(2), (double)localUB);
        Assert.assertFalse((boolean)csk.isEmpty());
        Assert.assertTrue((boolean)csk.isEstimationMode());
        Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactSketch");
        Util.clear((MemorySegment)seg2);
        csk = shared.compact(true, seg2);
        Assert.assertEquals((double)csk.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk.getUpperBound(2), (double)localUB);
        Assert.assertFalse((boolean)csk.isEmpty());
        Assert.assertTrue((boolean)csk.isEstimationMode());
        Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactSketch");
        csk.toString(false, true, 0, false);
    }

    @Test
    public void checkDQStoCompactEmptyForms() {
        int lgK = 9;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        local.toString(false, true, 0, false);
        Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertFalse((boolean)local.isEstimationMode());
        int bytes = local.getCompactBytes();
        Assert.assertEquals((int)bytes, (int)8);
        byte[] segArr2 = new byte[bytes];
        MemorySegment seg2 = MemorySegment.ofArray(segArr2);
        CompactThetaSketch csk2 = shared.compact(false, seg2);
        Assert.assertEquals((double)csk2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk2.getUpperBound(2), (double)localUB);
        Assert.assertTrue((boolean)csk2.isEmpty());
        Assert.assertFalse((boolean)csk2.isEstimationMode());
        Assert.assertTrue((boolean)csk2.isOrdered());
        CompactThetaSketch csk3 = shared.compact(true, seg2);
        csk3.toString(false, true, 0, false);
        csk3.toString();
        Assert.assertEquals((double)csk3.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk3.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk3.getUpperBound(2), (double)localUB);
        Assert.assertTrue((boolean)csk3.isEmpty());
        Assert.assertFalse((boolean)csk3.isEstimationMode());
        Assert.assertTrue((boolean)csk2.isOrdered());
    }

    @Test
    public void checkEstMode() {
        int lgK = 12;
        int k = 4096;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(12, 12, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 12288;
        for (int i = 0; i < 12288; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertTrue((shared.getRetainedEntries(false) > 4096 ? 1 : 0) != 0);
    }

    @Test
    public void checkErrorBounds() {
        int lgK = 9;
        int k = 512;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        for (int i = 0; i < 512; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est = local.getEstimate();
        double lb = local.getLowerBound(2);
        double ub = local.getUpperBound(2);
        Assert.assertEquals((double)est, (double)ub, (double)0.0);
        Assert.assertEquals((double)est, (double)lb, (double)0.0);
        int u = 51200;
        for (int i = 512; i < 51200; ++i) {
            local.update((long)i);
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        est = local.getEstimate();
        lb = local.getLowerBound(2);
        ub = local.getUpperBound(2);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertTrue((est >= lb ? 1 : 0) != 0);
    }

    @Test
    public void checkUpperAndLowerBounds() {
        int lgK = 9;
        int k = 512;
        int u = 1024;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        for (int i = 0; i < 1024; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est = local.getEstimate();
        double ub = local.getUpperBound(1);
        double lb = local.getLowerBound(1);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((lb < est ? 1 : 0) != 0);
    }

    @Test
    public void checkRebuild() {
        int lgK = 9;
        int k = 512;
        int u = 2048;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < 2048; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((shared.getRetainedEntries(false) >= 512 ? 1 : 0) != 0);
        shared.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)512);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)512);
        local.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)512);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)512);
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int lgK = 9;
        int k = 512;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 2048;
        for (int i = 0; i < 2048; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((shared.getRetainedEntries(false) >= 512 ? 1 : 0) != 0);
        Assert.assertTrue((local.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0);
        shared.reset();
        local.reset();
        Assert.assertTrue((boolean)local.isEmpty());
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)0);
        Assert.assertEquals((double)local.getEstimate(), (double)0.0, (double)0.0);
        Assert.assertEquals((long)local.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void checkExactModeMemorySegmentArr() {
        int lgK = 12;
        int k = 4096;
        int u = 4096;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(12, 12, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < 4096; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertEquals((double)local.getEstimate(), (double)4096.0, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)4096);
    }

    @Test
    public void checkEstModeMemorySegmentArr() {
        int lgK = 12;
        int k = 4096;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(12, 12, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 12288;
        for (int i = 0; i < 12288; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est = local.getEstimate();
        Assert.assertTrue((est < 12902.400000000001 && est > 11673.599999999999 ? 1 : 0) != 0);
        Assert.assertTrue((shared.getRetainedEntries(false) >= 4096 ? 1 : 0) != 0);
    }

    @Test
    public void checkEstModeNativeMemorySegment() {
        int lgK = 12;
        int k = 4096;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(12, 12, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 12288;
        for (int i = 0; i < 12288; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est = local.getEstimate();
        Assert.assertTrue((est < 12902.400000000001 && est > 11673.599999999999 ? 1 : 0) != 0);
        Assert.assertTrue((shared.getRetainedEntries(false) >= 4096 ? 1 : 0) != 0);
    }

    @Test
    public void checkConstructReconstructFromMemorySegment() {
        int lgK = 12;
        int k = 4096;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(12, 12, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 12288;
        for (int i = 0; i < 12288; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est1 = local.getEstimate();
        int count1 = shared.getRetainedEntries(false);
        Assert.assertTrue((est1 < 12902.400000000001 && est1 > 11673.599999999999 ? 1 : 0) != 0);
        Assert.assertTrue((count1 >= 4096 ? 1 : 0) != 0);
        byte[] serArr = shared.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(serArr);
        UpdatableThetaSketch recoveredShared = UpdatableThetaSketch.wrap((MemorySegment)seg);
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)4096);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        shared = sl.bldr.buildSharedFromSketch(recoveredShared, wseg);
        UpdatableThetaSketch local2 = sl.bldr.buildLocal(shared);
        double est2 = local2.getEstimate();
        Assert.assertEquals((double)est2, (double)est1, (double)0.0);
    }

    @Test
    public void checkNullMemorySegment() {
        UpdatableThetaSketchBuilder bldr = new UpdatableThetaSketchBuilder();
        UpdatableThetaSketch sk = bldr.build();
        for (int i = 0; i < 1000; ++i) {
            sk.update((long)i);
        }
        UpdatableThetaSketch shared = bldr.buildSharedFromSketch(sk, null);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)1000);
        Assert.assertFalse((boolean)shared.hasMemorySegment());
    }

    @Test
    public void checkResizeInBigSeg() {
        int lgK = 14;
        int u = 0x100000;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(14, 14, 9001L, true, true, 8);
        UpdatableThetaSketch local = sl.local;
        for (int i = 0; i < 0x100000; ++i) {
            local.update((long)i);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorKtooSmall() {
        int lgK = 3;
        boolean useSeg = true;
        new ConcurrentHeapQuickSelectSketchTest.SharedLocal(3, 3, true);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorSegTooSmall() {
        int lgK = 4;
        int k = 16;
        MemorySegment wseg = MemorySegment.ofArray(new byte[8]);
        UpdatableThetaSketchBuilder bldr = new UpdatableThetaSketchBuilder();
        bldr.setLogNominalEntries(4);
        bldr.buildShared(wseg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyIllegalFamilyID_heapify() {
        int lgK = 9;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        sl.wseg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        ThetaSketch.heapify((MemorySegment)sl.wseg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadLgNomLongs() {
        int lgK = 4;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(4, 4, true);
        sl.wseg.set(ValueLayout.JAVA_BYTE, 3L, (byte)3);
        DirectQuickSelectSketch.writableWrap((MemorySegment)sl.wseg, null, (long)9001L);
    }

    @Test
    public void checkBackgroundPropagation() {
        int i;
        int lgK = 4;
        int k = 16;
        int u = 160;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(4, 4, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        ConcurrentHeapThetaBuffer sk1 = (ConcurrentHeapThetaBuffer)local;
        for (i = 0; i < 16; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
        long theta1 = ((ConcurrentSharedThetaSketch)shared).getVolatileTheta();
        while (i < 160) {
            local.update((long)i);
            ++i;
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        long theta2 = ((ConcurrentSharedThetaSketch)shared).getVolatileTheta();
        int entries = shared.getRetainedEntries(false);
        Assert.assertTrue((entries > 16 || theta2 < theta1 ? 1 : 0) != 0, (String)("entries=" + entries + " k=16 theta1=" + theta1 + " theta2=" + theta2));
        shared.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)16);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)16);
        sk1.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)16);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)16);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int lgK = 9;
        int k = 512;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < 512; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertEquals((double)local.getEstimate(), (double)512.0, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)512);
        sl.wseg.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
        ThetaSketch.wrap((MemorySegment)sl.wseg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_wrap() {
        int lgK = 9;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        sl.wseg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        ThetaSketch.wrap((MemorySegment)sl.wseg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_direct() {
        int lgK = 9;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, true);
        sl.wseg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        DirectQuickSelectSketch.writableWrap((MemorySegment)sl.wseg, null, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        int lgK = 9;
        long seed1 = 1021L;
        long seed2 = 9001L;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(9, 9, 1021L, true, true, 1);
        UpdatableThetaSketch shared = sl.shared;
        MemorySegment srcSeg = MemorySegment.ofArray(shared.toByteArray()).asReadOnly();
        ThetaSketch.heapify((MemorySegment)srcSeg, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCorruptLgNomLongs() {
        int lgK = 4;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(4, 4, true);
        sl.wseg.set(ValueLayout.JAVA_BYTE, 3L, (byte)2);
        ThetaSketch.heapify((MemorySegment)sl.wseg, (long)9001L);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void checkIllegalHashUpdate() {
        int lgK = 4;
        boolean useSeg = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(4, 4, true);
        UpdatableThetaSketch shared = sl.shared;
        shared.hashUpdate(1L);
    }

    @Test
    public void printlnTest() {
        ConcurrentDirectQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    private static void checkMemorySegmentDirectProxyMethods(ThetaSketch local, ThetaSketch shared) {
        Assert.assertEquals((boolean)local.hasMemorySegment(), (boolean)shared.hasMemorySegment());
        Assert.assertEquals((boolean)local.isOffHeap(), (boolean)shared.isOffHeap());
    }

    private static void checkOtherProxyMethods(ThetaSketch local, ThetaSketch shared) {
        Assert.assertEquals((int)local.getCompactBytes(), (int)shared.getCompactBytes());
        Assert.assertEquals((int)local.getCurrentBytes(), (int)shared.getCurrentBytes());
        Assert.assertEquals((double)local.getEstimate(), (double)shared.getEstimate());
        Assert.assertEquals((double)local.getLowerBound(2), (double)shared.getLowerBound(2));
        Assert.assertEquals((double)local.getUpperBound(2), (double)shared.getUpperBound(2));
        Assert.assertEquals((boolean)local.isEmpty(), (boolean)shared.isEmpty());
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)shared.isEstimationMode());
    }
}

