/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Random;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.apache.datasketches.quantilescommon.KolmogorovSmirnov;
import org.apache.datasketches.quantilescommon.QuantilesAPI;
import org.apache.datasketches.quantilescommon.QuantilesDoublesAPI;
import org.apache.datasketches.quantilescommon.QuantilesFloatsAPI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KolmogorovSmirnovTest {
    private static final String LS = System.getProperty("line.separator");
    private static final boolean enablePrinting = false;

    @Test
    public void checkDisjointDistributionClassicDoubles() {
        int k = 256;
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().setK(256).build();
        UpdatableQuantilesDoublesSketch s2 = QuantilesDoublesSketch.builder().setK(256).build();
        Random rand = new Random(1L);
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 500.0);
            s2.update(x);
        }
        double eps = QuantilesDoublesSketch.getNormalizedRankError((int)256, (boolean)false);
        KolmogorovSmirnovTest.println("Disjoint Classic Doubles");
        KolmogorovSmirnovTest.println("D     = " + KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2));
        KolmogorovSmirnovTest.println("2*eps = " + 2.0 * eps + LS);
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2), (double)1.0, (double)(2.0 * eps));
    }

    @Test
    public void checkDisjointDistributionKllDoubles() {
        int k = 256;
        KllDoublesSketch s1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch s2 = KllDoublesSketch.newHeapInstance((int)256);
        Random rand = new Random(1L);
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 500.0);
            s2.update(x);
        }
        double eps = KllSketch.getNormalizedRankError((int)256, (boolean)false);
        KolmogorovSmirnovTest.println("Disjoint KLL Doubles");
        KolmogorovSmirnovTest.println("D     = " + KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2));
        KolmogorovSmirnovTest.println("2*eps = " + 2.0 * eps);
        KolmogorovSmirnovTest.println("");
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2), (double)1.0, (double)(2.0 * eps));
    }

    @Test
    public void checkDisjointDistributionKllFloats() {
        int k = 256;
        KllFloatsSketch s1 = KllFloatsSketch.newHeapInstance((int)256);
        KllFloatsSketch s2 = KllFloatsSketch.newHeapInstance((int)256);
        Random rand = new Random(1L);
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            float x = (float)rand.nextGaussian();
            s1.update(x + 500.0f);
            s2.update(x);
        }
        double eps = KllSketch.getNormalizedRankError((int)256, (boolean)false);
        KolmogorovSmirnovTest.println("Disjoint KLL Floats");
        KolmogorovSmirnovTest.println("D      = " + KolmogorovSmirnov.computeKSDelta((QuantilesFloatsAPI)s1, (QuantilesFloatsAPI)s2));
        KolmogorovSmirnovTest.println("2*eps = " + 2.0 * eps + LS);
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((QuantilesFloatsAPI)s1, (QuantilesFloatsAPI)s2), (double)1.0, (double)(2.0 * eps));
    }

    @Test
    public void checkIdenticalDistributionClassicDoubles() {
        int k = 256;
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().setK(256).build();
        Random rand = new Random(1L);
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x);
        }
        KolmogorovSmirnovTest.println("Identical Classic Doubles");
        KolmogorovSmirnovTest.println("D     = " + KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s1));
        KolmogorovSmirnovTest.println("2*eps = 0.0" + LS);
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s1), (double)0.0, (double)0.0);
    }

    @Test
    public void checkIdenticalDistributionKllDoubles() {
        int k = 256;
        KllDoublesSketch s1 = KllDoublesSketch.newHeapInstance((int)256);
        Random rand = new Random(1L);
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x);
        }
        KolmogorovSmirnovTest.println("Identical KLL Doubles");
        KolmogorovSmirnovTest.println("D     = " + KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s1));
        KolmogorovSmirnovTest.println("2*eps = 0.0" + LS);
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s1), (double)0.0, (double)0.0);
    }

    @Test
    public void checkIdenticalDistributionKllFloats() {
        int k = 256;
        KllFloatsSketch s1 = KllFloatsSketch.newHeapInstance((int)256);
        Random rand = new Random(1L);
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            float x = (float)rand.nextGaussian();
            s1.update(x);
        }
        KolmogorovSmirnovTest.println("Identical KLL Floats");
        KolmogorovSmirnovTest.println("D     = " + KolmogorovSmirnov.computeKSDelta((QuantilesFloatsAPI)s1, (QuantilesFloatsAPI)s1));
        KolmogorovSmirnovTest.println("2*eps = 0.0" + LS);
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((QuantilesFloatsAPI)s1, (QuantilesFloatsAPI)s1), (double)0.0, (double)0.0);
    }

    @Test
    public void checkSameDistributionDifferentClassicDoublesSketches() {
        int k = 256;
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().setK(256).build();
        UpdatableQuantilesDoublesSketch s2 = QuantilesDoublesSketch.builder().setK(256).build();
        Random rand = new Random(1L);
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x);
            s2.update(x);
        }
        double eps = QuantilesDoublesSketch.getNormalizedRankError((int)256, (boolean)false);
        KolmogorovSmirnovTest.println("Same Classic Doubles");
        KolmogorovSmirnovTest.println("D     = " + KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2));
        KolmogorovSmirnovTest.println("2*eps = " + 2.0 * eps + LS);
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2), (double)0.0, (double)(2.0 * eps));
    }

    @Test
    public void checkSameDistributionDifferentKllDoublesSketches() {
        int k = 256;
        KllDoublesSketch s1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch s2 = KllDoublesSketch.newHeapInstance((int)256);
        Random rand = new Random(1L);
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x);
            s2.update(x);
        }
        double eps = KllSketch.getNormalizedRankError((int)256, (boolean)false);
        KolmogorovSmirnovTest.println("Same KLL Doubles");
        KolmogorovSmirnovTest.println("D     = " + KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2));
        KolmogorovSmirnovTest.println("2*eps = " + 2.0 * eps + LS);
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2), (double)0.0, (double)(2.0 * eps));
    }

    @Test
    public void checkSameDistributionDifferentKllFloatsSketches() {
        int k = 256;
        KllFloatsSketch s1 = KllFloatsSketch.newHeapInstance((int)256);
        KllFloatsSketch s2 = KllFloatsSketch.newHeapInstance((int)256);
        Random rand = new Random(1L);
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            float x = (float)rand.nextGaussian();
            s1.update(x);
            s2.update(x);
        }
        double eps = KllSketch.getNormalizedRankError((int)256, (boolean)false);
        KolmogorovSmirnovTest.println("Same KLL Floats");
        KolmogorovSmirnovTest.println("D     = " + KolmogorovSmirnov.computeKSDelta((QuantilesFloatsAPI)s1, (QuantilesFloatsAPI)s2));
        KolmogorovSmirnovTest.println("2*eps = " + 2.0 * eps + LS);
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((QuantilesFloatsAPI)s1, (QuantilesFloatsAPI)s2), (double)0.0, (double)(2.0 * eps));
    }

    @Test
    public void mediumResolutionClassicDoubles() {
        int k = 2048;
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().setK(2048).build();
        UpdatableQuantilesDoublesSketch s2 = QuantilesDoublesSketch.builder().setK(2048).build();
        double tgtPvalue = 0.05;
        Random rand = new Random(1L);
        int n = 6143;
        for (int i = 0; i < 6143; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 0.05);
            s2.update(x);
        }
        double D = KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2);
        double thresh = KolmogorovSmirnov.computeKSThreshold((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        boolean reject = KolmogorovSmirnov.kolmogorovSmirnovTest((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        KolmogorovSmirnovTest.println("MedRes Classic Doubles");
        KolmogorovSmirnovTest.println("pVal = 0.05\nK = 2048\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject + LS);
        Assert.assertFalse((boolean)reject);
    }

    @Test
    public void mediumResolutionKllDoubles() {
        int k = 2048;
        KllDoublesSketch s1 = KllDoublesSketch.newHeapInstance((int)2048);
        KllDoublesSketch s2 = KllDoublesSketch.newHeapInstance((int)2048);
        double tgtPvalue = 0.05;
        Random rand = new Random(1L);
        int n = 6143;
        for (int i = 0; i < 6143; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 0.05);
            s2.update(x);
        }
        double D = KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2);
        double thresh = KolmogorovSmirnov.computeKSThreshold((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        boolean reject = KolmogorovSmirnov.kolmogorovSmirnovTest((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        KolmogorovSmirnovTest.println("MedRes KLL Doubles");
        KolmogorovSmirnovTest.println("pVal = 0.05\nK = 2048\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject + LS);
        Assert.assertFalse((boolean)reject);
    }

    @Test
    public void mediumResolutionKllFloats() {
        int k = 2048;
        KllFloatsSketch s1 = KllFloatsSketch.newHeapInstance((int)2048);
        KllFloatsSketch s2 = KllFloatsSketch.newHeapInstance((int)2048);
        double tgtPvalue = 0.05;
        Random rand = new Random(1L);
        int n = 6143;
        for (int i = 0; i < 6143; ++i) {
            float x = (float)rand.nextGaussian();
            s1.update(x + 0.05f);
            s2.update(x);
        }
        double D = KolmogorovSmirnov.computeKSDelta((QuantilesFloatsAPI)s1, (QuantilesFloatsAPI)s2);
        double thresh = KolmogorovSmirnov.computeKSThreshold((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        boolean reject = KolmogorovSmirnov.kolmogorovSmirnovTest((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        KolmogorovSmirnovTest.println("MedRes KLL Floats");
        KolmogorovSmirnovTest.println("pVal = 0.05\nK = 2048\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject + LS);
        Assert.assertFalse((boolean)reject);
    }

    @Test
    public void highResolutionClassicDoubles() {
        int k = 8192;
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().setK(8192).build();
        UpdatableQuantilesDoublesSketch s2 = QuantilesDoublesSketch.builder().setK(8192).build();
        double tgtPvalue = 0.05;
        Random rand = new Random(1L);
        int n = 24575;
        for (int i = 0; i < 24575; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 0.05);
            s2.update(x);
        }
        double D = KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2);
        double thresh = KolmogorovSmirnov.computeKSThreshold((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        boolean reject = KolmogorovSmirnov.kolmogorovSmirnovTest((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        KolmogorovSmirnovTest.println("HiRes Classic Doubles");
        KolmogorovSmirnovTest.println("pVal = 0.05\nK = 8192\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject + LS);
        Assert.assertTrue((boolean)reject);
    }

    @Test
    public void highResolutionKllDoubles() {
        int k = 8192;
        KllDoublesSketch s1 = KllDoublesSketch.newHeapInstance((int)8192);
        KllDoublesSketch s2 = KllDoublesSketch.newHeapInstance((int)8192);
        double tgtPvalue = 0.05;
        Random rand = new Random(1L);
        int n = 24575;
        for (int i = 0; i < 24575; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 0.05);
            s2.update(x);
        }
        double D = KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)s1, (QuantilesDoublesAPI)s2);
        double thresh = KolmogorovSmirnov.computeKSThreshold((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        boolean reject = KolmogorovSmirnov.kolmogorovSmirnovTest((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        KolmogorovSmirnovTest.println("HiRes KLL Doubles");
        KolmogorovSmirnovTest.println("pVal = 0.05\nK = 8192\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject + LS);
        Assert.assertTrue((boolean)reject);
    }

    @Test
    public void highResolutionKllFloats() {
        int k = 8192;
        KllFloatsSketch s1 = KllFloatsSketch.newHeapInstance((int)8192);
        KllFloatsSketch s2 = KllFloatsSketch.newHeapInstance((int)8192);
        double tgtPvalue = 0.05;
        Random rand = new Random(1L);
        int n = 24575;
        for (int i = 0; i < 24575; ++i) {
            float x = (float)rand.nextGaussian();
            s1.update(x + 0.05f);
            s2.update(x);
        }
        double D = KolmogorovSmirnov.computeKSDelta((QuantilesFloatsAPI)s1, (QuantilesFloatsAPI)s2);
        double thresh = KolmogorovSmirnov.computeKSThreshold((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        boolean reject = KolmogorovSmirnov.kolmogorovSmirnovTest((QuantilesAPI)s1, (QuantilesAPI)s2, (double)0.05);
        KolmogorovSmirnovTest.println("HiRes KLL Floats");
        KolmogorovSmirnovTest.println("pVal = 0.05\nK = 8192\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject + LS);
        Assert.assertTrue((boolean)reject);
    }

    @Test
    public void printlnTest() {
        KolmogorovSmirnovTest.println("PRINTING: " + this.getClass().getName());
    }

    private static final void println(Object o) {
    }
}

