/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.HeapCompactDoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HeapCompactDoublesSketchTest {
    @BeforeMethod
    public void setUp() {
        QuantilesDoublesSketch.rand.setSeed(32749L);
    }

    @Test
    public void heapifyFromUpdateSketch() {
        int k = 4;
        int n = 45;
        UpdatableQuantilesDoublesSketch qs = HeapCompactDoublesSketchTest.buildAndLoadQS(4, 45);
        byte[] qsBytes = qs.toByteArray();
        MemorySegment qsSeg = MemorySegment.ofArray(qsBytes);
        HeapCompactDoublesSketch compactQs = HeapCompactDoublesSketch.heapifyInstance((MemorySegment)qsSeg);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)qs, (QuantilesDoublesSketch)compactQs);
        Assert.assertNull((Object)compactQs.getMemorySegment());
    }

    @Test
    public void createFromUnsortedUpdateSketch() {
        int k = 4;
        int n = 13;
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(4).build();
        for (int i = 13; i > 0; --i) {
            qs.update((double)i);
        }
        HeapCompactDoublesSketch compactQs = HeapCompactDoublesSketch.createFromUpdateSketch((UpdatableQuantilesDoublesSketch)qs);
        HeapCompactDoublesSketchTest.checkBaseBufferIsSorted(compactQs);
    }

    @Test
    public void heapifyFromCompactSketch() {
        int k = 8;
        int n = 177;
        UpdatableQuantilesDoublesSketch qs = HeapCompactDoublesSketchTest.buildAndLoadQS(8, 177);
        byte[] qsBytes = qs.compact().toByteArray();
        MemorySegment qsSeg = MemorySegment.ofArray(qsBytes);
        HeapCompactDoublesSketch compactQs = HeapCompactDoublesSketch.heapifyInstance((MemorySegment)qsSeg);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)qs, (QuantilesDoublesSketch)compactQs);
    }

    @Test
    public void checkHeapifyUnsortedCompactV2() {
        int k = 64;
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(64).build();
        for (int i = 0; i < 192; ++i) {
            qs.update((double)i);
        }
        Assert.assertEquals((int)qs.getBaseBufferCount(), (int)64);
        byte[] sketchBytes = qs.toByteArray(true);
        MemorySegment seg = MemorySegment.ofArray(sketchBytes);
        PreambleUtil.insertSerVer((MemorySegment)seg, (int)2);
        PreambleUtil.insertFlags((MemorySegment)seg, (int)0);
        long tgtAddr = 288L;
        seg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 288L, -1.0);
        assert (seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 280L) > seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 288L));
        HeapCompactDoublesSketch qs2 = HeapCompactDoublesSketch.heapifyInstance((MemorySegment)seg);
        HeapCompactDoublesSketchTest.checkBaseBufferIsSorted(qs2);
    }

    @Test
    public void checkEmpty() {
        int k = 128;
        UpdatableQuantilesDoublesSketch qs1 = HeapCompactDoublesSketchTest.buildAndLoadQS(128, 0);
        byte[] byteArr = qs1.compact().toByteArray();
        byte[] byteArr2 = qs1.toByteArray(true);
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        HeapCompactDoublesSketch qs2 = HeapCompactDoublesSketch.heapifyInstance((MemorySegment)seg);
        Assert.assertTrue((boolean)qs2.isEmpty());
        Assert.assertEquals((int)byteArr.length, (int)qs1.getSerializedSizeBytes());
        Assert.assertEquals((byte[])byteArr, (byte[])byteArr2);
        try {
            qs2.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            qs2.getQuantiles(new double[]{0.0, 0.5, 1.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            qs2.getRank(0.0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSegTooSmall1() {
        MemorySegment seg = MemorySegment.ofArray(new byte[7]);
        HeapCompactDoublesSketch.heapifyInstance((MemorySegment)seg);
    }

    static void checkBaseBufferIsSorted(HeapCompactDoublesSketch qs) {
        double[] combinedBuffer = qs.getCombinedBuffer();
        int bbCount = qs.getBaseBufferCount();
        for (int i = 1; i < bbCount; ++i) {
            assert (combinedBuffer[i - 1] <= combinedBuffer[i]);
        }
    }

    static UpdatableQuantilesDoublesSketch buildAndLoadQS(int k, int n) {
        return HeapCompactDoublesSketchTest.buildAndLoadQS(k, n, 0);
    }

    static UpdatableQuantilesDoublesSketch buildAndLoadQS(int k, int n, int startV) {
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(k).build();
        for (int i = 1; i <= n; ++i) {
            qs.update((double)(startV + i));
        }
        return qs;
    }

    @Test
    public void printlnTest() {
        HeapCompactDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
        HeapCompactDoublesSketchTest.print("PRINTING: " + this.getClass().getName() + Util.LS);
    }

    static void println(String s) {
        HeapCompactDoublesSketchTest.print(s + Util.LS);
    }

    static void print(String s) {
    }
}

