/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.CompactQuantilesDoublesSketch;
import org.apache.datasketches.quantiles.DirectCompactDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.HeapCompactDoublesSketch;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketchTest;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DirectCompactDoublesSketchTest {
    @BeforeMethod
    public void setUp() {
        QuantilesDoublesSketch.rand.setSeed(32749L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void wrapFromUpdateSketch() {
        int k = 4;
        int n = 27;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(4, 27);
        byte[] qsBytes = qs.toByteArray();
        MemorySegment qsSeg = MemorySegment.ofArray(qsBytes);
        DirectCompactDoublesSketch.wrapInstance((MemorySegment)qsSeg);
        Assert.fail();
    }

    @Test
    public void createFromUnsortedUpdateSketch() {
        int k = 4;
        int n = 13;
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(4).build();
        for (int i = 13; i > 0; --i) {
            qs.update((double)i);
        }
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[qs.getCurrentCompactSerializedSizeBytes()]);
        DirectCompactDoublesSketch compactQs = DirectCompactDoublesSketch.createFromUpdateSketch((UpdatableQuantilesDoublesSketch)qs, (MemorySegment)dstSeg);
        double[] combinedBuffer = compactQs.getCombinedBuffer();
        int bbCount = compactQs.getBaseBufferCount();
        for (int i = 1; i < bbCount; ++i) {
            assert (combinedBuffer[i - 1] < combinedBuffer[i]);
        }
    }

    @Test
    public void wrapFromCompactSketch() {
        int k = 8;
        int n = 177;
        DirectCompactDoublesSketch qs = DirectCompactDoublesSketchTest.buildAndLoadDCQS(8, 177);
        byte[] qsBytes = qs.toByteArray();
        MemorySegment qsSeg = MemorySegment.ofArray(qsBytes);
        DirectCompactDoublesSketch compactQs = DirectCompactDoublesSketch.wrapInstance((MemorySegment)qsSeg);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)qs, (QuantilesDoublesSketch)compactQs);
        Assert.assertEquals((int)qsBytes.length, (int)compactQs.getSerializedSizeBytes());
        double[] combinedBuffer = compactQs.getCombinedBuffer();
        Assert.assertEquals((int)combinedBuffer.length, (int)compactQs.getCombinedBufferItemCapacity());
    }

    @Test
    public void wrapEmptyCompactSketch() {
        CompactQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build().compact();
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(s1.toByteArray()).order(ByteOrder.nativeOrder()));
        QuantilesDoublesSketch s2 = QuantilesDoublesSketch.wrap((MemorySegment)seg);
        Assert.assertTrue((boolean)s2.isEmpty());
        Assert.assertEquals((long)s2.getN(), (long)0L);
        Assert.assertTrue((boolean)Double.isNaN(s2.isEmpty() ? Double.NaN : s2.getMinItem()));
        Assert.assertTrue((boolean)Double.isNaN(s2.isEmpty() ? Double.NaN : s2.getMaxItem()));
    }

    @Test
    public void checkEmpty() {
        int k = 128;
        DirectCompactDoublesSketch qs1 = DirectCompactDoublesSketchTest.buildAndLoadDCQS(128, 0);
        try {
            qs1.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            qs1.getQuantiles(new double[]{0.0, 0.5, 1.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        double[] combinedBuffer = qs1.getCombinedBuffer();
        Assert.assertEquals((int)combinedBuffer.length, (int)256);
        Assert.assertNotEquals((Object)combinedBuffer.length, (Object)qs1.getCombinedBufferItemCapacity());
    }

    @Test
    public void checkCheckDirectSegCapacity() {
        int k = 128;
        DirectCompactDoublesSketch.checkDirectSegCapacity((int)128, (long)255L, (long)2080L);
        DirectCompactDoublesSketch.checkDirectSegCapacity((int)128, (long)257L, (long)3104L);
        DirectCompactDoublesSketch.checkDirectSegCapacity((int)128, (long)0L, (long)8L);
        try {
            DirectCompactDoublesSketch.checkDirectSegCapacity((int)128, (long)10000L, (long)64L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSegTooSmall() {
        MemorySegment seg = MemorySegment.ofArray(new byte[7]);
        HeapCompactDoublesSketch.heapifyInstance((MemorySegment)seg);
    }

    static DirectCompactDoublesSketch buildAndLoadDCQS(int k, int n) {
        return DirectCompactDoublesSketchTest.buildAndLoadDCQS(k, n, 0);
    }

    static DirectCompactDoublesSketch buildAndLoadDCQS(int k, int n, int startV) {
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(k).build();
        for (int i = 1; i <= n; ++i) {
            qs.update((double)(startV + i));
        }
        byte[] byteArr = new byte[qs.getCurrentCompactSerializedSizeBytes()];
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        return (DirectCompactDoublesSketch)qs.compact(seg);
    }

    @Test
    public void printlnTest() {
        DirectCompactDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
        DirectCompactDoublesSketchTest.print("PRINTING: " + this.getClass().getName() + Util.LS);
    }

    static void println(String s) {
        DirectCompactDoublesSketchTest.print(s + Util.LS);
    }

    static void print(String s) {
    }
}

