/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hash;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Random;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.hash.MurmurHash3FFM;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MurmurHash3FFMTest {
    private final Random rand = new Random();
    private static final int trials = 0x100000;

    @Test
    public void compareLongArrLong() {
        int arrLen = 3;
        boolean iPer = true;
        long[] key = new long[3];
        for (int i = 0; i < 0x100000; ++i) {
            for (int j = 0; j < 3; ++j) {
                long r;
                key[j] = r = this.rand.nextLong();
            }
            long[] res1 = MurmurHash3FFMTest.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFMTest.hashV2(key, 0L);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    @Test
    public void compareIntArr() {
        int bytes = 4;
        int arrLen = 6;
        int[] key = new int[6];
        int iPer = 2;
        int nLongs = 3;
        int shift = 32;
        for (int i = 0; i < 0x100000; ++i) {
            for (int j = 0; j < 3; ++j) {
                long r = this.rand.nextLong();
                for (int k = 0; k < 2; ++k) {
                    int shft = k * 32;
                    key[k] = (int)(r >>> shft);
                }
            }
            long[] res1 = MurmurHash3FFMTest.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFMTest.hashV2(key, 0L);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    @Test
    public void compareCharArr() {
        int bytes = 2;
        int arrLen = 12;
        char[] key = new char[12];
        int iPer = 4;
        int nLongs = 3;
        int shift = 16;
        for (int i = 0; i < 0x100000; ++i) {
            for (int j = 0; j < 3; ++j) {
                long r = this.rand.nextLong();
                for (int k = 0; k < 4; ++k) {
                    int shft = k * 16;
                    key[k] = (char)(r >>> shft);
                }
            }
            long[] res1 = MurmurHash3FFMTest.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFMTest.hashV2(key, 0L);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    @Test
    public void compareByteArr() {
        boolean bytes = true;
        int arrLen = 12;
        byte[] key = new byte[12];
        int iPer = 8;
        boolean nLongs = true;
        int shift = 8;
        for (int i = 0; i < 0x100000; ++i) {
            for (int j = 0; j < 1; ++j) {
                long r = this.rand.nextLong();
                for (int k = 0; k < 8; ++k) {
                    int shft = k * 8;
                    key[k] = (byte)(r >>> shft);
                }
            }
            long[] res1 = MurmurHash3FFMTest.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFMTest.hashV2(key, 0L);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    @Test
    public void compareLongVsLongArr() {
        boolean arrLen = true;
        long[] key = new long[1];
        long[] out = new long[2];
        for (int i = 0; i < 0x100000; ++i) {
            long r;
            key[0] = r = this.rand.nextLong();
            long[] res1 = MurmurHash3FFMTest.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFMTest.hashV2(r, 0L, out);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    private static final long[] hashV1(long[] key, long seed) {
        return MurmurHash3.hash((long[])key, (long)seed);
    }

    private static final long[] hashV1(int[] key, long seed) {
        return MurmurHash3.hash((int[])key, (long)seed);
    }

    private static final long[] hashV1(char[] key, long seed) {
        return MurmurHash3.hash((char[])key, (long)seed);
    }

    private static final long[] hashV1(byte[] key, long seed) {
        return MurmurHash3.hash((byte[])key, (long)seed);
    }

    private static final long[] hashV2(long[] key, long seed) {
        return MurmurHash3FFM.hash((long[])key, (long)seed);
    }

    private static final long[] hashV2(int[] key2, long seed) {
        return MurmurHash3FFM.hash((int[])key2, (long)seed);
    }

    private static final long[] hashV2(char[] key, long seed) {
        return MurmurHash3FFM.hash((char[])key, (long)seed);
    }

    private static final long[] hashV2(byte[] key, long seed) {
        return MurmurHash3FFM.hash((byte[])key, (long)seed);
    }

    private static final long[] hashV2(long key, long seed, long[] out) {
        return MurmurHash3FFM.hash((long)key, (long)seed, (long[])out);
    }

    @Test
    public void offsetChecks() {
        long seed = 12345L;
        int blocks = 6;
        int cap = 96;
        long[] hash1 = new long[2];
        MemorySegment wseg = MemorySegment.ofArray(new byte[96]);
        for (int i = 0; i < 96; ++i) {
            wseg.set(ValueLayout.JAVA_BYTE, (long)i, (byte)(-128 + i));
        }
        for (int offset = 0; offset < 16; ++offset) {
            int arrLen = 96 - offset;
            hash1 = MurmurHash3FFM.hash((MemorySegment)wseg, (long)offset, (long)arrLen, (long)12345L, (long[])hash1);
            byte[] byteArr2 = new byte[arrLen];
            MemorySegment.copy(wseg, ValueLayout.JAVA_BYTE, offset, byteArr2, 0, arrLen);
            long[] hash2 = MurmurHash3.hash((byte[])byteArr2, (long)12345L);
            Assert.assertEquals((long[])hash1, (long[])hash2);
        }
    }

    @Test
    public void byteArrChecks() {
        long seed = 0L;
        boolean offset = false;
        int bytes = 1024;
        long[] hash2 = new long[2];
        for (int j = 1; j < 1024; ++j) {
            byte[] in = new byte[1024];
            MemorySegment wseg = MemorySegment.ofArray(in);
            for (int i = 0; i < j; ++i) {
                wseg.set(ValueLayout.JAVA_BYTE, (long)i, (byte)(-128 + i));
            }
            long[] hash1 = MurmurHash3.hash((byte[])in, (long)0L);
            hash2 = MurmurHash3FFM.hash((MemorySegment)wseg, (long)0L, (long)1024L, (long)0L, (long[])hash2);
            long[] hash3 = MurmurHash3FFM.hash((byte[])in, (long)0L);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void charArrChecks() {
        long seed = 0L;
        boolean offset = false;
        int chars = 16;
        int bytes = 32;
        long[] hash2 = new long[2];
        for (int j = 1; j < 16; ++j) {
            char[] in = new char[16];
            MemorySegment wseg = MemorySegment.ofArray(in);
            for (int i = 0; i < j; ++i) {
                wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)i, i);
            }
            long[] hash1 = MurmurHash3.hash((char[])in, (long)0L);
            hash2 = MurmurHash3FFM.hash((MemorySegment)wseg, (long)0L, (long)32L, (long)0L, (long[])hash2);
            long[] hash3 = MurmurHash3FFM.hash((char[])in, (long)0L);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void intArrChecks() {
        long seed = 0L;
        boolean offset = false;
        int ints = 16;
        int bytes = 64;
        long[] hash2 = new long[2];
        for (int j = 1; j < 16; ++j) {
            int[] in = new int[16];
            MemorySegment wseg = MemorySegment.ofArray(in);
            for (int i = 0; i < j; ++i) {
                wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)i, i);
            }
            long[] hash1 = MurmurHash3.hash((int[])in, (long)0L);
            hash2 = MurmurHash3FFM.hash((MemorySegment)wseg, (long)0L, (long)64L, (long)0L, (long[])hash2);
            long[] hash3 = MurmurHash3FFM.hash((int[])in, (long)0L);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void longArrChecks() {
        long seed = 0L;
        boolean offset = false;
        int longs = 16;
        int bytes = 128;
        long[] hash2 = new long[2];
        for (int j = 1; j < 16; ++j) {
            long[] in = new long[16];
            MemorySegment wseg = MemorySegment.ofArray(in);
            for (int i = 0; i < j; ++i) {
                wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, (long)i, (long)i);
            }
            long[] hash1 = MurmurHash3.hash((long[])in, (long)0L);
            hash2 = MurmurHash3FFM.hash((MemorySegment)wseg, (long)0L, (long)128L, (long)0L, (long[])hash2);
            long[] hash3 = MurmurHash3FFM.hash((long[])in, (long)0L);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void longCheck() {
        long seed = 0L;
        boolean offset = false;
        int bytes = 8;
        long[] hash2 = new long[2];
        long[] in = new long[]{1L};
        MemorySegment wseg = MemorySegment.ofArray(in);
        long[] hash1 = MurmurHash3.hash((long[])in, (long)0L);
        hash2 = MurmurHash3FFM.hash((MemorySegment)wseg, (long)0L, (long)8L, (long)0L, (long[])hash2);
        long[] hash3 = MurmurHash3FFM.hash((long[])in, (long)0L);
        Assert.assertEquals((long[])hash1, (long[])hash2);
        Assert.assertEquals((long[])hash1, (long[])hash3);
    }

    @Test
    public void checkEmptiesNulls() {
        long[] larr2;
        int[] iarr2;
        char[] carr2;
        byte[] barr2;
        String s2;
        long seed = 123L;
        long[] hashOut = new long[2];
        try {
            MurmurHash3FFM.hash((MemorySegment)MemorySegment.ofArray(new long[0]), (long)0L, (long)0L, (long)123L, (long[])hashOut);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            s2 = "";
            MurmurHash3FFM.hash((String)"", (long)123L, (long[])hashOut);
            Assert.fail();
        }
        catch (IllegalArgumentException s2) {
            // empty catch block
        }
        try {
            s2 = null;
            MurmurHash3FFM.hash((String)s2, (long)123L, (long[])hashOut);
            Assert.fail();
        }
        catch (IllegalArgumentException s3) {
            // empty catch block
        }
        try {
            barr2 = new byte[]{};
            MurmurHash3FFM.hash((byte[])barr2, (long)123L);
            Assert.fail();
        }
        catch (IllegalArgumentException barr2) {
            // empty catch block
        }
        try {
            barr2 = null;
            MurmurHash3FFM.hash((byte[])barr2, (long)123L);
            Assert.fail();
        }
        catch (IllegalArgumentException barr3) {
            // empty catch block
        }
        try {
            carr2 = new char[]{};
            MurmurHash3FFM.hash((char[])carr2, (long)123L);
            Assert.fail();
        }
        catch (IllegalArgumentException carr2) {
            // empty catch block
        }
        try {
            carr2 = null;
            MurmurHash3FFM.hash((char[])carr2, (long)123L);
            Assert.fail();
        }
        catch (IllegalArgumentException carr3) {
            // empty catch block
        }
        try {
            iarr2 = new int[]{};
            MurmurHash3FFM.hash((int[])iarr2, (long)123L);
            Assert.fail();
        }
        catch (IllegalArgumentException iarr2) {
            // empty catch block
        }
        try {
            iarr2 = null;
            MurmurHash3FFM.hash((int[])iarr2, (long)123L);
            Assert.fail();
        }
        catch (IllegalArgumentException iarr3) {
            // empty catch block
        }
        try {
            larr2 = new long[]{};
            MurmurHash3FFM.hash((long[])larr2, (long)123L);
            Assert.fail();
        }
        catch (IllegalArgumentException larr2) {
            // empty catch block
        }
        try {
            larr2 = null;
            MurmurHash3FFM.hash((long[])larr2, (long)123L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkStringLong() {
        long seed = 123L;
        long[] hashOut = new long[2];
        String s = "123";
        Assert.assertTrue((MurmurHash3FFM.hash((String)"123", (long)123L, (long[])hashOut)[0] != 0L ? 1 : 0) != 0);
        long v = 123L;
        Assert.assertTrue((MurmurHash3FFM.hash((long)123L, (long)123L, (long[])hashOut)[0] != 0L ? 1 : 0) != 0);
    }

    @Test
    public void doubleCheck() {
        long[] hash1 = MurmurHash3FFMTest.checkDouble(-0.0);
        long[] hash2 = MurmurHash3FFMTest.checkDouble(0.0);
        Assert.assertEquals((long[])hash1, (long[])hash2);
        hash1 = MurmurHash3FFMTest.checkDouble(Double.NaN);
        long nan = 9218868437227405313L;
        hash2 = MurmurHash3FFMTest.checkDouble(Double.longBitsToDouble(9218868437227405313L));
        Assert.assertEquals((long[])hash1, (long[])hash2);
        MurmurHash3FFMTest.checkDouble(1.0);
    }

    private static long[] checkDouble(double dbl) {
        long seed = 0L;
        boolean offset = false;
        int bytes = 8;
        long[] hash2 = new long[2];
        double d = dbl == 0.0 ? 0.0 : dbl;
        long data = Double.doubleToLongBits(d);
        long[] dataArr = new long[]{data};
        MemorySegment wseg = MemorySegment.ofArray(dataArr);
        long[] hash1 = MurmurHash3.hash((long[])dataArr, (long)0L);
        hash2 = MurmurHash3FFM.hash((MemorySegment)wseg, (long)0L, (long)8L, (long)0L, (long[])hash2);
        long[] hash3 = MurmurHash3FFM.hash((double)dbl, (long)0L, (long[])hash2);
        Assert.assertEquals((long[])hash1, (long[])hash2);
        Assert.assertEquals((long[])hash1, (long[])hash3);
        return hash1;
    }
}

