/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.filters.bloomfilter.BloomFilter;
import org.apache.datasketches.filters.bloomfilter.BloomFilterBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BloomFilterCrossLanguageTest {
    @Test(groups={"generate_java_files"})
    public void generatBloomFilterBinariesForCompatibilityTesting() throws IOException {
        int[] nArr = new int[]{0, 10000, 2000000, 30000000};
        short[] hArr = new short[]{3, 5};
        for (int n : nArr) {
            for (short numHashes : hArr) {
                long configBits = Math.max((long)n, 1000L);
                BloomFilter bf = BloomFilterBuilder.createBySize((long)configBits, (int)numHashes);
                for (int i = 0; i < n / 10; ++i) {
                    bf.update((long)i);
                }
                if (n > 0) {
                    bf.update(Double.NaN);
                }
                Assert.assertEquals((boolean)bf.isEmpty(), (n == 0 ? 1 : 0) != 0);
                Assert.assertTrue((bf.isEmpty() || bf.getBitsUsed() > (long)(n / 10) ? 1 : 0) != 0);
                Files.newOutputStream(TestUtil.javaPath.resolve("bf_n" + n + "_h" + numHashes + "_java.sk"), new OpenOption[0]).write(bf.toByteArray());
            }
        }
    }

    @Test(groups={"check_cpp_files"})
    public void readBloomFilterBinariesForCompatibilityTesting() throws IOException {
        int[] nArr = new int[]{0, 10000, 2000000, 30000000};
        short[] hArr = new short[]{3, 5};
        for (int n : nArr) {
            for (short numHashes : hArr) {
                byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("bf_n" + n + "_h" + numHashes + "_cpp.sk"));
                BloomFilter bf = BloomFilter.heapify((MemorySegment)MemorySegment.ofArray(bytes));
                Assert.assertEquals((boolean)bf.isEmpty(), (n == 0 ? 1 : 0) != 0);
                Assert.assertTrue((bf.isEmpty() || bf.getBitsUsed() > (long)(n / 10) ? 1 : 0) != 0);
                for (int i = 0; i < n / 10; ++i) {
                    Assert.assertTrue((boolean)bf.query((long)i));
                }
                if (n > 0) assert (bf.query(Double.NaN));
            }
        }
    }
}

