/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common.positional;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.positional.PositionalSegment;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PositionalSegmentTest {
    @Test
    public void checkBytes() {
        int i;
        int n = 100;
        MemorySegment seg = MemorySegment.ofArray(new byte[100]);
        PositionalSegment posSeg = PositionalSegment.wrap((MemorySegment)seg);
        for (i = 0; i < 50; ++i) {
            posSeg.setByte((byte)i);
        }
        for (i = 50; i < 100; ++i) {
            posSeg.setByte((long)(i * 1), (byte)i);
        }
        posSeg.resetPosition();
        for (i = 0; i < 100; ++i) {
            byte v1 = posSeg.getByte((long)(i * 1));
            byte v2 = posSeg.getByte();
            Assert.assertEquals((byte)v1, (byte)v2);
            Assert.assertEquals((int)v2, (int)i);
        }
        posSeg.resetPosition();
        byte[] arr = new byte[100];
        posSeg.getByteArray(arr, 0, 100);
        posSeg.resetPosition();
        posSeg.setByteArray(arr, 0, 100);
        MemorySegment seg2 = posSeg.getMemorySegment();
        for (int i2 = 0; i2 < 100; ++i2) {
            Assert.assertEquals((byte)seg2.get(ValueLayout.JAVA_BYTE, (long)(i2 * 1)), (byte)((byte)i2));
        }
    }

    @Test
    public void checkChars() {
        int i;
        int n = 128;
        MemorySegment seg = MemorySegment.ofArray(new byte[256]);
        PositionalSegment posSeg = PositionalSegment.wrap((MemorySegment)seg);
        for (i = 0; i < 64; ++i) {
            posSeg.setChar((char)i);
        }
        for (i = 64; i < 128; ++i) {
            posSeg.setChar((long)(i * 2), (char)i);
        }
        posSeg.resetPosition();
        for (i = 0; i < 128; ++i) {
            char v1 = posSeg.getChar((long)(i * 2));
            char v2 = posSeg.getChar();
            Assert.assertEquals((int)v1, (int)v2);
            Assert.assertEquals((int)v2, (int)i);
        }
        posSeg.resetPosition();
        char[] arr = new char[128];
        posSeg.getCharArray(arr, 0, 128);
        posSeg.resetPosition();
        posSeg.setCharArray(arr, 0, 128);
        MemorySegment seg2 = posSeg.getMemorySegment();
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((char)seg2.get(ValueLayout.JAVA_CHAR_UNALIGNED, (long)(i2 * 2)), (char)((char)i2));
        }
    }

    @Test
    public void checkShorts() {
        int i;
        int n = 128;
        MemorySegment seg = MemorySegment.ofArray(new byte[256]);
        PositionalSegment posSeg = PositionalSegment.wrap((MemorySegment)seg);
        for (i = 0; i < 64; ++i) {
            posSeg.setShort((short)i);
        }
        for (i = 64; i < 128; ++i) {
            posSeg.setShort((long)(i * 2), (short)i);
        }
        posSeg.resetPosition();
        for (i = 0; i < 128; ++i) {
            short v1 = posSeg.getShort((long)(i * 2));
            short v2 = posSeg.getShort();
            Assert.assertEquals((int)v1, (int)v2);
            Assert.assertEquals((int)v2, (int)i);
        }
        posSeg.resetPosition();
        short[] arr = new short[128];
        posSeg.getShortArray(arr, 0, 128);
        posSeg.resetPosition();
        posSeg.setShortArray(arr, 0, 128);
        MemorySegment seg2 = posSeg.getMemorySegment();
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((short)seg2.get(ValueLayout.JAVA_SHORT_UNALIGNED, (long)(i2 * 2)), (short)((short)i2));
        }
    }

    @Test
    public void checkInts() {
        int i;
        int n = 128;
        MemorySegment seg = MemorySegment.ofArray(new byte[512]);
        PositionalSegment posSeg = PositionalSegment.wrap((MemorySegment)seg);
        for (i = 0; i < 64; ++i) {
            posSeg.setInt(i);
        }
        for (i = 64; i < 128; ++i) {
            posSeg.setInt((long)(i * 4), i);
        }
        posSeg.resetPosition();
        for (i = 0; i < 128; ++i) {
            int v1 = posSeg.getInt((long)(i * 4));
            int v2 = posSeg.getInt();
            Assert.assertEquals((int)v1, (int)v2);
            Assert.assertEquals((int)v2, (int)i);
        }
        posSeg.resetPosition();
        int[] arr = new int[128];
        posSeg.getIntArray(arr, 0, 128);
        posSeg.resetPosition();
        posSeg.setIntArray(arr, 0, 128);
        MemorySegment seg2 = posSeg.getMemorySegment();
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((int)seg2.get(ValueLayout.JAVA_INT_UNALIGNED, (long)(i2 * 4)), (int)i2);
        }
    }

    @Test
    public void checkLongs() {
        int i;
        int n = 128;
        MemorySegment seg = MemorySegment.ofArray(new byte[1024]);
        PositionalSegment posSeg = PositionalSegment.wrap((MemorySegment)seg);
        for (i = 0; i < 64; ++i) {
            posSeg.setLong((long)i);
        }
        for (i = 64; i < 128; ++i) {
            posSeg.setLong((long)(i * 8), (long)i);
        }
        posSeg.resetPosition();
        for (i = 0; i < 128; ++i) {
            long v1 = posSeg.getLong((long)(i * 8));
            long v2 = posSeg.getLong();
            Assert.assertEquals((long)v1, (long)v2);
            Assert.assertEquals((long)v2, (long)i);
        }
        posSeg.resetPosition();
        long[] arr = new long[128];
        posSeg.getLongArray(arr, 0, 128);
        posSeg.resetPosition();
        posSeg.setLongArray(arr, 0, 128);
        MemorySegment seg2 = posSeg.getMemorySegment();
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((long)seg2.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)(i2 * 8)), (long)i2);
        }
    }

    @Test
    public void checkFloats() {
        int i;
        int n = 128;
        MemorySegment seg = MemorySegment.ofArray(new byte[512]);
        PositionalSegment posSeg = PositionalSegment.wrap((MemorySegment)seg);
        for (i = 0; i < 64; ++i) {
            posSeg.setFloat((float)i);
        }
        for (i = 64; i < 128; ++i) {
            posSeg.setFloat((long)(i * 4), (float)i);
        }
        posSeg.resetPosition();
        for (i = 0; i < 128; ++i) {
            float v1 = posSeg.getFloat((long)(i * 4));
            float v2 = posSeg.getFloat();
            Assert.assertEquals((float)v1, (float)v2);
            Assert.assertEquals((float)v2, (float)i);
        }
        posSeg.resetPosition();
        float[] arr = new float[128];
        posSeg.getFloatArray(arr, 0, 128);
        posSeg.resetPosition();
        posSeg.setFloatArray(arr, 0, 128);
        MemorySegment seg2 = posSeg.getMemorySegment();
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)seg2.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(i2 * 4)), (float)i2);
        }
    }

    @Test
    public void checkDoubles() {
        int i;
        int n = 128;
        MemorySegment seg = MemorySegment.ofArray(new byte[1024]);
        PositionalSegment posSeg = PositionalSegment.wrap((MemorySegment)seg);
        for (i = 0; i < 64; ++i) {
            posSeg.setDouble((double)i);
        }
        for (i = 64; i < 128; ++i) {
            posSeg.setDouble((long)(i * 8), (double)i);
        }
        posSeg.resetPosition();
        for (i = 0; i < 128; ++i) {
            double v1 = posSeg.getDouble((long)(i * 8));
            double v2 = posSeg.getDouble();
            Assert.assertEquals((double)v1, (double)v2);
            Assert.assertEquals((double)v2, (double)i);
        }
        posSeg.resetPosition();
        double[] arr = new double[128];
        posSeg.getDoubleArray(arr, 0, 128);
        posSeg.resetPosition();
        posSeg.setDoubleArray(arr, 0, 128);
        MemorySegment seg2 = posSeg.getMemorySegment();
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)seg2.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)(i2 * 8)), (double)i2);
        }
    }

    @Test
    public void printlnTest() {
        PositionalSegmentTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

