/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfNumbersSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.ArrayOfUtf16StringsSerDe;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfXSerDeTest {
    @Test
    public void checkBooleanItems() {
        int offset = 10;
        ArrayOfBooleansSerDe serDe = new ArrayOfBooleansSerDe();
        Object[] items = new Boolean[]{true, false, true, false, true, false, true, false, true, false};
        int bytes = serDe.sizeOf((Boolean[])items);
        byte[] byteArr = serDe.serializeToByteArray((Boolean[])items);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        MemorySegment wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Object[] deSer = serDe.deserializeFromMemorySegment(wseg, 10L, items.length);
        Assert.assertEquals((Object[])deSer, (Object[])items);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, items.length), (int)bytes);
        Boolean item = true;
        bytes = serDe.sizeOf(item);
        byteArr = serDe.serializeToByteArray(item);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        Assert.assertEquals((String)serDe.toString(item), (String)item.toString());
        wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Boolean deItem = serDe.deserializeFromMemorySegment(wseg, 10L, 1)[0];
        Assert.assertEquals((Boolean)deItem, (Boolean)item);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, 1), (int)bytes);
    }

    @Test
    public void checkDoubleItems() {
        int offset = 10;
        ArrayOfDoublesSerDe serDe = new ArrayOfDoublesSerDe();
        Object[] items = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        int bytes = serDe.sizeOf((Double[])items);
        byte[] byteArr = serDe.serializeToByteArray((Double[])items);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        MemorySegment wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Object[] deSer = serDe.deserializeFromMemorySegment(wseg, 10L, items.length);
        Assert.assertEquals((Object[])deSer, (Object[])items);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, items.length), (int)bytes);
        Double item = 13.0;
        bytes = serDe.sizeOf(item);
        byteArr = serDe.serializeToByteArray(item);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        Assert.assertEquals((int)serDe.sizeOf(item), (int)bytes);
        Assert.assertEquals((String)serDe.toString(item), (String)item.toString());
        wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Double deItem = serDe.deserializeFromMemorySegment(wseg, 10L, 1)[0];
        Assert.assertEquals((Double)deItem, (Double)item);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, 1), (int)bytes);
    }

    @Test
    public void checkLongItems() {
        int offset = 10;
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        Object[] items = new Long[]{1L, 2L, 3L, 4L, 5L, 6L};
        int bytes = serDe.sizeOf((Long[])items);
        byte[] byteArr = serDe.serializeToByteArray((Long[])items);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        MemorySegment wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Object[] deSer = serDe.deserializeFromMemorySegment(wseg, 10L, items.length);
        Assert.assertEquals((Object[])deSer, (Object[])items);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, items.length), (int)bytes);
        Long item = 13L;
        bytes = serDe.sizeOf(item);
        byteArr = serDe.serializeToByteArray(item);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        Assert.assertEquals((int)serDe.sizeOf(item), (int)bytes);
        Assert.assertEquals((String)serDe.toString(item), (String)item.toString());
        wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Long deItem = serDe.deserializeFromMemorySegment(wseg, 10L, 1)[0];
        Assert.assertEquals((Long)deItem, (Long)item);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, 1), (int)bytes);
    }

    @Test
    public void checkNumberItems() {
        int offset = 10;
        ArrayOfNumbersSerDe serDe = new ArrayOfNumbersSerDe();
        Double item = 5.0;
        int bytes = serDe.sizeOf((Number)item);
        byte[] byteArr = serDe.serializeToByteArray((Number)item);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        MemorySegment wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Number deSer1 = serDe.deserializeFromMemorySegment(wseg, 10L, 1)[0];
        Assert.assertEquals((Object)deSer1, (Object)item);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, 1), (int)bytes);
        Object[] items = new Number[]{1L, 2, (short)3, (byte)4, 5.0, Float.valueOf(6.0f)};
        bytes = serDe.sizeOf((Number[])items);
        byteArr = serDe.serializeToByteArray((Number[])items);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Object[] deSer = serDe.deserializeFromMemorySegment(wseg, 10L, items.length);
        Assert.assertEquals((Object[])deSer, (Object[])items);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, items.length), (int)bytes);
        item = 13.0;
        bytes = serDe.sizeOf((Number)item);
        byteArr = serDe.serializeToByteArray(new Number[]{item});
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        Assert.assertEquals((int)serDe.sizeOf((Number)item), (int)bytes);
        Assert.assertEquals((String)serDe.toString((Number)item), (String)((Object)item).toString());
        wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Number[] deItem = serDe.deserializeFromMemorySegment(wseg, 10L, 1);
        Assert.assertEquals((Object)deItem[0], (Object)item);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, 1), (int)bytes);
    }

    @Test
    public void checkUTF8Items() {
        int offset = 10;
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        String item = "abcdefghijklmnopqr";
        int bytes = serDe.sizeOf(item);
        byte[] byteArr = serDe.serializeToByteArray(item);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        MemorySegment wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        String deSer1 = serDe.deserializeFromMemorySegment(wseg, 10L, 1)[0];
        Assert.assertEquals((String)deSer1, (String)item);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, 1), (int)bytes);
        Object[] items = new String[]{"abc", "def", "ghi", "jkl", "mno", "pqr"};
        bytes = serDe.sizeOf(items);
        byteArr = serDe.serializeToByteArray((String[])items);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Object[] deSer = serDe.deserializeFromMemorySegment(wseg, 10L, items.length);
        Assert.assertEquals((Object[])deSer, (Object[])items);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, items.length), (int)bytes);
        item = "13.0";
        bytes = serDe.sizeOf(item);
        byteArr = serDe.serializeToByteArray(new String[]{item});
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        Assert.assertEquals((int)serDe.sizeOf(item), (int)bytes);
        Assert.assertEquals((String)serDe.toString(item), (String)item);
        wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        String[] deItem = serDe.deserializeFromMemorySegment(wseg, 10L, 1);
        Assert.assertEquals((String)deItem[0], (String)item);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, 1), (int)bytes);
    }

    @Test
    public void checkUTF16Items() {
        int offset = 10;
        ArrayOfUtf16StringsSerDe serDe = new ArrayOfUtf16StringsSerDe();
        String item = "abcdefghijklmnopqr";
        int bytes = serDe.sizeOf(item);
        byte[] byteArr = serDe.serializeToByteArray(item);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        MemorySegment wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        String deSer1 = serDe.deserializeFromMemorySegment(wseg, 10L, 1)[0];
        Assert.assertEquals((String)deSer1, (String)item);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, 1), (int)bytes);
        Object[] items = new String[]{"abc", "def", "ghi", "jkl", "mno", "pqr"};
        bytes = serDe.sizeOf(items);
        byteArr = serDe.serializeToByteArray((String[])items);
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        Object[] deSer = serDe.deserializeFromMemorySegment(wseg, 10L, items.length);
        Assert.assertEquals((Object[])deSer, (Object[])items);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, items.length), (int)bytes);
        item = "13.0";
        bytes = serDe.sizeOf(item);
        byteArr = serDe.serializeToByteArray(new String[]{item});
        Assert.assertEquals((int)byteArr.length, (int)bytes);
        Assert.assertEquals((int)serDe.sizeOf(item), (int)bytes);
        Assert.assertEquals((String)serDe.toString(item), (String)item);
        wseg = MemorySegment.ofArray(new byte[10 + byteArr.length]);
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 10L, byteArr.length);
        String[] deItem = serDe.deserializeFromMemorySegment(wseg, 10L, 1);
        Assert.assertEquals((String)deItem[0], (String)item);
        Assert.assertEquals((int)serDe.sizeOf(wseg, 10L, 1), (int)bytes);
    }
}

