/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJweDecryptingFilter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;

@Priority(value=1002)
public class JweClientResponseFilter
extends AbstractJweDecryptingFilter
implements ClientResponseFilter {
    public void filter(ClientRequestContext req, ClientResponseContext res) throws IOException {
        if (this.isMethodWithNoContent(req.getMethod()) || this.isStatusCodeWithNoContent(res.getStatus()) || this.isCheckEmptyStream() && !res.hasEntity()) {
            return;
        }
        byte[] encryptedContent = IOUtils.readBytesFromStream((InputStream)res.getEntityStream());
        if (encryptedContent.length == 0) {
            return;
        }
        JweDecryptionOutput out = this.decrypt(encryptedContent);
        byte[] bytes = out.getContent();
        res.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        res.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType((String)out.getHeaders().getContentType(), (String)this.getDefaultMediaType());
        if (ct != null) {
            res.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
        if (super.isValidateHttpHeaders()) {
            super.validateHttpHeadersIfNeeded((MultivaluedMap<String, String>)res.getHeaders(), out.getHeaders());
        }
    }

    protected boolean isMethodWithNoContent(String method) {
        return "DELETE".equals(method) || HttpUtils.isMethodWithNoResponseContent((String)method);
    }

    protected boolean isStatusCodeWithNoContent(int statusCode) {
        return statusCode == Response.Status.NO_CONTENT.getStatusCode();
    }
}

