/***************************************************************************

    Sega Game Gear cartridges

***************************************************************************/

#include "driver.h"
#include "softlist.h"
#include "devices/cartslot.h"


#define GAMEGEAR_ROM_LOAD( set, name, offset, length, hash )	\
SOFTWARE_START( set ) \
	ROM_REGION( 0x100000, CARTRIDGE_REGION_ROM, 0 ) \
	ROM_LOAD(name, offset, length, hash) \
SOFTWARE_END


GAMEGEAR_ROM_LOAD( 5in1fun, "5 in 1 funpak (usa).bin",                                               0x000000 , 0x40000,    CRC(f85a8ce8) SHA1(dc8f5848fede37a914dbf1c104c3efb5a804ccbd) )
GAMEGEAR_ROM_LOAD( aaharima, "aa harimanada (japan).bin",                                            0x000000 , 0x80000,    CRC(1d17d2a0) SHA1(0fa7111fcd98670d4bef725d11e670e14eaaa7eb) )
GAMEGEAR_ROM_LOAD( addamfam, "addams family, the (world).bin",                                       0x000000 , 0x40000,    CRC(1d01f999) SHA1(3231d574e5eb0ac3a77b1d65d74f3a581819a9c7) )
GAMEGEAR_ROM_LOAD( advbatmrp1, "adventures of batman & robin, the (prototype - apr 27, 1995).bin",   0x000000 , 0x7fff6,    CRC(acce0d15) SHA1(ac60f308640eea536bb3007d2a0b78d95b81d160) )
GAMEGEAR_ROM_LOAD( advbatmrp2, "adventures of batman & robin, the (prototype - apr 29, 1995 - a).bin",0x000000 , 0x7fbdc,    CRC(14867057) SHA1(7877c4f8c271c37fc7d72208460231e60e63b95e) )
GAMEGEAR_ROM_LOAD( advbatmrp3, "adventures of batman & robin, the (prototype - apr 30, 1995).bin",   0x000000 , 0x7fbdc,    CRC(50376471) SHA1(cda657eb423a8891304cb64cf4a43fd434c60588) )
GAMEGEAR_ROM_LOAD( advbatmrp4, "adventures of batman & robin, the (prototype - may 02, 1995).bin",   0x000000 , 0x7fbdc,    CRC(e57566f3) SHA1(81cb20d64acc5cee4bc7b56f0dcec9125b55f66f) )
GAMEGEAR_ROM_LOAD( advbatmrp5, "adventures of batman & robin, the (prototype - may 04, 1995).bin",   0x000000 , 0x7fbdc,    CRC(a9cf66ed) SHA1(19f890a237d4aa0868121d80944055a314275f81) )
GAMEGEAR_ROM_LOAD( advbatmrp6, "adventures of batman & robin, the (prototype - may 06, 1995 - b).bin",0x000000 , 0x7fffa,    CRC(50c2f1ad) SHA1(8cebb48b14c4c1ee4d168f764b074a87cc4e5324) )
GAMEGEAR_ROM_LOAD( advbatmrp7, "adventures of batman & robin, the (prototype - may 06, 1995).bin",   0x000000 , 0x7fffa,    CRC(c403264a) SHA1(0afd0624bd054430b7894c24e2fb186d5f44af99) )
GAMEGEAR_ROM_LOAD( advbatmrp8, "adventures of batman & robin, the (prototype - may 07, 1995).bin",   0x000000 , 0x7fffa,    CRC(fc916fd7) SHA1(ea5b5b79f92f5546a733efc10f42997956037463) )
GAMEGEAR_ROM_LOAD( advbatmr, "adventures of batman & robin, the (usa, europe).bin",                  0x000000 , 0x80000,    CRC(bb4f23ff) SHA1(50e8726be1b26d066ea9e2e2b5cd7407c356187e) )
GAMEGEAR_ROM_LOAD( aerialasj, "aerial assault (japan) (v1.1).bin",                                   0x000000 , 0x20000,    CRC(04fe6dde) SHA1(2a91ab5817938dddf2724df2dfd95a3bc6f5156d) )
GAMEGEAR_ROM_LOAD( aerialas, "aerial assault (world).bin",                                           0x000000 , 0x20000,    CRC(3e549b7a) SHA1(cbdbaaeb62a8483d9d5a8757b0f19233dfb9b416) )
GAMEGEAR_ROM_LOAD( aladdinj, "aladdin (japan).bin",                                                  0x000000 , 0x80000,    CRC(770e95e1) SHA1(7ddfd53e91d8220e4238d3994921bf18fe383717) )
GAMEGEAR_ROM_LOAD( aladdinp1, "aladdin (prototype - dec 29, 1993).bin",                              0x000000 , 0x80000,    CRC(5b1f717f) SHA1(ed303cb2debbc74f65a02f863e8c5bbb446155c4) )
GAMEGEAR_ROM_LOAD( aladdinp2, "aladdin (prototype - jan 11, 1994).bin",                              0x000000 , 0x80000,    CRC(8a1693ab) SHA1(7ec48d31a35006ccba4abcf108e187e0b222852b) )
GAMEGEAR_ROM_LOAD( aladdinp3, "aladdin (prototype - jan 13, 1994).bin",                              0x000000 , 0x80000,    CRC(75a7f142) SHA1(a968ee77938233a4ff94c73266c7fb36fa25657d) )
GAMEGEAR_ROM_LOAD( aladdinp4, "aladdin (prototype with - jan 23, 1994).bin",                         0x000000 , 0x80000,    CRC(75a7f142) SHA1(a968ee77938233a4ff94c73266c7fb36fa25657d) )
GAMEGEAR_ROM_LOAD( aladdin, "aladdin (usa, europe).bin",                                             0x000000 , 0x80000,    CRC(7a41c1dc) SHA1(20ba7f5e5c801fbe48a537d2551a3d4525eb63e7) )
GAMEGEAR_ROM_LOAD( alien3, "alien 3 (usa, europe).bin",                                              0x000000 , 0x40000,    CRC(11a68c08) SHA1(f3b976fefc331f37c3e4d883791eba68890279a5) )
GAMEGEAR_ROM_LOAD( asyndromj, "alien syndrome (japan).bin",                                          0x000000 , 0x20000,    CRC(ffe4ed47) SHA1(b72e54493bfa7f13883a608bcf8c9f315dd490ca) )
GAMEGEAR_ROM_LOAD( asyndrom, "alien syndrome (usa, europe).bin",                                     0x000000 , 0x20000,    CRC(bb5e10e0) SHA1(112c7fba070eb7b6bdd41675d49caf934c17dc17) )
GAMEGEAR_ROM_LOAD( andreaga, "andre agassi tennis (usa).bin",                                        0x000000 , 0x40000,    CRC(46c9fa3e) SHA1(9bd46e137723795a62cca429effcdd51f3b71257) )
GAMEGEAR_ROM_LOAD( arcadecl, "arcade classics (usa).bin",                                            0x000000 , 0x40000,    CRC(3deca813) SHA1(fde19f418f4f13bbe43e6610f411065db9a6f550) )
GAMEGEAR_ROM_LOAD( archriv, "arch rivals (usa).bin",                                                 0x000000 , 0x40000,    CRC(f0204191) SHA1(9a2260a9cb9564a18f50edc8149a9e1e517bf649) )
GAMEGEAR_ROM_LOAD( arena, "arena (usa, europe).bin",                                                 0x000000 , 0x80000,    CRC(7cb3facf) SHA1(91e411d979789f2e31dcfe94fb7f757815f60680) )
GAMEGEAR_ROM_LOAD( arielmer, "ariel the little mermaid (usa, europe).bin",                           0x000000 , 0x40000,    CRC(97e3a18c) SHA1(d2f1b95a6d0a2cacd93ed307a5a6576f954a7d56) )
GAMEGEAR_ROM_LOAD( arliel, "arliel - crystal densetsu (japan).bin",                                  0x000000 , 0x40000,    CRC(35fa3f68) SHA1(75a04fa483fccd12a52aa18e494d542f4486577f) )
GAMEGEAR_ROM_LOAD( asterix, "asterix (prototype - feb 16, 1994).bin",                                0x000000 , 0x80000,    CRC(1e8d735c) SHA1(7d411f499e313bece6cd0a6f32c614adc0405190) )
GAMEGEAR_ROM_LOAD( asterixa, "asterix (prototype - feb 22, 1994).bin",                               0x000000 , 0x80000,    CRC(31bd3d8a) SHA1(ca04b12f93d3657e323db8ae3f3f31a6220ec732) )
GAMEGEAR_ROM_LOAD( asterixb, "asterix (prototype - jan 25, 1994).bin",                               0x000000 , 0x80000,    CRC(ba45f00f) SHA1(4d52303ce4aa680fcf5813317804b5805b9222a4) )
GAMEGEAR_ROM_LOAD( asterixc, "asterix (prototype - mar 13, 1994).bin",                               0x000000 , 0x80000,    CRC(faf09846) SHA1(cde9940d29dc834806b55cc1783c1b7944eb7600) )
GAMEGEAR_ROM_LOAD( asterixd, "asterix (prototype - mar 15, 1994).bin",                               0x000000 , 0x80000,    CRC(66d8eb63) SHA1(be292971696ecfa753d312c97c5b4788f5adfbee) )
GAMEGEAR_ROM_LOAD( astergre, "asterix and the great rescue (europe) (en,fr,de,es,it).bin",           0x000000 , 0x80000,    CRC(328c5cc8) SHA1(6083f57bc33c761ebf06b7c7512d1ee10bf619c8) )
GAMEGEAR_ROM_LOAD( astergreu, "asterix and the great rescue (usa).bin",                              0x000000 , 0x80000,    CRC(78208b40) SHA1(821a0f9087001831fb9828fe2ef193877f960db6) )
GAMEGEAR_ROM_LOAD( astermis, "asterix and the secret mission (europe) (en,fr,de).bin",               0x000000 , 0x80000,    CRC(c01a8051) SHA1(8ab4ea406a0503b09c1bd89e3217c5735b36ebed) )
GAMEGEAR_ROM_LOAD( axbattlr, "ax battler - a legend of golden axe (usa, europe) (v2.4).bin",         0x000000 , 0x40000,    CRC(663bcf8a) SHA1(9f5bf2973225b8ee337fcec460829724a0c63d9e) )
GAMEGEAR_ROM_LOAD( axbattlrj, "ax battler - golden axe densetsu (japan) (v1.5).bin",                 0x000000 , 0x40000,    CRC(dfcf555f) SHA1(ff7931d3461c69ffc3a82d892ae3bb3bb00788b3) )
GAMEGEAR_ROM_LOAD( ayrtonj, "ayrton senna's super monaco gp ii (japan).bin",                         0x000000 , 0x40000,    CRC(661faeff) SHA1(44f2c2bfa6ab57c1fd533996a5e404ebaa07264b) )
GAMEGEAR_ROM_LOAD( ayrton, "ayrton senna's super monaco gp ii (usa, europe).bin",                    0x000000 , 0x40000,    CRC(1d1b1dd3) SHA1(e6a86010a4dad0a6102783d3c00ad126e8221597) )
GAMEGEAR_ROM_LOAD( bakubaku, "baku baku animal (usa).bin",                                           0x000000 , 0x40000,    CRC(8d8bfdc4) SHA1(f4f31d08e17b9936dea621fef9b38e1cd067bef2) )
GAMEGEAR_ROM_LOAD( bakubakuj, "baku baku animal - sekai shiikugakari senshu-ken (japan).bin",        0x000000 , 0x40000,    CRC(10ac9374) SHA1(5145967d0a3632cf6bb1a9d58b2ef04faecd40db) )
GAMEGEAR_ROM_LOAD( barbie, "barbie super model (unknown) (proto).bin",                               0x000000 , 0x40000,    CRC(03a0ce9e) SHA1(4fabaf794081074ac1a76eb0efc4262efb627610) )
GAMEGEAR_ROM_LOAD( bartman, "bartman meets radioactive man (usa, europe).bin",                       0x000000 , 0x40000,    CRC(ffa447a9) SHA1(9dd99ca1b28dbb16f5f118e2729613d1452aba73) )
GAMEGEAR_ROM_LOAD( batmanfv, "batman forever (world).bin",                                           0x000000 , 0x80000,    CRC(618b19e2) SHA1(775ecf7ba87345c2f89f0e9d6e55544db8878786) )
GAMEGEAR_ROM_LOAD( batmanrn, "batman returns (world).bin",                                           0x000000 , 0x40000,    CRC(7ac4a3ca) SHA1(85994b2f506c7bded0b02a59d96b1d949e48d518) )
GAMEGEAR_ROM_LOAD( batterup, "batter up (usa, europe).bin",                                          0x000000 , 0x20000,    CRC(16448209) SHA1(107496f1afff8bcebcd507226e953871fc4d80e4) )
GAMEGEAR_ROM_LOAD( battlesh, "battleship (usa, europe).bin",                                         0x000000 , 0x10000,    CRC(fddd8cd9) SHA1(eae1ebec2c1be522924f669a2dc884f9f4a68cf3) )
GAMEGEAR_ROM_LOAD( btoads, "battletoads (japan, europe).bin",                                        0x000000 , 0x40000,    CRC(cb3cd075) SHA1(77a284b993c6f60652d88468b836d7a2ee7b4600) )
GAMEGEAR_ROM_LOAD( btoadsu, "battletoads (usa).bin",                                                 0x000000 , 0x40000,    CRC(817cc0ca) SHA1(f566a19d1cfd5c20d5b91b396f29323be2209911) )
GAMEGEAR_ROM_LOAD( beavis, "beavis and butt-head (europe).bin",                                      0x000000 , 0x80000,    CRC(a6bf865e) SHA1(dd2ea76c05d933b91f1b03140f6a04bf02f746d1) )
GAMEGEAR_ROM_LOAD( beavisu, "beavis and butt-head (usa).bin",                                        0x000000 , 0x80000,    CRC(3858f14f) SHA1(ef47d449f65cfe129368a77cc0a4679a0d55ee63) )
GAMEGEAR_ROM_LOAD( berensp, "berenstain bears (prototype - aug 01, 1994).bin",                       0x000000 , 0x40000,    CRC(882b8f53) SHA1(c7e0ccefdcc4f12d7ecdbab383e441b829a2c789) )
GAMEGEAR_ROM_LOAD( berensp1, "berenstain bears (prototype - aug 11, 1994 - a).bin",                  0x000000 , 0x40000,    CRC(81a5e68f) SHA1(af14fcb9329c0ded9775473ef78e241fb6b2d365) )
GAMEGEAR_ROM_LOAD( berensp2, "berenstain bears (prototype - aug 11, 1994).bin",                      0x000000 , 0x40000,    CRC(50d400b8) SHA1(2d6ecb588299bbe9cb0eb54954663043355d759e) )
GAMEGEAR_ROM_LOAD( berensp3, "berenstain bears (prototype - aug 12, 1994).bin",                      0x000000 , 0x40000,    CRC(0e676927) SHA1(9b2aa818cdadc435ca1aee8ae54809377dce26f3) )
GAMEGEAR_ROM_LOAD( berensp4, "berenstain bears (prototype - aug 13, 1994).bin",                      0x000000 , 0x40000,    CRC(f8f11b2a) SHA1(b43373e626d96649f11d5f0ac1101a20b7404978) )
GAMEGEAR_ROM_LOAD( berensp5, "berenstain bears (prototype - aug 14, 1994).bin",                      0x000000 , 0x40000,    CRC(d0971f78) SHA1(a8adae0ac9301b3342d79715b18e8cdebc6d84f6) )
GAMEGEAR_ROM_LOAD( berensp6, "berenstain bears (prototype - aug 19, 1994).bin",                      0x000000 , 0x40000,    CRC(177d65ac) SHA1(0e44212a90383b82cd0d4e03b6cd12a6b38e2d48) )
GAMEGEAR_ROM_LOAD( berensp7, "berenstain bears (prototype - aug 20, 1994).bin",                      0x000000 , 0x40000,    CRC(f61ac1e8) SHA1(6aad469e328614d9ed3f8f84bd90ef2dac2e71db) )
GAMEGEAR_ROM_LOAD( berensp8, "berenstain bears (prototype - aug 24, 1994).bin",                      0x000000 , 0x40000,    CRC(b73486d6) SHA1(480537a721631fc9cebe67422010dfe5739002ef) )
GAMEGEAR_ROM_LOAD( berensp9, "berenstain bears (prototype - aug 25, 1994 - b).bin",                  0x000000 , 0x40000,    CRC(e07b865e) SHA1(ac152aa09dc09419c26761c18276fe4d679d8992) )
GAMEGEAR_ROM_LOAD( beresp10, "berenstain bears (prototype - aug 26, 1994 - b).bin",                  0x000000 , 0x40000,    CRC(217b1ef0) SHA1(bd1ff3c4669379b2a02bd8e1d76b9c02fefc783e) )
GAMEGEAR_ROM_LOAD( beresp11, "berenstain bears (prototype - aug 26, 1994).bin",                      0x000000 , 0x40000,    CRC(167a4af6) SHA1(09bb4a3e936dcce34b46090f5f2f1353dee1d6f6) )
GAMEGEAR_ROM_LOAD( beresp12, "berenstain bears (prototype - jul 15, 1994 - b).bin",                  0x000000 , 0x40000,    CRC(fcf47bc9) SHA1(5fc1a46c47bb847fd3dbca54c9ba729011546b76) )
GAMEGEAR_ROM_LOAD( beresp13, "berenstain bears (prototype - jul 21, 1994).bin",                      0x000000 , 0x40000,    CRC(a279c6bc) SHA1(92ed587953db4c0001d19395c9c8c611d15d0cef) )
GAMEGEAR_ROM_LOAD( beresp14, "berenstain bears (prototype - jul 22, 1994).bin",                      0x000000 , 0x40000,    CRC(ffbf5abe) SHA1(83e3d4ed1437b6ed042b88129f3c1fb3d1846c94) )
GAMEGEAR_ROM_LOAD( beresp15, "berenstain bears (prototype - jul 27, 1994).bin",                      0x000000 , 0x40000,    CRC(112b123f) SHA1(801ed129a09373ad9606f7dedc9ce0bd7ce7dd21) )
GAMEGEAR_ROM_LOAD( beresp16, "berenstain bears (prototype - jun 28, 1994).bin",                      0x000000 , 0x40000,    CRC(75a7a8ca) SHA1(9e16aa6a11186089510fac9413bdd8e62001a761) )
GAMEGEAR_ROM_LOAD( berens, "berenstain bears' camping adventure, the (usa).bin",                     0x000000 , 0x40000,    CRC(a4bb9ffb) SHA1(a35bef59a59df2a6d3dc4b8d3fe2e4cc79464537) )
GAMEGEAR_ROM_LOAD( berlin, "berlin no kabe (japan).bin",                                             0x000000 , 0x40000,    CRC(325b1797) SHA1(1d58d3d8b957d33bab8b50ae60dc0c31eafc08af) )
GAMEGEAR_ROM_LOAD( bishou, "bishoujo senshi sailor moon s (japan).bin",                              0x000000 , 0x80000,    CRC(fe7374d2) SHA1(824e463d0be5c0e81205a475b5ad7e55c366e486) )
GAMEGEAR_ROM_LOAD( bonkersp, "bonkers wax up! (prototype - dec 03, 1994).bin",                       0x000000 , 0x80000,    CRC(63429025) SHA1(7e426a1db56125836dd93ea57d5ac82cff1be23f) )
GAMEGEAR_ROM_LOAD( bonkersp1, "bonkers wax up! (prototype - dec 05, 1994).bin",                      0x000000 , 0x80000,    CRC(c2229b6e) SHA1(dcbb000cda6f303d902a308a50e08ebc4803d511) )
GAMEGEAR_ROM_LOAD( bonkersp2, "bonkers wax up! (prototype - dec 07, 1994 - c).bin",                  0x000000 , 0x80000,    CRC(edaf25e7) SHA1(415fc9e0021f544cbf8fd0895d013465654fd1d5) )
GAMEGEAR_ROM_LOAD( bonkersp3, "bonkers wax up! (prototype - dec 08, 1994 - b).bin",                  0x000000 , 0x80000,    CRC(9907a738) SHA1(c8844bfda83a94ce648588ef945a0d76503b84ce) )
GAMEGEAR_ROM_LOAD( bonkersp4, "bonkers wax up! (prototype - dec 08, 1994 - c).bin",                  0x000000 , 0x80000,    CRC(91258adc) SHA1(50897d1cbda11e7b20678924d7461f8acd6f0686) )
GAMEGEAR_ROM_LOAD( bonkersp5, "bonkers wax up! (prototype - dec 11, 1994).bin",                      0x000000 , 0x80000,    CRC(9a405d0d) SHA1(e797640e2363f517fb83ee42903f5d13a1ffad73) )
GAMEGEAR_ROM_LOAD( bonkersp6, "bonkers wax up! (prototype - dec 12, 1994 - b).bin",                  0x000000 , 0x80000,    CRC(9a405d0d) SHA1(e797640e2363f517fb83ee42903f5d13a1ffad73) )
GAMEGEAR_ROM_LOAD( bonkersp7, "bonkers wax up! (prototype - dec 12, 1994 - d).bin",                  0x000000 , 0x80000,    CRC(6d295894) SHA1(368286ded1662eddfff056ad77583d62ce83f58b) )
GAMEGEAR_ROM_LOAD( bonkersp8, "bonkers wax up! (prototype - nov 15, 1994).bin",                      0x000000 , 0x80000,    CRC(85510a57) SHA1(6cd8fee2110bc5010a2840c6e5b3fb32270efc02) )
GAMEGEAR_ROM_LOAD( bonkersp9, "bonkers wax up! (prototype - nov 21, 1994).bin",                      0x000000 , 0x80000,    CRC(dab43f8f) SHA1(c60fbd9e191e4154e26e73f0fd1be1dc6e999e11) )
GAMEGEAR_ROM_LOAD( bonkrsp10, "bonkers wax up! (prototype - nov 23, 1994).bin",                      0x000000 , 0x80000,    CRC(1b081950) SHA1(ac22b149fcd6b500875c93f71e12b2a6cedea507) )
GAMEGEAR_ROM_LOAD( bonkrsp11, "bonkers wax up! (prototype - nov 26, 1994).bin",                      0x000000 , 0x80000,    CRC(eb3f22c2) SHA1(fbdccd5ee5f38b8ce5654a0093f32e3811c8b56b) )
GAMEGEAR_ROM_LOAD( bonkrsp12, "bonkers wax up! (prototype - nov 29, 1994).bin",                      0x000000 , 0x80000,    CRC(ad6a62fa) SHA1(4ad7947a4ffee9a76d146fecc9c3c2f6c5e680b7) )
GAMEGEAR_ROM_LOAD( bonkrsp13, "bonkers wax up! (prototype - oct 31, 1994).bin",                      0x000000 , 0x80000,    CRC(777dfd80) SHA1(160d28c7fd900ab25117247eccecf2ecdb164ce4) )
GAMEGEAR_ROM_LOAD( bonkers, "bonkers wax up! (usa, europe).bin",                                     0x000000 , 0x80000,    CRC(bfceba5f) SHA1(b98bd9467fe8bf782989172b576c7844f3666ae9) )
GAMEGEAR_ROM_LOAD( bramst, "bram stoker's dracula (usa).bin",                                        0x000000 , 0x40000,    CRC(69ebe5fa) SHA1(ea753b5dce4b319cc1709451a4c8cb55daf2b76b) )
GAMEGEAR_ROM_LOAD( bublbobl, "bubble bobble (usa, europe).bin",                                      0x000000 , 0x40000,    CRC(fba338c5) SHA1(c2c99d798bd0d4960021743a55e74644ad9020c6) )
GAMEGEAR_ROM_LOAD( bugsbun, "bugs bunny in double trouble (usa, europe).bin",                        0x000000 , 0x80000,    CRC(5c34d9cd) SHA1(a29dabb90532ff6114437f28970203e16003c11e) )
GAMEGEAR_ROM_LOAD( bustamov, "bust-a-move (usa, europe).bin",                                        0x000000 , 0x40000,    CRC(c90f29ef) SHA1(e6bb5f72cffb11c8dd44ac3e378088b04cec1297) )
GAMEGEAR_ROM_LOAD( busterb, "buster ball (japan).bin",                                               0x000000 , 0x20000,    CRC(7cb079d0) SHA1(5d67f38ec0c2e577a7ad88915849da696ad162aa) )
GAMEGEAR_ROM_LOAD( busterf, "buster fight (japan).bin",                                              0x000000 , 0x40000,    CRC(a72a1753) SHA1(5c87048082a95acd6bc27b98f85bda731617c739) )
GAMEGEAR_ROM_LOAD( caesar, "caesars palace (usa).bin",                                               0x000000 , 0x40000,    CRC(c53b60b8) SHA1(ce3f7d6f2df8509764f0ad06a05801ca76d6fb0a) )
GAMEGEAR_ROM_LOAD( captaven, "captain america and the avengers (usa, europe).bin",                   0x000000 , 0x40000,    CRC(5675dfdd) SHA1(4b859174d57cc4a5a575f8aa9547a83d08e6c117) )
GAMEGEAR_ROM_LOAD( carlicen, "car licence (japan).bin",                                              0x000000 , 0x80000,    CRC(f6a697f8) SHA1(0cf691dba7080a1f8d4a181563948b188115ec89) )
GAMEGEAR_ROM_LOAD( casino, "casino funpak (usa).bin",                                                0x000000 , 0x40000,    CRC(2b732056) SHA1(5b512d5c3ea92498831b40cd740b99107c369b56) )
GAMEGEAR_ROM_LOAD( castlill, "castle of illusion starring mickey mouse (usa, europe).bin",           0x000000 , 0x40000,    CRC(59840fd6) SHA1(06bbeb784f913b37f58c2581c66d4ecb099deace) )
GAMEGEAR_ROM_LOAD( chakan, "chakan (usa, europe).bin",                                               0x000000 , 0x40000,    CRC(dfc7adc8) SHA1(bdb82464147ef20792162cff7922824d4dee0dc1) )
GAMEGEAR_ROM_LOAD( chessmst, "chessmaster, the (usa, europe).bin",                                   0x000000 , 0x20000,    CRC(da811ba6) SHA1(daea9a76dedc080b9965cfa32e2ddb1eaaaab0b4) )
GAMEGEAR_ROM_LOAD( chicagop, "chicago syndicate (prototype - jul 03, 1995).bin",                     0x000000 , 0x80000,    CRC(e3c0ea98) SHA1(e526b1ff96c245d4ec69064a2cc8e57169081802) )
GAMEGEAR_ROM_LOAD( chicagop1, "chicago syndicate (prototype - jul 05, 1995).bin",                    0x000000 , 0x80000,    CRC(4158e203) SHA1(18b2a946800d4a6347cd96c8790add2f34fe4dfa) )
GAMEGEAR_ROM_LOAD( chicagop2, "chicago syndicate (prototype - jul 07, 1995).bin",                    0x000000 , 0x80000,    CRC(e44d1b01) SHA1(b76a7e673e5581a2084098f737ff551ce8880296) )
GAMEGEAR_ROM_LOAD( chicagop3, "chicago syndicate (prototype - jul 10, 1995).bin",                    0x000000 , 0x80000,    CRC(42becef6) SHA1(b32ec7e95dc39f0b78dd3d0b17c2d504f5f24f9a) )
GAMEGEAR_ROM_LOAD( chicagop4, "chicago syndicate (prototype - jul 11, 1995).bin",                    0x000000 , 0x80000,    CRC(afe46aa8) SHA1(bc01553450523d4860c2fb42d84297fd80cbf5d2) )
GAMEGEAR_ROM_LOAD( chicagop5, "chicago syndicate (prototype - jul 19, 1995).bin",                    0x000000 , 0x80000,    CRC(dd5f9327) SHA1(b70863b4a6aec101cee895baf3f8ea27e076e369) )
GAMEGEAR_ROM_LOAD( chicagop6, "chicago syndicate (prototype - jul 20, 1995).bin",                    0x000000 , 0x80000,    CRC(b0597a54) SHA1(087df96c15aa1258a46690b4859a5447481e058f) )
GAMEGEAR_ROM_LOAD( chicagop7, "chicago syndicate (prototype - jul 21, 1995 - b).bin",                0x000000 , 0x80000,    CRC(26ced733) SHA1(5c6db9314cbc4c7933dacc076e59948147ad79ae) )
GAMEGEAR_ROM_LOAD( chicagop8, "chicago syndicate (prototype - jul 21, 1995).bin",                    0x000000 , 0x80000,    CRC(8e149bb8) SHA1(17887be88692097acc74488b16a255b7b6b95aee) )
GAMEGEAR_ROM_LOAD( chicagop9, "chicago syndicate (prototype - jun 01, 1995).bin",                    0x000000 , 0x80000,    CRC(448c6890) SHA1(5ab2358c0db7c486ce2e9bcc663c054a694bff46) )
GAMEGEAR_ROM_LOAD( chicgop10, "chicago syndicate (prototype - jun 05, 1995).bin",                    0x000000 , 0x80000,    CRC(af43b940) SHA1(0fc9d9a9bbbc00dc286f350de07b0e53a507c01f) )
GAMEGEAR_ROM_LOAD( chicgop11, "chicago syndicate (prototype - jun 07, 1995).bin",                    0x000000 , 0x80000,    CRC(9b2fd7f3) SHA1(6154bbc7c0c06d354283af2292eb041e1d87944a) )
GAMEGEAR_ROM_LOAD( chicgop12, "chicago syndicate (prototype - jun 08, 1995).bin",                    0x000000 , 0x80000,    CRC(2036d4b7) SHA1(7138742323b2ba7d18eb9497f78fcb6cd2025df1) )
GAMEGEAR_ROM_LOAD( chicgop13, "chicago syndicate (prototype - jun 12, 1995).bin",                    0x000000 , 0x80000,    CRC(f2c24745) SHA1(99aeac9b5b3800ddd8ee6630e373af73496c8b3a) )
GAMEGEAR_ROM_LOAD( chicgop14, "chicago syndicate (prototype - jun 14, 1995).bin",                    0x000000 , 0x80000,    CRC(463a2197) SHA1(7f83c523a6b0813a2c1f72e71f5dbc0e1ea556cb) )
GAMEGEAR_ROM_LOAD( chicgop15, "chicago syndicate (prototype - jun 19, 1995).bin",                    0x000000 , 0x80000,    CRC(3cdb35b1) SHA1(61ca81b15fad4d71a8222a8dc9f9c1fc05561549) )
GAMEGEAR_ROM_LOAD( chicgop16, "chicago syndicate (prototype - jun 20, 1995).bin",                    0x000000 , 0x80000,    CRC(bf82cf83) SHA1(924bb32515d4a0435fb318f852483fdc1974e771) )
GAMEGEAR_ROM_LOAD( chicgop17, "chicago syndicate (prototype - jun 22, 1995).bin",                    0x000000 , 0x80000,    CRC(4ac79cec) SHA1(821bc6a27dd1cf519033d65ffe41458f3bee21cd) )
GAMEGEAR_ROM_LOAD( chicgop18, "chicago syndicate (prototype - jun 26, 1995).bin",                    0x000000 , 0x80000,    CRC(abe696e5) SHA1(148d09a535e50730672557668c3161f3b18b4834) )
GAMEGEAR_ROM_LOAD( chicgop19, "chicago syndicate (prototype - jun 28, 1995).bin",                    0x000000 , 0x80000,    CRC(5cd07aed) SHA1(5a46ace9f6b24e8403caead2b6ec39e4059e68e6) )
GAMEGEAR_ROM_LOAD( chicgop20, "chicago syndicate (prototype - jun 29, 1995 - b).bin",                0x000000 , 0x80000,    CRC(d3614e4e) SHA1(6fd25c55c8cc6b10f928af6d5de83d61685df940) )
GAMEGEAR_ROM_LOAD( chicgop21, "chicago syndicate (prototype - jun 29, 1995).bin",                    0x000000 , 0x80000,    CRC(e1112763) SHA1(f72c381fabef9286da6a7ede230156277364c5d1) )
GAMEGEAR_ROM_LOAD( chicgop22, "chicago syndicate (prototype - jun 30, 1995 - b).bin",                0x000000 , 0x80000,    CRC(f68a3581) SHA1(5fc82fc2866b7dd99868dfa1a0b619ad688d1221) )
GAMEGEAR_ROM_LOAD( chicgop23, "chicago syndicate (prototype - may 05, 1995).bin",                    0x000000 , 0x80000,    CRC(a5fa4eaf) SHA1(6534e73ea631de8df56779f3ba4c1948b0070400) )
GAMEGEAR_ROM_LOAD( chicago, "chicago syndicate (usa, europe).bin",                                   0x000000 , 0x80000,    CRC(6b0fcec3) SHA1(d7746e4c78aa86bc698fc25a52a791ba27a71add) )
GAMEGEAR_ROM_LOAD( choplif3, "choplifter iii (usa, europe).bin",                                     0x000000 , 0x40000,    CRC(c2e8a692) SHA1(c0152f5b07b6ff47dfedda5258eda1d4e335cdbf) )
GAMEGEAR_ROM_LOAD( chuckrck, "chuck rock (world).bin",                                               0x000000 , 0x40000,    CRC(191b1ed8) SHA1(2b08a3231c0504d86caca74c8508d85c8ef6a86a) )
GAMEGEAR_ROM_LOAD( chukrck2, "chuck rock ii - son of chuck (europe).bin",                            0x000000 , 0x40000,    CRC(656708bf) SHA1(8ee080538e87e0f39720c9254bb4a2d85f637967) )
GAMEGEAR_ROM_LOAD( chukrck2u, "chuck rock ii - son of chuck (usa).bin",                              0x000000 , 0x40000,    CRC(3fcc28c9) SHA1(f6aa6a9a641b3a588a8091cf44e8b0a55ebbd613) )
GAMEGEAR_ROM_LOAD( cliffh, "cliffhanger (usa, europe).bin",                                          0x000000 , 0x40000,    CRC(bf75b153) SHA1(7aaf4f7afc2af8dfbf9cc84c7db48788ab1b2d83) )
GAMEGEAR_ROM_LOAD( clutchit, "clutch hitter (usa).bin",                                              0x000000 , 0x20000,    CRC(d228a467) SHA1(df7af6588652c3163ea6f445fa21ef76b9764cd0) )
GAMEGEAR_ROM_LOAD( cocakid, "coca cola kid (japan).bin",                                             0x000000 , 0x80000,    CRC(c7598b81) SHA1(e0a6caba7d8433175a3b7f1dfb593f9ca2c67cd1) )
GAMEGEAR_ROM_LOAD( columnsj, "columns (japan).bin",                                                  0x000000 , 0x8000,     CRC(f3ca6676) SHA1(8b39ba23132af102b8dc313c5c1c211f4a4f27e1) )
GAMEGEAR_ROM_LOAD( columns, "columns (usa, europe).bin",                                             0x000000 , 0x8000,     CRC(83fa26d9) SHA1(05b73f39a90fd59e01262cbd3f4e7a21575d468a) )
GAMEGEAR_ROM_LOAD( coolspot, "cool spot (usa).bin",                                                  0x000000 , 0x40000,    CRC(2c758fc8) SHA1(c5f39a81c33327dc86b41d6f416efe09b131e14d) )
GAMEGEAR_ROM_LOAD( cosmicsp, "cosmic spacehead (europe).bin",                                        0x000000 , 0x40000,    CRC(6caa625b) SHA1(c24f48ca3fb7df3b50b4353095c7a070653f3539) )
GAMEGEAR_ROM_LOAD( crayon, "crayon shin-chan - taiketsu! kantam panic!! (japan).bin",                0x000000 , 0x80000,    CRC(03d28eab) SHA1(65bcbd89637b8e6837cf36c7f1241eacf85abaa9) )
GAMEGEAR_ROM_LOAD( crystalw, "crystal warriors (usa, europe).bin",                                   0x000000 , 0x40000,    CRC(529c864e) SHA1(6b03183b7183de17ad6fbc9938599d3d18badc1a) )
GAMEGEAR_ROM_LOAD( cutthrot, "cutthroat island (usa, europe).bin",                                   0x000000 , 0x80000,    CRC(6a24e47e) SHA1(95d2012c4027228fda50ef434b53ae5633a7eb8c) )
GAMEGEAR_ROM_LOAD( daffy, "daffy duck in hollywood (europe) (en,fr,de,es,it).bin",                   0x000000 , 0x80000,    CRC(aae268fc) SHA1(2d058f3885bee45b04b74cbe16f3974d4eb2bfcf) )
GAMEGEAR_ROM_LOAD( deepduck, "deep duck trouble starring donald duck (usa, europe).bin",             0x000000 , 0x80000,    CRC(5a136d7e) SHA1(24485549001bc57b5cffee1449ad0af80e862773) )
GAMEGEAR_ROM_LOAD( defoasis, "defenders of oasis (usa, europe).bin",                                 0x000000 , 0x80000,    CRC(e2791cc1) SHA1(07c1167c3b6eea294a73272c256934406f48f9d5) )
GAMEGEAR_ROM_LOAD( desert, "desert speedtrap (europe) (en,fr,de,es,it).bin",                         0x000000 , 0x40000,    CRC(ec808026) SHA1(a253283456010bd73d3bde209566f26b6f8c582f) )
GAMEGEAR_ROM_LOAD( desertu, "desert speedtrap (usa).bin",                                            0x000000 , 0x40000,    CRC(c2e111ac) SHA1(6b88fb212f0556ea57e01a3a1cd5123db5631e28) )
GAMEGEAR_ROM_LOAD( dstrike, "desert strike - return to the gulf (usa, europe).bin",                  0x000000 , 0x80000,    CRC(f6c400da) SHA1(80b91bdf20605d940401738202c473df632d0765) )
GAMEGEAR_ROM_LOAD( devilish, "devilish (europe).bin",                                                0x000000 , 0x20000,    CRC(d43ac6c5) SHA1(3eb7e6cbe74d16bb14c42e91ab6334c156071f6b) )
GAMEGEAR_ROM_LOAD( devilishj, "devilish (japan).bin",                                                0x000000 , 0x20000,    CRC(25db174f) SHA1(5b1d4295920ebe4d6d9b9610764939b2aaa6c598) )
GAMEGEAR_ROM_LOAD( devilishu, "devilish (usa).bin",                                                  0x000000 , 0x20000,    CRC(c01293b0) SHA1(421a416c71dd245d80b362af57d01c80547cf042) )
GAMEGEAR_ROM_LOAD( donald42, "donald duck no 4-tsu no hihou (japan).bin",                            0x000000 , 0x80000,    CRC(4457e7c0) SHA1(d5e278b5c68864da7ddfd1f9cfa5b25e462496b0) )
GAMEGEAR_ROM_LOAD( donaldld, "donald duck no lucky dime (japan).bin",                                0x000000 , 0x40000,    CRC(2d98bd87) SHA1(ee70ac64973775adc2063a8cdff203965f2e7e1d) )
GAMEGEAR_ROM_LOAD( donaldmw, "donald no magical world (japan) (en,ja).bin",                          0x000000 , 0x80000,    CRC(87b8b612) SHA1(5f9afdd5720f88f7cc18715f8e50fc5635b15323) )
GAMEGEAR_ROM_LOAD( doraemon, "doraemon - waku waku pocket paradise (japan).bin",                     0x000000 , 0x80000,    CRC(733292a6) SHA1(495816dbd49560cf02e841b53bd996456078c36b) )
GAMEGEAR_ROM_LOAD( ddragonb, "double dragon (usa, europe) (beta).bin",                               0x000000 , 0x40000,    CRC(331904c0) SHA1(b24aa3e31efbf09e8d0d9ae9d07b4d219b648f96) )
GAMEGEAR_ROM_LOAD( ddragon, "double dragon (usa, europe).bin",                                       0x000000 , 0x40000,    CRC(1307a290) SHA1(baebe28fc7549cbb06c94fcb36a3c40231933c01) )
GAMEGEAR_ROM_LOAD( drrobotn, "dr. robotnik's mean bean machine (usa, europe).bin",                   0x000000 , 0x40000,    CRC(3c2d4f48) SHA1(c36bda8a86994d430506b196922ec1365622e560) )
GAMEGEAR_ROM_LOAD( dragon, "dragon - the bruce lee story (europe).bin",                              0x000000 , 0x40000,    CRC(19e1cf2b) SHA1(f1a90ffdff1003b4dedc61ce688591006a2d40be) )
GAMEGEAR_ROM_LOAD( dragonu, "dragon - the bruce lee story (usa).bin",                                0x000000 , 0x40000,    CRC(17f588e8) SHA1(60c7cbe782c3df094452835076b9425c329c82ee) )
GAMEGEAR_ROM_LOAD( dragoncr, "dragon crystal (usa, europe).bin",                                     0x000000 , 0x20000,    CRC(0ef2ed93) SHA1(6d53f32001d419a5b5e9c16cb62e07e548d2f44a) )
GAMEGEAR_ROM_LOAD( dragoncrj, "dragon crystal - tsurani no meikyuu (japan).bin",                     0x000000 , 0x20000,    CRC(89f12e1e) SHA1(ea323c4ac28d7762277039450c341d0f025093d8) )
GAMEGEAR_ROM_LOAD( dropzone, "dropzone (europe).bin",                                                0x000000 , 0x20000,    CRC(152f0dcc) SHA1(b78bc3fe6bfbc7d6f5e85d59d79be19bf7372bcc) )
GAMEGEAR_ROM_LOAD( dunkkids, "dunk kids (japan).bin",                                                0x000000 , 0x80000,    CRC(77ed48f5) SHA1(7525923ba2531d5079d66b2b1156cb5e7d44c66a) )
GAMEGEAR_ROM_LOAD( dynaheadj, "dynamite headdy (japan).bin",                                         0x000000 , 0x80000,    CRC(f6af4b6b) SHA1(a8e3f447089537b52e40958c07610bfead82442d) )
GAMEGEAR_ROM_LOAD( dynaheadp1, "dynamite headdy (prototype - jul 01, 1994).bin",                     0x000000 , 0x80000,    CRC(49389319) SHA1(0e408b4c9dfbb94bdf556b7aa920d4ac71d88c56) )
GAMEGEAR_ROM_LOAD( dynaheadp2, "dynamite headdy (prototype - jul 05, 1994).bin",                     0x000000 , 0x80000,    CRC(c7bea89a) SHA1(59807e03d32837db34e2912d0e85db812edf823c) )
GAMEGEAR_ROM_LOAD( dynaheadp3, "dynamite headdy (prototype - jun 15, 1994).bin",                     0x000000 , 0x80000,    CRC(7bf339c0) SHA1(0e8bccb304898a80efcbae8351303103ec4145ee) )
GAMEGEAR_ROM_LOAD( dynahead, "dynamite headdy (usa, europe).bin",                                    0x000000 , 0x80000,    CRC(610ff95c) SHA1(a8c8b5252a885d466e044e6055336513d988e661) )
GAMEGEAR_ROM_LOAD( ejim, "earthworm jim (usa).bin",                                                  0x000000 , 0x80000,    CRC(5d3f23a9) SHA1(dbb149da0b0373f23750ed954dbb5e08bc634615) )
GAMEGEAR_ROM_LOAD( ecco2, "ecco ii - the tides of time (usa, europe).bin",                           0x000000 , 0x80000,    CRC(e2f3b203) SHA1(61913f6803977bb54fda7c3d969dc2c0f7c6da62) )
GAMEGEAR_ROM_LOAD( eccoj, "ecco the dolphin (japan).bin",                                            0x000000 , 0x80000,    CRC(a32eb9d5) SHA1(5f0de698e8e0d4323b36bd78e2bd1af1c3370f3e) )
GAMEGEAR_ROM_LOAD( ecco, "ecco the dolphin (usa, europe).bin",                                       0x000000 , 0x80000,    CRC(866c7113) SHA1(7c6c8f44d5aa799726adc3a9e21c9f35cacea87f) )
GAMEGEAR_ROM_LOAD( ecco2j, "ecco the dolphin ii (japan).bin",                                        0x000000 , 0x80000,    CRC(ba9cef4f) SHA1(36095f4c92f6f66ed6bc20d9b96227d6fb0dae5b) )
GAMEGEAR_ROM_LOAD( ernieeg, "ernie els golf (europe) (en,fr,de,es,it).bin",                          0x000000 , 0x40000,    CRC(5e53c7f7) SHA1(a8d75c2af514dc81ba4dc66a508384d730a77ce4) )
GAMEGEAR_ROM_LOAD( eternall, "eternal legend - eien no densetsu (japan).bin",                        0x000000 , 0x40000,    CRC(04302bbd) SHA1(717b4e33cf3956e4194b912533bf1b7bf9d20725) )
GAMEGEAR_ROM_LOAD( evander, "evander holyfield boxing (usa, europe).bin",                            0x000000 , 0x40000,    CRC(36aaf536) SHA1(3093d6e6e332c864da8473ac2eab7d17eb65b523) )
GAMEGEAR_ROM_LOAD( excdizzy, "excellent dizzy collection, the (europe).bin",                         0x000000 , 0x80000,    CRC(aa140c9c) SHA1(db3c0686715373242911f8471a1e91673811d62a) )
GAMEGEAR_ROM_LOAD( excdizzyp, "excellent dizzy collection, the (prototype) [s][!].bin",              0x000000 , 0x40000,    CRC(8813514b) SHA1(09a2acf3ed90101be2629384c5c702f6a5408035) )
GAMEGEAR_ROM_LOAD( f15strik, "f-15 strike eagle (usa, europe).bin",                                  0x000000 , 0x40000,    CRC(8bdb0806) SHA1(4bfdafa848223598ca16699ad44fe4a19a1c2ba2) )
GAMEGEAR_ROM_LOAD( f1, "f1 (usa, europe).bin",                                                       0x000000 , 0x40000,    CRC(d0a93e00) SHA1(b5a1985d671e8b9e0eed7922e6db695011071e99) )
GAMEGEAR_ROM_LOAD( faceball, "faceball 2000 (japan).bin",                                            0x000000 , 0x40000,    CRC(aaf6f87d) SHA1(967c50a5b64adc6da7bc730900c267e45c90053a) )
GAMEGEAR_ROM_LOAD( factoryp, "factory panic (europe).bin",                                           0x000000 , 0x20000,    CRC(59e3be92) SHA1(94beb8b6334bb9dc104ffdb0ad2bdd4964ed91a5) )
GAMEGEAR_ROM_LOAD( fantdizz, "fantastic dizzy (europe) (en,fr,de,es,it).bin",                        0x000000 , 0x40000,    CRC(c888222b) SHA1(b6a13d51c72b576738f0d7e8e328db2ffeb0b38c) )
GAMEGEAR_ROM_LOAD( fantzone, "fantasy zone gear (japan, europe).bin",                                0x000000 , 0x20000,    CRC(d69097e8) SHA1(5951d500d6f53b0537f045adb85d94068a838f32) )
GAMEGEAR_ROM_LOAD( fantzone1, "fantasy zone gear (ju) [a1].bin",                                     0x000000 , 0x20000,    CRC(365b92cf) SHA1(002de139e9e330f2811cf56401b9e3cc7f233b91) )
GAMEGEAR_ROM_LOAD( fatalfur, "fatal fury special (usa).bin",                                         0x000000 , 0x80000,    CRC(449787e2) SHA1(7ce20ca34b7bc91ba7e73f830b40830ad6bafbc8) )
GAMEGEAR_ROM_LOAD( fifaj, "fifa international soccer (japan).bin",                                   0x000000 , 0x80000,    CRC(78159325) SHA1(70385b99320f91fef54ea88123761af9d7ff54c5) )
GAMEGEAR_ROM_LOAD( fifa, "fifa international soccer (usa, europe).bin",                              0x000000 , 0x80000,    CRC(e632a3a2) SHA1(0725626fc9988b690fc1fc77b294d31b78cbfb5a) )
GAMEGEAR_ROM_LOAD( fifa96, "fifa soccer 96 (usa, europe) (en,fr,de,es).bin",                         0x000000 , 0x80000,    CRC(c379de95) SHA1(f928c32acba90ed5ebca131af03e76a0efb38797) )
GAMEGEAR_ROM_LOAD( foreman, "foreman for real (world).bin",                                          0x000000 , 0x80000,    CRC(d46d5685) SHA1(d7109dc1db52bb4828a01b433a4b2993ac2e59e1) )
GAMEGEAR_ROM_LOAD( frankt, "frank thomas big hurt baseball (usa).bin",                               0x000000 , 0x80000,    CRC(c443c35c) SHA1(aab42351d96e32d46631c540bdfa43a621ab0e76) )
GAMEGEAR_ROM_LOAD( fray, "fray - shugyou hen (japan).bin",                                           0x000000 , 0x40000,    CRC(e123d9b8) SHA1(0dc770773f651718881ce17a87f145e2f0b02fb1) )
GAMEGEAR_ROM_LOAD( fredcoupj, "fred couples' golf (japan).bin",                                      0x000000 , 0x80000,    CRC(b1196cd7) SHA1(fb7b3c6652c3105497b8254daf063d25519fea61) )
GAMEGEAR_ROM_LOAD( fredcoup, "fred couples' golf (usa).bin",                                         0x000000 , 0x80000,    CRC(46f40b9f) SHA1(fc160122f14772fd1c4476effae5a4010a6c012d) )
GAMEGEAR_ROM_LOAD( frogger, "frogger (usa) (proto).bin",                                             0x000000 , 0x20000,    CRC(02bbf994) SHA1(b917ac6fbd3e5d18c07246f1309d81943ee1dd47) )
GAMEGEAR_ROM_LOAD( slamdunk, "from tv animation - slam dunk - shouri e no starting 5 (japan).bin",   0x000000 , 0x80000,    CRC(751dad4c) SHA1(bee62a373655d0ef931d8b9a4ed88fb0f4d1a8bc) )
GAMEGEAR_ROM_LOAD( glocairj, "g-loc air battle (japan) (v1.1).bin",                                  0x000000 , 0x20000,    CRC(33237f50) SHA1(033c65e52011fd6b9be86ecb0f5d8209dbbdbbca) )
GAMEGEAR_ROM_LOAD( glocairj1, "g-loc air battle (japan).bin",                                        0x000000 , 0x20000,    CRC(2333f615) SHA1(ed32016476e40fde06d8a1a9777875b75d49adf6) )
GAMEGEAR_ROM_LOAD( glocair, "g-loc air battle (usa, europe).bin",                                    0x000000 , 0x20000,    CRC(18de59ed) SHA1(407da6e4d0916d3f54ad1ba8d45face04dad5657) )
GAMEGEAR_ROM_LOAD( galaga91, "galaga '91 (japan).bin",                                               0x000000 , 0x20000,    CRC(0593ba24) SHA1(7cd59fc473b9b1a1fdd659fdec2ae6cb1d3f471a) )
GAMEGEAR_ROM_LOAD( galaga2, "galaga 2 (europe).bin",                                                 0x000000 , 0x20000,    CRC(95ecece2) SHA1(33b552eb21ef4bf5cf10ab18afa9f2fbcd6635cd) )
GAMEGEAR_ROM_LOAD( gamble, "gamble panic (japan).bin",                                               0x000000 , 0x80000,    CRC(09534742) SHA1(d33cd19676fdb0e6180a24ed406a61cdf30f0065) )
GAMEGEAR_ROM_LOAD( gambler, "gambler jikochuushinha (japan).bin",                                    0x000000 , 0x40000,    CRC(423803a7) SHA1(ec26aa5f41f8abf1c0fa911c2031ac422f6280a6) )
GAMEGEAR_ROM_LOAD( ganbare, "ganbare gorby! (japan).bin",                                            0x000000 , 0x20000,    CRC(a1f2f4a1) SHA1(cd3e8910a99bf6717e63aed3aa212ead0597e5cd) )
GAMEGEAR_ROM_LOAD( garfield, "garfield - caught in the act (usa, europe).bin",                       0x000000 , 0x100000,   CRC(cd53f3af) SHA1(dc65f458cad3c165d0963b9b6da258d438da2ef7) )
GAMEGEAR_ROM_LOAD( garou, "garou densetsu special (japan).bin",                                      0x000000 , 0x80000,    CRC(9afb6f33) SHA1(ec2f11e28bff47d149df1987673f80da08c1af6d) )
GAMEGEAR_ROM_LOAD( gearstad, "gear stadium (japan).bin",                                             0x000000 , 0x20000,    CRC(0e300223) SHA1(10124c1ca517fa933ca0488f288d205b0cc80d9c) )
GAMEGEAR_ROM_LOAD( gearstah, "gear stadium heiseiban (japan).bin",                                   0x000000 , 0x20000,    CRC(a0530664) SHA1(210fef406c4fe8e0ed995f92ea7597e8f1b7f91c) )
GAMEGEAR_ROM_LOAD( gearwork, "gear works (usa).bin",                                                 0x000000 , 0x20000,    CRC(e9a2efb4) SHA1(dc71c749c4a78e28922e10df645d23cc8289531f) )
GAMEGEAR_ROM_LOAD( georgef, "george foreman's ko boxing (usa, europe).bin",                          0x000000 , 0x20000,    CRC(58b44585) SHA1(5b3e3e3b88079108a4379c2428e70007d62c7b51) )
GAMEGEAR_ROM_LOAD( ggaleste, "gg aleste (japan).bin",                                                0x000000 , 0x40000,    CRC(1b80a75b) SHA1(4c13dc3601a1702692c35eb6c89f0e09ab966f69) )
GAMEGEAR_ROM_LOAD( ggdora, "gg doraemon - noranosuke no yabou (japan).bin",                          0x000000 , 0x40000,    CRC(9a8b2c16) SHA1(6976b170879767889994b1e763a52726aa62ed98) )
GAMEGEAR_ROM_LOAD( ggport, "gg portrait - pai chen (japan).bin",                                     0x000000 , 0x80000,    CRC(695cc120) SHA1(cf752897523814951401994c95de299cd42fdb50) )
GAMEGEAR_ROM_LOAD( ggport1, "gg portrait - yuuki akira (japan).bin",                                 0x000000 , 0x80000,    CRC(51159f8f) SHA1(4cbb453663665a06e986a6ab015a041463b48373) )
GAMEGEAR_ROM_LOAD( ggshinob, "gg shinobi, the (japan).bin",                                          0x000000 , 0x40000,    CRC(83926bd1) SHA1(c5e1c2329f94f0804140792a3e3d5be2ac0d5d0d) )
GAMEGEAR_ROM_LOAD( godzilla, "godzilla - kaijuu daishingeki (japan).bin",                            0x000000 , 0x80000,    CRC(4cf97801) SHA1(ff3e8905635a02eb85556146225020b52506424c) )
GAMEGEAR_ROM_LOAD( gpriderj, "gp rider (japan).bin",                                                 0x000000 , 0x80000,    CRC(7a26ec6a) SHA1(b1c4315dc4afe58256f3834cff8e94c6b02bc1b6) )
GAMEGEAR_ROM_LOAD( gpriderp, "gp rider (prototype - jan 04, 1994).bin",                              0x000000 , 0x80000,    CRC(12e4f6db) SHA1(5e13822bf04facc19d44a718635647ad4db6cd2a) )
GAMEGEAR_ROM_LOAD( gprider, "gp rider (usa, europe).bin",                                            0x000000 , 0x80000,    CRC(876e9b72) SHA1(7777f091c8b540d3248fd7c0fb21e742af6f0ede) )
GAMEGEAR_ROM_LOAD( greendog, "greendog (usa, europe).bin",                                           0x000000 , 0x40000,    CRC(f27925b0) SHA1(b5bf962000636bb1cbdf134759baa1e25b25d097) )
GAMEGEAR_ROM_LOAD( griffin, "griffin (japan).bin",                                                   0x000000 , 0x20000,    CRC(a93e8b0f) SHA1(b479d977533398cef21ef9ff7cd8fc81bdbfa488) )
GAMEGEAR_ROM_LOAD( gunstar, "gunstar heroes (japan).bin",                                            0x000000 , 0x80000,    CRC(c3c52767) SHA1(c373d3876659095bb869ff0e4bb7ffc68123cf3e) )
GAMEGEAR_ROM_LOAD( halleywj, "halley wars (japan).bin",                                              0x000000 , 0x20000,    CRC(def5a5d0) SHA1(1c9932f592bb12e61acf597985e0bd5041e45da5) )
GAMEGEAR_ROM_LOAD( halleyw, "halley wars (usa, europe).bin",                                         0x000000 , 0x20000,    CRC(7e9dea46) SHA1(77637e9916a774529d971370c1509eec0b7e1651) )
GAMEGEAR_ROM_LOAD( headbust, "head buster (japan).bin",                                              0x000000 , 0x20000,    CRC(7e689995) SHA1(51432c7892d87b31f5f3216d3ef01eadc591b768) )
GAMEGEAR_ROM_LOAD( heavywc, "heavy weight champ (japan).bin",                                        0x000000 , 0x20000,    CRC(beed9150) SHA1(7cfd703ebdab4b2665f402adeac0060740615b6c) )
GAMEGEAR_ROM_LOAD( homea, "home alone (usa, europe).bin",                                            0x000000 , 0x40000,    CRC(dde29f74) SHA1(abad566f587affcb35102ed5b45c4e3a8ee22dc9) )
GAMEGEAR_ROM_LOAD( honoo, "honoo no toukyuuji - dodge danpei (japan).bin",                           0x000000 , 0x20000,    CRC(dfa805a0) SHA1(66032cc214d728b2f1c59ad2934277e378b36865) )
GAMEGEAR_ROM_LOAD( hook, "hook (usa, europe).bin",                                                   0x000000 , 0x40000,    CRC(f53ced2e) SHA1(b9bd292fa4f3ef7dd86ebae9e1b5364ce6653c45) )
GAMEGEAR_ROM_LOAD( hurric, "hurricanes (europe).bin",                                                0x000000 , 0x80000,    CRC(0a25eec5) SHA1(d4f0a691f11de7d91ede6ff95d26343a50840eb1) )
GAMEGEAR_ROM_LOAD( hyokkori, "hyokkori hyoutan jima - hyoutan jima no daikoukai (japan).bin",        0x000000 , 0x20000,    CRC(42389270) SHA1(0b0270060342f4e79d58104a85a7be04426683bd) )
GAMEGEAR_ROM_LOAD( hypery92, "hyper pro yakyuu '92 (japan).bin",                                     0x000000 , 0x20000,    CRC(056cae74) SHA1(245699bff66440b1e4483e8d68e468bbc3ba6ab3) )
GAMEGEAR_ROM_LOAD( ichirgg, "ichidant~r gg (japan).bin",                                             0x000000 , 0x80000,    CRC(9f64c2bb) SHA1(34f95713ae3fbd91452eb71ce1721ead153517e5) )
GAMEGEAR_ROM_LOAD( wakevamp, "in the wake of vampire (japan).bin",                                   0x000000 , 0x40000,    CRC(dab0f265) SHA1(da5116b7ed890f35506c5b33c5c9716f528169b1) )
GAMEGEAR_ROM_LOAD( incred, "incredible crash dummies, the (usa, europe).bin",                        0x000000 , 0x40000,    CRC(087fc247) SHA1(6858554fc26f2382a262736854496e11f0925d40) )
GAMEGEAR_ROM_LOAD( incrhulk, "incredible hulk, the (usa, europe).bin",                               0x000000 , 0x80000,    CRC(d7055f88) SHA1(0410dafce21e5f40263ccb39871188ca84f7dd22) )
GAMEGEAR_ROM_LOAD( indycrus1, "indiana jones and the last crusade (u).bin",                          0x000000 , 0x40000,    CRC(8c048325) SHA1(a171c8f9ded70023588a3736f8b031d45b6c32de) )
GAMEGEAR_ROM_LOAD( indycrus, "indiana jones and the last crusade (usa, europe).bin",                 0x000000 , 0x40000,    CRC(b875226b) SHA1(2607f99263c8dd732d199b2357400638e08402ec) )
GAMEGEAR_ROM_LOAD( ironman1, "iron man x-o manowar in heavy metal (u) [a1].bin",                     0x000000 , 0x80000,    CRC(847ae5ce) SHA1(609edf453719c82b044e5f6d89152241b637de77) )
GAMEGEAR_ROM_LOAD( ironman, "iron man x-o manowar in heavy metal (usa, europe).bin",                 0x000000 , 0x80000,    CRC(8927b69b) SHA1(3da4166c88ee24ab86a18554ae7c5ee7bce42f11) )
GAMEGEAR_ROM_LOAD( itchy, "itchy & scratchy game, the (usa, europe).bin",                            0x000000 , 0x40000,    CRC(44e7e2da) SHA1(2d0c2be09b977cc68a7e8f0fc415d8783ad7f8ae) )
GAMEGEAR_ROM_LOAD( jleagu94, "j.league gg pro striker '94 (japan).bin",                              0x000000 , 0x80000,    CRC(a12a28a0) SHA1(04248e53ce54c9f17daae9885fed87d39f0117b6) )
GAMEGEAR_ROM_LOAD( jleague, "j.league soccer - dream eleven (japan).bin",                            0x000000 , 0x80000,    CRC(abddf0eb) SHA1(bed727b732712f115ddc4dc5fd873e6cd3787b62) )
GAMEGEAR_ROM_LOAD( jb007, "james bond 007 - the duel (europe).bin",                                  0x000000 , 0x40000,    CRC(881a4524) SHA1(6e2124b40db7d1fc22b4f1e41565710500611d8e) )
GAMEGEAR_ROM_LOAD( jpond3, "james pond 3 - operation starfi5h (europe).bin",                         0x000000 , 0x80000,    CRC(68bb7f71) SHA1(53790edee813a0a444b0369fd15672bb2a343780) )
GAMEGEAR_ROM_LOAD( robocod, "james pond ii - codename robocod (usa).bin",                            0x000000 , 0x80000,    CRC(9fb5c155) SHA1(6c4a9c1613bc436033b54914acaf951c62593972) )
GAMEGEAR_ROM_LOAD( jangpun2, "jang pung ii (k) [s].bin",                                             0x000000 , 0x40000,    CRC(76c5bdfb) SHA1(2b3bb8fd76fe706d7e564b372d2d71dfce53cb1b) )
GAMEGEAR_ROM_LOAD( jeopardy, "jeopardy! (usa).bin",                                                  0x000000 , 0x40000,    CRC(d7820c21) SHA1(28ef5cc2689a1f3bc3bd1b24c3e4132a423fc274) )
GAMEGEAR_ROM_LOAD( jeopards, "jeopardy! - sports edition (usa, europe).bin",                         0x000000 , 0x40000,    CRC(2dd850b7) SHA1(55cb5cb3c37e8403ebf4a47560f0ece416323c56) )
GAMEGEAR_ROM_LOAD( joemontj, "joe montana's football (japan).bin",                                   0x000000 , 0x40000,    CRC(4a98678b) SHA1(253196b98d83b910c289b0211b6de025c66c916c) )
GAMEGEAR_ROM_LOAD( joemont, "joe montana's football (usa, europe).bin",                              0x000000 , 0x40000,    CRC(2e01ba6c) SHA1(24c3b2cd18967b7141850d4f63b4992c3dad3ad4) )
GAMEGEAR_ROM_LOAD( striderr, "journey from darkness - strider returns (usa, europe).bin",            0x000000 , 0x40000,    CRC(1ebfa5ca) SHA1(ed5d1fc5ba8a47992551b0d577c1a6a06d0f7ac2) )
GAMEGEAR_ROM_LOAD( judged, "judge dredd (usa, europe).bin",                                          0x000000 , 0x80000,    CRC(04d23fc4) SHA1(4c9d00faeb4454a8f538b5ccc6453b3464930afa) )
GAMEGEAR_ROM_LOAD( junction, "junction (usa, europe).bin",                                           0x000000 , 0x20000,    CRC(a8ef36a7) SHA1(70cac7959d29903ad22316e9f5edf60834381d27) )
GAMEGEAR_ROM_LOAD( jungle, "jungle book, the (europe).bin",                                          0x000000 , 0x40000,    CRC(90100884) SHA1(14a5d4ea99ee91aec948d62cab56fc1c05cc7c45) )
GAMEGEAR_ROM_LOAD( jungleu, "jungle book, the (usa).bin",                                            0x000000 , 0x40000,    CRC(30c09f31) SHA1(f9da97db661f8ef7e7af87a83d23100c2fed4fb0) )
GAMEGEAR_ROM_LOAD( jurassicj, "jurassic park (japan).bin",                                           0x000000 , 0x80000,    CRC(2f536ae3) SHA1(89486678a6a065c56102296eebc7b25c5ef32d21) )
GAMEGEAR_ROM_LOAD( jurassic, "jurassic park (usa, europe).bin",                                      0x000000 , 0x80000,    CRC(bd6f2321) SHA1(0425dc09465a4b7be78ab7aa46107987ba61e82a) )
GAMEGEAR_ROM_LOAD( kaitou, "kaitou saint tale (japan).bin",                                          0x000000 , 0x80000,    CRC(937fd52b) SHA1(3e4e7ec4a4ce5d48baed7d583ede8bb9f92a44a6) )
GAMEGEAR_ROM_LOAD( kawasaki, "kawasaki superbike challenge (usa, europe).bin",                       0x000000 , 0x40000,    CRC(23f9150a) SHA1(7b0801c4ad6c15546f61decf2620f198b990425d) )
GAMEGEAR_ROM_LOAD( kenyuu, "kenyuu densetsu yaiba (japan).bin",                                      0x000000 , 0x80000,    CRC(d9ce3f4c) SHA1(21b08c5c4b086e169d5f780cafc22c041e19807b) )
GAMEGEAR_ROM_LOAD( kickrush, "kick & rush (japan).bin",                                              0x000000 , 0x40000,    CRC(fd14ce00) SHA1(d1c04a94a21684be2e83fbd0e0677bbc8ef86f57) )
GAMEGEAR_ROM_LOAD( kineticc, "kinetic connection (japan).bin",                                       0x000000 , 0x20000,    CRC(4af7f2aa) SHA1(7447e0ad5e8e14c3ae05a274d393ca34de044855) )
GAMEGEAR_ROM_LOAD( kishin, "kishin douji zenki (japan).bin",                                         0x000000 , 0x80000,    CRC(7d622bdd) SHA1(0fb3530633070551f3d5a04839fc42babc092fbd) )
GAMEGEAR_ROM_LOAD( klax, "klax (usa, europe).bin",                                                   0x000000 , 0x20000,    CRC(9b40fc8e) SHA1(4705bbc862169cdfeb3b30dba6f274b094ab99b3) )
GAMEGEAR_ROM_LOAD( krusty, "krusty's fun house (usa, europe).bin",                                   0x000000 , 0x40000,    CRC(d01e784f) SHA1(a24fd153669e0c38d55ff939e1ea52b6a316ad0d) )
GAMEGEAR_ROM_LOAD( kunichan, "kuni-chan no game tengoku (japan).bin",                                0x000000 , 0x40000,    CRC(398f2358) SHA1(497f137e0f33b45a1560f51ca06b2bfaef51484a) )
GAMEGEAR_ROM_LOAD( kunichn2, "kuni-chan no game tengoku part 2 (japan).bin",                         0x000000 , 0x40000,    CRC(f3774c65) SHA1(f11af70a52cfd96ad4d03da8ca9227ddd5bcc382) )
GAMEGEAR_ROM_LOAD( landill, "land of illusion starring mickey mouse (usa, europe).bin",              0x000000 , 0x80000,    CRC(52dbf3e1) SHA1(5975bf7d01c84b9433c2859e6d38d26545fd3bc9) )
GAMEGEAR_ROM_LOAD( lastact, "last action hero (usa).bin",                                            0x000000 , 0x40000,    CRC(2d367c43) SHA1(340e0e8ab5b4e89f6d56bc30cabf8322e79b2347) )
GAMEGEAR_ROM_LOAD( legndillp, "legend of illusion starring mickey mouse (prototype - oct 11, 1994).bin",0x000000 , 0x80000,    CRC(f9d4cee9) SHA1(13c6f75a1360a76673bcebdf18b9735ddaa113c7) )
GAMEGEAR_ROM_LOAD( legndillp1, "legend of illusion starring mickey mouse (prototype - oct 14, 1994).bin",0x000000 , 0x80000,    CRC(670ede92) SHA1(98c4adaf6e74d960760f686f256f63bc887c1a2b) )
GAMEGEAR_ROM_LOAD( legndillp2, "legend of illusion starring mickey mouse (prototype - oct 17, 1994).bin",0x000000 , 0x80000,    CRC(de8545af) SHA1(ccbcda1e7d74e0bfe94ecb1214d4ca1a5d1504ab) )
GAMEGEAR_ROM_LOAD( legndillp3, "legend of illusion starring mickey mouse (prototype - sep 22, 1994).bin",0x000000 , 0x80000,    CRC(1cc16ad9) SHA1(2d78a5b6449c9d20cd03156a56cbc6bc10c2ef68) )
GAMEGEAR_ROM_LOAD( legndillp4, "legend of illusion starring mickey mouse (prototype - sep 30, 1994 - sel).bin",0x000000 , 0x80000,    CRC(a0565a5c) SHA1(14f266482bfd25238c6e44087c26aca329d4fa64) )
GAMEGEAR_ROM_LOAD( legndillp5, "legend of illusion starring mickey mouse (prototype - sep 30, 1994).bin",0x000000 , 0x80000,    CRC(63020617) SHA1(94ec7c72e2fb6e4bd51ef55eac9646fb2fa8d791) )
GAMEGEAR_ROM_LOAD( legndill, "legend of illusion starring mickey mouse (usa, europe).bin",           0x000000 , 0x80000,    CRC(ce5ad8b7) SHA1(fa1200fd34a81796222eae97175c2fb72a77e970) )
GAMEGEAR_ROM_LOAD( lemmingsb, "lemmings (world) (beta).bin",                                         0x000000 , 0x40000,    CRC(51548f61) SHA1(31b9926efff652151c8390529fc2c8a211aafb0b) )
GAMEGEAR_ROM_LOAD( lemmings, "lemmings (world).bin",                                                 0x000000 , 0x40000,    CRC(0fde7baa) SHA1(5a79b6fa15b7085fc7062945f0e6d469d49871e1) )
GAMEGEAR_ROM_LOAD( lionkingt, "lion king, the (e) [t1].bin",                                         0x000000 , 0x80000,    CRC(040512ce) SHA1(64d02b7791865d295474b3661c5b6bc10d64e979) )
GAMEGEAR_ROM_LOAD( lionking, "lion king, the (europe).bin",                                          0x000000 , 0x80000,    CRC(0cd9c20b) SHA1(49f00887a297f70a51711fe18433bc168ec49fc9) )
GAMEGEAR_ROM_LOAD( lionkingp, "lion king, the (prototype - aug 03, 1994).bin",                       0x000000 , 0x7d909,    CRC(aacb7387) SHA1(6d71ff5dfd04ec1641b0db367b52ae3f23805e60) )
GAMEGEAR_ROM_LOAD( lionkingp1, "lion king, the (prototype - aug 11, 1994).bin",                      0x000000 , 0x7d992,    CRC(214c13dc) SHA1(9d8fdc7b48f2c09bcbbb30061941e46ddf986e4e) )
GAMEGEAR_ROM_LOAD( lionkingp2, "lion king, the (prototype - aug 12, 1994).bin",                      0x000000 , 0x7d9ae,    CRC(0e80efe0) SHA1(0e5f5156be26d18f8c2678f7d2400a54b9c51f37) )
GAMEGEAR_ROM_LOAD( lionkingp3, "lion king, the (prototype - aug 13, 1994).bin",                      0x000000 , 0x7d9b2,    CRC(8250c11e) SHA1(05d6e8f6b8adde3a03ea89f53dd02f02f3366477) )
GAMEGEAR_ROM_LOAD( lionkingp4, "lion king, the (prototype - aug 14, 1994).bin",                      0x000000 , 0x7d9b6,    CRC(eb10a2d4) SHA1(cdce953f16e4db6e9137ea8d523588b3469a544d) )
GAMEGEAR_ROM_LOAD( lionkingp5, "lion king, the (prototype - aug 15, 1994).bin",                      0x000000 , 0x7d9b6,    CRC(eb10a2d4) SHA1(cdce953f16e4db6e9137ea8d523588b3469a544d) )
GAMEGEAR_ROM_LOAD( lionkingp6, "lion king, the (prototype - aug 16, 1994).bin",                      0x000000 , 0x7d9b6,    CRC(c6af9643) SHA1(14c4d13eb118dc5082441f4eddaac229019b2598) )
GAMEGEAR_ROM_LOAD( lionkingp7, "lion king, the (prototype - aug 17, 1994 - 2).bin",                  0x000000 , 0x7da3a,    CRC(b65030d0) SHA1(d3d44f8cbe32970f2e138c183078b8190808e625) )
GAMEGEAR_ROM_LOAD( lionkingp8, "lion king, the (prototype - aug 17, 1994).bin",                      0x000000 , 0x7d9ea,    CRC(4214c474) SHA1(6301d8ede680007e645c84d24064df5e76ea996b) )
GAMEGEAR_ROM_LOAD( lionkingp9, "lion king, the (prototype - aug 20, 1994).bin",                      0x000000 , 0x7fe56,    CRC(3d0b31a2) SHA1(79f221ca2654d5df64392e4e06c498557eaebf19) )
GAMEGEAR_ROM_LOAD( lionkingut, "lion king, the (u) [t1].bin",                                        0x000000 , 0x80000,    CRC(90d40776) SHA1(151dc547dc42c214052b3ee8b2f686b73a17d200) )
GAMEGEAR_ROM_LOAD( lionkingu, "lion king, the (usa).bin",                                            0x000000 , 0x80000,    CRC(9808d7b3) SHA1(e21025b2f6d5bbc18107905ad6c0c58d061d9c17) )
GAMEGEAR_ROM_LOAD( lostwrld, "lost world, the - jurassic park (usa).bin",                            0x000000 , 0x100000,   CRC(8d1597f5) SHA1(1730b85fac5478da92b0905c6525e715bb4470d4) )
GAMEGEAR_ROM_LOAD( luckydim, "lucky dime caper, the (usa, europe).bin",                              0x000000 , 0x40000,    CRC(07a7815a) SHA1(5cc5caa887a63c580c1e3ff344a4b0ade643f24b) )
GAMEGEAR_ROM_LOAD( lunar, "lunar - sanposuru gakuen (japan).bin",                                    0x000000 , 0x80000,    CRC(58459edd) SHA1(1b0cc847d31956d843cadab7d86a2f434220301e) )
GAMEGEAR_ROM_LOAD( madden95, "madden nfl '95 (usa).bin",                                             0x000000 , 0x80000,    CRC(75c71ebf) SHA1(69d900be52502a4630ebcf9073175d8af45b655d) )
GAMEGEAR_ROM_LOAD( madden96, "madden nfl '96 (u) [!].bin",                                           0x000000 , 0x80000,    CRC(75e273eb) SHA1(73fb57977b2e1aa96003b4c15a38885ccd3f51a1) )
GAMEGEAR_ROM_LOAD( madden96a, "madden nfl '96 (usa, europe).bin",                                    0x000000 , 0x80000,    CRC(9f59d302) SHA1(49412ebef31558afd8cb534c6914f5612eaa25b1) )
GAMEGEAR_ROM_LOAD( madoumna, "madou monogatari a - dokidoki vacation (japan).bin",                   0x000000 , 0x80000,    CRC(7ec95282) SHA1(c027aa76fe0e09a2d1b982eea0df2c8b687aadf7) )
GAMEGEAR_ROM_LOAD( madoumon, "madou monogatari i - 3-tsu no madoukyuu (japan).bin",                  0x000000 , 0x80000,    CRC(00c34d94) SHA1(5ccd474cefcb8e086e2e1f77c0fdd5c1d2bf82e7) )
GAMEGEAR_ROM_LOAD( madoumn2, "madou monogatari ii - arle 16-sai (japan).bin",                        0x000000 , 0x80000,    CRC(12eb2287) SHA1(deead79fa4cb2e87652a9c8a76f2a7174f48f37a) )
GAMEGEAR_ROM_LOAD( madoumn3, "madou monogatari iii - kyuukyoku joou-sama (japan) (v1.1).bin",        0x000000 , 0x80000,    CRC(568f4825) SHA1(673670f954176ffab28a0280aa49856a457f36b1) )
GAMEGEAR_ROM_LOAD( madoumn3a, "madou monogatari iii - kyuukyoku joou-sama (japan).bin",              0x000000 , 0x80000,    CRC(0a634d79) SHA1(dd590c9086161b1f97573c48720c32cc5506dabc) )
GAMEGEAR_ROM_LOAD( magicray, "magic knight rayearth (japan).bin",                                    0x000000 , 0x80000,    CRC(8f82a6b9) SHA1(6c13e3b9bb24eafc1186c5ffa322b1f40c676b3d) )
GAMEGEAR_ROM_LOAD( magicry2, "magic knight rayearth 2 - making of magic knight (japan).bin",         0x000000 , 0x80000,    CRC(1c2c2b04) SHA1(29615d86057f3323ecda75d47102e77d364f6499) )
GAMEGEAR_ROM_LOAD( magiclpp, "magical puzzle popils (world) (en,ja).bin",                            0x000000 , 0x20000,    CRC(cf6d7bc5) SHA1(fb939f0810d0763b9abaeec1a2bfbabacaad5441) )
GAMEGEAR_ROM_LOAD( magical, "magical taruruuto-kun (japan).bin",                                     0x000000 , 0x20000,    CRC(6e1cc23c) SHA1(40fae12f1d565849158ff87700e25d6967038867) )
GAMEGEAR_ROM_LOAD( majors, "majors pro baseball, the (usa).bin",                                     0x000000 , 0x40000,    CRC(36ebcd6d) SHA1(76f3c504d717067134a88f7f1d0ef38bd6698e50) )
GAMEGEAR_ROM_LOAD( mappy, "mappy (japan).bin",                                                       0x000000 , 0x20000,    CRC(01d2dd2a) SHA1(44d0b857d88a293da47dc161115422d830d81302) )
GAMEGEAR_ROM_LOAD( marble, "marble madness (usa, europe).bin",                                       0x000000 , 0x40000,    CRC(9559e339) SHA1(42c5cd5afebbf860a8ad80ea684f9b216762109e) )
GAMEGEAR_ROM_LOAD( marko, "marko's magic football (europe) (en,fr,de,es).bin",                       0x000000 , 0x80000,    CRC(22c418bf) SHA1(f255d7ea194d88a1588a2bf3ff34926de17c7ff1) )
GAMEGEAR_ROM_LOAD( megaman, "mega man (usa, europe).bin",                                            0x000000 , 0x80000,    CRC(1ace93af) SHA1(085517c4ac940b937d0e0a900e4735a2247ca4dd) )
GAMEGEAR_ROM_LOAD( lastbibl, "megami tensei gaiden - last bible (japan).bin",                        0x000000 , 0x80000,    CRC(2e4ec17b) SHA1(d98332eba27fd4a0db82d551a54bee4fdccf41a2) )
GAMEGEAR_ROM_LOAD( lastbibs, "megami tensei gaiden - last bible s (japan).bin",                      0x000000 , 0x80000,    CRC(4ec30806) SHA1(ca597064a8f0dd8221e89655584ec0cc67dbe026) )
GAMEGEAR_ROM_LOAD( mickmack, "mick & mack as the global gladiators (usa, europe).bin",               0x000000 , 0x40000,    CRC(d2b6021e) SHA1(ddad863406d429acb218c75042d5e5c511bdad4f) )
GAMEGEAR_ROM_LOAD( legndillj, "mickey mouse densetsu no oukoku - legend of illusion (japan).bin",    0x000000 , 0x80000,    CRC(fe12a92f) SHA1(cdcde96fe2a86fc2c404e7746c8670c44f8e169c) )
GAMEGEAR_ROM_LOAD( castlillj, "mickey mouse no castle illusion (japan).bin",                         0x000000 , 0x40000,    CRC(9942b69b) SHA1(d2580137c641192d7faa98dbf8c715623e7d0bed) )
GAMEGEAR_ROM_LOAD( mickeymc, "mickey mouse no mahou no crystal (japan).bin",                         0x000000 , 0x80000,    CRC(0117c3df) SHA1(5cc1a27f801491971e20551b9b9b4388245c0478) )
GAMEGEAR_ROM_LOAD( mickeyuc, "mickey's ultimate challenge (usa, europe).bin",                        0x000000 , 0x40000,    CRC(eccf7a4f) SHA1(f62c129b5142d3dac66392b521003111b9291b3e) )
GAMEGEAR_ROM_LOAD( micromac, "micro machines (europe).bin",                                          0x000000 , 0x40000,    CRC(f7c524f6) SHA1(7b2d39b68622e18eac6c27fd961133b1d002342b) )
GAMEGEAR_ROM_LOAD( micromc2, "micro machines 2 - turbo tournament (europe).bin",                     0x000000 , 0x80000,    CRC(dbe8895c) SHA1(53ad6546462638ab246b4fdd7ca4b8966dde0d96) )
GAMEGEAR_ROM_LOAD( mmprp, "mighty morphin power rangers (prototype - jul 16, 1994).bin",             0x000000 , 0x80000,    CRC(2887f04a) SHA1(88a90ac68fe67872cdee9c4ab2b77595347297eb) )
GAMEGEAR_ROM_LOAD( mmpr, "mighty morphin power rangers (usa, europe).bin",                           0x000000 , 0x80000,    CRC(9289dfcc) SHA1(86c4d12257faf355623f47f8fa22da23a3b36cd9) )
GAMEGEAR_ROM_LOAD( mmprtmp, "mighty morphin power rangers - the movie (prototype - may 30, 1995).bin",0x000000 , 0x80000,    CRC(8c665203) SHA1(ad8fa368c86687d99587aec697ed9f7b47c918b4) )
GAMEGEAR_ROM_LOAD( mmprtm, "mighty morphin power rangers - the movie (usa, europe).bin",             0x000000 , 0x80000,    CRC(b47c19e5) SHA1(dfe7dc7b2df143da4f4eeb32051a6d373dddba5d) )
GAMEGEAR_ROM_LOAD( mlbpab, "mlbpa baseball (usa).bin",                                               0x000000 , 0x80000,    CRC(1ecf07b4) SHA1(74c7433ae9807a0042741d1945472eafd88b48cd) )
GAMEGEAR_ROM_LOAD( moldoran, "moldorian - hikari to yami no sister (japan).bin",                     0x000000 , 0x80000,    CRC(4d5d15fb) SHA1(0dad260b5357b2f61d1452bb73d8321ca53d7262) )
GAMEGEAR_ROM_LOAD( monstert, "monster truck wars (usa, europe).bin",                                 0x000000 , 0x40000,    CRC(453c5cec) SHA1(f493d5aebef88b44cadcb3459d214a6c3ba155c8) )
GAMEGEAR_ROM_LOAD( monstwld2, "monster world ii - dragon no wana (japan).bin",                       0x000000 , 0x40000,    CRC(ea89e0e7) SHA1(5c4d25432512852f48f22280544bd7d034aab744) )
GAMEGEAR_ROM_LOAD( mkj, "mortal kombat (japan) (v3.3).bin",                                          0x000000 , 0x80000,    CRC(dbff0461) SHA1(f28e50f1283d7a2516267a13a16a3e6914ae0a18) )
GAMEGEAR_ROM_LOAD( mk, "mortal kombat (usa, europe) (v2.6).bin",                                     0x000000 , 0x80000,    CRC(07494f2a) SHA1(ef634649b846b3f49d2c68739b36019e4fae0464) )
GAMEGEAR_ROM_LOAD( mk3, "mortal kombat 3 (europe).bin",                                              0x000000 , 0x80000,    CRC(c2be62bb) SHA1(034ecd615609efb4d96669dda7f32f546d5782f8) )
GAMEGEAR_ROM_LOAD( mk2, "mortal kombat ii (world).bin",                                              0x000000 , 0x80000,    CRC(4b304e0f) SHA1(320d2b8b62ef0109621bbe609b02bd8b0769a0b9) )
GAMEGEAR_ROM_LOAD( mspacman, "ms. pac-man (usa).bin",                                                0x000000 , 0x20000,    CRC(5ee88bd5) SHA1(dbba762b62e786be2c1df30a595cf3bc11b106c5) )
GAMEGEAR_ROM_LOAD( nazpuyo, "nazo puyo (japan).bin",                                                 0x000000 , 0x20000,    CRC(bcce5fd4) SHA1(6ad654e11067ed12437022fcf22b9fea9be7ac46) )
GAMEGEAR_ROM_LOAD( nazpuyo2, "nazo puyo 2 (japan).bin",                                              0x000000 , 0x40000,    CRC(73939de4) SHA1(dbd511aff622c618eac0c21de36965b869362dbd) )
GAMEGEAR_ROM_LOAD( nazpyoar1, "nazo puyo arle no roux (japan) (development edition).bin",            0x000000 , 0x40000,    CRC(4c874466) SHA1(23d51aa54d04a145a9df457135b088eef359d46a) )
GAMEGEAR_ROM_LOAD( nazpyoar, "nazo puyo arle no roux (japan).bin",                                   0x000000 , 0x40000,    CRC(54ab42a4) SHA1(20308b7389a9e860697a66510d4925d1af3b769a) )
GAMEGEAR_ROM_LOAD( nbaactn, "nba action (usa).bin",                                                  0x000000 , 0x40000,    CRC(19030108) SHA1(b81b3740e6dbc931dc4a867a8aabdb971492e2b1) )
GAMEGEAR_ROM_LOAD( nbaactnp1, "nba action starring david robinson (final a - feb 28, 1994).bin",     0x000000 , 0x40000,    CRC(d15aa940) SHA1(54060a0430a898f9ac32eb685758f5144a347531) )
GAMEGEAR_ROM_LOAD( nbaactnp2, "nba action starring david robinson (final b - mar 01, 1994).bin",     0x000000 , 0x40000,    CRC(4415c0bb) SHA1(d7062bdecbb42c1869ba70f5d6eed441607e8bd8) )
GAMEGEAR_ROM_LOAD( nbaactnp3, "nba action starring david robinson (final c - mar 02, 1994).bin",     0x000000 , 0x40000,    CRC(5254577a) SHA1(41124a549e9b5362b496709f61ce6710df6caec2) )
GAMEGEAR_ROM_LOAD( nbaactnp4, "nba action starring david robinson (final d - mar 03, 1994).bin",     0x000000 , 0x40000,    CRC(75a5bc5d) SHA1(226de9e66562f7dd05b0b3265aefa94f86f2a724) )
GAMEGEAR_ROM_LOAD( nbaactnp5, "nba action starring david robinson (final e - mar 04, 1994).bin",     0x000000 , 0x40000,    CRC(80c0586c) SHA1(cd2114ce46eec5b0e4bc4f1c4c65926b4c37541a) )
GAMEGEAR_ROM_LOAD( nbaactnp6, "nba action starring david robinson (final f - mar 04, 1994).bin",     0x000000 , 0x40000,    CRC(a82049df) SHA1(60e804882a04f376e6914ebd9683268d016d0d69) )
GAMEGEAR_ROM_LOAD( nbaactnp7, "nba action starring david robinson (final g - mar 05, 1994).bin",     0x000000 , 0x40000,    CRC(e197a0bb) SHA1(7b6620a9f60d75595df59f3723c8c5b76e6b2d8f) )
GAMEGEAR_ROM_LOAD( nbaactnp8, "nba action starring david robinson (final h - mar 08, 1994).bin",     0x000000 , 0x40000,    CRC(c9e98a49) SHA1(0ea3a2656145092d8df00b6a7668599b0ab1b8d3) )
GAMEGEAR_ROM_LOAD( nbaactnp9, "nba action starring david robinson (prototype - dec 01, 1993).bin",   0x000000 , 0x40000,    CRC(8c089da5) SHA1(ac01abe3858ac97f31b23104231bb26bb2ee4a6c) )
GAMEGEAR_ROM_LOAD( nbaactp10, "nba action starring david robinson (prototype - feb 02, 1994).bin",   0x000000 , 0x40000,    CRC(f9d5500b) SHA1(6c427db53067dfaf1979422b970b79d6fa55fec8) )
GAMEGEAR_ROM_LOAD( nbaactp11, "nba action starring david robinson (prototype - feb 03, 1994).bin",   0x000000 , 0x40000,    CRC(e2341dce) SHA1(5a4ab43ddd63d3a9198a940479626b427ec39c6a) )
GAMEGEAR_ROM_LOAD( nbaactp12, "nba action starring david robinson (prototype - feb 06, 1994).bin",   0x000000 , 0x40000,    CRC(07649147) SHA1(c0389169ce2b8b619afa6b7e2c5cede667299e64) )
GAMEGEAR_ROM_LOAD( nbaactp13, "nba action starring david robinson (prototype - feb 08, 1994).bin",   0x000000 , 0x40000,    CRC(5e089fbc) SHA1(026cfde6ad4a499fa08ebec57a69cd80239f642b) )
GAMEGEAR_ROM_LOAD( nbaactp14, "nba action starring david robinson (prototype - feb 12, 1994).bin",   0x000000 , 0x40000,    CRC(0c0f6b4c) SHA1(006ce9972fd532abb1b426de2bf02e75dd616bba) )
GAMEGEAR_ROM_LOAD( nbaactp15, "nba action starring david robinson (prototype - feb 15, 1994).bin",   0x000000 , 0x40000,    CRC(e73b02a4) SHA1(6bff3fa4cab82f688a02318b19af57cb21f75ca5) )
GAMEGEAR_ROM_LOAD( nbaactp16, "nba action starring david robinson (prototype - feb 17, 1994).bin",   0x000000 , 0x40000,    CRC(c4b3328c) SHA1(60ebead82b6e30f00ea5ac37f30d854eddc37945) )
GAMEGEAR_ROM_LOAD( nbaactp17, "nba action starring david robinson (prototype - feb 20, 1994).bin",   0x000000 , 0x40000,    CRC(91e3026c) SHA1(eedd9e46158547c80d4c58745a68fe3d083288c2) )
GAMEGEAR_ROM_LOAD( nbaactp18, "nba action starring david robinson (prototype - feb 21, 1994).bin",   0x000000 , 0x40000,    CRC(9265f8c3) SHA1(74716d2e00728bee25985ca2acf0547080699f87) )
GAMEGEAR_ROM_LOAD( nbaactp19, "nba action starring david robinson (prototype - feb 24, 1994).bin",   0x000000 , 0x40000,    CRC(21a79f63) SHA1(bfbcb9dc6c2c66108ba8910df7b360f287feb997) )
GAMEGEAR_ROM_LOAD( nbaactp20, "nba action starring david robinson (prototype - feb 25, 1994 - b).bin", 0x000000 , 0x40000,    CRC(188a319e) SHA1(23cdda16537505afa407704f493c0ed4e51d6373) )
GAMEGEAR_ROM_LOAD( nbaactp21, "nba action starring david robinson (prototype - feb 25, 1994).bin",   0x000000 , 0x40000,    CRC(afc8a69e) SHA1(305c1ca1b947694b61cfd896abca5c6f9ec287f3) )
GAMEGEAR_ROM_LOAD( nbaactp22, "nba action starring david robinson (prototype - feb 26, 1994).bin",   0x000000 , 0x40000,    CRC(6896b65d) SHA1(1d75c23394eaf7506f54a4f55a9e2234c35a5b6d) )
GAMEGEAR_ROM_LOAD( nbaactp23, "nba action starring david robinson (prototype - feb 27, 1994).bin",   0x000000 , 0x40000,    CRC(ab721f11) SHA1(a11674848036a8d587c939ac568bc505d811c0ab) )
GAMEGEAR_ROM_LOAD( nbaactp24, "nba action starring david robinson (prototype - feb 28, 1994).bin",   0x000000 , 0x40000,    CRC(82e882d6) SHA1(e9b3acc9c18ff76d3a48400da39eae98f42d3e5d) )
GAMEGEAR_ROM_LOAD( nbaactp25, "nba action starring david robinson (prototype - jan 04, 1994).bin",   0x000000 , 0x40000,    CRC(c658b5b3) SHA1(9f7e49a7881333a0bc8e6c0ad2a6920102bdb23c) )
GAMEGEAR_ROM_LOAD( nbaactp26, "nba action starring david robinson (prototype - jan 06, 1994).bin",   0x000000 , 0x40000,    CRC(41dabd84) SHA1(01bb6913099fedbc2cf0193351f8a307facad3df) )
GAMEGEAR_ROM_LOAD( nbaactp27, "nba action starring david robinson (prototype - jan 10, 1994).bin",   0x000000 , 0x40000,    CRC(a34b2b4c) SHA1(377ccf6af5fd66672e212005529665c3934e4ead) )
GAMEGEAR_ROM_LOAD( nbaactp28, "nba action starring david robinson (prototype - jan 24, 1994).bin",   0x000000 , 0x40000,    CRC(9824f77d) SHA1(d38c5f823bbb8db43bf25a71d57329d7ca7e9087) )
GAMEGEAR_ROM_LOAD( nbaactp29, "nba action starring david robinson (prototype - jan 29, 1994).bin",   0x000000 , 0x40000,    CRC(0d6bf79d) SHA1(866f61bfd3e54dc6963fae24fda1333cdceef32d) )
GAMEGEAR_ROM_LOAD( nbaactp30, "nba action starring david robinson (prototype - nov 28, 1993).bin",   0x000000 , 0x40000,    CRC(31084021) SHA1(6e12de62fe88f12ec28e594871df90a4e42f4f33) )
GAMEGEAR_ROM_LOAD( nbajamj, "nba jam (japan).bin",                                                   0x000000 , 0x80000,    CRC(a49e9033) SHA1(e7c040a58c8d35bf5b5b556b2d3c55e7a5eb0550) )
GAMEGEAR_ROM_LOAD( nbajam, "nba jam (usa) (v1.1).bin",                                               0x000000 , 0x80000,    CRC(820fa4ab) SHA1(30bdf6edfb1772054e15edefd69fbe16efd1797a) )
GAMEGEAR_ROM_LOAD( nbajam1, "nba jam (usa, europe).bin",                                             0x000000 , 0x80000,    CRC(8f17597e) SHA1(2de5991810bad1a4120a2698530c66d4dbf16f7c) )
GAMEGEAR_ROM_LOAD( nbajamte, "nba jam tournament edition (usa, europe).bin",                         0x000000 , 0x80000,    CRC(86c32e5b) SHA1(c34e318852ca6f52e980c7a63721a145cd167843) )
GAMEGEAR_ROM_LOAD( nekodais, "neko daisuki! (japan).bin",                                            0x000000 , 0x80000,    CRC(3679be80) SHA1(c83fd440895ceb50e4da2ab9db2a29ac21555e9d) )
GAMEGEAR_ROM_LOAD( nfl95pa, "nfl '95 (prototype - aug 08, 1994).bin",                                0x000000 , 0x80000,    CRC(8cd96d95) SHA1(2bcaa3b7d0ba5bb5dfb716071f365f6e0248bc0b) )
GAMEGEAR_ROM_LOAD( nfl95pb, "nfl '95 (prototype - aug 25, 1994 - a).bin",                            0x000000 , 0x80000,    CRC(7f769052) SHA1(0d79198d43250ad4a745da7853050a3db8f2803c) )
GAMEGEAR_ROM_LOAD( nfl95pc, "nfl '95 (prototype - aug 25, 1994 - b).bin",                            0x000000 , 0x80000,    CRC(fe140eaa) SHA1(b79af203bc01ea1c59563e34105cb36cad158cca) )
GAMEGEAR_ROM_LOAD( nfl95pd, "nfl '95 (prototype - aug 25, 1994).bin",                                0x000000 , 0x80000,    CRC(fe140eaa) SHA1(b79af203bc01ea1c59563e34105cb36cad158cca) )
GAMEGEAR_ROM_LOAD( nfl95pe, "nfl '95 (prototype - aug 26, 1994).bin",                                0x000000 , 0x80000,    CRC(f77138dd) SHA1(b86fa58449e1544014ffce590efe16678e93f811) )
GAMEGEAR_ROM_LOAD( nfl95pf, "nfl '95 (prototype - aug 31, 1994).bin",                                0x000000 , 0x80000,    CRC(a3b046e7) SHA1(d426cd29a03b2341c417c3d5b40f16c4e066f27e) )
GAMEGEAR_ROM_LOAD( nfl95pg, "nfl '95 (prototype - sep 02, 1994).bin",                                0x000000 , 0x80000,    CRC(3978387b) SHA1(f2e837a299bc357f8f75e8daaa38159d926d8202) )
GAMEGEAR_ROM_LOAD( nfl95ph, "nfl '95 (prototype - sep 08, 1994).bin",                                0x000000 , 0x80000,    CRC(ff70a26f) SHA1(95ef164e629eb5ac88201e2cb1606d305f1881b0) )
GAMEGEAR_ROM_LOAD( nfl95pi, "nfl '95 (prototype - sep 10, 1994).bin",                                0x000000 , 0x80000,    CRC(132db489) SHA1(5eebf128b61ce03ea2eb44e5b42ccdf4de80d0ec) )
GAMEGEAR_ROM_LOAD( nfl95pj, "nfl '95 (prototype - sep 11, 1994 - b).bin",                            0x000000 , 0x80000,    CRC(c57c6afd) SHA1(087c59dace9afbd2cd6b53bfe896f33820b03f5e) )
GAMEGEAR_ROM_LOAD( nfl95pk, "nfl '95 (prototype - sep 11, 1994 - c).bin",                            0x000000 , 0x80000,    CRC(088e4b6d) SHA1(7a5c9883fa5775ee357de76e60b5435acfa4f47f) )
GAMEGEAR_ROM_LOAD( nfl95pl, "nfl '95 (prototype - sep 12, 1994).bin",                                0x000000 , 0x80000,    CRC(b38f48b6) SHA1(dc3c1d7b0137d26d79cb7d0be5ed51d551a256d7) )
GAMEGEAR_ROM_LOAD( nfl95pm, "nfl '95 (prototype - sep 14, 1994 - f).bin",                            0x000000 , 0x80000,    CRC(2828cb66) SHA1(e76270bfbe8a64173fba9ca14d15679fb340d0c9) )
GAMEGEAR_ROM_LOAD( nfl95pn, "nfl '95 (prototype - sep 14, 1994).bin",                                0x000000 , 0x80000,    CRC(474a162b) SHA1(441468692ee04852424dac693697389c93f44482) )
GAMEGEAR_ROM_LOAD( nfl95, "nfl '95 (usa).bin",                                                       0x000000 , 0x80000,    CRC(dc5b0407) SHA1(d5f2b7b495794f11a9a67e2b34a44d59003f5960) )
GAMEGEAR_ROM_LOAD( nflqrt96, "nfl quarterback club '96 (usa, europe).bin",                           0x000000 , 0x80000,    CRC(c348e53a) SHA1(fd4167dbc780ff402ba1df2671982ab722c0b3f3) )
GAMEGEAR_ROM_LOAD( nflquart, "nfl quarterback club (world).bin",                                     0x000000 , 0x80000,    CRC(61785ed5) SHA1(ea42bb90eea90a159f8c662743aa59d6dd6f7250) )
GAMEGEAR_ROM_LOAD( nhlallstpa, "nhl all-star hockey (prototype - dec 15, 1994).bin",                 0x000000 , 0x80000,    CRC(e583d999) SHA1(dec66ddac97c91aebcefc479da79ea086b0ebea8) )
GAMEGEAR_ROM_LOAD( nhlallstpb, "nhl all-star hockey (prototype - dec 22, 1994).bin",                 0x000000 , 0x80000,    CRC(dfba792a) SHA1(be689bef9395d698ed5f9629c80762d7f6847393) )
GAMEGEAR_ROM_LOAD( nhlallstpc, "nhl all-star hockey (prototype - dec 29, 1994).bin",                 0x000000 , 0x80000,    CRC(e14d071b) SHA1(be2afd53ba0ceb64e9069c4fefd73db5b31ad9e2) )
GAMEGEAR_ROM_LOAD( nhlallstpd, "nhl all-star hockey (prototype - dec 31, 1994).bin",                 0x000000 , 0x80000,    CRC(8a2b6323) SHA1(f7d636b7e75853a744c61da7ac3c91766fc34dc7) )
GAMEGEAR_ROM_LOAD( nhlallstpe, "nhl all-star hockey (prototype - jan 02, 1995).bin",                 0x000000 , 0x80000,    CRC(2551f22c) SHA1(393d17319e28c5774e7a3f2c336a36f1279d6932) )
GAMEGEAR_ROM_LOAD( nhlallstpf, "nhl all-star hockey (prototype - jan 03, 1995).bin",                 0x000000 , 0x80000,    CRC(ece5633b) SHA1(5560ce4cff2f2b4ca7a89c34d295ac11983aa698) )
GAMEGEAR_ROM_LOAD( nhlallstpg, "nhl all-star hockey (prototype - jan 07, 1995).bin",                 0x000000 , 0x80000,    CRC(82504476) SHA1(7ff1ee75043b1fe81c7db4b1aeac0f3c3c84c90a) )
GAMEGEAR_ROM_LOAD( nhlallstph, "nhl all-star hockey (prototype - jan 11, 1995).bin",                 0x000000 , 0x80000,    CRC(49f8b9e4) SHA1(c5bc673a9e1c046a13d19151e52022dba3e862ba) )
GAMEGEAR_ROM_LOAD( nhlallstpi, "nhl all-star hockey (prototype - jan 13, 1995).bin",                 0x000000 , 0x80000,    CRC(87d8fe13) SHA1(338d8d9a6adaa9f4cc1733a62de76ad240ff1f79) )
GAMEGEAR_ROM_LOAD( nhlallstpj, "nhl all-star hockey (prototype - jan 16, 1995).bin",                 0x000000 , 0x80000,    CRC(50dcf5b6) SHA1(5e251060685b00d4b492e1eddfcabfa0d78d42cf) )
GAMEGEAR_ROM_LOAD( nhlallstpk, "nhl all-star hockey (prototype - jan 20 ,1995).bin",                 0x000000 , 0x80000,    CRC(499b06c2) SHA1(76de1dadc2fb155dbb3b4c17c77aad9e87d93271) )
GAMEGEAR_ROM_LOAD( nhlallstpl, "nhl all-star hockey (prototype - jan 21, 1995).bin",                 0x000000 , 0x80000,    CRC(16af7995) SHA1(7d0dd9e5d441e6e55d0c31f313c7761cf5860c16) )
GAMEGEAR_ROM_LOAD( nhlallstpm, "nhl all-star hockey (prototype - jan 24, 1995 - a).bin",             0x000000 , 0x80000,    CRC(0b1c38f4) SHA1(91e8a0184d77dcd7c484b125b560b113aeaeaeb4) )
GAMEGEAR_ROM_LOAD( nhlallstpn, "nhl all-star hockey (prototype - jan 24, 1995 - b).bin",             0x000000 , 0x80000,    CRC(0a4a6830) SHA1(c7c54814c416bd3a1eed38e13a1644fe3f57160e) )
GAMEGEAR_ROM_LOAD( nhlallstpo, "nhl all-star hockey (prototype - jan 24, 1995 - c).bin",             0x000000 , 0x80000,    CRC(54f5efb2) SHA1(318b3f3615f7b94e9f375f8b1c7a0a98c2bfe3ab) )
GAMEGEAR_ROM_LOAD( nhlallstpp, "nhl all-star hockey (prototype - jan 24, 1995).bin",                 0x000000 , 0x80000,    CRC(74be3c4c) SHA1(235a09f13eecd83d6c278a5e476a93004ff78c9b) )
GAMEGEAR_ROM_LOAD( nhlallstpq, "nhl all-star hockey (prototype - jan 25, 1995).bin",                 0x000000 , 0x80000,    CRC(a587b13e) SHA1(4f6077aa192be69261cbce3ec3ddc35c6d04a0d2) )
GAMEGEAR_ROM_LOAD( nhlallst, "nhl all-star hockey (usa).bin",                                        0x000000 , 0x80000,    CRC(4680c7aa) SHA1(9556d7a49372ebc8cfe3ab43704ceade86d5fef5) )
GAMEGEAR_ROM_LOAD( nhlhocky, "nhl hockey (usa, europe).bin",                                         0x000000 , 0x80000,    CRC(658713a5) SHA1(8f243a6011f769538349c968929a500aff7d3e6d) )
GAMEGEAR_ROM_LOAD( ninjagj, "ninja gaiden (japan).bin",                                              0x000000 , 0x20000,    CRC(20ef017a) SHA1(acedddaa928a96085544440c2bec2685a6cdf501) )
GAMEGEAR_ROM_LOAD( ninjag, "ninja gaiden (usa, europe).bin",                                         0x000000 , 0x20000,    CRC(c578756b) SHA1(1a5c44e76a0e913d76f590affae3b2e24fbd0f59) )
GAMEGEAR_ROM_LOAD( ninku, "ninku (japan).bin",                                                       0x000000 , 0x80000,    CRC(c3056e15) SHA1(d22bfa865b34866568f3dd7fccec886170071c81) )
GAMEGEAR_ROM_LOAD( ninku2, "ninku 2 - tenkuuryuu e no michi (japan).bin",                            0x000000 , 0x80000,    CRC(06247dd2) SHA1(fd6452974da734fcd4292cb0cd728a0ac9aef714) )
GAMEGEAR_ROM_LOAD( ninkug, "ninku gaiden - hiroyuki daikatsugeki (japan).bin",                       0x000000 , 0x80000,    CRC(9140f239) SHA1(23003e39918f855bd37f58b7b8840960cc82196a) )
GAMEGEAR_ROM_LOAD( nomohide, "nomo hideo no world series baseball (japan).bin",                      0x000000 , 0x80000,    CRC(4ed45bda) SHA1(127a7e6706f6d9b129d5cf0dd2bb417e9b108748) )
GAMEGEAR_ROM_LOAD( olympi, "olympic gold (europe) (en,fr,de,es,it,nl,pt,sv) (v1.1).bin",             0x000000 , 0x40000,    CRC(1d93246e) SHA1(53fd026008be77cd0cda7080e67a87a7bad33a6a) )
GAMEGEAR_ROM_LOAD( olympiju, "olympic gold (japan, usa) (en,fr,de,es,it,nl,pt,sv).bin",              0x000000 , 0x40000,    CRC(a2f9c7af) SHA1(b7e5ae436ccaa9984297b0c14969922d189cb10c) )
GAMEGEAR_ROM_LOAD( ottifant, "ottifants, the (europe) (en,fr,de,es,it).bin",                         0x000000 , 0x40000,    CRC(1e673168) SHA1(e66185d8f389ea2c48842f2623349c5cc8b1463d) )
GAMEGEAR_ROM_LOAD( outrunj, "out run (japan).bin",                                                   0x000000 , 0x20000,    CRC(d58cb27c) SHA1(284a68102eb71958a3553626ea3dd56485453300) )
GAMEGEAR_ROM_LOAD( outruneu, "out run europa (usa, europe).bin",                                     0x000000 , 0x40000,    CRC(f037ec00) SHA1(dd842a7294eee7badf4353fbe3e5d87dd570c671) )
GAMEGEAR_ROM_LOAD( outrun, "outrun (ju) [a1].bin",                                                   0x000000 , 0x20000,    CRC(4753c309) SHA1(25d999bb8edfb59075d774050c68d5c9f286793d) )
GAMEGEAR_ROM_LOAD( pacattck, "pac-attack (usa, europe).bin",                                         0x000000 , 0x20000,    CRC(9273ee2c) SHA1(e9e3d7c116e82e7fe696ac3e043d14ece51e9f8e) )
GAMEGEAR_ROM_LOAD( pacintim, "pac-in-time (unknown) (proto).bin",                                    0x000000 , 0x40000,    CRC(64c28e20) SHA1(bc956615da23f13bddc491377b29631f9c0a4d5a) )
GAMEGEAR_ROM_LOAD( pacman, "pac-man (japan).bin",                                                    0x000000 , 0x20000,    CRC(a16c5e58) SHA1(d78b6aac927692f1b67e6a4b7494e2c7e709ae17) )
GAMEGEAR_ROM_LOAD( panzer, "panzer dragoon mini (japan).bin",                                        0x000000 , 0x80000,    CRC(e9783cea) SHA1(c1498f68acb234f46ab6f443f484a48ebd183f0f) )
GAMEGEAR_ROM_LOAD( paperboy, "paperboy (usa, europe).bin",                                           0x000000 , 0x20000,    CRC(f54b6803) SHA1(b1f81f9e2b7197b2fa1475b9cd422479780ef7f2) )
GAMEGEAR_ROM_LOAD( paperby2, "paperboy ii (usa, europe).bin",                                        0x000000 , 0x40000,    CRC(8b2c454b) SHA1(2fa97c21bfd9d3968c473b6fa4fb7485b6dfb35d) )
GAMEGEAR_ROM_LOAD( pengoj, "pengo (japan).bin",                                                      0x000000 , 0x8000,     CRC(ce863dba) SHA1(5883e2d19ab7126d52abc177a97d44bc88c319de) )
GAMEGEAR_ROM_LOAD( pengo, "pengo (usa, europe).bin",                                                 0x000000 , 0x8000,     CRC(0da23cc1) SHA1(e42f85feb631712b8615a0b19bfbf6432633ba00) )
GAMEGEAR_ROM_LOAD( petclub, "pet club inu daisuki! (japan).bin",                                     0x000000 , 0x80000,    CRC(b42d8430) SHA1(0c0bcfd06084419e7c5921f92ccb0f977058c5a3) )
GAMEGEAR_ROM_LOAD( psampras, "pete sampras tennis (europe).bin",                                     0x000000 , 0x40000,    CRC(c1756bee) SHA1(ab9b4c833207824efb14b712b4ec82721c8436bc) )
GAMEGEAR_ROM_LOAD( pga96, "pga tour 96 (usa, europe).bin",                                           0x000000 , 0x80000,    CRC(542b6d8e) SHA1(dc71616c742f23979c5eb27aafa27961170e0ae8) )
GAMEGEAR_ROM_LOAD( pgatour, "pga tour golf (usa) (v1.1).bin",                                        0x000000 , 0x40000,    CRC(1c77d996) SHA1(cddc04025a10e4351a4c63d118a74bc8b7d2b257) )
GAMEGEAR_ROM_LOAD( pgatoura, "pga tour golf (usa, europe).bin",                                      0x000000 , 0x40000,    CRC(9700bb65) SHA1(34a2b521c4577e4d1699311365722745d62f10aa) )
GAMEGEAR_ROM_LOAD( pgatour2, "pga tour golf ii (usa, europe).bin",                                   0x000000 , 0x80000,    CRC(4a8ac851) SHA1(871b94f1ff63e2a89bc165382110d4f79df53fa3) )
GAMEGEAR_ROM_LOAD( pstaradv, "phantasy star adventure (japan).bin",                                  0x000000 , 0x20000,    CRC(1a51579d) SHA1(fdd940556f7d3af14979dbf057809d5a22e46d8e) )
GAMEGEAR_ROM_LOAD( pstargai, "phantasy star gaiden (japan).bin",                                     0x000000 , 0x40000,    CRC(a942514a) SHA1(914f1e693f396794a37b5d99acaf5db54fe529c2) )
GAMEGEAR_ROM_LOAD( phantom, "phantom 2040 (usa, europe).bin",                                        0x000000 , 0x80000,    CRC(281b1c3a) SHA1(0e054455d99b6d1732abbe9d0ca1b25825b70b87) )
GAMEGEAR_ROM_LOAD( pinballd, "pinball dreams (usa).bin",                                             0x000000 , 0x20000,    CRC(635c483a) SHA1(1734288c1ca2d83b28b5e266998fbbba76f665f6) )
GAMEGEAR_ROM_LOAD( pocketj, "pocket jansou (japan).bin",                                             0x000000 , 0x20000,    CRC(cc90c723) SHA1(5949695ae82b796d4cc141fcb57d01463e1b0ec6) )
GAMEGEAR_ROM_LOAD( pokerf, "poker faced paul's blackjack (usa).bin",                                 0x000000 , 0x20000,    CRC(89d34067) SHA1(010560dee1eafae3266eb9720e2f802c0deccf40) )
GAMEGEAR_ROM_LOAD( pokerf1, "poker faced paul's gin (usa).bin",                                      0x000000 , 0x20000,    CRC(afd61b89) SHA1(e21d29b2864b6eed3a4eb4dcf7443f1114e92bd4) )
GAMEGEAR_ROM_LOAD( pokerf2, "poker faced paul's poker (usa).bin",                                    0x000000 , 0x20000,    CRC(e783daf8) SHA1(c21b3a14bd560261c01eccb413b27fecf231495b) )
GAMEGEAR_ROM_LOAD( pokerf3, "poker faced paul's solitaire (usa).bin",                                0x000000 , 0x20000,    CRC(0e9b0c0a) SHA1(141b53c7f85b50626c6619094f4f8f7bec3676d2) )
GAMEGEAR_ROM_LOAD( popbreak, "pop breaker (japan).bin",                                              0x000000 , 0x20000,    CRC(71deba5a) SHA1(9c358504d3c106dd62bd8981132b47cdb95903de) )
GAMEGEAR_ROM_LOAD( popeye, "popeye no beach volleyball (japan).bin",                                 0x000000 , 0x80000,    CRC(3ef66810) SHA1(921e3922e1b550b6914fb06ba74d4661ef25a89e) )
GAMEGEAR_ROM_LOAD( pstrike2, "power strike ii (japan, europe).bin",                                  0x000000 , 0x40000,    CRC(09de1528) SHA1(e4db2140761b43426024bd08c4372bb9b8979d3d) )
GAMEGEAR_ROM_LOAD( predator, "predator 2 (usa, europe).bin",                                         0x000000 , 0x40000,    CRC(e5f789b9) SHA1(76464809826a0ceed7cfd68a8fe5e06c06bd96fc) )
GAMEGEAR_ROM_LOAD( primal, "primal rage (usa, europe).bin",                                          0x000000 , 0x80000,    CRC(2a34b5c7) SHA1(6d193840463722ed141ed503c2cfc7ae0077ce35) )
GAMEGEAR_ROM_LOAD( ppersiab, "prince of persia (usa, europe) (beta).bin",                            0x000000 , 0x40000,    CRC(45f058d6) SHA1(0672814b9fb20dd217141f7853db300343f2c1ea) )
GAMEGEAR_ROM_LOAD( ppersia, "prince of persia (usa, europe).bin",                                    0x000000 , 0x40000,    CRC(311d2863) SHA1(7820699ee6b214f3f02f724f4d7891184caf93f8) )
GAMEGEAR_ROM_LOAD( proyak91, "pro yakyuu '91, the (japan).bin",                                      0x000000 , 0x20000,    CRC(6d3a10d3) SHA1(804cfac0a7578c3fd625f0084a24afa26a2dc015) )
GAMEGEAR_ROM_LOAD( proyak94, "pro yakyuu gg league '94 (japan).bin",                                 0x000000 , 0x80000,    CRC(a1a19135) SHA1(faac2b420cb895aec4216d4c5ce21e5f2a4c4338) )
GAMEGEAR_ROM_LOAD( proyakgg, "pro yakyuu gg league (japan).bin",                                     0x000000 , 0x40000,    CRC(2da8e943) SHA1(bf78122a549ad9b016e3704690c7eea1574af140) )
GAMEGEAR_ROM_LOAD( psychicwj, "psychic world (japan).bin",                                           0x000000 , 0x20000,    CRC(afcc7828) SHA1(1c0074c811ed4eb369be31c1bc7d851e40ae8797) )
GAMEGEAR_ROM_LOAD( psychicw, "psychic world (usa, europe) (v1.1).bin",                               0x000000 , 0x20000,    CRC(73779b22) SHA1(3be13f79eeb26b82343afab3e740b3a1d35978eb) )
GAMEGEAR_ROM_LOAD( puttputtj, "putt & putter (japan).bin",                                           0x000000 , 0x20000,    CRC(407ac070) SHA1(2d4a72e6f5db344240c2a65141b08e57a4b52416) )
GAMEGEAR_ROM_LOAD( puttputt, "putt & putter (usa, europe).bin",                                      0x000000 , 0x20000,    CRC(ecc301dd) SHA1(7038a6e60106eba19e0aff56c14749c2dbb5de5f) )
GAMEGEAR_ROM_LOAD( puyopuyo, "puyo puyo (japan).bin",                                                0x000000 , 0x40000,    CRC(d173a06f) SHA1(8ea2e623858221c5d39eb1e0f6532a0b23b00305) )
GAMEGEAR_ROM_LOAD( puyopyo2, "puyo puyo 2 (japan).bin",                                              0x000000 , 0x80000,    CRC(3ab2393b) SHA1(04ea9ff57faeeccd1bbb17490d22313ae94c86d6) )
GAMEGEAR_ROM_LOAD( tantor, "puzzle and action tanto-r (japan).bin",                                  0x000000 , 0x80000,    CRC(09151743) SHA1(75f54793ac09e22e0be1864ea16e68b2fb4610ff) )
GAMEGEAR_ROM_LOAD( pbobble, "puzzle bobble (japan).bin",                                             0x000000 , 0x40000,    CRC(8e54ee04) SHA1(15568554cf6474e1ad64401217b702a048113a2d) )
GAMEGEAR_ROM_LOAD( questf, "quest for the shaven yak starring ren hoek & stimpy (usa, europe).bin",  0x000000 , 0x80000,    CRC(6c451ee1) SHA1(83bc52f669183f99accb078a454f786b5e320e40) )
GAMEGEAR_ROM_LOAD( quizgear, "quiz gear fight!!, the (japan).bin",                                   0x000000 , 0x80000,    CRC(736cdb76) SHA1(6ce8ff78d96a1a0e13997489d1a53b5a57a619c2) )
GAMEGEAR_ROM_LOAD( rbibas, "r.b.i. baseball '94 (usa).bin",                                          0x000000 , 0x80000,    CRC(6dc3295e) SHA1(21e3800ecfb6c8210cfc1213a6cbf0bb63519633) )
GAMEGEAR_ROM_LOAD( rcgp, "r.c. grand prix (usa, europe).bin",                                        0x000000 , 0x40000,    CRC(56201996) SHA1(c789e7f9450c8eaa08be1bf6c39e877973216431) )
GAMEGEAR_ROM_LOAD( rastansg, "rastan saga (japan).bin",                                              0x000000 , 0x40000,    CRC(9c76fb3a) SHA1(96bf8a67919218aac91fb74cde80a16f90df77d5) )
GAMEGEAR_ROM_LOAD( revenged, "revenge of drancon (usa).bin",                                         0x000000 , 0x20000,    CRC(03e9c607) SHA1(286f673b11739d624899479216e30b58efd049be) )
GAMEGEAR_ROM_LOAD( riddickj, "riddick bowe boxing (japan).bin",                                      0x000000 , 0x40000,    CRC(a45fffb7) SHA1(af32ad098a1bf872d5a2cef38105704d3507ed75) )
GAMEGEAR_ROM_LOAD( riddick, "riddick bowe boxing (usa).bin",                                         0x000000 , 0x40000,    CRC(38d8ec56) SHA1(b8487bdb0a6167753fc6de82714793181d7718db) )
GAMEGEAR_ROM_LOAD( riserobo, "rise of the robots (usa, europe).bin",                                 0x000000 , 0x80000,    CRC(100b77b2) SHA1(9ba2f734eccf5b2ceefaa69cebdf7399bc9032d8) )
GAMEGEAR_ROM_LOAD( ristarp, "ristar (prototype - nov 01, 1994).bin",                                 0x000000 , 0x80000,    CRC(44fa6ae6) SHA1(e2a06327647d9ad2358e34aae069d7789bc70e65) )
GAMEGEAR_ROM_LOAD( ristarp1, "ristar (prototype - nov 02, 1994).bin",                                0x000000 , 0x80000,    CRC(302d2b4b) SHA1(cf2a646d5c4b3f717a5c2a29d193210abbf770ca) )
GAMEGEAR_ROM_LOAD( ristarp2, "ristar (prototype - oct 19, 1994).bin",                                0x000000 , 0x80000,    CRC(672d38d5) SHA1(ac6d5e7f5c3fbd828876a12e10d89274025f3924) )
GAMEGEAR_ROM_LOAD( ristarp3, "ristar (prototype - oct 26, 1994).bin",                                0x000000 , 0x80000,    CRC(a302413c) SHA1(b13c32f50e7eb7d8147b7ad1d310e89e690ba6b2) )
GAMEGEAR_ROM_LOAD( ristarp4, "ristar (prototype - sep 09, 1994).bin",                                0x000000 , 0x80000,    CRC(a1c214bd) SHA1(f746e8e99f4fca811a32716d96a4e6528ec930eb) )
GAMEGEAR_ROM_LOAD( ristar, "ristar - the shooting star (world).bin",                                 0x000000 , 0x80000,    CRC(efe65b3b) SHA1(d0d950097471553b6a96dc9cf0fb14ddb3a7dda2) )
GAMEGEAR_ROM_LOAD( roadrash, "road rash (usa).bin",                                                  0x000000 , 0x80000,    CRC(96045f76) SHA1(2cf136b5feb786770322e1a03e7e3577a1a9eec0) )
GAMEGEAR_ROM_LOAD( robocop3, "robocop 3 (usa, europe).bin",                                          0x000000 , 0x40000,    CRC(069a0704) SHA1(8de7c9ac95b734af9e3fbe5700ac4c6599799702) )
GAMEGEAR_ROM_LOAD( roboterm, "robocop versus the terminator (usa, europe).bin",                      0x000000 , 0x80000,    CRC(4ab7fa4e) SHA1(13286df11fc66a8974a73a82e8478fa382fa2b43) )
GAMEGEAR_ROM_LOAD( royalstn, "royal stone - hirakareshi toki no tobira (japan).bin",                 0x000000 , 0x80000,    CRC(445d7cd2) SHA1(c1afca3ac30cb9852f508f5dded7e50e08000f86) )
GAMEGEAR_ROM_LOAD( ryuukyuu, "ryuukyuu (japan).bin",                                                 0x000000 , 0x20000,    CRC(95efd52b) SHA1(ffaa1c97c64aec30176254f1ef655c06c63e1b53) )
GAMEGEAR_ROM_LOAD( sslucifr, "s.s. lucifer - man overboard! (europe).bin",                           0x000000 , 0x40000,    CRC(d9a7f170) SHA1(b167fda9f0e7a6a47027f782a08149e8d4f46e0c) )
GAMEGEAR_ROM_LOAD( samsho, "samurai shodown (usa).bin",                                              0x000000 , 0x80000,    CRC(98171deb) SHA1(d7330f5abcadb5c199299b24c22334be0072ec80) )
GAMEGEAR_ROM_LOAD( samspi, "samurai spirits (japan).bin",                                            0x000000 , 0x80000,    CRC(93fd73dc) SHA1(2aaf7b6f9d37275995d4a62bb8a465333d8b0bf4) )
GAMEGEAR_ROM_LOAD( scratchg, "scratch golf (japan).bin",                                             0x000000 , 0x40000,    CRC(ec0f2c72) SHA1(4c1d3b5057702341b5646d0a2fe65a9bda966211) )
GAMEGEAR_ROM_LOAD( sdgundam, "sd gundam - winner's history (japan).bin",                             0x000000 , 0x80000,    CRC(5e2b39b8) SHA1(24e217098845ab5a0eb29e9dc6af2e86be1b0a84) )
GAMEGEAR_ROM_LOAD( segagame, "sega game pack 4 in 1 (europe).bin",                                   0x000000 , 0x40000,    CRC(0924d2ec) SHA1(02fa5c6c6f81f5f4e1d78eced5a37617888404d3) )
GAMEGEAR_ROM_LOAD( sensible, "sensible soccer (europe).bin",                                         0x000000 , 0x20000,    CRC(5b68da75) SHA1(c02830156779a27b79435ec0cbf7a03cbbfda920) )
GAMEGEAR_ROM_LOAD( shadam, "shadam crusader - harukanaru oukoku (japan).bin",                        0x000000 , 0x80000,    CRC(09f9ed60) SHA1(de4b546f61dd32106247d38643849f6aaeeedb07) )
GAMEGEAR_ROM_LOAD( shangh2, "shanghai ii (japan).bin",                                               0x000000 , 0x20000,    CRC(2ae8c75f) SHA1(5180891ec0ae08d784dd89222d9ffd7f88a59691) )
GAMEGEAR_ROM_LOAD( shaqfu, "shaq fu (usa, europe).bin",                                              0x000000 , 0x80000,    CRC(6fcb8ab0) SHA1(bc9d0b0dc2b22b9530660f0a04b865492766c9d0) )
GAMEGEAR_ROM_LOAD( shikinjo, "shikinjou (japan).bin",                                                0x000000 , 0x20000,    CRC(9c5c7f53) SHA1(bf36130b1be4bce6c6eb7b87db00d420797c3611) )
GAMEGEAR_ROM_LOAD( shinfrcg, "shining force gaiden - ensei, jashin no kuni e (japan).bin",           0x000000 , 0x80000,    CRC(4d1f4699) SHA1(bea1bea94ea745691ad944eaadc8a5576057ed53) )
GAMEGEAR_ROM_LOAD( shinfrgf, "shining force gaiden - final conflict (japan).bin",                    0x000000 , 0x80000,    CRC(6019fe5e) SHA1(0d4bc152e7ae70457fa74f593e064403cd24ab72) )
GAMEGEAR_ROM_LOAD( shinfrg2, "shining force gaiden ii - jashin no kakusei (japan).bin",              0x000000 , 0x80000,    CRC(30374681) SHA1(2dd374db661315e51e9eedebf346a5a4ded0c3be) )
GAMEGEAR_ROM_LOAD( shinfrc2p1, "shining force ii (prototype - apr 27, 1994).bin",                    0x000000 , 0x80000,    CRC(65e5345c) SHA1(71ed14c75915d606e00481cc2fbbaa28b6d2ba4f) )
GAMEGEAR_ROM_LOAD( shinfrc2p2, "shining force ii (prototype - jul 08, 1994).bin",                    0x000000 , 0x80000,    CRC(80dca91d) SHA1(a9dd1254577bff20ee33f7bce56e2c4361f911c4) )
GAMEGEAR_ROM_LOAD( shinfrc2p3, "shining force ii (prototype - jun 27, 1994).bin",                    0x000000 , 0x80000,    CRC(8bfc56c3) SHA1(900f8640af14dd6c413f20058a98da11a0fd07b1) )
GAMEGEAR_ROM_LOAD( shinfrc2p4, "shining force ii (prototype - may 30, 1994).bin",                    0x000000 , 0x80000,    CRC(e97ec011) SHA1(bb7be9acb986a923c6c8ae41053c1b2f508885d1) )
GAMEGEAR_ROM_LOAD( shinfrc2, "shining force ii - the sword of hajya (usa, europe).bin",              0x000000 , 0x80000,    CRC(a6ca6fa9) SHA1(789734c4a837dffd2ad3e2c8de22cbd83836580d) )
GAMEGEAR_ROM_LOAD( shinobi, "shinobi (usa, europe).bin",                                             0x000000 , 0x40000,    CRC(30f1c984) SHA1(2e7303f82d885cb84fa557e211954808c8ebe779) )
GAMEGEAR_ROM_LOAD( shinobi2, "shinobi ii - the silent fury (world).bin",                             0x000000 , 0x40000,    CRC(6201c694) SHA1(cd57301d16202ea02d9f97bd8b17d71772782c94) )
GAMEGEAR_ROM_LOAD( sidepock, "side pocket (usa).bin",                                                0x000000 , 0x40000,    CRC(6a603eed) SHA1(794775a858ff04c9da1c897b51eede4677a35c21) )
GAMEGEAR_ROM_LOAD( bartvssm, "simpsons, the - bart vs. the space mutants (usa, europe).bin",         0x000000 , 0x40000,    CRC(c0009274) SHA1(c8bbc1ea5b9b60ebcd15efc2dc850e0ffd20dae0) )
GAMEGEAR_ROM_LOAD( bartvswd, "simpsons, the - bart vs. the world (usa, europe).bin",                 0x000000 , 0x40000,    CRC(da7bd5c7) SHA1(256672261c9a2d35e10eb06e990e8ebc46fb35c1) )
GAMEGEAR_ROM_LOAD( skweek, "skweek (japan).bin",                                                     0x000000 , 0x20000,    CRC(786dd67b) SHA1(17794ed08c1df2ebc992c5686dc1072a75731e4d) )
GAMEGEAR_ROM_LOAD( slider, "slider (usa, europe).bin",                                               0x000000 , 0x20000,    CRC(4dc6f555) SHA1(ab37b26ca62339720d1cefcb152a0aca545359aa) )
GAMEGEAR_ROM_LOAD( smurfs, "smurfs, the (europe) (en,fr,de,es).bin",                                 0x000000 , 0x40000,    CRC(354e1cbd) SHA1(faa80f644ece06b10b8e5ad035cbf518f80d609b) )
GAMEGEAR_ROM_LOAD( solitair, "solitaire funpak (usa).bin",                                           0x000000 , 0x40000,    CRC(f6f24b75) SHA1(f1d31d734f3ef590b0aefd1b89a455e9040d102e) )
GAMEGEAR_ROM_LOAD( solitarp, "solitaire poker (usa, europe).bin",                                    0x000000 , 0x20000,    CRC(06f2fc46) SHA1(7478a2f641fa371999f2c9f0a1efd9917615be5f) )
GAMEGEAR_ROM_LOAD( sonictls, "sonic & tails (japan).bin",                                            0x000000 , 0x80000,    CRC(8ac0dade) SHA1(e70228cbde1b54f1520804c6e3c28b4130a68c84) )
GAMEGEAR_ROM_LOAD( sonictl2, "sonic & tails 2 (japan).bin",                                          0x000000 , 0x80000,    CRC(496bce64) SHA1(bb14ed43cf815e82f55e79753d0a7c8a24e24e7f) )
GAMEGEAR_ROM_LOAD( sonicblsp1, "sonic blast (prototype 611 - may 31, 1996, 13.49).bin",              0x000000 , 0x80000,    CRC(c09ef45b) SHA1(5d9fa949aeddfc4251d7b8a58cb1122f190ecd36) )
GAMEGEAR_ROM_LOAD( sonicblsp2, "sonic blast (prototype 74 - jul 17, 1996, 09.11).bin",               0x000000 , 0x100000,   CRC(362b186d) SHA1(e7bb20410c7ab341a3f7df7fcfee3a6996823655) )
GAMEGEAR_ROM_LOAD( sonicblsp3, "sonic blast (prototype 806 - aug 06, 1996, 18.37).bin",              0x000000 , 0x100000,   CRC(19dad067) SHA1(12a8a59da110b914acde68112db691df9595d4e8) )
GAMEGEAR_ROM_LOAD( sonicblsp4, "sonic blast (prototype 821 - aug 22, 1996, 09.38).bin",              0x000000 , 0x100000,   CRC(5eecb549) SHA1(da497ae41be3fccc97eb18bd6349917e645c5179) )
GAMEGEAR_ROM_LOAD( sonicblsp5, "sonic blast (prototype 827 - aug 28, 1996, 11.13).bin",              0x000000 , 0x100000,   CRC(e6847ac0) SHA1(f1a1edee0eb15faf74dd6896753f0f6abcf12a45) )
GAMEGEAR_ROM_LOAD( sonicblsp6, "sonic blast (prototype 94 - sep 02, 1996, 17.47).bin",               0x000000 , 0x100000,   CRC(2f22a352) SHA1(8aa965b342466cc3ac4093bba61abf7d68b5ec86) )
GAMEGEAR_ROM_LOAD( sonicbls, "sonic blast (world).bin",                                              0x000000 , 0x100000,   CRC(031b9da9) SHA1(11241be4082f6f9d057488ae75ccdd482f623f8c) )
GAMEGEAR_ROM_LOAD( sonicc, "sonic chaos (usa, europe).bin",                                          0x000000 , 0x80000,    CRC(663f2abb) SHA1(5b5b7d9cd8adf0f8e1ee15fd4557828f91dfdca1) )
GAMEGEAR_ROM_LOAD( sonicdrs, "sonic drift (japan) (sample).bin",                                     0x000000 , 0x80000,    CRC(baac1fc0) SHA1(462bdf9bfac3eb9b389142b55be39608c3343223) )
GAMEGEAR_ROM_LOAD( sonicdr, "sonic drift (japan).bin",                                               0x000000 , 0x80000,    CRC(68f0a776) SHA1(fef5d69093df2d774ed274a4079790f8778577fc) )
GAMEGEAR_ROM_LOAD( sonicdr2, "sonic drift 2 (japan, usa).bin",                                       0x000000 , 0x80000,    CRC(d6e8a305) SHA1(fe597c5cfbbc31e54f2484eb5b33c21c66cf0290) )
GAMEGEAR_ROM_LOAD( soniclab, "sonic labyrinth (world).bin",                                          0x000000 , 0x80000,    CRC(5550173b) SHA1(e24bf33d8d5a79f371485f20f207b6b26f5b341e) )
GAMEGEAR_ROM_LOAD( sonicsp, "sonic spinball (prototype 0307 - mar 07, 1994, 05.24).bin",             0x000000 , 0x80000,    CRC(3283580d) SHA1(1b6f1469d0e707aab3eba3c6748f350a30eb530f) )
GAMEGEAR_ROM_LOAD( sonicspa, "sonic spinball (prototype 031094 - mar 10, 1994, 17.41).bin",          0x000000 , 0x80000,    CRC(1a736612) SHA1(81dc53c9103fab356014e7e45082fc562cdd59ec) )
GAMEGEAR_ROM_LOAD( sonicspb, "sonic spinball (prototype 031194 - mar 11, 1994, 12.09).bin",          0x000000 , 0x80000,    CRC(1aed8f62) SHA1(cec96b3372a4ecb39ac7bd51829d4f641ff8d198) )
GAMEGEAR_ROM_LOAD( sonicspc, "sonic spinball (prototype 032194 - mar 21, 1994, 07.12).bin",          0x000000 , 0x80000,    CRC(46657b4e) SHA1(6b08dd5e60e957739cd7c8dea5f9fcb2bf82009c) )
GAMEGEAR_ROM_LOAD( sonicspd, "sonic spinball (prototype 0328 - mar 28, 1994, 06.54).bin",            0x000000 , 0x80000,    CRC(1233c3e3) SHA1(41260c00f83592c6c21800750bd25359f8cce911) )
GAMEGEAR_ROM_LOAD( sonicspe, "sonic spinball (prototype 0329 - mar 29, 1994, 07.35).bin",            0x000000 , 0x80000,    CRC(aa7aedb0) SHA1(f3a3b701f7700459b0a4175e6b8c24ab68518f40) )
GAMEGEAR_ROM_LOAD( sonicspf, "sonic spinball (prototype 0330 - mar 30, 1994, 06.54).bin",            0x000000 , 0x80000,    CRC(2ca34ab2) SHA1(a066324f8d781ea218ea61689eea6d6254bf9aab) )
GAMEGEAR_ROM_LOAD( sonicspg, "sonic spinball (prototype 0405 - apr 05, 1994, 18.07).bin",            0x000000 , 0x80000,    CRC(09b913d5) SHA1(35ed35fda5fc8d5f1ac1068157c176bb216769e4) )
GAMEGEAR_ROM_LOAD( sonicsph, "sonic spinball (prototype 0412 - apr 12, 1994, 07.26).bin",            0x000000 , 0x80000,    CRC(f8a432f6) SHA1(3fd285036f794574b7310ca093a6d5d5bc244bc7) )
GAMEGEAR_ROM_LOAD( sonicspi, "sonic spinball (prototype 0413 - apr 13, 1994, 02.54).bin",            0x000000 , 0x80000,    CRC(1f1abf2c) SHA1(a4c3d6b3601d321003aad3b759487bddb4cd64b3) )
GAMEGEAR_ROM_LOAD( sonicspj, "sonic spinball (prototype 0415 - apr 15, 1994, 17.33).bin",            0x000000 , 0x80000,    CRC(e3b5cd1e) SHA1(e59e3d9b0a8d9adb13a32cfdbe027ade81c8ded1) )
GAMEGEAR_ROM_LOAD( sonicspk, "sonic spinball (prototype 0421 - apr 21, 1994, 05.30).bin",            0x000000 , 0x80000,    CRC(bbaecf7c) SHA1(f0abf46487acc6a2a93b3e7e93dbe9f651ccbd41) )
GAMEGEAR_ROM_LOAD( sonicspl, "sonic spinball (prototype 0427 - apr 27, 1994, 04.51).bin",            0x000000 , 0x5c000,    CRC(07d32244) SHA1(2be84549aeecf580ef25290b7255270ede38b830) )
GAMEGEAR_ROM_LOAD( sonicspm, "sonic spinball (prototype 0429 - apr 29, 1994, 06.01).bin",            0x000000 , 0x80000,    CRC(30a7d062) SHA1(35954b7e65e663fba3066046e971316d5e573158) )
GAMEGEAR_ROM_LOAD( sonicspn, "sonic spinball (prototype 0430 - apr 29, 1994, 21.48).bin",            0x000000 , 0x80000,    CRC(221c4ba4) SHA1(ab9ac3b4ebecd02c8f3b0d29b921a3d8bcf96458) )
GAMEGEAR_ROM_LOAD( sonicspo, "sonic spinball (prototype 0505 - may 05, 1994, 04.47).bin",            0x000000 , 0x80000,    CRC(be76bf30) SHA1(975232a729179c1db5307c072593cdbf83e233d6) )
GAMEGEAR_ROM_LOAD( sonicspp, "sonic spinball (prototype 0506 - may 06, 1994, 13.04).bin",            0x000000 , 0x80000,    CRC(a4833d27) SHA1(36cd00138f78bf31ee6098d1f5b0b2e870ab5637) )
GAMEGEAR_ROM_LOAD( sonicspq, "sonic spinball (prototype 0525 - may 25, 1994, 13.24).bin",            0x000000 , 0x80000,    CRC(a035fd5c) SHA1(cf9afbc274afcd28931bb1298c53bfdf6e04a9b6) )
GAMEGEAR_ROM_LOAD( sonicspr, "sonic spinball (prototype 0530 - may 30, 1994, 23.25).bin",            0x000000 , 0x80000,    CRC(6107819d) SHA1(8c16865212ad284a0929869a95980bcdf3d9ba81) )
GAMEGEAR_ROM_LOAD( sonicsps, "sonic spinball (prototype 503b - may 03, 1994, 19.27).bin",            0x000000 , 0x80000,    CRC(e2fe976a) SHA1(7577eef2ac9823a539d6af1c2673d1702d29695f) )
GAMEGEAR_ROM_LOAD( sonics, "sonic spinball (usa, europe).bin",                                       0x000000 , 0x80000,    CRC(a9210434) SHA1(df21d42b55b1b4a25704957fe323728b775eb84d) )
GAMEGEAR_ROM_LOAD( sonicj, "sonic the hedgehog (japan).bin",                                         0x000000 , 0x40000,    CRC(3e31cb8c) SHA1(8923295c96b2e05da0a83a827fd709b033fc7332) )
GAMEGEAR_ROM_LOAD( sonicp, "sonic the hedgehog (world) (proto).bin",                                 0x000000 , 0x40000,    CRC(816c0a1e) SHA1(7ff6810e4ac03e04584243995c3fd54b77896c23) )
GAMEGEAR_ROM_LOAD( sonic, "sonic the hedgehog (world) (v1.1).bin",                                   0x000000 , 0x40000,    CRC(d163356e) SHA1(7dbbbca2229e74fcb8f90ec794aa6e5cb168e489) )
GAMEGEAR_ROM_LOAD( sonictrip, "sonic the hedgehog - triple trouble (prototype 0808 - aug 08, 1994, 18.05).bin",0x000000 , 0x80000,    CRC(80eb7cfb) SHA1(02257fece665d04d3c88b5f5589773d5a8433953) )
GAMEGEAR_ROM_LOAD( sonictri, "sonic the hedgehog - triple trouble (usa, europe).bin",                0x000000 , 0x80000,    CRC(d23a2a93) SHA1(4965af7ffe60382ffa805710b7c8006419cc4ac4) )
GAMEGEAR_ROM_LOAD( sonic2, "sonic the hedgehog 2 (world).bin",                                       0x000000 , 0x80000,    CRC(95a18ec7) SHA1(dabb452e416b4fa9cb83d8ddd307c2a32c3a1a7f) )
GAMEGEAR_ROM_LOAD( soukoban, "soukoban (japan).bin",                                                 0x000000 , 0x20000,    CRC(0f3e3840) SHA1(e5865a22dc3a9714160ef14bc59d510502d39b97) )
GAMEGEAR_ROM_LOAD( sharr, "space harrier (world).bin",                                               0x000000 , 0x20000,    CRC(600c15b3) SHA1(d00b8ff195d4423f2a344490eb34156017f4ee64) )
GAMEGEAR_ROM_LOAD( cheesep1, "speedy gonzales cheese catastrophe (prototype - feb 17, 1995).bin",    0x000000 , 0x80000,    CRC(4e78fd36) SHA1(8897ba5aa76d0e17251b2765fafbdb0df41030a6) )
GAMEGEAR_ROM_LOAD( cheesep2, "speedy gonzales cheese catastrophe (prototype - feb 24, 1995).bin",    0x000000 , 0x80000,    CRC(4e78fd36) SHA1(8897ba5aa76d0e17251b2765fafbdb0df41030a6) )
GAMEGEAR_ROM_LOAD( spidsin6, "spider-man - return of the sinister six (usa, europe).bin",            0x000000 , 0x40000,    CRC(bc240779) SHA1(37e2b3fd35138e9e939d5152d86e307f7ac06f7e) )
GAMEGEAR_ROM_LOAD( spidxmen, "spider-man and the x-men in arcade's revenge (usa).bin",               0x000000 , 0x80000,    CRC(742a372b) SHA1(4006a23571f194e1fcb3563557decd5d11e7b5c2) )
GAMEGEAR_ROM_LOAD( spidking, "spider-man vs. the kingpin (usa, europe).bin",                         0x000000 , 0x40000,    CRC(2651024e) SHA1(46b064b4b5a6444ce0e64e16a7e5cec2087fb4d3) )
GAMEGEAR_ROM_LOAD( spirou, "spirou (europe) (proto).bin",                                            0x000000 , 0x80000,    CRC(ab622adc) SHA1(40359adbe9950b8e5e46158f519ad782757f0884) )
GAMEGEAR_ROM_LOAD( sportill, "sports illustrated championship football & baseball (usa, europe).bin",0x000000 , 0x80000,    CRC(de25e2d8) SHA1(781bc3ef9fbbbfcb5452dad99633b65c172b62fa) )
GAMEGEAR_ROM_LOAD( sportrvp1, "sports trivia (prototype - apr 03, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(3e3d6728) SHA1(8fc968be19d8da9335bf3a6dac97657058ef5a78) )
GAMEGEAR_ROM_LOAD( sportrvp2, "sports trivia (prototype - apr 03, 1995 - qtest).bin",                0x000000 , 0x40000,    CRC(c68762e6) SHA1(dbab3669da5a204ce78af3fc5a1749a08c39262e) )
GAMEGEAR_ROM_LOAD( sportrvp3, "sports trivia (prototype - apr 04, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(d61a366f) SHA1(463dbaafd144c430f3b62dbb53578f26441bfdb8) )
GAMEGEAR_ROM_LOAD( sportrvp4, "sports trivia (prototype - apr 05, 1995 - 2meg - b).bin",             0x000000 , 0x40000,    CRC(818ec54c) SHA1(48ff2e462d0b17022c8085133447dd7eedac898b) )
GAMEGEAR_ROM_LOAD( sportrvp5, "sports trivia (prototype - apr 05, 1995 - 2meg - c).bin",             0x000000 , 0x40000,    CRC(f88a55f4) SHA1(c857bef7eed535d1f827ad439df112b3b0c05cf8) )
GAMEGEAR_ROM_LOAD( sportrvp6, "sports trivia (prototype - apr 05, 1995 - qtest).bin",                0x000000 , 0x40000,    CRC(93b98f19) SHA1(a57c18adfa86e86b3e43f605617205a219aafdfb) )
GAMEGEAR_ROM_LOAD( sportrvp7, "sports trivia (prototype - apr 06, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(cab74070) SHA1(aa61ae6b979d30757b1192118796878e3e1c082f) )
GAMEGEAR_ROM_LOAD( sportrvp8, "sports trivia (prototype - apr 07, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(352e8b8c) SHA1(e4938d6b435fce12b4b73591447422342b919e9f) )
GAMEGEAR_ROM_LOAD( sportrvp9, "sports trivia (prototype - apr 07, 1995 - qtest).bin",                0x000000 , 0x40000,    CRC(961ae378) SHA1(34986c53709ef347a8ec620dbe7b35fef8ff3ef0) )
GAMEGEAR_ROM_LOAD( sportvp10, "sports trivia (prototype - apr 11, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(8bdb184d) SHA1(203f4ebd0ca75bbeeb3723372500336415f59da4) )
GAMEGEAR_ROM_LOAD( sportvp11, "sports trivia (prototype - apr 12, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(1e360a20) SHA1(5ced41cadede9959775f1d6cf229a19c0d739c88) )
GAMEGEAR_ROM_LOAD( sportvp12, "sports trivia (prototype - apr 25, 1995 - 1meg).bin",                 0x000000 , 0x20000,    CRC(895af58a) SHA1(8e42323155c0e0f0cd050e66f89f821cb884f7a1) )
GAMEGEAR_ROM_LOAD( sportvp13, "sports trivia (prototype - apr 25, 1995 - qtest).bin",                0x000000 , 0x20000,    CRC(7524957c) SHA1(90834a82aa40f69abf57d34d1910d829d8632af0) )
GAMEGEAR_ROM_LOAD( sportvp14, "sports trivia (prototype - apr 27, 1995 - 1meg).bin",                 0x000000 , 0x20000,    CRC(7898919f) SHA1(36d665e221ecf7c0d5f3af1edc83c9e56f3256af) )
GAMEGEAR_ROM_LOAD( sportvp15, "sports trivia (prototype - apr 28, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(26470d2b) SHA1(23a9d5dee62d64eed1de6e35ac75cbe5786a0c06) )
GAMEGEAR_ROM_LOAD( sportvp16, "sports trivia (prototype - mar 08, 1995).bin",                        0x000000 , 0x20000,    CRC(c38d41c3) SHA1(d3503a568182f1f286203c2e2a5516f74684f4f3) )
GAMEGEAR_ROM_LOAD( sportvp17, "sports trivia (prototype - mar 09, 1995).bin",                        0x000000 , 0x20000,    CRC(34407fe9) SHA1(c977c038df47192996e05c9db130bf2c82a129ff) )
GAMEGEAR_ROM_LOAD( sportvp18, "sports trivia (prototype - mar 13, 1995).bin",                        0x000000 , 0x40000,    CRC(a8d1ac51) SHA1(58c08b83df499755a47dc8407807bd2f93a58583) )
GAMEGEAR_ROM_LOAD( sportvp19, "sports trivia (prototype - mar 16, 1995 - 1meg).bin",                 0x000000 , 0x20000,    CRC(464f1b51) SHA1(151a9d25a29a41d00d20d9d6a93620682464e037) )
GAMEGEAR_ROM_LOAD( sportvp20, "sports trivia (prototype - mar 16, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(caf87d8b) SHA1(61e215dd6ac4a9ab334210a9d87876222a717e12) )
GAMEGEAR_ROM_LOAD( sportvp21, "sports trivia (prototype - mar 17, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(43bb6b10) SHA1(5b5034d5689bb116ca602ea30a696af60444ced8) )
GAMEGEAR_ROM_LOAD( sportvp22, "sports trivia (prototype - mar 20, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(e7aff566) SHA1(693cc753fc94eb5d79fb0bf0e4cb484dd1fb57f3) )
GAMEGEAR_ROM_LOAD( sportvp23, "sports trivia (prototype - mar 20, 1995 - qtest).bin",                0x000000 , 0x40000,    CRC(a3e57816) SHA1(70e71c0581019c89bd2c38ee45b05bff84fc3eb0) )
GAMEGEAR_ROM_LOAD( sportvp24, "sports trivia (prototype - mar 21, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(18cf6145) SHA1(400a91d37ad6eaf54d2b4057d562876507ea715e) )
GAMEGEAR_ROM_LOAD( sportvp25, "sports trivia (prototype - mar 23, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(27816c09) SHA1(5ad1ed30fcc414b237c6a9057e3f43913c3ebf23) )
GAMEGEAR_ROM_LOAD( sportvp26, "sports trivia (prototype - mar 23, 1995 - algotest).bin",             0x000000 , 0x40000,    CRC(9a8ad5ca) SHA1(7a9dfd2ca7ecba07ef141ad9f2428052b441e200) )
GAMEGEAR_ROM_LOAD( sportvp27, "sports trivia (prototype - mar 23, 1995 - qtest).bin",                0x000000 , 0x40000,    CRC(acb7e580) SHA1(227f12188ceaa0577cd6604804d1228e342c67a2) )
GAMEGEAR_ROM_LOAD( sportvp28, "sports trivia (prototype - mar 27, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(517bd817) SHA1(3ae00363f54b73c47d6e6125e3a7d3741f33fccf) )
GAMEGEAR_ROM_LOAD( sportvp29, "sports trivia (prototype - mar 27, 1995 - algotest).bin",             0x000000 , 0x40000,    CRC(511b1d24) SHA1(b7ba8f1c6ec2958da3a040ab56f9915f13723a70) )
GAMEGEAR_ROM_LOAD( sportvp30, "sports trivia (prototype - mar 29, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(e906fbd8) SHA1(3410bafb1757988f1cb270745dfa9ac22212539b) )
GAMEGEAR_ROM_LOAD( sportvp31, "sports trivia (prototype - mar 29, 1995 - algotest).bin",             0x000000 , 0x40000,    CRC(e80459b3) SHA1(cfcb94207728f781602ff8375cda3c2de25b7eed) )
GAMEGEAR_ROM_LOAD( sportvp32, "sports trivia (prototype - mar 29, 1995 - qtest).bin",                0x000000 , 0x40000,    CRC(05047357) SHA1(50cce09ee3c077feaf7ad9df1e2a9f4fde0e7691) )
GAMEGEAR_ROM_LOAD( sportvp33, "sports trivia (prototype - mar 30, 1995 - 2meg - d).bin",             0x000000 , 0x40000,    CRC(302b9b36) SHA1(d462337a78f85882e7ebcb95e129ab18e75e44a4) )
GAMEGEAR_ROM_LOAD( sportvp34, "sports trivia (prototype - mar 30, 1995 - qtest).bin",                0x000000 , 0x40000,    CRC(f3f9a87b) SHA1(0ac64a9077ddcb53d2d35748f13b9d462f27ab51) )
GAMEGEAR_ROM_LOAD( sportvp35, "sports trivia (prototype - may 02, 1995 - 2meg).bin",                 0x000000 , 0x40000,    CRC(15e7e261) SHA1(03b4e8d8afc14d8df113043c3d53130df6eb769e) )
GAMEGEAR_ROM_LOAD( sportvp36, "sports trivia (prototype - may 04, 1995 - 1meg).bin",                 0x000000 , 0x20000,    CRC(bba4cf7b) SHA1(7c17382789e6648019e99fb8feca84535f50ae4f) )
GAMEGEAR_ROM_LOAD( sporttrv, "sports trivia (usa).bin",                                              0x000000 , 0x20000,    CRC(a7af7ca9) SHA1(7787c8f0178829fc2ce25930ad91f0b712fa3625) )
GAMEGEAR_ROM_LOAD( sprtrvce, "sports trivia - championship edition (usa, europe).bin",               0x000000 , 0x40000,    CRC(5b5de94d) SHA1(f2542d122570fad8d2f91aae8ef074e58487ede0) )
GAMEGEAR_ROM_LOAD( stng, "star trek - the next generation - the advanced holodeck tutorial (usa).bin", 0x000000 , 0x40000,    CRC(80156323) SHA1(a508ff0ea93390e42e2440ed4aca531047281c23) )
GAMEGEAR_ROM_LOAD( strekg, "star trek generations - beyond the nexus (usa, europe).bin",             0x000000 , 0x40000,    CRC(087fc5f0) SHA1(307e4956fd0d50f3732215574957b040937bbfca) )
GAMEGEAR_ROM_LOAD( starwars, "star wars (europe).bin",                                               0x000000 , 0x80000,    CRC(db9bc599) SHA1(682df750f372134734d8668f08b9a5acbb4f2cfd) )
GAMEGEAR_ROM_LOAD( starwarsu, "star wars (usa).bin",                                                 0x000000 , 0x80000,    CRC(0228769c) SHA1(48c14c0c2b4e38ac122d9ccdcdc8b194e15ef032) )
GAMEGEAR_ROM_LOAD( stargate, "stargate (world).bin",                                                 0x000000 , 0x40000,    CRC(fc7c64e4) SHA1(011fd49600eaef8be7cbe35ab6eeb4e1554d836c) )
GAMEGEAR_ROM_LOAD( sor, "streets of rage (world).bin",                                               0x000000 , 0x40000,    CRC(3d8bcf1d) SHA1(ca8c8a00ee838e994b2fa17e595ddd40d898cf42) )
GAMEGEAR_ROM_LOAD( sor2, "streets of rage ii (world).bin",                                           0x000000 , 0x80000,    CRC(0b618409) SHA1(2804b355347bda6e2903078ba30ed6b3a289ebba) )
GAMEGEAR_ROM_LOAD( striker	, "striker (europe) (en,fr,de,es,it).bin",                             0x000000 , 0x80000,    CRC(b421c057) SHA1(dc51ed36b12d1a943bcf79d9ab246505a190f795) )
GAMEGEAR_ROM_LOAD( suprbtnk, "super battletank (usa).bin",                                           0x000000 , 0x40000,    CRC(73d6745a) SHA1(f827545cccd5360552e839a377c1b886e6c80176) )
GAMEGEAR_ROM_LOAD( supercolj, "super columns (japan).bin",                                           0x000000 , 0x20000,    CRC(2a100717) SHA1(a1de915b0f10894bedc6ee8f0fd1f2da65bcfa68) )
GAMEGEAR_ROM_LOAD( supercolp, "super columns (prototype - dec 01, 1994).bin",                        0x000000 , 0x20000,    CRC(56cf1d4f) SHA1(29dac0da809c8a74c6610e4dde300efaddaca29a) )
GAMEGEAR_ROM_LOAD( supercolp1, "super columns (prototype - dec 15, 1994).bin",                       0x000000 , 0x20000,    CRC(abe92434) SHA1(3edad6d335d5f6ec3dc403fd642cd6a71e3c053d) )
GAMEGEAR_ROM_LOAD( supercolp2, "super columns (prototype - dec 21, 1994).bin",                       0x000000 , 0x20000,    CRC(81451fc0) SHA1(b7cabe08f0e0850b055fd0e694e175e8f1c47e4d) )
GAMEGEAR_ROM_LOAD( supercolp3, "super columns (prototype - dec 26, 1994).bin",                       0x000000 , 0x20000,    CRC(5c4c633d) SHA1(d3050de383e772bb068d4c722bbe91ff05172d45) )
GAMEGEAR_ROM_LOAD( supercolp4, "super columns (prototype - dec 28, 1994).bin",                       0x000000 , 0x20000,    CRC(3d931952) SHA1(b2bc04e1f7a00ec5431774db0b47da53db57d3a3) )
GAMEGEAR_ROM_LOAD( supercolp5, "super columns (prototype - jan 06, 1995).bin",                       0x000000 , 0x20000,    CRC(096f4ff5) SHA1(fed437cf7d22c685fef7b2e55579cd77bb48e232) )
GAMEGEAR_ROM_LOAD( supercolp6, "super columns (prototype - nov 11, 1994).bin",                       0x000000 , 0x20000,    CRC(f28f89d1) SHA1(e5b23a687c9dd285970f4783369e36c7a96d19fa) )
GAMEGEAR_ROM_LOAD( supercol, "super columns (usa, europe).bin",                                      0x000000 , 0x20000,    CRC(8ba43af3) SHA1(ce59845e973b7fb7b3b2121b35a95fba5727df62) )
GAMEGEAR_ROM_LOAD( superglf, "super golf (japan).bin",                                               0x000000 , 0x20000,    CRC(528cbbce) SHA1(9ecb48513621086ec6d5bffa1375914f21f393e4) )
GAMEGEAR_ROM_LOAD( suprkick, "super kick off (japan).bin",                                           0x000000 , 0x40000,    CRC(10dbbef4) SHA1(cb4a08b89cc24154328309cab54bfd9d83e4754f) )
GAMEGEAR_ROM_LOAD( supermd2, "super momotarou dentetsu iii (japan).bin",                             0x000000 , 0x80000,    CRC(b731bb80) SHA1(f62e0e433987f97143282d2526490cd45f3e7185) )
GAMEGEAR_ROM_LOAD( smgpj, "super monaco gp (japan).bin",                                             0x000000 , 0x20000,    CRC(4f686c4a) SHA1(2a61491785ad56f5bdc504c994f36ee8ea9dcf68) )
GAMEGEAR_ROM_LOAD( smgp, "super monaco gp (usa, europe).bin",                                        0x000000 , 0x20000,    CRC(fcf12547) SHA1(d834e43d7ec6dbadf2e367afd45b7e1e4362035b) )
GAMEGEAR_ROM_LOAD( superoff, "super off road (usa, europe).bin",                                     0x000000 , 0x20000,    CRC(e8b42b1f) SHA1(c5ee89f785c44784867c3b33fd6466fc72e9042c) )
GAMEGEAR_ROM_LOAD( superoffu, "super off-road (u).bin",                                              0x000000 , 0x20000,    CRC(2e217fae) SHA1(0d2fc2fa9e52e24cf0930e47c16e43a7c26adad7) )
GAMEGEAR_ROM_LOAD( suprjedi, "super return of the jedi (usa, europe).bin",                           0x000000 , 0x80000,    CRC(4a38b6b6) SHA1(a37858100903ad1e0224c870fe12419c25df90e0) )
GAMEGEAR_ROM_LOAD( ssmashtv, "super smash t.v. (world).bin",                                         0x000000 , 0x40000,    CRC(1006e4e3) SHA1(85189e29f3f6b94f95723bc75571e9424df119f9) )
GAMEGEAR_ROM_LOAD( ssinv, "super space invaders (usa, europe).bin",                                  0x000000 , 0x40000,    CRC(dfe38e24) SHA1(3864c399f76e67ae4ff40d32a60c36ad16578988) )
GAMEGEAR_ROM_LOAD( stetris, "super tetris (k) [s][!].bin",                                           0x000000 , 0x10000,    CRC(bd1cc7df) SHA1(3772e9dc07b15de62326ee78981ec0b6f4387590) )
GAMEGEAR_ROM_LOAD( superman, "superman - the man of steel (europe).bin",                             0x000000 , 0x40000,    CRC(73df5a15) SHA1(8e0d837cf285d8669d30ef1328453949cea70a6a) )
GAMEGEAR_ROM_LOAD( surfninj, "surf ninjas (usa).bin",                                                0x000000 , 0x80000,    CRC(284482a8) SHA1(23e493f7c19ffb17e67392289c5a72dc9d0d6d9e) )
GAMEGEAR_ROM_LOAD( sylvan, "sylvan tale (japan).bin",                                                0x000000 , 0x80000,    CRC(45ef2062) SHA1(bec44ab675bcd6b081590d4d52b6af4076c342e6) )
GAMEGEAR_ROM_LOAD( t2ag, "t2 - the arcade game (usa, europe).bin",                                   0x000000 , 0x80000,    CRC(9479c83a) SHA1(12b6f5542b6cebfe872096eab2a885d297eefa2f) )
GAMEGEAR_ROM_LOAD( tailsadv, "tails adventures (world) (en,ja).bin",                                 0x000000 , 0x80000,    CRC(5bb6e5d6) SHA1(da3df145b8e9f2a2e680d2c92939084d4530ed90) )
GAMEGEAR_ROM_LOAD( tailskyp, "tails no skypatrol (japan).bin",                                       0x000000 , 0x40000,    CRC(88618afa) SHA1(9cb440611e9e3a7957438698fede0978d568a807) )
GAMEGEAR_ROM_LOAD( taisnmj, "taisen mahjong haopai (japan).bin",                                     0x000000 , 0x20000,    CRC(cf9c607c) SHA1(9cd50acaab1c2452e5a231e1a5646c3c38b50d9c) )
GAMEGEAR_ROM_LOAD( taisnmj2, "taisen mahjong haopai 2 (japan).bin",                                  0x000000 , 0x80000,    CRC(20527530) SHA1(8dfd49a2e740a232efc52ceefc85f51cf292d75e) )
GAMEGEAR_ROM_LOAD( taisendg, "taisen-gata daisenryaku g (japan).bin",                                0x000000 , 0x40000,    CRC(7b7717b8) SHA1(d290bba12f4b7341c3ce2a00be8b8d7e548327e1) )
GAMEGEAR_ROM_LOAD( chasehq, "chase h.q. (j) [s][!].bin",                                            0x000000 , 0x20000,    CRC(44fbe8f6) SHA1(cc8e0d3a9826348bbb90ebcc5021b4e2e909965f) )
GAMEGEAR_ROM_LOAD( chasehq1, "taito chase h.q. (japan).bin",                                          0x000000 , 0x20000,    CRC(7bb81e3d) SHA1(b757b45a07ae6530443862e0eca547e16c23b4a3) )
GAMEGEAR_ROM_LOAD( talespin, "tale spin (usa, europe).bin",                                          0x000000 , 0x40000,    CRC(f1732ffe) SHA1(60e5c27a07a69969ea1ba830cc82df33a5fbf227) )
GAMEGEAR_ROM_LOAD( tamalymp, "tama & friends sanchoume kouen - tamalympic (japan).bin",              0x000000 , 0x40000,    CRC(dd1d2ebf) SHA1(c8bf11726a152a88f2b1d900bbd974775a8e608b) )
GAMEGEAR_ROM_LOAD( tarot, "tarot no yakata (japan).bin",                                             0x000000 , 0x20000,    CRC(57834c03) SHA1(b8b45b2e59f5d3239984205c120421923d833505) )
GAMEGEAR_ROM_LOAD( tarzan, "tarzan - lord of the jungle (europe).bin",                               0x000000 , 0x40000,    CRC(ef3afe8b) SHA1(a787db71f221c71a89f39c6c3a153c43d6d5555a) )
GAMEGEAR_ROM_LOAD( tatakae, "tatakae! pro yakyuu twin league (japan).bin",                           0x000000 , 0x80000,    CRC(bec57602) SHA1(8c629941ae7077862dd516283c656b5212920936) )
GAMEGEAR_ROM_LOAD( tazmarsp, "taz in escape from mars (prototype - aug 10, 1994).bin",               0x000000 , 0x80000,    CRC(92388016) SHA1(ed5a66c278fc429fd4ddb993c4a7bdf2d2400a3a) )
GAMEGEAR_ROM_LOAD( tazmarspa, "taz in escape from mars (prototype - aug 12, 1994).bin",              0x000000 , 0x80000,    CRC(a43fdfad) SHA1(6482e281447b586c533a45527db52bd5c333ebdd) )
GAMEGEAR_ROM_LOAD( tazmarspb, "taz in escape from mars (prototype - aug 14, 1994).bin",              0x000000 , 0x80000,    CRC(9267d968) SHA1(8800da06ea2aa3982cf2e294b165f5e1a9cab63c) )
GAMEGEAR_ROM_LOAD( tazmarspc, "taz in escape from mars (prototype - aug 15, 1994).bin",              0x000000 , 0x80000,    CRC(9267d968) SHA1(8800da06ea2aa3982cf2e294b165f5e1a9cab63c) )
GAMEGEAR_ROM_LOAD( tazmarspd, "taz in escape from mars (prototype - aug 19, 1994).bin",              0x000000 , 0x80000,    CRC(57747640) SHA1(d32127a67f988062407d92bb1dfdf3ce38210e31) )
GAMEGEAR_ROM_LOAD( tazmarspe, "taz in escape from mars (prototype - aug 23, 1994).bin",              0x000000 , 0x80000,    CRC(6cd0fd78) SHA1(9cc498d9975fa2633a4ec98581768856884163a8) )
GAMEGEAR_ROM_LOAD( tazmarspf, "taz in escape from mars (prototype - aug 29, 1994 - b).bin",          0x000000 , 0x80000,    CRC(3c03919d) SHA1(b1b5f7b06001f38e0533bc489b5c7f8b9caf6a5b) )
GAMEGEAR_ROM_LOAD( tazmarspg, "taz in escape from mars (prototype - aug 30, 1994).bin",              0x000000 , 0x80000,    CRC(09679b89) SHA1(20c0398e036f733734d2d38e8d2e3e57a1086106) )
GAMEGEAR_ROM_LOAD( tazmarsph, "taz in escape from mars (prototype - may 11, 1994).bin",              0x000000 , 0x40000,    CRC(030f396a) SHA1(47b98ee8dfe407bac65fd02257e99221feb088fc) )
GAMEGEAR_ROM_LOAD( tazmarspi, "taz in escape from mars (prototype - sep 02, 1994).bin",              0x000000 , 0x80000,    CRC(18913d93) SHA1(afca21f4f5337540343b6c74f36d6b2d0c9ca6c9) )
GAMEGEAR_ROM_LOAD( tazmarspj, "taz in escape from mars (prototype - sep 05, 1994 - b).bin",          0x000000 , 0x80000,    CRC(d84a631c) SHA1(02b726d8c0da2f51076ad95ddc750d423636a807) )
GAMEGEAR_ROM_LOAD( tazmarspk, "taz in escape from mars (prototype - sep 05, 1994 - c).bin",          0x000000 , 0x80000,    CRC(61330a58) SHA1(b383c0e67e47bb1b6f2402948408da1d5418c354) )
GAMEGEAR_ROM_LOAD( tazmarspl, "taz in escape from mars (prototype - sep 06, 1994 - d).bin",          0x000000 , 0x80000,    CRC(1f040bca) SHA1(5fb66139767319777153faddbdfdb1168f898546) )
GAMEGEAR_ROM_LOAD( tazmarspm, "taz in escape from mars (prototype - sep 09, 1994 - b).bin",          0x000000 , 0x80000,    CRC(c867da05) SHA1(c3cbe41444dadd60a0f79af213a50eab552f083f) )
GAMEGEAR_ROM_LOAD( tazmarspn, "taz in escape from mars (prototype - sep 10, 1994).bin",              0x000000 , 0x80000,    CRC(faf4bec0) SHA1(3d0da9536c47ecad367a83a6645172cee46b2ca8) )
GAMEGEAR_ROM_LOAD( tazmars, "taz in escape from mars (usa, europe).bin",                             0x000000 , 0x80000,    CRC(eebad66b) SHA1(1d19306b7dbcb37fd1ab62021b5054efd2d04889) )
GAMEGEAR_ROM_LOAD( tazmania, "taz-mania - the search for the lost seabirds (usa, europe).bin",       0x000000 , 0x40000,    CRC(36040c24) SHA1(0d0285bc5350146f365dae1f271ed0828971cf4d) )
GAMEGEAR_ROM_LOAD( tempojrp, "tempo jr. (prototype - dec 05, 1994).bin",                             0x000000 , 0x80000,    CRC(3475d48e) SHA1(c86b63d669464cba8bf167c33cfa8dc5bf1625b4) )
GAMEGEAR_ROM_LOAD( tempojrp1, "tempo jr. (prototype - dec 12, 1994).bin",                            0x000000 , 0x80000,    CRC(fb9a5885) SHA1(6112068a8b6ad0e34afc2d576c2ef7e95af32c6d) )
GAMEGEAR_ROM_LOAD( tempojrp2, "tempo jr. (prototype - dec 26, 1994).bin",                            0x000000 , 0x80000,    CRC(e484e41c) SHA1(9fb56c4cb39f48bdfb6a16a7af40b85888d81b3b) )
GAMEGEAR_ROM_LOAD( tempojrp3, "tempo jr. (prototype - feb 06, 1995).bin",                            0x000000 , 0x80000,    CRC(3ef6551c) SHA1(f3a25425c939a3190c15a1c35a86cde116dcc5ea) )
GAMEGEAR_ROM_LOAD( tempojrp4, "tempo jr. (prototype - feb 15, 1995).bin",                            0x000000 , 0x80000,    CRC(79e83d67) SHA1(bb2cfeb11e0319021a83a63556bd5e4f98e3d217) )
GAMEGEAR_ROM_LOAD( tempojrp5, "tempo jr. (prototype - jan 17, 1995).bin",                            0x000000 , 0x80000,    CRC(ab6dc88c) SHA1(987bbf9f394a3aa7e79a95b847b093e45d532296) )
GAMEGEAR_ROM_LOAD( tempojrp6, "tempo jr. (prototype - jan 20, 1995).bin",                            0x000000 , 0x80000,    CRC(96d64b16) SHA1(01a81e62f04759993d1fb865aa5f7feb086e15ec) )
GAMEGEAR_ROM_LOAD( tempojrp7, "tempo jr. (prototype - jan 31, 1995).bin",                            0x000000 , 0x80000,    CRC(7afedf36) SHA1(75a0914f97622c3f148b7874a8b8ce564a150eae) )
GAMEGEAR_ROM_LOAD( tempojrp8, "tempo jr. (prototype - nov 28, 1994).bin",                            0x000000 , 0x80000,    CRC(a33b5b92) SHA1(d909b2b153e500c506a5cee3439d3c514c58600b) )
GAMEGEAR_ROM_LOAD( tempojr, "tempo jr. (world).bin",                                                 0x000000 , 0x80000,    CRC(de466796) SHA1(a2d800d2836a03f81dd8f3dda23cd2d8bfff18a5) )
GAMEGEAR_ROM_LOAD( tengenwc, "tengen world cup soccer (usa, europe).bin",                            0x000000 , 0x40000,    CRC(dd6d2e34) SHA1(8e1beab60e120924656d8a741a38b112abd7ef97) )
GAMEGEAR_ROM_LOAD( t2jd, "terminator 2 - judgment day (usa, europe).bin",                            0x000000 , 0x40000,    CRC(1bd15773) SHA1(833c94ea65a7c36349b2bb0b2b637116f54a6762) )
GAMEGEAR_ROM_LOAD( termntr, "terminator, the (usa, europe).bin",                                     0x000000 , 0x40000,    CRC(c029a5fd) SHA1(1889d019bd9f5919517805a2e02a9691de5ef634) )
GAMEGEAR_ROM_LOAD( tesserae, "tesserae (usa, europe).bin",                                           0x000000 , 0x20000,    CRC(ca0e11cc) SHA1(2b2652c7e03218b212e4d6a6246bd70e925e7ee1) )
GAMEGEAR_ROM_LOAD( tintin, "tintin in tibet (europe) (en,fr,de,es,nl,sv).bin",                       0x000000 , 0x80000,    CRC(969cf389) SHA1(2fdf4a953b53578befd69e9477ac6148cfa1c67c) )
GAMEGEAR_ROM_LOAD( tomjermv, "tom and jerry - the movie (usa).bin",                                  0x000000 , 0x40000,    CRC(5cd33ff2) SHA1(514f8bc2e9306f4005d5a8aa2dc49304d48bfc82) )
GAMEGEAR_ROM_LOAD( torarete, "torarete tamaruka (japan).bin",                                        0x000000 , 0x80000,    CRC(5bcf9b97) SHA1(fa87ac6b14c4b9eaa91fa8e4550b3c9049dd8ef2) )
GAMEGEAR_ROM_LOAD( truelies, "true lies (world).bin",                                                0x000000 , 0x80000,    CRC(5173b02a) SHA1(7ee525e68b9f3bca2a5bdd6de14711108dcbc288) )
GAMEGEAR_ROM_LOAD( ultimate, "ultimate soccer (japan, europe) (en,fr,de,es,it).bin",                 0x000000 , 0x40000,    CRC(820965a3) SHA1(7994621926628d2376a75e8d90cd066d48a4d502) )
GAMEGEAR_ROM_LOAD( ustrike, "urban strike (usa, europe).bin",                                        0x000000 , 0x80000,    CRC(185e9fc1) SHA1(2d33d049a7f3dcde8c4f294cca5597ca590bb407) )
GAMEGEAR_ROM_LOAD( vampir, "vampire - master of darkness (usa).bin",                                 0x000000 , 0x40000,    CRC(7ec64025) SHA1(14e6b1e886355d902b34acdf503eced8df88afe4) )
GAMEGEAR_ROM_LOAD( vfa, "virtua fighter animation (usa, europe).bin",                                0x000000 , 0x100000,   CRC(d431c452) SHA1(222f3e49f595ceb4263af329c4021d64fc4772e6) )
GAMEGEAR_ROM_LOAD( vfmini, "virtua fighter mini (japan).bin",                                        0x000000 , 0x100000,   CRC(c05657f8) SHA1(b0622ef2e58fc38af35ead0a632babc4bfe49e86) )
GAMEGEAR_ROM_LOAD( vrtroop, "vr troopers (usa, europe).bin",                                         0x000000 , 0x80000,    CRC(b0f22745) SHA1(0986935cee44541c1e24bcd4dc3d9f87f324bbbe) )
GAMEGEAR_ROM_LOAD( waganlnd, "wagan land (japan).bin",                                               0x000000 , 0x40000,    CRC(29e697b2) SHA1(6b74f3fddabd52ac6bb1b812043537154f8a43c5) )
GAMEGEAR_ROM_LOAD( waganlnd1, "wagan land (j) [a1].bin",                                             0x000000 , 0x40000,    CRC(d5369192) SHA1(1f5e511f6230797ef163b587f1988f097e795a61) )
GAMEGEAR_ROM_LOAD( wheelof, "wheel of fortune (usa).bin",                                            0x000000 , 0x20000,    CRC(e91cdb2a) SHA1(5d3ce8b008e81bdda2e12b8036b4efb6dff69b9f) )
GAMEGEAR_ROM_LOAD( wimbledn, "wimbledon (world).bin",                                                0x000000 , 0x20000,    CRC(ce1108fd) SHA1(6aa588e0aa93c5c74c80f7044de49933291af4e9) )
GAMEGEAR_ROM_LOAD( winterolj, "winter olympics - lillehammer '94 (japan) (en,fr,de,es,it,pt,sv,no).bin",0x000000 , 0x80000,    CRC(d5195a39) SHA1(578fc35fe155dca2c9adf17464d23aaf8205148f) )
GAMEGEAR_ROM_LOAD( winterol, "winter olympics - lillehammer '94 (usa, europe) (en,fr,de,es,it,pt,sv,no).bin",              0x000000 , 0x80000,    CRC(d15d335b) SHA1(6f9942792072626f1322e11835dbc5e2e94aa718) )
GAMEGEAR_ROM_LOAD( wizard, "wizard pinball (europe).bin",                                            0x000000 , 0x40000,    CRC(9e03f96c) SHA1(22c4165f41066d9a525543d716162bd70a39e9fb) )
GAMEGEAR_ROM_LOAD( wolfch, "wolfchild (europe).bin",                                                 0x000000 , 0x40000,    CRC(840a8f8e) SHA1(7889b67ee0e5c884fa267688aad4b6c23849268c) )
GAMEGEAR_ROM_LOAD( wboy, "wonder boy (europe).bin",                                                  0x000000 , 0x20000,    CRC(ea2dd3a7) SHA1(f2c546bc87c5e89719fe01a59142bb3250861b83) )
GAMEGEAR_ROM_LOAD( wboyj, "wonder boy (japan).bin",                                                  0x000000 , 0x20000,    CRC(9977fcb3) SHA1(7ff0f0757c7b2e84d99a4291656d74a20ec2651d) )
GAMEGEAR_ROM_LOAD( wboydtrap, "wonder boy - the dragon's trap (europe).bin",                         0x000000 , 0x40000,    CRC(a74c97a7) SHA1(d98344a2c644ce9a0184e8f836271c038aa16a23) )
GAMEGEAR_ROM_LOAD( wboydtrapb, "wonder boy iii - the dragon's trap (europe) (beta).bin",             0x000000 , 0x40000,    CRC(db1b5b44) SHA1(5108c4920b4a14fd06f1a024e1be5f6bf233bd84) )
GAMEGEAR_ROM_LOAD( woodypop, "woody pop (usa, europe) (v1.1).bin",                                   0x000000 , 0x8000,    CRC(b74f3a4f) SHA1(4efbfa1d3234d8f1800a06ab72b2177fba6914cb) )
GAMEGEAR_ROM_LOAD( woodypop1, "woody pop (usa, europe).bin",                                         0x000000 , 0x8000,    CRC(9c0e5a04) SHA1(9e7defda6873b7bca5650fad4426a6fb443522d8) )
GAMEGEAR_ROM_LOAD( wclead, "world class leader board (usa, europe).bin",                             0x000000 , 0x40000,    CRC(868fe528) SHA1(23b28cf137adc947ffd1af649cf3c8d64e6fadc1) )
GAMEGEAR_ROM_LOAD( wcup94, "world cup usa 94 (usa, europe) (en,fr,de,es,it,nl,pt,sv).bin",           0x000000 , 0x80000,    CRC(d2bb3690) SHA1(5596ecb5b7a28027e5c0ad1c8acc73c45e7a1265) )
GAMEGEAR_ROM_LOAD( wderby, "world derby (japan).bin",                                                0x000000 , 0x80000,    CRC(1e81861f) SHA1(af96e8d9470df941c7c356cc9b6e143a3c44dd86) )
GAMEGEAR_ROM_LOAD( worlds95p1, "world series baseball '95 (prototype - jul 09, 1994).bin",           0x000000 , 0x80000,    CRC(410f1ca0) SHA1(a1f06ac03e229b6be08e995365bf6ffda0b32184) )
GAMEGEAR_ROM_LOAD( worlds95p2, "world series baseball '95 (prototype - jul 19, 1994).bin",           0x000000 , 0x80000,    CRC(5f7cca5f) SHA1(7b9750f398f1bab2a6d10df58e610a4ce59287bb) )
GAMEGEAR_ROM_LOAD( worlds95p3, "world series baseball '95 (prototype - jul 22, 1994).bin",           0x000000 , 0x80000,    CRC(6073cd59) SHA1(149f8d34be9f2cfc080f5e192712a134656d12f3) )
GAMEGEAR_ROM_LOAD( worlds95p4, "world series baseball '95 (prototype - jul 28, 1994).bin",           0x000000 , 0x80000,    CRC(4190ad97) SHA1(fddf978dc5c29ca234080fff32680fbf66d7be2c) )
GAMEGEAR_ROM_LOAD( worlds95p5, "world series baseball '95 (prototype - jul 29, 1994).bin",           0x000000 , 0x80000,    CRC(f1987de6) SHA1(5ba283dff711ad4a32d52aa077829dda43d52eaa) )
GAMEGEAR_ROM_LOAD( worlds95p6, "world series baseball '95 (prototype - jun 29, 1994).bin",           0x000000 , 0x80000,    CRC(496515a6) SHA1(3e05e8b9628853d05aef16a6b7d09e307c989548) )
GAMEGEAR_ROM_LOAD( worlds95, "world series baseball '95 (usa).bin",                                  0x000000 , 0x80000,    CRC(578a8a38) SHA1(66d31ed6bb6dfedd769bf5e6c5dcbf899f2f2c8c) )
GAMEGEAR_ROM_LOAD( worldsb, "world series baseball (usa) (v1.1).bin",                                0x000000 , 0x40000,    CRC(bb38cfd7) SHA1(333dd99f11781d6de5720043530a460a409d652b) )
GAMEGEAR_ROM_LOAD( worldsb1, "world series baseball (usa).bin",                                      0x000000 , 0x40000,    CRC(3d8d0dd6) SHA1(ccfd03edf130f28e6bb4c2764df7ace7bbe9e159) )
GAMEGEAR_ROM_LOAD( wwfraw, "wwf raw (usa, europe).bin",                                              0x000000 , 0x80000,    CRC(8dc68d92) SHA1(585e147026bd998062e64ed3c0aaa0a07e6ee734) )
GAMEGEAR_ROM_LOAD( wwfwre, "wwf wrestlemania steel cage challenge (europe).bin",                     0x000000 , 0x40000,    CRC(da8e95a9) SHA1(59e2fab18a0244efcc9cb9ad1e4ed3a1c777948d) )
GAMEGEAR_ROM_LOAD( xmen, "x-men (usa).bin",                                                          0x000000 , 0x80000,    CRC(567a5ee6) SHA1(215e5f761475ca17a091371e39f636718f213403) )
GAMEGEAR_ROM_LOAD( xmengamlp1, "x-men - gamemaster's legacy (prototype - aug 10, 1994).bin",         0x000000 , 0x80000,    CRC(66cc4034) SHA1(46237cf1c2810a8f2e5c31907a1ae04b647256c8) )
GAMEGEAR_ROM_LOAD( xmengamlp2, "x-men - gamemaster's legacy (prototype - aug 15, 1994).bin",         0x000000 , 0x80000,    CRC(66cc4034) SHA1(46237cf1c2810a8f2e5c31907a1ae04b647256c8) )
GAMEGEAR_ROM_LOAD( xmengamlp3, "x-men - gamemaster's legacy (prototype 36 - aug 31, 1994).bin",      0x000000 , 0x80000,    CRC(271a0a1d) SHA1(9df11129d4f7e55a1380b139d1bb0cdb4137a702) )
GAMEGEAR_ROM_LOAD( xmengamlp4, "x-men - gamemaster's legacy (prototype 51 - sep 06, 1994).bin",      0x000000 , 0x80000,    CRC(a3cf94ba) SHA1(1078ef9c16cb997f61eddbd07c1bfbc5f74b177b) )
GAMEGEAR_ROM_LOAD( xmengaml, "x-men - gamemaster's legacy (usa, europe).bin",                        0x000000 , 0x80000,    CRC(c169c344) SHA1(872596d40aae1755c9dda99180cb165166267904) )
GAMEGEAR_ROM_LOAD( xmenmojop1, "x-men - mojo world (prototype - jun 05, 1996).bin",                  0x000000 , 0x80000,    CRC(626f9987) SHA1(b9a4d3bd1f33a988b48fdffedabd26ddaf7d7ab5) )
GAMEGEAR_ROM_LOAD( xmenmojop2, "x-men - mojo world (prototype - jun 13, 1996).bin",                  0x000000 , 0x80000,    CRC(c4f3ced4) SHA1(eb9646133ca49838c7d559492f1a059398abe34f) )
GAMEGEAR_ROM_LOAD( xmenmojop3, "x-men - mojo world (prototype - jun 24, 1996).bin",                  0x000000 , 0x80000,    CRC(78001a5d) SHA1(e7d3af2bb027af159d02eb85b8810438af59c8dd) )
GAMEGEAR_ROM_LOAD( xmenmojop4, "x-men - mojo world (prototype - jun 25, 1996).bin",                  0x000000 , 0x80000,    CRC(d4d2f077) SHA1(3ade7aeea0d0d5e65d4da24021b565de891e45a8) )
GAMEGEAR_ROM_LOAD( xmenmojop5, "x-men - mojo world (prototype - jun 27, 1996).bin",                  0x000000 , 0x80000,    CRC(425ac73f) SHA1(5690f9609c641ea7718ddb8e7c36342eeb4a25dd) )
GAMEGEAR_ROM_LOAD( xmenmojop6, "x-men - mojo world (prototype - jun 28, 1996).bin",                  0x000000 , 0x80000,    CRC(d44925ea) SHA1(97fce993a317cbc09825849a45bc2c2ab3e97179) )
GAMEGEAR_ROM_LOAD( xmenmojop7, "x-men - mojo world (prototype - jun 29, 1996).bin",                  0x000000 , 0x80000,    CRC(ba71da19) SHA1(cc3fc3b57bcd4daea90a572c935013d286ebbb99) )
GAMEGEAR_ROM_LOAD( xmenmojo, "x-men - mojo world (usa, europe).bin",                                 0x000000 , 0x80000,    CRC(c2cba9d7) SHA1(cff15c4a3e555c2868af93c55386b5ab3d3db4e3) )
GAMEGEAR_ROM_LOAD( yogibear, "yogi bear in yogi bear's goldrush (unknown) (proto).bin",              0x000000 , 0x40000,    CRC(e678f264) SHA1(ea5f9ce4b3618565ea24a858f7efe3988b82eb8a) )
GAMEGEAR_ROM_LOAD( yuyuhaku, "yu yu hakusho - horobishimono no gyakushuu (japan).bin",               0x000000 , 0x80000,    CRC(88ebbf9e) SHA1(e75803c9241094f7cfe251b99cd370228cc0923c) )
GAMEGEAR_ROM_LOAD( yuyuhak2, "yu yu hakusho 2 - gekitou! nanakyou no tatakai (japan).bin",           0x000000 , 0x80000,    CRC(46ae9159) SHA1(140efe67e886f52aeda2089a73599f7680c89f24) )
GAMEGEAR_ROM_LOAD( zangear, "zan gear (japan).bin",                                                  0x000000 , 0x20000,    CRC(141aaf96) SHA1(115074a58606720755364eaf0a4bc60aabf18f94) )
GAMEGEAR_ROM_LOAD( zool, "zool (usa).bin",                                                           0x000000 , 0x40000,    CRC(b287c695) SHA1(8143c1d5e6c677ae5dd8143620b9fd02be8873f6) )
GAMEGEAR_ROM_LOAD( zoolj, "zool no yume bouken (japan).bin",                                         0x000000 , 0x40000,    CRC(e35ef7ed) SHA1(2c799ee084b858cb71cfaa7a3f6d3a4f364b6c43) )
GAMEGEAR_ROM_LOAD( zoop, "zoop (europe).bin",                                                        0x000000 , 0x20000,    CRC(f397f041) SHA1(f704412387c1fe91d94d2c1405f8a49768320d0c) )
GAMEGEAR_ROM_LOAD( zoopu, "zoop (usa).bin",                                                          0x000000 , 0x20000,    CRC(3247ff8b) SHA1(f58359ffa7bc3ec82913be128d141e5d41926b88) )



SOFTWARE_LIST_START( gamegear_cart )
	SOFTWARE( 5in1fun, 0       , 199?, "Sega License", "5 in 1 Funpak"REGION_U, 0, 0 )
	SOFTWARE( aaharima, 0       , 199?, "Sega License", "Aa Harimanada"REGION_J, 0, 0 )
	SOFTWARE( addamfam, 0       , 199?, "Sega License", "The Addams Family"REGION_W, 0, 0 )
	SOFTWARE( advbatmrp1, advbatmr, 199?, "Sega License", "The Adventures of Batman & Robin (Prototype - Apr 27, 1995)", 0, 0 )
	SOFTWARE( advbatmrp2, advbatmr, 199?, "Sega License", "The Adventures of Batman & Robin (Prototype - Apr 29, 1995 - A)", 0, 0 )
	SOFTWARE( advbatmrp3, advbatmr, 199?, "Sega License", "The Adventures of Batman & Robin (Prototype - Apr 30, 1995)", 0, 0 )
	SOFTWARE( advbatmrp4, advbatmr, 199?, "Sega License", "The Adventures of Batman & Robin (Prototype - May 02, 1995)", 0, 0 )
	SOFTWARE( advbatmrp5, advbatmr, 199?, "Sega License", "The Adventures of Batman & Robin (Prototype - May 04, 1995)", 0, 0 )
	SOFTWARE( advbatmrp6, advbatmr, 199?, "Sega License", "The Adventures of Batman & Robin (Prototype - May 06, 1995 - B)", 0, 0 )
	SOFTWARE( advbatmrp7, advbatmr, 199?, "Sega License", "The Adventures of Batman & Robin (Prototype - May 06, 1995)", 0, 0 )
	SOFTWARE( advbatmrp8, advbatmr, 199?, "Sega License", "The Adventures of Batman & Robin (Prototype - May 07, 1995)", 0, 0 )
	SOFTWARE( advbatmr, 0       , 199?, "Sega License", "The Adventures of Batman & Robin"REGION_EU, 0, 0 )
	SOFTWARE( aerialasj, aerialas, 199?, "Sega License", "Aerial Assault (v1.1)"REGION_J, 0, 0 )
	SOFTWARE( aerialas, 0       , 199?, "Sega License", "Aerial Assault"REGION_W, 0, 0 )
	SOFTWARE( aladdinj, aladdin, 199?, "Sega License", "Aladdin"REGION_J, 0, 0 )
	SOFTWARE( aladdinp1, aladdin, 199?, "Sega License", "Aladdin (Prototype - Dec 29, 1993)", 0, 0 )
	SOFTWARE( aladdinp2, aladdin, 199?, "Sega License", "Aladdin (Prototype - Jan 11, 1994)", 0, 0 )
	SOFTWARE( aladdinp3, aladdin, 199?, "Sega License", "Aladdin (Prototype - Jan 13, 1994)", 0, 0 )
	SOFTWARE( aladdinp4, aladdin, 199?, "Sega License", "Aladdin (Prototype WITH - Jan 23, 1994)", 0, 0 )
	SOFTWARE( aladdin, 0       , 199?, "Sega License", "Aladdin"REGION_EU, 0, 0 )
	SOFTWARE( alien3, 0       , 199?, "Sega License", "Alien 3"REGION_EU, 0, 0 )
	SOFTWARE( asyndromj, asyndrom, 199?, "Sega License", "Alien Syndrome"REGION_J, 0, 0 )
	SOFTWARE( asyndrom, 0       , 199?, "Sega License", "Alien Syndrome"REGION_EU, 0, 0 )
	SOFTWARE( andreaga, 0       , 199?, "Sega License", "Andre Agassi Tennis"REGION_U, 0, 0 )
	SOFTWARE( arcadecl, 0       , 199?, "Sega License", "Arcade Classics"REGION_U, 0, 0 )
	SOFTWARE( archriv, 0       , 199?, "Sega License", "Arch Rivals"REGION_U, 0, 0 )
	SOFTWARE( arena, 0       , 199?, "Sega License", "Arena"REGION_EU, 0, 0 )
	SOFTWARE( arielmer, 0       , 199?, "Sega License", "Ariel the Little Mermaid"REGION_EU, 0, 0 )
	SOFTWARE( arliel, 0       , 199?, "Sega License", "Arliel - Crystal Densetsu"REGION_J, 0, 0 )
	SOFTWARE( asterix, 0       , 199?, "Sega License", "Asterix (Prototype - Feb 16, 1994)", 0, 0 )
	SOFTWARE( asterixa, 0       , 199?, "Sega License", "Asterix (Prototype - Feb 22, 1994)", 0, 0 )
	SOFTWARE( asterixb, 0       , 199?, "Sega License", "Asterix (Prototype - Jan 25, 1994)", 0, 0 )
	SOFTWARE( asterixc, 0       , 199?, "Sega License", "Asterix (Prototype - Mar 13, 1994)", 0, 0 )
	SOFTWARE( asterixd, 0       , 199?, "Sega License", "Asterix (Prototype - Mar 15, 1994)", 0, 0 )
	SOFTWARE( astergre, 0       , 199?, "Sega License", "Asterix and the Great Rescue (En, Fr, De, Es, It)"REGION_E, 0, 0 )
	SOFTWARE( astergreu, astergre, 199?, "Sega License", "Asterix and the Great Rescue"REGION_U, 0, 0 )
	SOFTWARE( astermis, 0       , 199?, "Sega License", "Asterix and the Secret Mission (En, Fr, De)"REGION_E, 0, 0 )
	SOFTWARE( axbattlr, 0       , 199?, "Sega License", "Ax Battler - A Legend of Golden Axe (v2.4)"REGION_EU, 0, 0 )
	SOFTWARE( axbattlrj, axbattlr, 199?, "Sega License", "Ax Battler - Golden Axe Densetsu (v1.5)"REGION_J, 0, 0 )
	SOFTWARE( ayrtonj, ayrton, 199?, "Sega License", "Ayrton Senna's Super Monaco GP II"REGION_J, 0, 0 )
	SOFTWARE( ayrton, 0       , 199?, "Sega License", "Ayrton Senna's Super Monaco GP II"REGION_EU, 0, 0 )
	SOFTWARE( bakubaku, 0       , 199?, "Sega License", "Baku Baku Animal"REGION_U, 0, 0 )
	SOFTWARE( bakubakuj, 0       , 199?, "Sega License", "Baku Baku Animal - Sekai Shiikugakari Senshu-ken"REGION_J, 0, 0 )
	SOFTWARE( barbie, 0       , 199?, "Sega License", "Barbie Super Model (Unknown) (Proto)", 0, 0 )
	SOFTWARE( bartman, 0       , 199?, "Sega License", "Bartman Meets Radioactive Man"REGION_EU, 0, 0 )
	SOFTWARE( batmanfv, 0       , 199?, "Sega License", "Batman Forever"REGION_W, 0, 0 )
	SOFTWARE( batmanrn, 0       , 199?, "Sega License", "Batman Returns"REGION_W, 0, 0 )
	SOFTWARE( batterup, 0       , 199?, "Sega License", "Batter Up"REGION_EU, 0, 0 )
	SOFTWARE( battlesh, 0       , 199?, "Sega License", "Battleship"REGION_EU, 0, 0 )
	SOFTWARE( btoads, 0       , 199?, "Sega License", "Battletoads"REGION_EJ, 0, 0 )
	SOFTWARE( btoadsu, 0       , 199?, "Sega License", "Battletoads"REGION_U, 0, 0 )
	SOFTWARE( beavis, 0       , 199?, "Sega License", "Beavis and Butt-head"REGION_E, 0, 0 )
	SOFTWARE( beavisu, beavis, 199?, "Sega License", "Beavis and Butt-head"REGION_U, 0, 0 )
	SOFTWARE( berensp, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 01, 1994)", 0, 0 )
	SOFTWARE( berensp1, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 11, 1994 - A)", 0, 0 )
	SOFTWARE( berensp2, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 11, 1994)", 0, 0 )
	SOFTWARE( berensp3, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 12, 1994)", 0, 0 )
	SOFTWARE( berensp4, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 13, 1994)", 0, 0 )
	SOFTWARE( berensp5, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 14, 1994)", 0, 0 )
	SOFTWARE( berensp6, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 19, 1994)", 0, 0 )
	SOFTWARE( berensp7, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 20, 1994)", 0, 0 )
	SOFTWARE( berensp8, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 24, 1994)", 0, 0 )
	SOFTWARE( berensp9, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 25, 1994 - B)", 0, 0 )
	SOFTWARE( beresp10, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 26, 1994 - B)", 0, 0 )
	SOFTWARE( beresp11, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Aug 26, 1994)", 0, 0 )
	SOFTWARE( beresp12, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Jul 15, 1994 - B)", 0, 0 )
	SOFTWARE( beresp13, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Jul 21, 1994)", 0, 0 )
	SOFTWARE( beresp14, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Jul 22, 1994)", 0, 0 )
	SOFTWARE( beresp15, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Jul 27, 1994)", 0, 0 )
	SOFTWARE( beresp16, berens, 199?, "Sega License", "Berenstain Bears (Prototype - Jun 28, 1994)", 0, 0 )
	SOFTWARE( berens, 0       , 199?, "Sega License", "The Berenstain Bears' Camping Adventure"REGION_U, 0, 0 )
	SOFTWARE( berlin, 0       , 199?, "Sega License", "Berlin no Kabe"REGION_J, 0, 0 )
	SOFTWARE( bishou, 0       , 199?, "Sega License", "Bishoujo Senshi Sailor Moon S"REGION_J, 0, 0 )
	SOFTWARE( bonkersp,  bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Dec 03, 1994)", 0, 0 )
	SOFTWARE( bonkersp1, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Dec 05, 1994)", 0, 0 )
	SOFTWARE( bonkersp2, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Dec 07, 1994 - C)", 0, 0 )
	SOFTWARE( bonkersp3, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Dec 08, 1994 - B)", 0, 0 )
	SOFTWARE( bonkersp4, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Dec 08, 1994 - C)", 0, 0 )
	SOFTWARE( bonkersp5, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Dec 11, 1994)", 0, 0 )
	SOFTWARE( bonkersp6, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Dec 12, 1994 - B)", 0, 0 )
	SOFTWARE( bonkersp7, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Dec 12, 1994 - D)", 0, 0 )
	SOFTWARE( bonkersp8, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Nov 15, 1994)", 0, 0 )
	SOFTWARE( bonkersp9, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Nov 21, 1994)", 0, 0 )
	SOFTWARE( bonkrsp10, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Nov 23, 1994)", 0, 0 )
	SOFTWARE( bonkrsp11, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Nov 26, 1994)", 0, 0 )
	SOFTWARE( bonkrsp12, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Nov 29, 1994)", 0, 0 )
	SOFTWARE( bonkrsp13, bonkers, 199?, "Sega License", "Bonkers Wax Up! (Prototype - Oct 31, 1994)", 0, 0 )
	SOFTWARE( bonkers, 0       , 199?, "Sega License", "Bonkers Wax Up!"REGION_EU, 0, 0 )
	SOFTWARE( bramst, 0       , 199?, "Sega License", "Bram Stoker's Dracula"REGION_U, 0, 0 )
	SOFTWARE( bublbobl, 0       , 199?, "Sega License", "Bubble Bobble"REGION_EU, 0, 0 )
	SOFTWARE( bugsbun, 0       , 199?, "Sega License", "Bugs Bunny in Double Trouble"REGION_EU, 0, 0 )
	SOFTWARE( bustamov, 0       , 199?, "Sega License", "Bust-A-Move"REGION_EU, 0, 0 )
	SOFTWARE( busterb, 0       , 199?, "Sega License", "Buster Ball"REGION_J, 0, 0 )
	SOFTWARE( busterf, 0       , 199?, "Sega License", "Buster Fight"REGION_J, 0, 0 )
	SOFTWARE( caesar, 0       , 199?, "Sega License", "Caesars Palace"REGION_U, 0, 0 )
	SOFTWARE( captaven, 0       , 199?, "Sega License", "Captain America and the Avengers"REGION_EU, 0, 0 )
	SOFTWARE( carlicen, 0       , 199?, "Sega License", "Car Licence"REGION_J, 0, 0 )
	SOFTWARE( casino, 0       , 199?, "Sega License", "Casino Funpak"REGION_U, 0, 0 )
	SOFTWARE( castlill, 0       , 199?, "Sega License", "Castle of Illusion Starring Mickey Mouse (USA, Europe) (SMS Mode?)", 0, 0 )
	SOFTWARE( chakan, 0       , 199?, "Sega License", "Chakan"REGION_EU, 0, 0 )
	SOFTWARE( chessmst, 0       , 199?, "Sega License", "The Chessmaster"REGION_EU, 0, 0 )
	SOFTWARE( chicagop,  chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jul 03, 1995)", 0, 0 )
	SOFTWARE( chicagop1, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jul 05, 1995)", 0, 0 )
	SOFTWARE( chicagop2, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jul 07, 1995)", 0, 0 )
	SOFTWARE( chicagop3, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jul 10, 1995)", 0, 0 )
	SOFTWARE( chicagop4, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jul 11, 1995)", 0, 0 )
	SOFTWARE( chicagop5, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jul 19, 1995)", 0, 0 )
	SOFTWARE( chicagop6, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jul 20, 1995)", 0, 0 )
	SOFTWARE( chicagop7, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jul 21, 1995 - B)", 0, 0 )
	SOFTWARE( chicagop8, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jul 21, 1995)", 0, 0 )
	SOFTWARE( chicagop9, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 01, 1995)", 0, 0 )
	SOFTWARE( chicgop10, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 05, 1995)", 0, 0 )
	SOFTWARE( chicgop11, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 07, 1995)", 0, 0 )
	SOFTWARE( chicgop12, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 08, 1995)", 0, 0 )
	SOFTWARE( chicgop13, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 12, 1995)", 0, 0 )
	SOFTWARE( chicgop14, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 14, 1995)", 0, 0 )
	SOFTWARE( chicgop15, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 19, 1995)", 0, 0 )
	SOFTWARE( chicgop16, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 20, 1995)", 0, 0 )
	SOFTWARE( chicgop17, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 22, 1995)", 0, 0 )
	SOFTWARE( chicgop18, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 26, 1995)", 0, 0 )
	SOFTWARE( chicgop19, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 28, 1995)", 0, 0 )
	SOFTWARE( chicgop20, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 29, 1995 - B)", 0, 0 )
	SOFTWARE( chicgop21, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 29, 1995)", 0, 0 )
	SOFTWARE( chicgop22, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - Jun 30, 1995 - B)", 0, 0 )
	SOFTWARE( chicgop23, chicago, 199?, "Sega License", "Chicago Syndicate (Prototype - May 05, 1995)", 0, 0 )
	SOFTWARE( chicago, 0       , 199?, "Sega License", "Chicago Syndicate"REGION_EU, 0, 0 )
	SOFTWARE( choplif3, 0       , 199?, "Sega License", "Choplifter III"REGION_EU, 0, 0 )
	SOFTWARE( chuckrck, 0       , 199?, "Sega License", "Chuck Rock"REGION_W, 0, 0 )
	SOFTWARE( chukrck2, 0       , 199?, "Sega License", "Chuck Rock II - Son of Chuck"REGION_E, 0, 0 )
	SOFTWARE( chukrck2u, chukrck2, 199?, "Sega License", "Chuck Rock II - Son of Chuck"REGION_U, 0, 0 )
	SOFTWARE( cliffh, 0       , 199?, "Sega License", "Cliffhanger"REGION_EU, 0, 0 )
	SOFTWARE( clutchit, 0       , 199?, "Sega License", "Clutch Hitter"REGION_U, 0, 0 )
	SOFTWARE( cocakid, 0       , 199?, "Sega License", "Coca Cola Kid"REGION_J, 0, 0 )
	SOFTWARE( columnsj, columns, 199?, "Sega License", "Columns"REGION_J, 0, 0 )
	SOFTWARE( columns, 0       , 199?, "Sega License", "Columns"REGION_EU, 0, 0 )
	SOFTWARE( coolspot, 0       , 199?, "Sega License", "Cool Spot"REGION_U, 0, 0 )
	SOFTWARE( cosmicsp, 0       , 199?, "Sega License", "Cosmic Spacehead"REGION_E, 0, 0 )
	SOFTWARE( crayon, 0       , 199?, "Sega License", "Crayon Shin-chan - Taiketsu! Kantam Panic!!"REGION_J, 0, 0 )
	SOFTWARE( crystalw, 0       , 199?, "Sega License", "Crystal Warriors"REGION_EU, 0, 0 )
	SOFTWARE( cutthrot, 0       , 199?, "Sega License", "Cutthroat Island"REGION_EU, 0, 0 )
	SOFTWARE( daffy, 0       , 199?, "Sega License", "Daffy Duck in Hollywood (En, Fr, De, Es, It)"REGION_E, 0, 0 )
	SOFTWARE( deepduck, 0       , 199?, "Sega License", "Deep Duck Trouble Starring Donald Duck"REGION_EU, 0, 0 )
	SOFTWARE( defoasis, 0       , 199?, "Sega License", "Defenders of Oasis"REGION_EU, 0, 0 )
	SOFTWARE( desert, 0       , 199?, "Sega License", "Desert Speedtrap (En, Fr, De, Es, It)"REGION_E, 0, 0 )
	SOFTWARE( desertu, desert, 199?, "Sega License", "Desert Speedtrap"REGION_U, 0, 0 )
	SOFTWARE( dstrike, 0       , 199?, "Sega License", "Desert Strike - Return to the Gulf"REGION_EU, 0, 0 )
	SOFTWARE( devilish, 0       , 199?, "Sega License", "Devilish"REGION_E, 0, 0 )
	SOFTWARE( devilishj, devilish, 199?, "Sega License", "Devilish"REGION_J, 0, 0 )
	SOFTWARE( devilishu, devilish, 199?, "Sega License", "Devilish"REGION_U, 0, 0 )
	SOFTWARE( donald42, 0       , 199?, "Sega License", "Donald Duck no 4-Tsu no Hihou"REGION_J, 0, 0 )
	SOFTWARE( donaldld, 0       , 199?, "Sega License", "Donald Duck no Lucky Dime"REGION_J, 0, 0 )
	SOFTWARE( donaldmw, 0       , 199?, "Sega License", "Donald no Magical World (En, Ja)"REGION_J, 0, 0 )
	SOFTWARE( doraemon, 0       , 199?, "Sega License", "Doraemon - Waku Waku Pocket Paradise"REGION_J, 0, 0 )
	SOFTWARE( ddragonb, ddragon, 199?, "Sega License", "Double Dragon (Beta)"REGION_EU, 0, 0 )
	SOFTWARE( ddragon, 0       , 199?, "Sega License", "Double Dragon"REGION_EU, 0, 0 )
	SOFTWARE( drrobotn, 0       , 199?, "Sega License", "Dr. Robotnik's Mean Bean Machine"REGION_EU, 0, 0 )
	SOFTWARE( dragon, 0       , 199?, "Sega License", "Dragon - The Bruce Lee Story"REGION_E, 0, 0 )
	SOFTWARE( dragonu, dragon, 199?, "Sega License", "Dragon - The Bruce Lee Story"REGION_U, 0, 0 )
	SOFTWARE( dragoncr, 0       , 199?, "Sega License", "Dragon Crystal"REGION_EU, 0, 0 )
	SOFTWARE( dragoncrj, dragoncr, 199?, "Sega License", "Dragon Crystal - Tsurani no Meikyuu"REGION_J, 0, 0 )
	SOFTWARE( dropzone, 0       , 199?, "Sega License", "Dropzone"REGION_E, 0, 0 )
	SOFTWARE( dunkkids, 0       , 199?, "Sega License", "Dunk Kids"REGION_J, 0, 0 )
	SOFTWARE( dynaheadj, dynahead, 199?, "Sega License", "Dynamite Headdy"REGION_J, 0, 0 )
	SOFTWARE( dynaheadp1, dynahead, 199?, "Sega License", "Dynamite Headdy (Prototype - Jul 01, 1994)", 0, 0 )
	SOFTWARE( dynaheadp2, dynahead, 199?, "Sega License", "Dynamite Headdy (Prototype - Jul 05, 1994)", 0, 0 )
	SOFTWARE( dynaheadp3, dynahead, 199?, "Sega License", "Dynamite Headdy (Prototype - Jun 15, 1994)", 0, 0 )
	SOFTWARE( dynahead, 0       , 199?, "Sega License", "Dynamite Headdy"REGION_EU, 0, 0 )
	SOFTWARE( ejim, 0       , 199?, "Sega License", "Earthworm Jim"REGION_U, 0, 0 )
	SOFTWARE( ecco2, 0       , 199?, "Sega License", "Ecco II - The Tides of Time"REGION_EU, 0, 0 )
	SOFTWARE( eccoj, ecco, 199?, "Sega License", "Ecco the Dolphin"REGION_J, 0, 0 )
	SOFTWARE( ecco, 0       , 199?, "Sega License", "Ecco the Dolphin"REGION_EU, 0, 0 )
	SOFTWARE( ecco2j, ecco2, 199?, "Sega License", "Ecco the Dolphin II"REGION_J, 0, 0 )
	SOFTWARE( ernieeg, 0       , 199?, "Sega License", "Ernie Els Golf (En, Fr, De, Es, It)"REGION_E, 0, 0 )
	SOFTWARE( eternall, 0       , 199?, "Sega License", "Eternal Legend - Eien no Densetsu"REGION_J, 0, 0 )
	SOFTWARE( evander, 0       , 199?, "Sega License", "Evander Holyfield Boxing"REGION_EU, 0, 0 )
	SOFTWARE( excdizzy, 0       , 199?, "Sega License", "The Excellent Dizzy Collection (SMS Mode?)"REGION_E, 0, 0 )
	SOFTWARE( excdizzyp, excdizzy, 199?, "Sega License", "The Excellent Dizzy Collection (Prototype) (SMS Mode)", 0, 0 )
	SOFTWARE( f15strik, 0       , 199?, "Sega License", "F-15 Strike Eagle"REGION_EU, 0, 0 )
	SOFTWARE( f1, 0       , 199?, "Sega License", "F1"REGION_EU, 0, 0 )
	SOFTWARE( faceball, 0       , 199?, "Sega License", "Faceball 2000"REGION_J, 0, 0 )
	SOFTWARE( factoryp, 0       , 199?, "Sega License", "Factory Panic"REGION_E, 0, 0 )
	SOFTWARE( fantdizz, 0       , 199?, "Sega License", "Fantastic Dizzy (En, Fr, De, Es, It) (SMS Mode?)"REGION_E, 0, 0 )
	SOFTWARE( fantzone, 0       , 199?, "Sega License", "Fantasy Zone Gear "REGION_EJ, 0, 0 )
	SOFTWARE( fantzone1, fantzone, 199?, "Sega License", "Fantasy Zone Gear (Alt)"REGION_JU, 0, 0 )
	SOFTWARE( fatalfur, 0       , 199?, "Sega License", "Fatal Fury Special"REGION_U, 0, 0 )
	SOFTWARE( fifaj, fifa, 199?, "Sega License", "FIFA International Soccer"REGION_J, 0, 0 )
	SOFTWARE( fifa, 0       , 199?, "Sega License", "FIFA International Soccer"REGION_EU, 0, 0 )
	SOFTWARE( fifa96, 0       , 199?, "Sega License", "FIFA Soccer 96 (En, Fr, De, Es)"REGION_EU, 0, 0 )
	SOFTWARE( foreman, 0       , 199?, "Sega License", "Foreman for Real"REGION_W, 0, 0 )
	SOFTWARE( frankt, 0       , 199?, "Sega License", "Frank Thomas Big Hurt Baseball"REGION_U, 0, 0 )
	SOFTWARE( fray, 0       , 199?, "Sega License", "Fray - Shugyou Hen"REGION_J, 0, 0 )
	SOFTWARE( fredcoupj, fredcoup, 199?, "Sega License", "Fred Couples' Golf"REGION_J, 0, 0 )
	SOFTWARE( fredcoup, 0       , 199?, "Sega License", "Fred Couples' Golf"REGION_U, 0, 0 )
	SOFTWARE( frogger, 0       , 199?, "Sega License", "Frogger (Proto)"REGION_U, 0, 0 )
	SOFTWARE( slamdunk, 0       , 199?, "Sega License", "From TV Animation - Slam Dunk - Shouri e no Starting 5"REGION_J, 0, 0 )
	SOFTWARE( glocairj, glocair, 199?, "Sega License", "G-LOC Air Battle (v1.1)"REGION_J, 0, 0 )
	SOFTWARE( glocairj1, glocair, 199?, "Sega License", "G-LOC Air Battle"REGION_J, 0, 0 )
	SOFTWARE( glocair, 0       , 199?, "Sega License", "G-LOC Air Battle"REGION_EU, 0, 0 )
	SOFTWARE( galaga91, 0       , 199?, "Sega License", "Galaga '91"REGION_J, 0, 0 )
	SOFTWARE( galaga2, 0       , 199?, "Sega License", "Galaga 2"REGION_E, 0, 0 )
	SOFTWARE( gamble, 0       , 199?, "Sega License", "Gamble Panic"REGION_J, 0, 0 )
	SOFTWARE( gambler, 0       , 199?, "Sega License", "Gambler Jikochuushinha"REGION_J, 0, 0 )
	SOFTWARE( ganbare, 0       , 199?, "Sega License", "Ganbare Gorby!"REGION_J, 0, 0 )
	SOFTWARE( garfield, 0       , 199?, "Sega License", "Garfield - Caught in the Act"REGION_EU, 0, 0 )
	SOFTWARE( garou, 0       , 199?, "Sega License", "Garou Densetsu Special"REGION_J, 0, 0 )
	SOFTWARE( gearstad, 0       , 199?, "Sega License", "Gear Stadium"REGION_J, 0, 0 )
	SOFTWARE( gearstah, 0       , 199?, "Sega License", "Gear Stadium Heiseiban"REGION_J, 0, 0 )
	SOFTWARE( gearwork, 0       , 199?, "Sega License", "Gear Works"REGION_U, 0, 0 )
	SOFTWARE( georgef, 0       , 199?, "Sega License", "George Foreman's KO Boxing"REGION_EU, 0, 0 )
	SOFTWARE( ggaleste, 0       , 199?, "Sega License", "GG Aleste"REGION_J, 0, 0 )
	SOFTWARE( ggdora, 0       , 199?, "Sega License", "GG Doraemon - Noranosuke no Yabou"REGION_J, 0, 0 )
	SOFTWARE( ggport, 0       , 199?, "Sega License", "GG Portrait - Pai Chen"REGION_J, 0, 0 )
	SOFTWARE( ggport1, 0       , 199?, "Sega License", "GG Portrait - Yuuki Akira"REGION_J, 0, 0 )
	SOFTWARE( ggshinob, 0       , 199?, "Sega License", "The GG Shinobi"REGION_J, 0, 0 )
	SOFTWARE( godzilla, 0       , 199?, "Sega License", "Godzilla - Kaijuu Daishingeki"REGION_J, 0, 0 )
	SOFTWARE( gpriderj, gprider, 199?, "Sega License", "GP Rider"REGION_J, 0, 0 )
	SOFTWARE( gpriderp, gprider, 199?, "Sega License", "GP Rider (Prototype - Jan 04, 1994)", 0, 0 )
	SOFTWARE( gprider, 0       , 199?, "Sega License", "GP Rider"REGION_EU, 0, 0 )
	SOFTWARE( greendog, 0       , 199?, "Sega License", "Greendog"REGION_EU, 0, 0 )
	SOFTWARE( griffin, 0       , 199?, "Sega License", "Griffin"REGION_J, 0, 0 )
	SOFTWARE( gunstar, 0       , 199?, "Sega License", "Gunstar Heroes"REGION_J, 0, 0 )
	SOFTWARE( halleywj, halleyw, 199?, "Sega License", "Halley Wars"REGION_J, 0, 0 )
	SOFTWARE( halleyw, 0       , 199?, "Sega License", "Halley Wars"REGION_EU, 0, 0 )
	SOFTWARE( headbust, 0       , 199?, "Sega License", "Head Buster"REGION_J, 0, 0 )
	SOFTWARE( heavywc, 0       , 199?, "Sega License", "Heavy Weight Champ"REGION_J, 0, 0 )
	SOFTWARE( homea, 0       , 199?, "Sega License", "Home Alone"REGION_EU, 0, 0 )
	SOFTWARE( honoo, 0       , 199?, "Sega License", "Honoo no Toukyuuji - Dodge Danpei"REGION_J, 0, 0 )
	SOFTWARE( hook, 0       , 199?, "Sega License", "Hook"REGION_EU, 0, 0 )
	SOFTWARE( hurric, 0       , 199?, "Sega License", "Hurricanes"REGION_E, 0, 0 )
	SOFTWARE( hyokkori, 0       , 199?, "Sega License", "Hyokkori Hyoutan Jima - Hyoutan Jima no Daikoukai"REGION_J, 0, 0 )
	SOFTWARE( hypery92, 0       , 199?, "Sega License", "Hyper Pro Yakyuu '92"REGION_J, 0, 0 )
	SOFTWARE( ichirgg, 0       , 199?, "Sega License", "Ichidant~R GG"REGION_J, 0, 0 )
	SOFTWARE( wakevamp, 0       , 199?, "Sega License", "In the Wake of Vampire"REGION_J, 0, 0 )
	SOFTWARE( incred, 0       , 199?, "Sega License", "The Incredible Crash Dummies"REGION_EU, 0, 0 )
	SOFTWARE( incrhulk, 0       , 199?, "Sega License", "The Incredible Hulk"REGION_EU, 0, 0 )
	SOFTWARE( indycrus1, indycrus, 199?, "Sega License", "Indiana Jones and the Last Crusade (Alt)"REGION_U, 0, 0 )
	SOFTWARE( indycrus, 0       , 199?, "Sega License", "Indiana Jones and the Last Crusade"REGION_EU, 0, 0 )
	SOFTWARE( ironman1, ironman, 199?, "Sega License", "Iron Man X-O Manowar in Heavy Metal (Alt)"REGION_U, 0, 0 )
	SOFTWARE( ironman, 0       , 199?, "Sega License", "Iron Man X-O Manowar in Heavy Metal"REGION_EU, 0, 0 )
	SOFTWARE( itchy, 0       , 199?, "Sega License", "The Itchy & Scratchy Game"REGION_EU, 0, 0 )
	SOFTWARE( jleagu94, 0       , 199?, "Sega License", "J.League GG Pro Striker '94"REGION_J, 0, 0 )
	SOFTWARE( jleague, 0       , 199?, "Sega License", "J.League Soccer - Dream Eleven"REGION_J, 0, 0 )
	SOFTWARE( jb007, 0       , 199?, "Sega License", "James Bond 007 - The Duel"REGION_E, 0, 0 )
	SOFTWARE( jpond3, 0       , 199?, "Sega License", "James Pond 3 - Operation Starfi5h"REGION_E, 0, 0 )
	SOFTWARE( robocod, 0       , 199?, "Sega License", "James Pond II - Codename RoboCod"REGION_U, 0, 0 )
	SOFTWARE( jangpun2, 0       , 199?, "Sega License", "Jang Pung II (SMS Mode)"REGION_K, 0, 0 )
	SOFTWARE( jeopardy, 0       , 199?, "Sega License", "Jeopardy!"REGION_U, 0, 0 )
	SOFTWARE( jeopards, 0       , 199?, "Sega License", "Jeopardy! - Sports Edition"REGION_EU, 0, 0 )
	SOFTWARE( joemontj, joemont, 199?, "Sega License", "Joe Montana's Football"REGION_J, 0, 0 )
	SOFTWARE( joemont, 0       , 199?, "Sega License", "Joe Montana's Football"REGION_EU, 0, 0 )
	SOFTWARE( striderr, 0       , 199?, "Sega License", "Journey from Darkness - Strider Returns"REGION_EU, 0, 0 )
	SOFTWARE( judged, 0       , 199?, "Sega License", "Judge Dredd"REGION_EU, 0, 0 )
	SOFTWARE( junction, 0       , 199?, "Sega License", "Junction"REGION_EU, 0, 0 )
	SOFTWARE( jungle, 0       , 199?, "Sega License", "The Jungle Book"REGION_E, 0, 0 )
	SOFTWARE( jungleu, 0       , 199?, "Sega License", "The Jungle Book"REGION_U, 0, 0 )
	SOFTWARE( jurassicj, jurassic, 199?, "Sega License", "Jurassic Park"REGION_J, 0, 0 )
	SOFTWARE( jurassic, 0       , 199?, "Sega License", "Jurassic Park"REGION_EU, 0, 0 )
	SOFTWARE( kaitou, 0       , 199?, "Sega License", "Kaitou Saint Tale"REGION_J, 0, 0 )
	SOFTWARE( kawasaki, 0       , 199?, "Sega License", "Kawasaki Superbike Challenge"REGION_EU, 0, 0 )
	SOFTWARE( kenyuu, 0       , 199?, "Sega License", "Kenyuu Densetsu Yaiba"REGION_J, 0, 0 )
	SOFTWARE( kickrush, 0       , 199?, "Sega License", "Kick & Rush"REGION_J, 0, 0 )
	SOFTWARE( kineticc, 0       , 199?, "Sega License", "Kinetic Connection"REGION_J, 0, 0 )
	SOFTWARE( kishin, 0       , 199?, "Sega License", "Kishin Douji Zenki"REGION_J, 0, 0 )
	SOFTWARE( klax, 0       , 199?, "Sega License", "Klax"REGION_EU, 0, 0 )
	SOFTWARE( krusty, 0       , 199?, "Sega License", "Krusty's Fun House"REGION_EU, 0, 0 )
	SOFTWARE( kunichan, 0       , 199?, "Sega License", "Kuni-chan no Game Tengoku"REGION_J, 0, 0 )
	SOFTWARE( kunichn2, 0       , 199?, "Sega License", "Kuni-chan no Game Tengoku Part 2"REGION_J, 0, 0 )
	SOFTWARE( landill, 0       , 199?, "Sega License", "Land of Illusion Starring Mickey Mouse"REGION_EU, 0, 0 )
	SOFTWARE( lastact, 0       , 199?, "Sega License", "Last Action Hero"REGION_U, 0, 0 )
	SOFTWARE( legndillp, legndill, 199?, "Sega License", "Legend of Illusion Starring Mickey Mouse (Prototype - Oct 11, 1994)", 0, 0 )
	SOFTWARE( legndillp1, legndill, 199?, "Sega License", "Legend of Illusion Starring Mickey Mouse (Prototype - Oct 14, 1994)", 0, 0 )
	SOFTWARE( legndillp2, legndill, 199?, "Sega License", "Legend of Illusion Starring Mickey Mouse (Prototype - Oct 17, 1994)", 0, 0 )
	SOFTWARE( legndillp3, legndill, 199?, "Sega License", "Legend of Illusion Starring Mickey Mouse (Prototype - Sep 22, 1994)", 0, 0 )
	SOFTWARE( legndillp4, legndill, 199?, "Sega License", "Legend of Illusion Starring Mickey Mouse (Prototype - Sep 30, 1994 - SEL)", 0, 0 )
	SOFTWARE( legndillp5, legndill, 199?, "Sega License", "Legend of Illusion Starring Mickey Mouse (Prototype - Sep 30, 1994)", 0, 0 )
	SOFTWARE( legndill, 0       , 199?, "Sega License", "Legend of Illusion Starring Mickey Mouse"REGION_EU, 0, 0 )
	SOFTWARE( lemmingsb, lemmings, 199?, "Sega License", "Lemmings (Beta)"REGION_W, 0, 0 )
	SOFTWARE( lemmings, 0       , 199?, "Sega License", "Lemmings"REGION_W, 0, 0 )
	SOFTWARE( lionkingt, lionking, 199?, "Sega License", "The Lion King (Trainer?)"REGION_E, 0, 0 )
	SOFTWARE( lionking, 0       , 199?, "Sega License", "The Lion King"REGION_E, 0, 0 )
	SOFTWARE( lionkingp, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 03, 1994)", 0, 0 )
	SOFTWARE( lionkingp1, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 11, 1994)", 0, 0 )
	SOFTWARE( lionkingp2, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 12, 1994)", 0, 0 )
	SOFTWARE( lionkingp3, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 13, 1994)", 0, 0 )
	SOFTWARE( lionkingp4, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 14, 1994)", 0, 0 )
	SOFTWARE( lionkingp5, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 15, 1994)", 0, 0 )
	SOFTWARE( lionkingp6, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 16, 1994)", 0, 0 )
	SOFTWARE( lionkingp7, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 17, 1994 - 2)", 0, 0 )
	SOFTWARE( lionkingp8, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 17, 1994)", 0, 0 )
	SOFTWARE( lionkingp9, lionking, 199?, "Sega License", "The Lion King (Prototype - Aug 20, 1994)", 0, 0 )
	SOFTWARE( lionkingu, lionking, 199?, "Sega License", "The Lion King (Trainer?)"REGION_U, 0, 0 )
	SOFTWARE( lionkingut, lionking, 199?, "Sega License", "The Lion King"REGION_U, 0, 0 )
	SOFTWARE( lostwrld, 0       , 199?, "Sega License", "The Lost World - Jurassic Park"REGION_U, 0, 0 )
	SOFTWARE( luckydim, 0       , 199?, "Sega License", "The Lucky Dime Caper"REGION_EU, 0, 0 )
	SOFTWARE( lunar, 0       , 199?, "Sega License", "Lunar - Sanposuru Gakuen"REGION_J, 0, 0 )
	SOFTWARE( madden95, 0       , 199?, "Sega License", "Madden NFL '95"REGION_U, 0, 0 )
	SOFTWARE( madden96, 0       , 199?, "Sega License", "Madden NFL '96"REGION_U, 0, 0 )
	SOFTWARE( madden96a, 0       , 199?, "Sega License", "Madden NFL '96"REGION_EU, 0, 0 )
	SOFTWARE( madoumna, 0       , 199?, "Sega License", "Madou Monogatari A - Dokidoki Vacation"REGION_J, 0, 0 )
	SOFTWARE( madoumon, 0       , 199?, "Sega License", "Madou Monogatari I - 3-Tsu no Madoukyuu"REGION_J, 0, 0 )
	SOFTWARE( madoumn2, 0       , 199?, "Sega License", "Madou Monogatari II - Arle 16-Sai"REGION_J, 0, 0 )
	SOFTWARE( madoumn3, 0       , 199?, "Sega License", "Madou Monogatari III - Kyuukyoku Joou-sama (v1.1)"REGION_J, 0, 0 )
	SOFTWARE( madoumn3a, madoumn3, 199?, "Sega License", "Madou Monogatari III - Kyuukyoku Joou-sama"REGION_J, 0, 0 )
	SOFTWARE( magicray, 0       , 199?, "Sega License", "Magic Knight Rayearth"REGION_J, 0, 0 )
	SOFTWARE( magicry2, 0       , 199?, "Sega License", "Magic Knight Rayearth 2 - Making of Magic Knight"REGION_J, 0, 0 )
	SOFTWARE( magiclpp, 0       , 199?, "Sega License", "Magical Puzzle Popils (En, Ja)"REGION_W, 0, 0 )
	SOFTWARE( magical, 0       , 199?, "Sega License", "Magical Taruruuto-kun"REGION_J, 0, 0 )
	SOFTWARE( majors, 0       , 199?, "Sega License", "The Majors Pro Baseball"REGION_U, 0, 0 )
	SOFTWARE( mappy, 0       , 199?, "Sega License", "Mappy"REGION_J, 0, 0 )
	SOFTWARE( marble, 0       , 199?, "Sega License", "Marble Madness"REGION_EU, 0, 0 )
	SOFTWARE( marko, 0       , 199?, "Sega License", "Marko's Magic Football (En, Fr, De, Es)"REGION_E, 0, 0 )
	SOFTWARE( megaman, 0       , 199?, "Sega License", "Mega Man"REGION_EU, 0, 0 )
	SOFTWARE( lastbibl, 0       , 199?, "Sega License", "Megami Tensei Gaiden - Last Bible"REGION_J, 0, 0 )
	SOFTWARE( lastbibs, 0       , 199?, "Sega License", "Megami Tensei Gaiden - Last Bible S"REGION_J, 0, 0 )
	SOFTWARE( mickmack, 0       , 199?, "Sega License", "Mick & Mack as the Global Gladiators"REGION_EU, 0, 0 )
	SOFTWARE( legndillj, legndill, 199?, "Sega License", "Mickey Mouse Densetsu no Oukoku - Legend of Illusion"REGION_J, 0, 0 )
	SOFTWARE( castlillj, castlill, 199?, "Sega License", "Mickey Mouse no Castle Illusion (SMS Mode?)"REGION_J, 0, 0 )
	SOFTWARE( mickeymc, 0       , 199?, "Sega License", "Mickey Mouse no Mahou no Crystal"REGION_J, 0, 0 )
	SOFTWARE( mickeyuc, 0       , 199?, "Sega License", "Mickey's Ultimate Challenge"REGION_EU, 0, 0 )
	SOFTWARE( micromac, 0       , 199?, "Sega License", "Micro Machines"REGION_E, 0, 0 )
	SOFTWARE( micromc2, 0       , 199?, "Sega License", "Micro Machines 2 - Turbo Tournament"REGION_E, 0, 0 )
	SOFTWARE( mmprp, mmpr, 199?, "Sega License", "Mighty Morphin Power Rangers (Prototype - Jul 16, 1994)", 0, 0 )
	SOFTWARE( mmpr, 0       , 199?, "Sega License", "Mighty Morphin Power Rangers"REGION_EU, 0, 0 )
	SOFTWARE( mmprtmp, mmprtm, 199?, "Sega License", "Mighty Morphin Power Rangers - The Movie (Prototype - May 30, 1995)", 0, 0 )
	SOFTWARE( mmprtm, 0       , 199?, "Sega License", "Mighty Morphin Power Rangers - The Movie"REGION_EU, 0, 0 )
	SOFTWARE( mlbpab, 0       , 199?, "Sega License", "MLBPA Baseball"REGION_U, 0, 0 )
	SOFTWARE( moldoran, 0       , 199?, "Sega License", "Moldorian - Hikari to Yami no Sister"REGION_J, 0, 0 )
	SOFTWARE( monstert, 0       , 199?, "Sega License", "Monster Truck Wars"REGION_EU, 0, 0 )
	SOFTWARE( monstwld2, 0       , 199?, "Sega License", "Monster World II - Dragon no Wana"REGION_J, 0, 0 )
	SOFTWARE( mkj,   mk,    199?, "Sega License", "Mortal Kombat (v3.3)"REGION_J, 0, 0 )
	SOFTWARE( mk, 0       , 199?, "Sega License", "Mortal Kombat (v2.6)"REGION_EU, 0, 0 )
	SOFTWARE( mk3, 0       , 199?, "Sega License", "Mortal Kombat 3"REGION_E, 0, 0 )
	SOFTWARE( mk2, 0       , 199?, "Sega License", "Mortal Kombat II"REGION_W, 0, 0 )
	SOFTWARE( mspacman, 0       , 199?, "Sega License", "Ms. Pac-Man"REGION_U, 0, 0 )
	SOFTWARE( nazpuyo, 0       , 199?, "Sega License", "Nazo Puyo"REGION_J, 0, 0 )
	SOFTWARE( nazpuyo2, 0       , 199?, "Sega License", "Nazo Puyo 2"REGION_J, 0, 0 )
	SOFTWARE( nazpyoar1, nazpyoar, 199?, "Sega License", "Nazo Puyo Arle no Roux (Development Edition)"REGION_J, 0, 0 )
	SOFTWARE( nazpyoar, 0       , 199?, "Sega License", "Nazo Puyo Arle no Roux"REGION_J, 0, 0 )
	SOFTWARE( nbaactn, 0       , 199?, "Sega License", "NBA Action"REGION_U, 0, 0 )
	SOFTWARE( nbaactnp1, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Final A - Feb 28, 1994)", 0, 0 )
	SOFTWARE( nbaactnp2, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Final B - Mar 01, 1994)", 0, 0 )
	SOFTWARE( nbaactnp3, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Final C - Mar 02, 1994)", 0, 0 )
	SOFTWARE( nbaactnp4, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Final D - Mar 03, 1994)", 0, 0 )
	SOFTWARE( nbaactnp5, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Final E - Mar 04, 1994)", 0, 0 )
	SOFTWARE( nbaactnp6, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Final F - Mar 04, 1994)", 0, 0 )
	SOFTWARE( nbaactnp7, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Final G - Mar 05, 1994)", 0, 0 )
	SOFTWARE( nbaactnp8, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Final H - Mar 08, 1994)", 0, 0 )
	SOFTWARE( nbaactnp9, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Dec 01, 1993)", 0, 0 )
	SOFTWARE( nbaactp10, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 02, 1994)", 0, 0 )
	SOFTWARE( nbaactp11, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 03, 1994)", 0, 0 )
	SOFTWARE( nbaactp12, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 06, 1994)", 0, 0 )
	SOFTWARE( nbaactp13, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 08, 1994)", 0, 0 )
	SOFTWARE( nbaactp14, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 12, 1994)", 0, 0 )
	SOFTWARE( nbaactp15, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 15, 1994)", 0, 0 )
	SOFTWARE( nbaactp16, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 17, 1994)", 0, 0 )
	SOFTWARE( nbaactp17, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 20, 1994)", 0, 0 )
	SOFTWARE( nbaactp18, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 21, 1994)", 0, 0 )
	SOFTWARE( nbaactp19, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 24, 1994)", 0, 0 )
	SOFTWARE( nbaactp20, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 25, 1994 - B)", 0, 0 )
	SOFTWARE( nbaactp21, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 25, 1994)", 0, 0 )
	SOFTWARE( nbaactp22, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 26, 1994)", 0, 0 )
	SOFTWARE( nbaactp23, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 27, 1994)", 0, 0 )
	SOFTWARE( nbaactp24, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Feb 28, 1994)", 0, 0 )
	SOFTWARE( nbaactp25, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Jan 04, 1994)", 0, 0 )
	SOFTWARE( nbaactp26, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Jan 06, 1994)", 0, 0 )
	SOFTWARE( nbaactp27, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Jan 10, 1994)", 0, 0 )
	SOFTWARE( nbaactp28, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Jan 24, 1994)", 0, 0 )
	SOFTWARE( nbaactp29, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Jan 29, 1994)", 0, 0 )
	SOFTWARE( nbaactp30, nbaactn, 199?, "Sega License", "NBA Action Starring David Robinson (Prototype - Nov 28, 1993)", 0, 0 )
	SOFTWARE( nbajamj, nbajam, 199?, "Sega License", "NBA Jam"REGION_J, 0, 0 )
	SOFTWARE( nbajam, 0       , 199?, "Sega License", "NBA Jam (v1.1)"REGION_U, 0, 0 )
	SOFTWARE( nbajam1, nbajam, 199?, "Sega License", "NBA Jam"REGION_EU, 0, 0 )
	SOFTWARE( nbajamte, 0       , 199?, "Sega License", "NBA Jam Tournament Edition"REGION_EU, 0, 0 )
	SOFTWARE( nekodais, 0       , 199?, "Sega License", "Neko Daisuki!"REGION_J, 0, 0 )
	SOFTWARE( nfl95pa, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Aug 08, 1994)", 0, 0 )
	SOFTWARE( nfl95pb, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Aug 25, 1994 - A)", 0, 0 )
	SOFTWARE( nfl95pc, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Aug 25, 1994 - B)", 0, 0 )
	SOFTWARE( nfl95pd, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Aug 25, 1994)", 0, 0 )
	SOFTWARE( nfl95pe, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Aug 26, 1994)", 0, 0 )
	SOFTWARE( nfl95pf, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Aug 31, 1994)", 0, 0 )
	SOFTWARE( nfl95pg, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Sep 02, 1994)", 0, 0 )
	SOFTWARE( nfl95ph, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Sep 08, 1994)", 0, 0 )
	SOFTWARE( nfl95pi, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Sep 10, 1994)", 0, 0 )
	SOFTWARE( nfl95pj, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Sep 11, 1994 - B)", 0, 0 )
	SOFTWARE( nfl95pk, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Sep 11, 1994 - C)", 0, 0 )
	SOFTWARE( nfl95pl, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Sep 12, 1994)", 0, 0 )
	SOFTWARE( nfl95pm, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Sep 14, 1994 - F)", 0, 0 )
	SOFTWARE( nfl95pn, nfl95, 199?, "Sega License", "NFL '95 (Prototype - Sep 14, 1994)", 0, 0 )
	SOFTWARE( nfl95, 0       , 199?, "Sega License", "NFL '95"REGION_U, 0, 0 )
	SOFTWARE( nflqrt96, 0       , 199?, "Sega License", "NFL Quarterback Club '96"REGION_EU, 0, 0 )
	SOFTWARE( nflquart, 0       , 199?, "Sega License", "NFL Quarterback Club"REGION_W, 0, 0 )
	SOFTWARE( nhlallstpa, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Dec 15, 1994)", 0, 0 )
	SOFTWARE( nhlallstpb, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Dec 22, 1994)", 0, 0 )
	SOFTWARE( nhlallstpc, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Dec 29, 1994)", 0, 0 )
	SOFTWARE( nhlallstpd, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Dec 31, 1994)", 0, 0 )
	SOFTWARE( nhlallstpe, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 02, 1995)", 0, 0 )
	SOFTWARE( nhlallstpf, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 03, 1995)", 0, 0 )
	SOFTWARE( nhlallstpg, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 07, 1995)", 0, 0 )
	SOFTWARE( nhlallstph, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 11, 1995)", 0, 0 )
	SOFTWARE( nhlallstpi, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 13, 1995)", 0, 0 )
	SOFTWARE( nhlallstpj, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 16, 1995)", 0, 0 )
	SOFTWARE( nhlallstpk, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 20 ,1995)", 0, 0 )
	SOFTWARE( nhlallstpl, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 21, 1995)", 0, 0 )
	SOFTWARE( nhlallstpm, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 24, 1995 - A)", 0, 0 )
	SOFTWARE( nhlallstpn, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 24, 1995 - B)", 0, 0 )
	SOFTWARE( nhlallstpo, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 24, 1995 - C)", 0, 0 )
	SOFTWARE( nhlallstpp, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 24, 1995)", 0, 0 )
	SOFTWARE( nhlallstpq, nhlallst, 199?, "Sega License", "NHL All-Star Hockey (Prototype - Jan 25, 1995)", 0, 0 )
	SOFTWARE( nhlallst, 0       , 199?, "Sega License", "NHL All-Star Hockey"REGION_U, 0, 0 )
	SOFTWARE( nhlhocky, 0       , 199?, "Sega License", "NHL Hockey"REGION_EU, 0, 0 )
	SOFTWARE( ninjagj, ninjag, 199?, "Sega License", "Ninja Gaiden"REGION_J, 0, 0 )
	SOFTWARE( ninjag, 0       , 199?, "Sega License", "Ninja Gaiden"REGION_EU, 0, 0 )
	SOFTWARE( ninku, 0       , 199?, "Sega License", "Ninku"REGION_J, 0, 0 )
	SOFTWARE( ninku2, 0       , 199?, "Sega License", "Ninku 2 - Tenkuuryuu e no Michi"REGION_J, 0, 0 )
	SOFTWARE( ninkug, 0       , 199?, "Sega License", "Ninku Gaiden - Hiroyuki Daikatsugeki"REGION_J, 0, 0 )
	SOFTWARE( nomohide, 0       , 199?, "Sega License", "Nomo Hideo no World Series Baseball"REGION_J, 0, 0 )
	SOFTWARE( olympi, 0       , 199?, "Sega License", "Olympic Gold (En, Fr, De, Es, It, Nl, Pt, Sv) (v1.1) (SMS Mode?)"REGION_E, 0, 0 )
	SOFTWARE( olympiju, olympi, 199?, "Sega License", "Olympic Gold (En, Fr, De, Es, It, Nl, Pt, Sv) (SMS Mode?)"REGION_JU, 0, 0 )
	SOFTWARE( ottifant, 0       , 199?, "Sega License", "The Ottifants (En, Fr, De, Es, It)"REGION_E, 0, 0 )
	SOFTWARE( outrunj, outrun, 199?, "Sega License", "Out Run"REGION_J, 0, 0 )
	SOFTWARE( outruneu, 0       , 199?, "Sega License", "Out Run Europa (SMS Mode?)"REGION_EU, 0, 0 )
	SOFTWARE( outrun, 0       , 199?, "Sega License", "OutRun (Alt)"REGION_JU, 0, 0 )
	SOFTWARE( pacattck, 0       , 199?, "Sega License", "Pac-Attack"REGION_EU, 0, 0 )
	SOFTWARE( pacintim, 0       , 199?, "Sega License", "Pac-In-Time (Unknown) (Proto)", 0, 0 )
	SOFTWARE( pacman, 0       , 199?, "Sega License", "Pac-Man"REGION_J, 0, 0 )
	SOFTWARE( panzer, 0       , 199?, "Sega License", "Panzer Dragoon Mini"REGION_J, 0, 0 )
	SOFTWARE( paperboy, 0       , 199?, "Sega License", "Paperboy"REGION_EU, 0, 0 )
	SOFTWARE( paperby2, 0       , 199?, "Sega License", "Paperboy II"REGION_EU, 0, 0 )
	SOFTWARE( pengoj, 0       , 199?, "Sega License", "Pengo"REGION_J, 0, 0 )
	SOFTWARE( pengo, pengo, 199?, "Sega License", "Pengo"REGION_EU, 0, 0 )
	SOFTWARE( petclub, 0       , 199?, "Sega License", "Pet Club Inu Daisuki!"REGION_J, 0, 0 )
	SOFTWARE( psampras, 0       , 199?, "Sega License", "Pete Sampras Tennis"REGION_E, 0, 0 )
	SOFTWARE( pga96, 0       , 199?, "Sega License", "PGA Tour 96"REGION_EU, 0, 0 )
	SOFTWARE( pgatour, 0       , 199?, "Sega License", "PGA Tour Golf (v1.1)"REGION_U, 0, 0 )
	SOFTWARE( pgatoura, pgatour, 199?, "Sega License", "PGA Tour Golf"REGION_EU, 0, 0 )
	SOFTWARE( pgatour2, 0       , 199?, "Sega License", "PGA Tour Golf II"REGION_EU, 0, 0 )
	SOFTWARE( pstaradv, 0       , 199?, "Sega License", "Phantasy Star Adventure"REGION_J, 0, 0 )
	SOFTWARE( pstargai, 0       , 199?, "Sega License", "Phantasy Star Gaiden"REGION_J, 0, 0 )
	SOFTWARE( phantom, 0       , 199?, "Sega License", "Phantom 2040"REGION_EU, 0, 0 )
	SOFTWARE( pinballd, 0       , 199?, "Sega License", "Pinball Dreams"REGION_U, 0, 0 )
	SOFTWARE( pocketj, 0       , 199?, "Sega License", "Pocket Jansou"REGION_J, 0, 0 )
	SOFTWARE( pokerf, 0       , 199?, "Sega License", "Poker Faced Paul's Blackjack"REGION_U, 0, 0 )
	SOFTWARE( pokerf1, 0       , 199?, "Sega License", "Poker Faced Paul's Gin"REGION_U, 0, 0 )
	SOFTWARE( pokerf2, 0       , 199?, "Sega License", "Poker Faced Paul's Poker"REGION_U, 0, 0 )
	SOFTWARE( pokerf3, 0       , 199?, "Sega License", "Poker Faced Paul's Solitaire"REGION_U, 0, 0 )
	SOFTWARE( popbreak, 0       , 199?, "Sega License", "Pop Breaker"REGION_J, 0, 0 )
	SOFTWARE( popeye, 0       , 199?, "Sega License", "Popeye no Beach Volleyball"REGION_J, 0, 0 )
	SOFTWARE( pstrike2, 0       , 199?, "Sega License", "Power Strike II"REGION_EJ, 0, 0 )
	SOFTWARE( predator, 0       , 199?, "Sega License", "Predator 2 (SMS Mode?)"REGION_EU, 0, 0 )
	SOFTWARE( primal, 0       , 199?, "Sega License", "Primal Rage"REGION_EU, 0, 0 )
	SOFTWARE( ppersiab, ppersia, 199?, "Sega License", "Prince of Persia (Beta) (SMS Mode?)"REGION_EU, 0, 0 )
	SOFTWARE( ppersia, 0       , 199?, "Sega License", "Prince of Persia (SMS Mode?)"REGION_EU, 0, 0 )
	SOFTWARE( proyak91, 0       , 199?, "Sega License", "The Pro Yakyuu '91"REGION_J, 0, 0 )
	SOFTWARE( proyak94, 0       , 199?, "Sega License", "Pro Yakyuu GG League '94"REGION_J, 0, 0 )
	SOFTWARE( proyakgg, 0       , 199?, "Sega License", "Pro Yakyuu GG League"REGION_J, 0, 0 )
	SOFTWARE( psychicwj, psychicw, 199?, "Sega License", "Psychic World"REGION_J, 0, 0 )
	SOFTWARE( psychicw, 0       , 199?, "Sega License", "Psychic World (v1.1)"REGION_EU, 0, 0 )
	SOFTWARE( puttputtj, puttputt, 199?, "Sega License", "Putt & Putter"REGION_J, 0, 0 )
	SOFTWARE( puttputt, 0       , 199?, "Sega License", "Putt & Putter"REGION_EU, 0, 0 )
	SOFTWARE( puyopuyo, 0       , 199?, "Sega License", "Puyo Puyo"REGION_J, 0, 0 )
	SOFTWARE( puyopyo2, 0       , 199?, "Sega License", "Puyo Puyo 2"REGION_J, 0, 0 )
	SOFTWARE( tantor, 0       , 199?, "Sega License", "Puzzle and Action Tanto-R"REGION_J, 0, 0 )
	SOFTWARE( pbobble, 0       , 199?, "Sega License", "Puzzle Bobble"REGION_J, 0, 0 )
	SOFTWARE( questf, 0       , 199?, "Sega License", "Quest for the Shaven Yak Starring Ren Hoek & Stimpy"REGION_EU, 0, 0 )
	SOFTWARE( quizgear, 0       , 199?, "Sega License", "The Quiz Gear Fight!!"REGION_J, 0, 0 )
	SOFTWARE( rbibas, 0       , 199?, "Sega License", "R.B.I. Baseball '94"REGION_U, 0, 0 )
	SOFTWARE( rcgp, 0       , 199?, "Sega License", "R.C. Grand Prix (SMS Mode?)"REGION_EU, 0, 0 )
	SOFTWARE( rastansg, 0       , 199?, "Sega License", "Rastan Saga (SMS Mode?)"REGION_J, 0, 0 )
	SOFTWARE( revenged, 0       , 199?, "Sega License", "Revenge of Drancon"REGION_U, 0, 0 )
	SOFTWARE( riddickj, riddick, 199?, "Sega License", "Riddick Bowe Boxing"REGION_J, 0, 0 )
	SOFTWARE( riddick, 0       , 199?, "Sega License", "Riddick Bowe Boxing"REGION_U, 0, 0 )
	SOFTWARE( riserobo, 0       , 199?, "Sega License", "Rise of the Robots"REGION_EU, 0, 0 )
	SOFTWARE( ristarp, ristar, 199?, "Sega License", "Ristar (Prototype - Nov 01, 1994)", 0, 0 )
	SOFTWARE( ristarp1, ristar, 199?, "Sega License", "Ristar (Prototype - Nov 02, 1994)", 0, 0 )
	SOFTWARE( ristarp2, ristar, 199?, "Sega License", "Ristar (Prototype - Oct 19, 1994)", 0, 0 )
	SOFTWARE( ristarp3, ristar, 199?, "Sega License", "Ristar (Prototype - Oct 26, 1994)", 0, 0 )
	SOFTWARE( ristarp4, ristar, 199?, "Sega License", "Ristar (Prototype - Sep 09, 1994)", 0, 0 )
	SOFTWARE( ristar, 0       , 199?, "Sega License", "Ristar - The Shooting Star"REGION_W, 0, 0 )
	SOFTWARE( roadrash, 0       , 199?, "Sega License", "Road Rash"REGION_U, 0, 0 )
	SOFTWARE( robocop3, 0       , 199?, "Sega License", "RoboCop 3"REGION_EU, 0, 0 )
	SOFTWARE( roboterm, 0       , 199?, "Sega License", "RoboCop versus The Terminator"REGION_EU, 0, 0 )
	SOFTWARE( royalstn, 0       , 199?, "Sega License", "Royal Stone - Hirakareshi Toki no Tobira"REGION_J, 0, 0 )
	SOFTWARE( ryuukyuu, 0       , 199?, "Sega License", "Ryuukyuu"REGION_J, 0, 0 )
	SOFTWARE( sslucifr, 0       , 199?, "Sega License", "S.S. Lucifer - Man Overboard!"REGION_E, 0, 0 )
	SOFTWARE( samsho, 0       , 199?, "Sega License", "Samurai Shodown"REGION_U, 0, 0 )
	SOFTWARE( samspi, 0       , 199?, "Sega License", "Samurai Spirits"REGION_J, 0, 0 )
	SOFTWARE( scratchg, 0       , 199?, "Sega License", "Scratch Golf"REGION_J, 0, 0 )
	SOFTWARE( sdgundam, 0       , 199?, "Sega License", "SD Gundam - Winner's History"REGION_J, 0, 0 )
	SOFTWARE( segagame, 0       , 199?, "Sega License", "Sega Game Pack 4 in 1"REGION_E, 0, 0 )
	SOFTWARE( sensible, 0       , 199?, "Sega License", "Sensible Soccer"REGION_E, 0, 0 )
	SOFTWARE( shadam, 0       , 199?, "Sega License", "Shadam Crusader - Harukanaru Oukoku"REGION_J, 0, 0 )
	SOFTWARE( shangh2, 0       , 199?, "Sega License", "Shanghai II"REGION_J, 0, 0 )
	SOFTWARE( shaqfu, 0       , 199?, "Sega License", "Shaq Fu"REGION_EU, 0, 0 )
	SOFTWARE( shikinjo, 0       , 199?, "Sega License", "Shikinjou"REGION_J, 0, 0 )
	SOFTWARE( shinfrcg, 0       , 199?, "Sega License", "Shining Force Gaiden - Ensei, Jashin no Kuni e"REGION_J, 0, 0 )
	SOFTWARE( shinfrgf, 0       , 199?, "Sega License", "Shining Force Gaiden - Final Conflict"REGION_J, 0, 0 )
	SOFTWARE( shinfrg2, 0       , 199?, "Sega License", "Shining Force Gaiden II - Jashin no Kakusei"REGION_J, 0, 0 )
	SOFTWARE( shinfrc2p1, shinfrc2, 199?, "Sega License", "Shining Force II (Prototype - Apr 27, 1994)", 0, 0 )
	SOFTWARE( shinfrc2p2, shinfrc2, 199?, "Sega License", "Shining Force II (Prototype - Jul 08, 1994)", 0, 0 )
	SOFTWARE( shinfrc2p3, shinfrc2, 199?, "Sega License", "Shining Force II (Prototype - Jun 27, 1994)", 0, 0 )
	SOFTWARE( shinfrc2p4, shinfrc2, 199?, "Sega License", "Shining Force II (Prototype - May 30, 1994)", 0, 0 )
	SOFTWARE( shinfrc2, 0       , 199?, "Sega License", "Shining Force II - The Sword of Hajya"REGION_EU, 0, 0 )
	SOFTWARE( shinobi, 0       , 199?, "Sega License", "Shinobi"REGION_EU, 0, 0 )
	SOFTWARE( shinobi2, 0       , 199?, "Sega License", "Shinobi II - The Silent Fury"REGION_W, 0, 0 )
	SOFTWARE( sidepock, 0       , 199?, "Sega License", "Side Pocket"REGION_U, 0, 0 )
	SOFTWARE( bartvssm, 0       , 199?, "Sega License", "The Simpsons - Bart vs. The Space Mutants"REGION_EU, 0, 0 )
	SOFTWARE( bartvswd, 0       , 199?, "Sega License", "The Simpsons - Bart vs. The World"REGION_EU, 0, 0 )
	SOFTWARE( skweek, 0       , 199?, "Sega License", "Skweek"REGION_J, 0, 0 )
	SOFTWARE( slider, 0       , 199?, "Sega License", "Slider"REGION_EU, 0, 0 )
	SOFTWARE( smurfs, 0       , 199?, "Sega License", "The Smurfs (Europe) (En,Fr,De,Es)", 0, 0 )
	SOFTWARE( solitair, 0       , 199?, "Sega License", "Solitaire Funpak"REGION_U, 0, 0 )
	SOFTWARE( solitarp, 0       , 199?, "Sega License", "Solitaire Poker"REGION_EU, 0, 0 )
	SOFTWARE( sonictls, 0       , 199?, "Sega License", "Sonic & Tails"REGION_J, 0, 0 )
	SOFTWARE( sonictl2, 0       , 199?, "Sega License", "Sonic & Tails 2"REGION_J, 0, 0 )
	SOFTWARE( sonicblsp1, sonicbls, 199?, "Sega License", "Sonic Blast (Prototype 611 - May 31, 1996, 13.49)", 0, 0 )
	SOFTWARE( sonicblsp2, sonicbls, 199?, "Sega License", "Sonic Blast (Prototype 74 - Jul 17, 1996, 09.11)", 0, 0 )
	SOFTWARE( sonicblsp3, sonicbls, 199?, "Sega License", "Sonic Blast (Prototype 806 - Aug 06, 1996, 18.37)", 0, 0 )
	SOFTWARE( sonicblsp4, sonicbls, 199?, "Sega License", "Sonic Blast (Prototype 821 - Aug 22, 1996, 09.38)", 0, 0 )
	SOFTWARE( sonicblsp5, sonicbls, 199?, "Sega License", "Sonic Blast (Prototype 827 - Aug 28, 1996, 11.13)", 0, 0 )
	SOFTWARE( sonicblsp6, sonicbls, 199?, "Sega License", "Sonic Blast (Prototype 94 - Sep 02, 1996, 17.47)", 0, 0 )
	SOFTWARE( sonicbls, 0       , 199?, "Sega License", "Sonic Blast"REGION_W, 0, 0 )
	SOFTWARE( sonicc, 0       , 199?, "Sega License", "Sonic Chaos"REGION_EU, 0, 0 )
	SOFTWARE( sonicdrs, sonicdr, 199?, "Sega License", "Sonic Drift (Sample)"REGION_J, 0, 0 )
	SOFTWARE( sonicdr, 0       , 199?, "Sega License", "Sonic Drift"REGION_J, 0, 0 )
	SOFTWARE( sonicdr2, 0       , 199?, "Sega License", "Sonic Drift 2"REGION_JU, 0, 0 )
	SOFTWARE( soniclab, 0       , 199?, "Sega License", "Sonic Labyrinth"REGION_W, 0, 0 )
	SOFTWARE( sonicsp,  sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0307 - Mar 07, 1994, 05.24)", 0, 0 )
	SOFTWARE( sonicspa, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 031094 - Mar 10, 1994, 17.41)", 0, 0 )
	SOFTWARE( sonicspb, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 031194 - Mar 11, 1994, 12.09)", 0, 0 )
	SOFTWARE( sonicspc, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 032194 - Mar 21, 1994, 07.12)", 0, 0 )
	SOFTWARE( sonicspd, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0328 - Mar 28, 1994, 06.54)", 0, 0 )
	SOFTWARE( sonicspe, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0329 - Mar 29, 1994, 07.35)", 0, 0 )
	SOFTWARE( sonicspf, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0330 - Mar 30, 1994, 06.54)", 0, 0 )
	SOFTWARE( sonicspg, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0405 - Apr 05, 1994, 18.07)", 0, 0 )
	SOFTWARE( sonicsph, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0412 - Apr 12, 1994, 07.26)", 0, 0 )
	SOFTWARE( sonicspi, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0413 - Apr 13, 1994, 02.54)", 0, 0 )
	SOFTWARE( sonicspj, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0415 - Apr 15, 1994, 17.33)", 0, 0 )
	SOFTWARE( sonicspk, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0421 - Apr 21, 1994, 05.30)", 0, 0 )
	SOFTWARE( sonicspl, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0427 - Apr 27, 1994, 04.51)", 0, 0 )
	SOFTWARE( sonicspm, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0429 - Apr 29, 1994, 06.01)", 0, 0 )
	SOFTWARE( sonicspn, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0430 - Apr 29, 1994, 21.48)", 0, 0 )
	SOFTWARE( sonicspo, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0505 - May 05, 1994, 04.47)", 0, 0 )
	SOFTWARE( sonicspp, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0506 - May 06, 1994, 13.04)", 0, 0 )
	SOFTWARE( sonicspq, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0525 - May 25, 1994, 13.24)", 0, 0 )
	SOFTWARE( sonicspr, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 0530 - May 30, 1994, 23.25)", 0, 0 )
	SOFTWARE( sonicsps, sonics, 199?, "Sega License", "Sonic Spinball (Prototype 503B - May 03, 1994, 19.27)", 0, 0 )
	SOFTWARE( sonics, sonics, 199?, "Sega License", "Sonic Spinball"REGION_EU, 0, 0 )
	SOFTWARE( sonicj, sonic, 199?, "Sega License", "Sonic The Hedgehog"REGION_J, 0, 0 )
	SOFTWARE( sonicp, sonic, 199?, "Sega License", "Sonic The Hedgehog (Proto)"REGION_W, 0, 0 )
	SOFTWARE( sonic, 0       , 199?, "Sega License", "Sonic The Hedgehog (v1.1)"REGION_W, 0, 0 )
	SOFTWARE( sonictrip, sonictri, 199?, "Sega License", "Sonic The Hedgehog - Triple Trouble (Prototype 0808 - Aug 08, 1994, 18.05)", 0, 0 )
	SOFTWARE( sonictri, 0       , 199?, "Sega License", "Sonic The Hedgehog - Triple Trouble"REGION_EU, 0, 0 )
	SOFTWARE( sonic2, 0       , 199?, "Sega License", "Sonic The Hedgehog 2"REGION_W, 0, 0 )
	SOFTWARE( soukoban, 0       , 199?, "Sega License", "Soukoban"REGION_J, 0, 0 )
	SOFTWARE( sharr, 0       , 199?, "Sega License", "Space Harrier"REGION_W, 0, 0 )
	SOFTWARE( cheesep1, 0       , 199?, "Sega License", "Speedy Gonzales Cheese Catastrophe (Prototype - Feb 17, 1995)", 0, 0 )
	SOFTWARE( cheesep2, cheesp1, 199?, "Sega License", "Speedy Gonzales Cheese Catastrophe (Prototype - Feb 24, 1995)", 0, 0 )
	SOFTWARE( spidsin6, 0       , 199?, "Sega License", "Spider-Man - Return of the Sinister Six"REGION_EU, 0, 0 )
	SOFTWARE( spidxmen, 0       , 199?, "Sega License", "Spider-Man and the X-Men in Arcade's Revenge"REGION_U, 0, 0 )
	SOFTWARE( spidking, 0       , 199?, "Sega License", "Spider-Man vs. The Kingpin"REGION_EU, 0, 0 )
	SOFTWARE( spirou, 0       , 199?, "Sega License", "Spirou (Proto)"REGION_E, 0, 0 )
	SOFTWARE( sportill, 0       , 199?, "Sega License", "Sports Illustrated Championship Football & Baseball"REGION_EU, 0, 0 )
	SOFTWARE( sportrvp1, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 03, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportrvp2, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 03, 1995 - QTEST)", 0, 0 )
	SOFTWARE( sportrvp3, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 04, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportrvp4, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 05, 1995 - 2MEG - B)", 0, 0 )
	SOFTWARE( sportrvp5, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 05, 1995 - 2MEG - C)", 0, 0 )
	SOFTWARE( sportrvp6, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 05, 1995 - QTEST)", 0, 0 )
	SOFTWARE( sportrvp7, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 06, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportrvp8, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 07, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportrvp9, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 07, 1995 - QTEST)", 0, 0 )
	SOFTWARE( sportvp10, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 11, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp11, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 12, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp12, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 25, 1995 - 1MEG)", 0, 0 )
	SOFTWARE( sportvp13, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 25, 1995 - QTEST)", 0, 0 )
	SOFTWARE( sportvp14, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 27, 1995 - 1MEG)", 0, 0 )
	SOFTWARE( sportvp15, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Apr 28, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp16, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 08, 1995)", 0, 0 )
	SOFTWARE( sportvp17, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 09, 1995)", 0, 0 )
	SOFTWARE( sportvp18, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 13, 1995)", 0, 0 )
	SOFTWARE( sportvp19, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 16, 1995 - 1MEG)", 0, 0 )
	SOFTWARE( sportvp20, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 16, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp21, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 17, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp22, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 20, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp23, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 20, 1995 - QTEST)", 0, 0 )
	SOFTWARE( sportvp24, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 21, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp25, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 23, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp26, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 23, 1995 - ALGOTEST)", 0, 0 )
	SOFTWARE( sportvp27, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 23, 1995 - QTEST)", 0, 0 )
	SOFTWARE( sportvp28, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 27, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp29, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 27, 1995 - ALGOTEST)", 0, 0 )
	SOFTWARE( sportvp30, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 29, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp31, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 29, 1995 - ALGOTEST)", 0, 0 )
	SOFTWARE( sportvp32, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 29, 1995 - QTEST)", 0, 0 )
	SOFTWARE( sportvp33, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 30, 1995 - 2MEG - D)", 0, 0 )
	SOFTWARE( sportvp34, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - Mar 30, 1995 - QTEST)", 0, 0 )
	SOFTWARE( sportvp35, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - May 02, 1995 - 2MEG)", 0, 0 )
	SOFTWARE( sportvp36, sporttrv, 199?, "Sega License", "Sports Trivia (Prototype - May 04, 1995 - 1MEG)", 0, 0 )
	SOFTWARE( sporttrv, 0       , 199?, "Sega License", "Sports Trivia"REGION_U, 0, 0 )
	SOFTWARE( sprtrvce, 0       , 199?, "Sega License", "Sports Trivia - Championship Edition"REGION_EU, 0, 0 )
	SOFTWARE( stng, 0       , 199?, "Sega License", "Star Trek - The Next Generation - The Advanced Holodeck Tutorial"REGION_U, 0, 0 )
	SOFTWARE( strekg, 0       , 199?, "Sega License", "Star Trek Generations - Beyond the Nexus"REGION_EU, 0, 0 )
	SOFTWARE( starwars, 0       , 199?, "Sega License", "Star Wars"REGION_E, 0, 0 )
	SOFTWARE( starwarsu, starwars, 199?, "Sega License", "Star Wars"REGION_U, 0, 0 )
	SOFTWARE( stargate, 0       , 199?, "Sega License", "Stargate"REGION_W, 0, 0 )
	SOFTWARE( sor, 0       , 199?, "Sega License", "Streets of Rage"REGION_W, 0, 0 )
	SOFTWARE( sor2, 0       , 199?, "Sega License", "Streets of Rage II"REGION_W, 0, 0 )
	SOFTWARE( striker, 0       , 199?, "Sega License", "Striker (En, Fr, De, Es, It)"REGION_E, 0, 0 )
	SOFTWARE( suprbtnk, 0       , 199?, "Sega License", "Super Battletank"REGION_U, 0, 0 )
	SOFTWARE( supercolj, supercol, 199?, "Sega License", "Super Columns"REGION_J, 0, 0 )
	SOFTWARE( supercolp, supercol, 199?, "Sega License", "Super Columns (Prototype - Dec 01, 1994)", 0, 0 )
	SOFTWARE( supercolp1, supercol, 199?, "Sega License", "Super Columns (Prototype - Dec 15, 1994)", 0, 0 )
	SOFTWARE( supercolp2, supercol, 199?, "Sega License", "Super Columns (Prototype - Dec 21, 1994)", 0, 0 )
	SOFTWARE( supercolp3, supercol, 199?, "Sega License", "Super Columns (Prototype - Dec 26, 1994)", 0, 0 )
	SOFTWARE( supercolp4, supercol, 199?, "Sega License", "Super Columns (Prototype - Dec 28, 1994)", 0, 0 )
	SOFTWARE( supercolp5, supercol, 199?, "Sega License", "Super Columns (Prototype - Jan 06, 1995)", 0, 0 )
	SOFTWARE( supercolp6, supercol, 199?, "Sega License", "Super Columns (Prototype - Nov 11, 1994)", 0, 0 )
	SOFTWARE( supercol, 0       , 199?, "Sega License", "Super Columns"REGION_EU, 0, 0 )
	SOFTWARE( superglf, 0       , 199?, "Sega License", "Super Golf"REGION_J, 0, 0 )
	SOFTWARE( suprkick, 0       , 199?, "Sega License", "Super Kick Off (SMS Mode?)"REGION_J, 0, 0 )
	SOFTWARE( supermd2, 0       , 199?, "Sega License", "Super Momotarou Dentetsu III"REGION_J, 0, 0 )
	SOFTWARE( smgpj, 0       , 199?, "Sega License", "Super Monaco GP"REGION_J, 0, 0 )
	SOFTWARE( smgp, 0       , 199?, "Sega License", "Super Monaco GP"REGION_EU, 0, 0 )
	SOFTWARE( superoff, 0       , 199?, "Sega License", "Super Off Road"REGION_EU, 0, 0 )
	SOFTWARE( superoffu, superoff, 199?, "Sega License", "Super Off-Road (Alt)"REGION_U, 0, 0 )
	SOFTWARE( suprjedi, 0       , 199?, "Sega License", "Super Return of the Jedi"REGION_EU, 0, 0 )
	SOFTWARE( ssmashtv, 0       , 199?, "Sega License", "Super Smash T.V."REGION_W, 0, 0 )
	SOFTWARE( ssinv, 0       , 199?, "Sega License", "Super Space Invaders"REGION_EU, 0, 0 )
	SOFTWARE( stetris, 0       , 199?, "Sega License", "Super Tetris (SMS Mode?)"REGION_K, 0, 0 )
	SOFTWARE( superman, 0       , 199?, "Sega License", "Superman - The Man of Steel"REGION_E, 0, 0 )
	SOFTWARE( surfninj, 0       , 199?, "Sega License", "Surf Ninjas"REGION_U, 0, 0 )
	SOFTWARE( sylvan, 0       , 199?, "Sega License", "Sylvan Tale"REGION_J, 0, 0 )
	SOFTWARE( t2ag, 0       , 199?, "Sega License", "T2 - The Arcade Game"REGION_EU, 0, 0 )
	SOFTWARE( tailsadv, 0       , 199?, "Sega License", "Tails Adventures (En, Ja)"REGION_W, 0, 0 )
	SOFTWARE( tailskyp, 0       , 199?, "Sega License", "Tails no Skypatrol"REGION_J, 0, 0 )
	SOFTWARE( taisnmj, 0       , 199?, "Sega License", "Taisen Mahjong HaoPai"REGION_J, 0, 0 )
	SOFTWARE( taisnmj2, 0       , 199?, "Sega License", "Taisen Mahjong HaoPai 2"REGION_J, 0, 0 )
	SOFTWARE( taisendg, 0       , 199?, "Sega License", "Taisen-gata Daisenryaku G"REGION_J, 0, 0 )
	SOFTWARE( chasehq, 0       , 199?, "Sega License", "Taito Chase H.Q. (SMS Mode)"REGION_J, 0, 0 )
	SOFTWARE( chasehq1, chasehq, 199?, "Sega License", "Taito Chase H.Q. (Alt, SMS Mode?)"REGION_J, 0, 0 )
	SOFTWARE( talespin, 0       , 199?, "Sega License", "Tale Spin"REGION_EU, 0, 0 )
	SOFTWARE( tamalymp, 0       , 199?, "Sega License", "Tama & Friends Sanchoume Kouen - Tamalympic"REGION_J, 0, 0 )
	SOFTWARE( tarot, 0       , 199?, "Sega License", "Tarot no Yakata"REGION_J, 0, 0 )
	SOFTWARE( tarzan, 0       , 199?, "Sega License", "Tarzan - Lord of the Jungle"REGION_E, 0, 0 )
	SOFTWARE( tatakae, 0       , 199?, "Sega License", "Tatakae! Pro Yakyuu Twin League"REGION_J, 0, 0 )
	SOFTWARE( tazmarsp,  tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Aug 10, 1994)", 0, 0 )
	SOFTWARE( tazmarspa, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Aug 12, 1994)", 0, 0 )
	SOFTWARE( tazmarspb, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Aug 14, 1994)", 0, 0 )
	SOFTWARE( tazmarspc, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Aug 15, 1994)", 0, 0 )
	SOFTWARE( tazmarspd, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Aug 19, 1994)", 0, 0 )
	SOFTWARE( tazmarspe, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Aug 23, 1994)", 0, 0 )
	SOFTWARE( tazmarspf, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Aug 29, 1994 - B)", 0, 0 )
	SOFTWARE( tazmarspg, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Aug 30, 1994)", 0, 0 )
	SOFTWARE( tazmarsph, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - May 11, 1994)", 0, 0 )
	SOFTWARE( tazmarspi, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Sep 02, 1994)", 0, 0 )
	SOFTWARE( tazmarspj, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Sep 05, 1994 - B)", 0, 0 )
	SOFTWARE( tazmarspk, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Sep 05, 1994 - C)", 0, 0 )
	SOFTWARE( tazmarspl, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Sep 06, 1994 - D)", 0, 0 )
	SOFTWARE( tazmarspm, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Sep 09, 1994 - B)", 0, 0 )
	SOFTWARE( tazmarspn, tazmars, 199?, "Sega License", "Taz in Escape from Mars (Prototype - Sep 10, 1994)", 0, 0 )
	SOFTWARE( tazmars, 0       , 199?, "Sega License", "Taz in Escape from Mars"REGION_EU, 0, 0 )
	SOFTWARE( tazmania, 0       , 199?, "Sega License", "Taz-Mania - The Search for the Lost Seabirds"REGION_EU, 0, 0 )
	SOFTWARE( tempojrp, tempojr, 199?, "Sega License", "Tempo Jr. (Prototype - Dec 05, 1994)", 0, 0 )
	SOFTWARE( tempojrp1, tempojr, 199?, "Sega License", "Tempo Jr. (Prototype - Dec 12, 1994)", 0, 0 )
	SOFTWARE( tempojrp2, tempojr, 199?, "Sega License", "Tempo Jr. (Prototype - Dec 26, 1994)", 0, 0 )
	SOFTWARE( tempojrp3, tempojr, 199?, "Sega License", "Tempo Jr. (Prototype - Feb 06, 1995)", 0, 0 )
	SOFTWARE( tempojrp4, tempojr, 199?, "Sega License", "Tempo Jr. (Prototype - Feb 15, 1995)", 0, 0 )
	SOFTWARE( tempojrp5, tempojr, 199?, "Sega License", "Tempo Jr. (Prototype - Jan 17, 1995)", 0, 0 )
	SOFTWARE( tempojrp6, tempojr, 199?, "Sega License", "Tempo Jr. (Prototype - Jan 20, 1995)", 0, 0 )
	SOFTWARE( tempojrp7, tempojr, 199?, "Sega License", "Tempo Jr. (Prototype - Jan 31, 1995)", 0, 0 )
	SOFTWARE( tempojrp8, tempojr, 199?, "Sega License", "Tempo Jr. (Prototype - Nov 28, 1994)", 0, 0 )
	SOFTWARE( tempojr, 0       , 199?, "Sega License", "Tempo Jr."REGION_W, 0, 0 )
	SOFTWARE( tengenwc, 0       , 199?, "Sega License", "Tengen World Cup Soccer"REGION_EU, 0, 0 )
	SOFTWARE( t2jd, 0       , 199?, "Sega License", "Terminator 2 - Judgment Day"REGION_EU, 0, 0 )
	SOFTWARE( termntr, 0       , 199?, "Sega License", "The Terminator"REGION_EU, 0, 0 )
	SOFTWARE( tesserae, 0       , 199?, "Sega License", "Tesserae"REGION_EU, 0, 0 )
	SOFTWARE( tintin, 0       , 199?, "Sega License", "Tintin in Tibet (En, Fr, De, Es, Nl, Sv)"REGION_E, 0, 0 )
	SOFTWARE( tomjermv, 0       , 199?, "Sega License", "Tom and Jerry - The Movie"REGION_U, 0, 0 )
	SOFTWARE( torarete, 0       , 199?, "Sega License", "Torarete Tamaruka"REGION_J, 0, 0 )
	SOFTWARE( truelies, 0       , 199?, "Sega License", "True Lies"REGION_W, 0, 0 )
	SOFTWARE( ultimate, 0       , 199?, "Sega License", "Ultimate Soccer (En, Fr, De, Es, It)"REGION_EJ, 0, 0 )
	SOFTWARE( ustrike, 0       , 199?, "Sega License", "Urban Strike"REGION_EU, 0, 0 )
	SOFTWARE( vampir, 0       , 199?, "Sega License", "Vampire - Master of Darkness"REGION_U, 0, 0 )
	SOFTWARE( vfa, 0       , 199?, "Sega License", "Virtua Fighter Animation"REGION_EU, 0, 0 )
	SOFTWARE( vfmini, 0       , 199?, "Sega License", "Virtua Fighter Mini"REGION_J, 0, 0 )
	SOFTWARE( vrtroop, 0       , 199?, "Sega License", "VR Troopers"REGION_EU, 0, 0 )
	SOFTWARE( waganlnd, 0       , 199?, "Sega License", "Wagan Land"REGION_J, 0, 0 )
	SOFTWARE( waganlnd1, waganlnd, 199?, "Sega License", "Wagan Land (Alt)"REGION_J, 0, 0 )
	SOFTWARE( wheelof, 0       , 199?, "Sega License", "Wheel of Fortune"REGION_U, 0, 0 )
	SOFTWARE( wimbledn, 0       , 199?, "Sega License", "Wimbledon"REGION_W, 0, 0 )
	SOFTWARE( winterolj, winterol, 199?, "Sega License", "Winter Olympics - Lillehammer '94 (En, Fr, De, Es, It, Pt, Sv, No)"REGION_J, 0, 0 )
	SOFTWARE( winterol,  0       , 199?, "Sega License", "Winter Olympics - Lillehammer '94 (En, Fr, De, Es, It, Pt, Sv, No)"REGION_EU, 0, 0 )
	SOFTWARE( wizard, 0       , 199?, "Sega License", "Wizard Pinball"REGION_E, 0, 0 )
	SOFTWARE( wolfch, 0       , 199?, "Sega License", "Wolfchild"REGION_E, 0, 0 )
	SOFTWARE( wboy, 0       , 199?, "Sega License", "Wonder Boy"REGION_E, 0, 0 )
	SOFTWARE( wboyj, wboy, 199?, "Sega License", "Wonder Boy"REGION_J, 0, 0 )
	SOFTWARE( wboydtrap, 0       , 199?, "Sega License", "Wonder Boy III - The Dragon's Trap"REGION_E, 0, 0 )
	SOFTWARE( wboydtrapb, wboydtrap, 199?, "Sega License", "Wonder Boy III - The Dragon's Trap (Beta)"REGION_E, 0, 0 )
	SOFTWARE( woodypop, 0       , 199?, "Sega License", "Woody Pop (v1.1)"REGION_EU, 0, 0 )
	SOFTWARE( woodypop1, 0       , 199?, "Sega License", "Woody Pop"REGION_EU, 0, 0 )
	SOFTWARE( wclead, 0       , 199?, "Sega License", "World Class Leader Board"REGION_EU, 0, 0 )
	SOFTWARE( wcup94, 0       , 199?, "Sega License", "World Cup USA 94 (En, Fr, De, Es, It, Nl, Pt, Sv)"REGION_EU, 0, 0 )
	SOFTWARE( wderby, 0       , 199?, "Sega License", "World Derby"REGION_J, 0, 0 )
	SOFTWARE( worlds95p1, worlds95, 199?, "Sega License", "World Series Baseball '95 (Prototype - Jul 09, 1994)", 0, 0 )
	SOFTWARE( worlds95p2, worlds95, 199?, "Sega License", "World Series Baseball '95 (Prototype - Jul 19, 1994)", 0, 0 )
	SOFTWARE( worlds95p3, worlds95, 199?, "Sega License", "World Series Baseball '95 (Prototype - Jul 22, 1994)", 0, 0 )
	SOFTWARE( worlds95p4, worlds95, 199?, "Sega License", "World Series Baseball '95 (Prototype - Jul 28, 1994)", 0, 0 )
	SOFTWARE( worlds95p5, worlds95, 199?, "Sega License", "World Series Baseball '95 (Prototype - Jul 29, 1994)", 0, 0 )
	SOFTWARE( worlds95p6, worlds95, 199?, "Sega License", "World Series Baseball '95 (Prototype - Jun 29, 1994)", 0, 0 )
	SOFTWARE( worlds95, 0       , 199?, "Sega License", "World Series Baseball '95"REGION_U, 0, 0 )
	SOFTWARE( worldsb, 0       , 199?, "Sega License", "World Series Baseball (v1.1)"REGION_U, 0, 0 )
	SOFTWARE( worldsb1, worldsb, 199?, "Sega License", "World Series Baseball"REGION_U, 0, 0 )
	SOFTWARE( wwfraw, 0       , 199?, "Sega License", "WWF Raw"REGION_EU, 0, 0 )
	SOFTWARE( wwfwre, 0       , 199?, "Sega License", "WWF Wrestlemania Steel Cage Challenge (SMS Mode?)"REGION_E, 0, 0 )
	SOFTWARE( xmen, 0       , 199?, "Sega License", "X-Men"REGION_U, 0, 0 )
	SOFTWARE( xmengamlp1, xmengaml, 199?, "Sega License", "X-Men - Gamemaster's Legacy (Prototype - Aug 10, 1994)", 0, 0 )
	SOFTWARE( xmengamlp2, xmengaml, 199?, "Sega License", "X-Men - Gamemaster's Legacy (Prototype - Aug 15, 1994)", 0, 0 )
	SOFTWARE( xmengamlp3, xmengaml, 199?, "Sega License", "X-Men - Gamemaster's Legacy (Prototype 36 - Aug 31, 1994)", 0, 0 )
	SOFTWARE( xmengamlp4, xmengaml, 199?, "Sega License", "X-Men - Gamemaster's Legacy (Prototype 51 - Sep 06, 1994)", 0, 0 )
	SOFTWARE( xmengaml, 0       , 199?, "Sega License", "X-Men - Gamemaster's Legacy"REGION_EU, 0, 0 )
	SOFTWARE( xmenmojop1, xmenmojo, 199?, "Sega License", "X-Men - Mojo World (Prototype - Jun 05, 1996)", 0, 0 )
	SOFTWARE( xmenmojop2, xmenmojo, 199?, "Sega License", "X-Men - Mojo World (Prototype - Jun 13, 1996)", 0, 0 )
	SOFTWARE( xmenmojop3, xmenmojo, 199?, "Sega License", "X-Men - Mojo World (Prototype - Jun 24, 1996)", 0, 0 )
	SOFTWARE( xmenmojop4, xmenmojo, 199?, "Sega License", "X-Men - Mojo World (Prototype - Jun 25, 1996)", 0, 0 )
	SOFTWARE( xmenmojop5, xmenmojo, 199?, "Sega License", "X-Men - Mojo World (Prototype - Jun 27, 1996)", 0, 0 )
	SOFTWARE( xmenmojop6, xmenmojo, 199?, "Sega License", "X-Men - Mojo World (Prototype - Jun 28, 1996)", 0, 0 )
	SOFTWARE( xmenmojop7, xmenmojo, 199?, "Sega License", "X-Men - Mojo World (Prototype - Jun 29, 1996)", 0, 0 )
	SOFTWARE( xmenmojo, 0       , 199?, "Sega License", "X-Men - Mojo World"REGION_EU, 0, 0 )
	SOFTWARE( yogibear, 0       , 199?, "Sega License", "Yogi Bear in Yogi Bear's Goldrush (Unknown) (Proto)", 0, 0 )
	SOFTWARE( yuyuhaku, 0       , 199?, "Sega License", "Yu Yu Hakusho - Horobishimono no Gyakushuu"REGION_J, 0, 0 )
	SOFTWARE( yuyuhak2, 0       , 199?, "Sega License", "Yu Yu Hakusho 2 - Gekitou! Nanakyou no Tatakai"REGION_J, 0, 0 )
	SOFTWARE( zangear, 0       , 199?, "Sega License", "Zan Gear"REGION_J, 0, 0 )
	SOFTWARE( zool, 0       , 199?, "Sega License", "Zool"REGION_U, 0, 0 )
	SOFTWARE( zoolj, zool, 199?, "Sega License", "Zool no Yume Bouken"REGION_J, 0, 0 )
	SOFTWARE( zoop, 0       , 199?, "Sega License", "Zoop"REGION_E, 0, 0 )
	SOFTWARE( zoopu, zoop, 199?, "Sega License", "Zoop"REGION_U, 0, 0 )
SOFTWARE_LIST_END


SOFTWARE_LIST( gamegear_cart, "Sega Game Gear cartridges" )

