/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup.config;

import io.smallrye.metrics.setup.config.PropertySingleValueConfiguration;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimerBucketMinConfiguration
extends PropertySingleValueConfiguration<Duration> {
    private static final String CLASS_NAME = TimerBucketMinConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public TimerBucketMinConfiguration(String metricName, Duration value) {
        super(metricName, value);
    }

    public static Collection<TimerBucketMinConfiguration> parse(String input) {
        String[] metricValuePairs;
        ArrayDeque<TimerBucketMinConfiguration> sloMinConfigCollection = new ArrayDeque<TimerBucketMinConfiguration>();
        if (input == null || input.length() == 0) {
            return null;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String val;
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            TimerBucketMinConfiguration sloMinConfiguration = null;
            Duration dur = null;
            if (keyValueSplit.length != 2) continue;
            String s = keyValueSplit[1];
            if (s.matches("[0-9]+ms")) {
                val = s.substring(0, s.length() - 2);
                dur = Duration.ofMillis(Long.parseLong(val));
            } else if (s.matches("[0-9]+s")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofSeconds(Long.parseLong(val));
            } else if (s.matches("[0-9]+m")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofMinutes(Long.parseLong(val));
            } else if (s.matches("[0-9]+h")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofHours(Long.parseLong(val));
            } else if (s.matches("[0-9]+")) {
                dur = Duration.ofMillis(Long.parseLong(s));
            } else {
                LOGGER.logp(Level.WARNING, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer values with an optional time unit (e.g. ms,s,m,h) are accepted.", new Object[]{s, "mp.metrics.distribution.timer.buckets"});
            }
            if (dur == null) continue;
            sloMinConfiguration = new TimerBucketMinConfiguration(metricName, dur);
            sloMinConfigCollection.addFirst(sloMinConfiguration);
        }
        return sloMinConfigCollection;
    }
}

